/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.classstore;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.diagnostic.hprof.util.IDMapper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u001aH\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\tJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u0016J\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0004J\u001a\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020%0'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00040\bj\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0004`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "", "classes", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "<init>", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;)V", "stringToClassDefinition", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "classDefinitionToShortPrettyName", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "softReferenceClass", "getSoftReferenceClass", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "weakReferenceClass", "getWeakReferenceClass", "classClass", "getClassClass", "primitiveArrayToClassDefinition", "Lcom/intellij/diagnostic/hprof/parser/Type;", "get", "id", "", "", "name", "getClassIfExists", "containsClass", "", "getClassForPrimitiveArray", "t", "size", "isSoftOrWeakReferenceClass", "classDefinition", "forEachClass", "", "func", "Lkotlin/Function1;", "createStoreWithRemappedIDs", "idMapper", "Lcom/intellij/diagnostic/hprof/util/IDMapper;", "getShortPrettyNameForClass", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClassStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassStore.kt\ncom/intellij/diagnostic/hprof/classstore/ClassStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,169:1\n1915#2,2:170\n14060#3,2:172\n221#4,2:174\n*S KotlinDebug\n*F\n+ 1 ClassStore.kt\ncom/intellij/diagnostic/hprof/classstore/ClassStore\n*L\n81#1:170,2\n88#1:172,2\n115#1:174,2\n*E\n"})
public final class ClassStore {
    @NotNull
    private final Long2ObjectMap<ClassDefinition> classes;
    @NotNull
    private final HashMap<String, ClassDefinition> stringToClassDefinition;
    @NotNull
    private final HashSet<ClassDefinition> classDefinitionToShortPrettyName;
    @NotNull
    private final ClassDefinition softReferenceClass;
    @NotNull
    private final ClassDefinition weakReferenceClass;
    @NotNull
    private final ClassDefinition classClass;
    @NotNull
    private final HashMap<Type, ClassDefinition> primitiveArrayToClassDefinition;

    public ClassStore(@NotNull Long2ObjectMap<ClassDefinition> classes) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        this.classes = classes;
        this.stringToClassDefinition = new HashMap();
        this.classDefinitionToShortPrettyName = new HashSet();
        this.primitiveArrayToClassDefinition = new HashMap();
        HashSet<Object> clashedClassNames = new HashSet<Object>();
        ObjectIterator objectIterator = ((ObjectCollection)this.classes.values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            ClassDefinition classDefinition = (ClassDefinition)objectIterator2.next();
            String className = classDefinition.getName();
            boolean bl = false;
            if (clashedClassNames.contains(className)) {
                bl = true;
            } else {
                ClassDefinition clashedClass = this.stringToClassDefinition.remove(className);
                if (clashedClass != null) {
                    bl = true;
                    ClassDefinition newDefinition = clashedClass.copyWithName(ClassStore._init_$getClashedNameWithIndex(clashedClass, 1));
                    ((Map)this.stringToClassDefinition).put(newDefinition.getName(), newDefinition);
                    this.classes.put(clashedClass.getId(), (Object)newDefinition);
                    clashedClassNames.add(className);
                }
            }
            if (bl) {
                int i2 = 2;
                String newName = null;
                do {
                    Intrinsics.checkNotNull((Object)classDefinition);
                    newName = ClassStore._init_$getClashedNameWithIndex(classDefinition, i2);
                    ++i2;
                } while (this.stringToClassDefinition.containsKey(newName));
                ClassDefinition newClassDefinition = classDefinition.copyWithName(newName);
                ((Map)this.stringToClassDefinition).put(newName, newClassDefinition);
                this.classes.put(classDefinition.getId(), (Object)newClassDefinition);
                continue;
            }
            ((Map)this.stringToClassDefinition).put(classDefinition.getName(), classDefinition);
        }
        Type[] $this$forEach$iv = (Type[])clashedClassNames;
        boolean $i$f$forEach = false;
        for (Object e : $this$forEach$iv) {
            boolean newClassDefinition;
            String it = (String)e;
            boolean bl = false;
            boolean bl2 = newClassDefinition = !((Map)this.stringToClassDefinition).containsKey(it);
            if (!_Assertions.ENABLED || newClassDefinition) continue;
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ClassDefinition classDefinition = this.stringToClassDefinition.get("java.lang.ref.SoftReference");
        Intrinsics.checkNotNull((Object)classDefinition);
        this.softReferenceClass = classDefinition;
        ClassDefinition classDefinition2 = this.stringToClassDefinition.get("java.lang.ref.WeakReference");
        Intrinsics.checkNotNull((Object)classDefinition2);
        this.weakReferenceClass = classDefinition2;
        ClassDefinition classDefinition3 = this.stringToClassDefinition.get("java.lang.Class");
        Intrinsics.checkNotNull((Object)classDefinition3);
        this.classClass = classDefinition3;
        $this$forEach$iv = Type.values();
        boolean $i$f$forEach42 = false;
        int n = $this$forEach$iv.length;
        for (int className = 0; className < n; ++className) {
            ClassDefinition classDefinition4;
            Type element$iv2;
            Type type = element$iv2 = $this$forEach$iv[className];
            boolean bl = false;
            if (type == Type.OBJECT) continue;
            if (this.stringToClassDefinition.get(type.getClassNameOfPrimitiveArray()) == null) continue;
            boolean bl3 = false;
            this.primitiveArrayToClassDefinition.put(type, classDefinition4);
        }
        HashMap shortNameToClassDefinition = new HashMap();
        ObjectIterator objectIterator3 = ((ObjectCollection)this.classes.values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator3, (String)"iterator(...)");
        ObjectIterator $i$f$forEach42 = objectIterator3;
        while ($i$f$forEach42.hasNext()) {
            ClassDefinition classDefinition5 = (ClassDefinition)$i$f$forEach42.next();
            if (StringsKt.contains$default((CharSequence)classDefinition5.getName(), (char)'$', (boolean)false, (int)2, null)) continue;
            String string = classDefinition5.getPrettyName();
            String shortPrettyName = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null);
            if (shortNameToClassDefinition.containsKey(shortPrettyName)) {
                ClassDefinition prevClassDefinition = (ClassDefinition)shortNameToClassDefinition.get(shortPrettyName);
                if (prevClassDefinition == null) continue;
                ((Map)shortNameToClassDefinition).put(shortPrettyName, null);
                continue;
            }
            ((Map)shortNameToClassDefinition).put(shortPrettyName, classDefinition5);
        }
        Map $this$forEach$iv2 = shortNameToClassDefinition;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv3;
            Map.Entry entry = element$iv3 = iterator2.next();
            boolean bl = false;
            ClassDefinition classDef = (ClassDefinition)entry.getValue();
            if (classDef == null) continue;
            this.classDefinitionToShortPrettyName.add(classDef);
        }
    }

    @NotNull
    public final ClassDefinition getSoftReferenceClass() {
        return this.softReferenceClass;
    }

    @NotNull
    public final ClassDefinition getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    @NotNull
    public final ClassDefinition getClassClass() {
        return this.classClass;
    }

    @NotNull
    public final ClassDefinition get(int id2) {
        Object object = this.classes.get((long)id2);
        Intrinsics.checkNotNull((Object)object);
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(long id2) {
        Object object = this.classes.get(id2);
        Intrinsics.checkNotNull((Object)object);
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ClassDefinition classDefinition = this.stringToClassDefinition.get(name2);
        Intrinsics.checkNotNull((Object)classDefinition);
        return classDefinition;
    }

    @Nullable
    public final ClassDefinition getClassIfExists(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.stringToClassDefinition.get(name2);
    }

    public final boolean containsClass(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.stringToClassDefinition.containsKey(name2);
    }

    @Nullable
    public final ClassDefinition getClassForPrimitiveArray(@NotNull Type t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        return this.primitiveArrayToClassDefinition.get((Object)t);
    }

    public final int size() {
        return this.classes.size();
    }

    public final boolean isSoftOrWeakReferenceClass(@NotNull ClassDefinition classDefinition) {
        Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
        return Intrinsics.areEqual((Object)classDefinition, (Object)this.softReferenceClass) || Intrinsics.areEqual((Object)classDefinition, (Object)this.weakReferenceClass);
    }

    public final void forEachClass(@NotNull Function1<? super ClassDefinition, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        ObjectIterator objectIterator = ((ObjectCollection)this.classes.values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            ClassDefinition classDefinition = (ClassDefinition)objectIterator2.next();
            Intrinsics.checkNotNull((Object)classDefinition);
            func.invoke((Object)classDefinition);
        }
    }

    @NotNull
    public final ClassStore createStoreWithRemappedIDs(@NotNull IDMapper idMapper) {
        Intrinsics.checkNotNullParameter((Object)idMapper, (String)"idMapper");
        Long2ObjectOpenHashMap newClasses = new Long2ObjectOpenHashMap();
        ObjectIterator objectIterator = ((ObjectCollection)this.classes.values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            ClassDefinition classDefinition = (ClassDefinition)objectIterator2.next();
            newClasses.put(ClassStore.createStoreWithRemappedIDs$map(idMapper, classDefinition.getId()), (Object)classDefinition.copyWithRemappedIDs(idMapper));
        }
        return new ClassStore((Long2ObjectMap<ClassDefinition>)((Long2ObjectMap)newClasses));
    }

    @NotNull
    public final String getShortPrettyNameForClass(@NotNull ClassDefinition classDefinition) {
        ClassDefinition outerClass;
        Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
        if (StringsKt.contains$default((CharSequence)classDefinition.getName(), (char)'$', (boolean)false, (int)2, null) ? (outerClass = this.stringToClassDefinition.get(StringsKt.substringBefore$default((String)classDefinition.getName(), (char)'$', null, (int)2, null))) != null && this.classDefinitionToShortPrettyName.contains(outerClass) : this.classDefinitionToShortPrettyName.contains(classDefinition)) {
            return StringsKt.substringAfterLast$default((String)classDefinition.getPrettyName(), (char)'.', null, (int)2, null);
        }
        return classDefinition.getPrettyName();
    }

    private static final String _init_$getClashedNameWithIndex(ClassDefinition classDefinition, int index) {
        if (StringsKt.endsWith$default((CharSequence)classDefinition.getName(), (char)';', (boolean)false, (int)2, null)) {
            return StringsKt.removeSuffix((String)classDefinition.getName(), (CharSequence)";") + "!" + index + ";";
        }
        return classDefinition.getName() + "!" + index;
    }

    private static final long createStoreWithRemappedIDs$map(IDMapper $idMapper, long id2) {
        return $idMapper.getID(id2);
    }
}

