/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.visitors;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.InstanceField;
import com.intellij.diagnostic.hprof.classstore.StaticField;
import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.RecordType;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J(\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J_\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001eH\u0016\u00a2\u0006\u0002\u0010$J\u0006\u0010%\u001a\u00020&R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/diagnostic/hprof/visitors/CreateClassStoreVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "stringIdMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "", "<init>", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;)V", "classIDToNameStringID", "Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "result", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "completed", "", "preVisit", "", "postVisit", "visitLoadClass", "classSerialNumber", "", "classObjectId", "stackSerialNumber", "classNameStringId", "visitClassDump", "classId", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "getClassStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nCreateClassStoreVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateClassStoreVisitor.kt\ncom/intellij/diagnostic/hprof/visitors/CreateClassStoreVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,104:1\n14060#2,2:105\n1342#3,2:107\n37#4,2:109\n37#4,2:111\n37#4,2:113\n37#4,2:115\n*S KotlinDebug\n*F\n+ 1 CreateClassStoreVisitor.kt\ncom/intellij/diagnostic/hprof/visitors/CreateClassStoreVisitor\n*L\n61#1:105,2\n76#1:107,2\n91#1:109,2\n92#1:111,2\n94#1:113,2\n95#1:115,2\n*E\n"})
public final class CreateClassStoreVisitor
extends HProfVisitor {
    @NotNull
    private final Long2ObjectMap<String> stringIdMap;
    @NotNull
    private final Long2LongOpenHashMap classIDToNameStringID;
    @NotNull
    private final Long2ObjectOpenHashMap<ClassDefinition> result;
    private boolean completed;

    public CreateClassStoreVisitor(@NotNull Long2ObjectMap<String> stringIdMap) {
        Intrinsics.checkNotNullParameter(stringIdMap, (String)"stringIdMap");
        this.stringIdMap = stringIdMap;
        this.classIDToNameStringID = new Long2LongOpenHashMap();
        this.result = new Long2ObjectOpenHashMap();
    }

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(RecordType.LoadClass);
        this.enable(HeapDumpRecordType.ClassDump);
        this.classIDToNameStringID.clear();
    }

    @Override
    public void postVisit() {
        this.completed = true;
    }

    @Override
    public void visitLoadClass(long classSerialNumber, long classObjectId, long stackSerialNumber, long classNameStringId) {
        this.classIDToNameStringID.put(classObjectId, classNameStringId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        void $this$forEach$iv;
        Object it;
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        List refInstanceFields = new ArrayList();
        List primitiveInstanceFields = new ArrayList();
        int currentOffset = 0;
        InstanceFieldEntry[] $this$forEach$iv2 = instanceFields;
        boolean $i$f$forEach22 = false;
        for (InstanceFieldEntry element$iv : $this$forEach$iv2) {
            it = element$iv;
            boolean bl = false;
            String fieldName = (String)this.stringIdMap.get(((InstanceFieldEntry)it).getFieldNameStringId());
            Intrinsics.checkNotNull((Object)fieldName);
            InstanceField field = new InstanceField(fieldName, currentOffset, ((InstanceFieldEntry)it).getType());
            if (((InstanceFieldEntry)it).getType() != Type.OBJECT) {
                primitiveInstanceFields.add(field);
                currentOffset += ((InstanceFieldEntry)it).getType().getSize();
                continue;
            }
            refInstanceFields.add(field);
            currentOffset += this.getVisitorContext().getIdSize();
        }
        LongArrayList constantsArray = new LongArrayList(constants.length);
        Sequence $i$f$forEach22 = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])constants), CreateClassStoreVisitor::visitClassDump$lambda$1);
        boolean $i$f$forEach = false;
        for (InstanceFieldEntry element$iv : $this$forEach$iv) {
            it = (ConstantPoolEntry)((Object)element$iv);
            boolean bl = false;
            constantsArray.add(((ConstantPoolEntry)it).getValue());
        }
        Sequence objectStaticFieldList = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])staticFields), CreateClassStoreVisitor::visitClassDump$lambda$3), arg_0 -> CreateClassStoreVisitor.visitClassDump$lambda$4(this, arg_0));
        Sequence primitiveStaticFieldList = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])staticFields), CreateClassStoreVisitor::visitClassDump$lambda$5), arg_0 -> CreateClassStoreVisitor.visitClassDump$lambda$6(this, arg_0));
        Object object = this.stringIdMap.get(this.classIDToNameStringID.get(classId));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string = StringsKt.replace$default((String)((String)object), (char)'/', (char)'.', (boolean)false, (int)4, null);
        int n = (int)instanceSize;
        Collection $this$toTypedArray$iv = refInstanceFields;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = primitiveInstanceFields;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        long[] lArray = constantsArray.toLongArray();
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"toLongArray(...)");
        $this$toTypedArray$iv = SequencesKt.toList((Sequence)objectStaticFieldList);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = SequencesKt.toList((Sequence)primitiveStaticFieldList);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        ClassDefinition classDefinition = new ClassDefinition(string, classId, superClassId, classloaderClassId, n, currentOffset, thisCollection$iv.toArray(new InstanceField[0]), thisCollection$iv.toArray(new InstanceField[0]), lArray, thisCollection$iv.toArray(new StaticField[0]), thisCollection$iv.toArray(new StaticField[0]));
        this.result.put(classId, (Object)classDefinition);
    }

    @NotNull
    public final ClassStore getClassStore() {
        boolean bl = this.completed;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new ClassStore((Long2ObjectMap<ClassDefinition>)((Long2ObjectMap)this.result));
    }

    private static final boolean visitClassDump$lambda$1(ConstantPoolEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType() == Type.OBJECT;
    }

    private static final boolean visitClassDump$lambda$3(StaticFieldEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType() == Type.OBJECT;
    }

    private static final StaticField visitClassDump$lambda$4(CreateClassStoreVisitor this$0, StaticFieldEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0.stringIdMap.get(it.getFieldNameStringId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return new StaticField((String)object, it.getValue());
    }

    private static final boolean visitClassDump$lambda$5(StaticFieldEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType() != Type.OBJECT;
    }

    private static final StaticField visitClassDump$lambda$6(CreateClassStoreVisitor this$0, StaticFieldEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0.stringIdMap.get(it.getFieldNameStringId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return new StaticField((String)object, it.getValue());
    }
}

