/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Indent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class IndentImpl
extends Indent {
    private final boolean myIsAbsolute;
    private final boolean myRelativeToDirectParent;
    private final boolean myEnforceChildrenToBeRelativeToMe;
    @NotNull
    private final Indent.Type myType;
    private final int mySpaces;
    private final boolean myEnforceIndentToChildren;

    public IndentImpl(@NotNull Indent.Type type, boolean absolute, boolean relativeToDirectParent) {
        if (type == null) {
            IndentImpl.$$$reportNull$$$0(0);
        }
        this(type, absolute, 0, relativeToDirectParent, false);
    }

    public IndentImpl(@NotNull Indent.Type type, boolean absolute, int spaces, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        if (type == null) {
            IndentImpl.$$$reportNull$$$0(1);
        }
        this(type, absolute, spaces, relativeToDirectParent, enforceIndentToChildren, false);
    }

    @ApiStatus.Experimental
    public IndentImpl(@NotNull Indent.Type type, boolean absolute, int spaces, boolean relativeToDirectParent, boolean enforceIndentToChildren, boolean enforceChildrenToBeRelativeToMe) {
        if (type == null) {
            IndentImpl.$$$reportNull$$$0(2);
        }
        this.myType = type;
        this.myIsAbsolute = absolute;
        this.mySpaces = spaces;
        this.myRelativeToDirectParent = relativeToDirectParent;
        this.myEnforceIndentToChildren = enforceIndentToChildren;
        this.myEnforceChildrenToBeRelativeToMe = enforceChildrenToBeRelativeToMe;
        if (this.myEnforceChildrenToBeRelativeToMe) {
            assert (this.myEnforceIndentToChildren);
            assert (!this.myRelativeToDirectParent);
            assert (!this.myIsAbsolute);
        }
    }

    @NotNull
    public Indent.Type getType() {
        Indent.Type type = this.myType;
        if (type == null) {
            IndentImpl.$$$reportNull$$$0(3);
        }
        return type;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    public boolean isAbsolute() {
        return this.myIsAbsolute;
    }

    public boolean isRelativeToDirectParent() {
        return this.myRelativeToDirectParent;
    }

    @ApiStatus.Experimental
    public boolean isEnforceChildrenToBeRelativeToMe() {
        return this.myEnforceChildrenToBeRelativeToMe;
    }

    public boolean isEnforceIndentToChildren() {
        return this.myEnforceIndentToChildren;
    }

    @NonNls
    public String toString() {
        if (this.myType == Indent.Type.SPACES) {
            return "<Indent: SPACES(" + this.mySpaces + ")>";
        }
        return "<Indent: " + String.valueOf(this.myType) + (this.myIsAbsolute ? ":ABSOLUTE " : "") + (this.myRelativeToDirectParent ? " relative to direct parent " : "") + (this.myEnforceChildrenToBeRelativeToMe ? " enforce children to be relative to me" : (this.myEnforceIndentToChildren ? " enforce indent to children" : "")) + ">";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/IndentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/IndentImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

