/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.BlockRangesMap;
import com.intellij.formatting.engine.DependentSpacingEngine;
import com.intellij.formatting.engine.IndentAdjuster;
import com.intellij.formatting.engine.State;
import com.intellij.formatting.engine.WrapBlocksState;
import com.intellij.formatting.engine.WrapProcessor;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class AdjustWhiteSpacesState
extends State {
    private final FormattingProgressCallback myProgressCallback;
    private final WrapBlocksState myWrapBlocksState;
    private LeafBlockWrapper myCurrentBlock;
    private DependentSpacingEngine myDependentSpacingEngine;
    private WrapProcessor myWrapProcessor;
    private BlockRangesMap myBlockRangesMap;
    private IndentAdjuster myIndentAdjuster;
    private final boolean myReformatContext;
    private Set<Alignment> myAlignmentsInsideRangesToModify = null;
    private final HashSet<WhiteSpace> myAlignAgain = new HashSet();
    private LeafBlockWrapper myFirstBlock;

    public AdjustWhiteSpacesState(WrapBlocksState state2, FormattingProgressCallback progressCallback, boolean isReformatContext) {
        this.myWrapBlocksState = state2;
        this.myProgressCallback = progressCallback;
        this.myReformatContext = isReformatContext;
    }

    @Override
    public void prepare() {
        if (this.myWrapBlocksState != null) {
            this.myCurrentBlock = this.myFirstBlock = this.myWrapBlocksState.getFirstBlock();
            this.myDependentSpacingEngine = this.myWrapBlocksState.getDependentSpacingEngine();
            this.myWrapProcessor = this.myWrapBlocksState.getWrapProcessor();
            this.myIndentAdjuster = this.myWrapBlocksState.getIndentAdjuster();
            this.myBlockRangesMap = this.myWrapBlocksState.getBlockRangesMap();
            this.myAlignmentsInsideRangesToModify = this.myWrapBlocksState.getAlignmentsInsideRangesToModify();
        }
    }

    public LeafBlockWrapper getCurrentBlock() {
        return this.myCurrentBlock;
    }

    @Override
    public void doIteration() {
        LeafBlockWrapper blockToProcess = this.myCurrentBlock;
        this.processToken();
        if (blockToProcess != null) {
            this.myProgressCallback.afterProcessingBlock(blockToProcess);
        }
        if (this.myCurrentBlock != null) {
            return;
        }
        if (this.myAlignAgain.isEmpty()) {
            this.postProcessDependantWhitespaces();
            this.setDone(true);
        } else {
            this.myAlignAgain.clear();
            this.myDependentSpacingEngine.clear();
            this.myCurrentBlock = this.myFirstBlock;
            this.myDependentSpacingEngine.incrementIteration();
        }
    }

    private void postProcessDependantWhitespaces() {
        for (LeafBlockWrapper block : this.myDependentSpacingEngine.getLeafBlocksToReformat()) {
            WhiteSpace whiteSpace = block.getWhiteSpace();
            SpacingImpl spaceProperty = block.getSpaceProperty();
            this.updateSpacing(spaceProperty, whiteSpace);
            this.myIndentAdjuster.adjustIndent(block);
        }
    }

    boolean isReformatSelectedRangesContext() {
        return this.myReformatContext && !ContainerUtil.isEmpty(this.myAlignmentsInsideRangesToModify);
    }

    void defineAlignOffset(LeafBlockWrapper block) {
        AbstractBlockWrapper current = this.myCurrentBlock;
        do {
            AlignmentImpl alignment;
            if ((alignment = current.getAlignment()) != null) {
                alignment.setOffsetRespBlock(block);
            }
            if ((current = current.getParent()) != null) continue;
            return;
        } while (current.getStartOffset() == this.myCurrentBlock.getStartOffset());
    }

    private void onCurrentLineChanged() {
        this.myWrapProcessor.onCurrentLineChanged();
    }

    private boolean isCurrentBlockAlignmentUsedInRangesToModify() {
        AbstractBlockWrapper block = this.myCurrentBlock;
        AlignmentImpl alignment = this.myCurrentBlock.getAlignment();
        while (alignment == null) {
            if ((block = block.getParent()) == null || block.getStartOffset() != this.myCurrentBlock.getStartOffset()) {
                return false;
            }
            alignment = block.getAlignment();
        }
        return this.myAlignmentsInsideRangesToModify.contains((Object)alignment);
    }

    private static @Unmodifiable List<TextRange> getDependentRegionRangesAfterCurrentWhiteSpace(SpacingImpl spaceProperty, WhiteSpace whiteSpace) {
        if (!(spaceProperty instanceof DependantSpacingImpl)) {
            return ContainerUtil.emptyList();
        }
        DependantSpacingImpl spacing = (DependantSpacingImpl)spaceProperty;
        if (whiteSpace.isReadOnly() || whiteSpace.isLineFeedsAreReadOnly()) {
            return ContainerUtil.emptyList();
        }
        return ContainerUtil.filter(spacing.getDependentRegionRanges(), dependencyRange -> whiteSpace.getStartOffset() < dependencyRange.getEndOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processToken() {
        List<TextRange> ranges;
        SpacingImpl spaceProperty = this.myCurrentBlock.getSpaceProperty();
        WhiteSpace whiteSpace = this.myCurrentBlock.getWhiteSpace();
        if (this.isReformatSelectedRangesContext() && this.isCurrentBlockAlignmentUsedInRangesToModify() && whiteSpace.isReadOnly() && spaceProperty != null && !spaceProperty.isReadOnly()) {
            whiteSpace.setReadOnly(false);
            whiteSpace.setLineFeedsAreReadOnly(true);
        }
        this.updateSpacing(spaceProperty, whiteSpace);
        try {
            LeafBlockWrapper newBlock = this.myWrapProcessor.processWrap(this.myCurrentBlock);
            if (newBlock != null) {
                this.myCurrentBlock = newBlock;
                return;
            }
        }
        finally {
            if (whiteSpace.containsLineFeeds()) {
                this.onCurrentLineChanged();
            }
        }
        LeafBlockWrapper newCurrentBlock = this.myIndentAdjuster.adjustIndent(this.myCurrentBlock);
        if (newCurrentBlock != null) {
            this.myCurrentBlock = newCurrentBlock;
            this.onCurrentLineChanged();
            return;
        }
        this.defineAlignOffset(this.myCurrentBlock);
        if (this.myCurrentBlock.containsLineFeeds()) {
            this.onCurrentLineChanged();
        }
        if (!(ranges = AdjustWhiteSpacesState.getDependentRegionRangesAfterCurrentWhiteSpace(spaceProperty, whiteSpace)).isEmpty()) {
            this.myDependentSpacingEngine.registerUnresolvedDependentSpacingRanges(this.myCurrentBlock, ranges);
        }
        if (!whiteSpace.isIsReadOnly() && this.myDependentSpacingEngine.shouldReformatPreviouslyLocatedDependentSpacing(whiteSpace)) {
            this.myAlignAgain.add(whiteSpace);
        } else if (!this.myAlignAgain.isEmpty()) {
            this.myAlignAgain.remove(whiteSpace);
        }
        this.myCurrentBlock = this.myCurrentBlock.getNextBlock();
    }

    private void updateSpacing(SpacingImpl spaceProperty, WhiteSpace whiteSpace) {
        whiteSpace.arrangeLineFeeds(spaceProperty, this.myBlockRangesMap);
        if (!whiteSpace.containsLineFeeds()) {
            whiteSpace.arrangeSpaces(spaceProperty);
        }
    }
}

