/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.hover.HoverListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;

final class HoverService {
    private static final Logger LOG = Logger.getInstance(HoverService.class);
    private final List<ComponentPoint> hierarchy = new ArrayList<ComponentPoint>();

    HoverService() {
    }

    void process(@NotNull AWTEvent event) {
        if (event == null) {
            HoverService.$$$reportNull$$$0(0);
        }
        if (event instanceof MouseEvent) {
            this.process((MouseEvent)event);
        }
    }

    private void process(@NotNull MouseEvent event) {
        int index;
        Component parent;
        if (event == null) {
            HoverService.$$$reportNull$$$0(1);
        }
        PersistentList components = ExtensionsKt.persistentListOf();
        if (505 != event.getID() && (parent = event.getComponent()) != null && parent.isShowing()) {
            for (Component component2 = HoverService.getDeepestComponentAt(parent, event.getX(), event.getY()); component2 != null && !(component2 instanceof Window); component2 = component2.getParent()) {
                if (HoverListener.getAll((Component)component2).isEmpty()) continue;
                components = components.add(0, (Object)component2);
            }
        }
        int componentsCount = components.size();
        int hierarchySize = this.hierarchy.size();
        for (index = 0; index < hierarchySize && index < componentsCount && components.get(index) == this.hierarchy.get((int)index).reference.get(); ++index) {
        }
        while (index < hierarchySize) {
            this.hierarchy.remove(--hierarchySize).mouseExited();
        }
        if (index == componentsCount) {
            if (index > 0) {
                this.hierarchy.get(index - 1).mouseMoved(event);
            }
        } else {
            while (index < componentsCount) {
                ComponentPoint point = new ComponentPoint((Component)components.get(index++));
                this.hierarchy.add(point);
                point.mouseEntered(event);
            }
        }
    }

    private static Component getDeepestComponentAt(@NotNull Component parent, int x, int y) {
        if (parent == null) {
            HoverService.$$$reportNull$$$0(2);
        }
        if (!parent.contains(x, y)) {
            return null;
        }
        if (parent instanceof Container) {
            for (Component child : ((Container)parent).getComponents()) {
                Component deepest;
                if (child == null || !child.isVisible() || (deepest = child instanceof Container ? HoverService.getDeepestComponentAt(child, x - child.getX(), y - child.getY()) : child.getComponentAt(x - child.getX(), y - child.getY())) == null || !deepest.isVisible()) continue;
                return deepest;
            }
        }
        return parent instanceof IdeGlassPane ? null : parent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/HoverService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeepestComponentAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ComponentPoint {
        private final WeakReference<Component> reference;
        private final Point point;

        private ComponentPoint(@NotNull Component component2) {
            if (component2 == null) {
                ComponentPoint.$$$reportNull$$$0(0);
            }
            this.point = new Point();
            this.reference = new WeakReference<Component>(component2);
        }

        private void mouseEntered(@NotNull MouseEvent event) {
            Component component2;
            if (event == null) {
                ComponentPoint.$$$reportNull$$$0(1);
            }
            if ((component2 = (Component)this.reference.get()) == null) {
                return;
            }
            this.point.setLocation(event.getXOnScreen(), event.getYOnScreen());
            SwingUtilities.convertPointFromScreen(this.point, component2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("mouse entered into " + String.valueOf(component2));
            }
            ComponentPoint.notifySafely(component2, listener2 -> listener2.mouseEntered(component2, this.point.x, this.point.y));
        }

        private void mouseMoved(@NotNull MouseEvent event) {
            Component component2;
            if (event == null) {
                ComponentPoint.$$$reportNull$$$0(2);
            }
            if ((component2 = (Component)this.reference.get()) == null) {
                return;
            }
            int x = this.point.x;
            int y = this.point.y;
            this.point.setLocation(event.getXOnScreen(), event.getYOnScreen());
            SwingUtilities.convertPointFromScreen(this.point, component2);
            if (this.point.x == x && this.point.y == y) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("mouse moved in " + String.valueOf(component2));
            }
            ComponentPoint.notifySafely(component2, listener2 -> listener2.mouseMoved(component2, this.point.x, this.point.y));
        }

        private void mouseExited() {
            Component component2 = (Component)this.reference.get();
            if (component2 == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("mouse exited from " + String.valueOf(component2));
            }
            ComponentPoint.notifySafely(component2, listener2 -> listener2.mouseExited(component2));
        }

        private static void notifySafely(@NotNull Component component2, @NotNull Consumer<? super HoverListener> notify2) {
            if (component2 == null) {
                ComponentPoint.$$$reportNull$$$0(3);
            }
            if (notify2 == null) {
                ComponentPoint.$$$reportNull$$$0(4);
            }
            for (HoverListener listener2 : HoverListener.getAll((Component)component2)) {
                try {
                    notify2.accept((HoverListener)listener2);
                }
                catch (Exception exception) {
                    LOG.error((Throwable)exception);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notify";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/HoverService$ComponentPoint";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifySafely";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

