/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ProjectNameOrPathIfNotYetComputed;
import com.intellij.ide.RecentProject;
import com.intellij.ide.RecentProjectProvider;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.RemoteRecentProjectAction;
import com.intellij.ide.RemoteRecentProjectActionGroup;
import com.intellij.ide.vcs.RecentProjectsBranchesProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.wm.impl.headertoolbar.ProjectToolbarWidgetPresentable;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.ProviderRecentProjectItem;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectItem;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectTreeItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001aF\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u0002H\t\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0002\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u001a\u0010%\u001a\u0004\u0018\u00010\u00172\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0012H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u000e*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u000e*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\"\"\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/ide/RecentProjectProvider;", "createProjectsFromProvider", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/wm/impl/welcomeScreen/recentProjects/ProviderRecentProjectItem;", "provider", "insertProjectsFromProvider", "", "T", "projects", "projectsFromEP", "timestampGetter", "Lkotlin/Function1;", "", "createActionsFromProvider", "Lcom/intellij/openapi/actionSystem/AnAction;", "allowCustomProjectActions", "", "getDuplicateProjectNames", "", "Lcom/intellij/ide/ProjectNameOrPathIfNotYetComputed;", "openedPaths", "", "recentPaths", "recentProjectManager", "Lcom/intellij/ide/RecentProjectsManagerBase;", "getProviderProjectId", "project", "Lcom/intellij/ide/RecentProject;", "activationTimestamp", "Lcom/intellij/openapi/wm/impl/welcomeScreen/recentProjects/RecentProjectTreeItem;", "getActivationTimestamp", "(Lcom/intellij/openapi/wm/impl/welcomeScreen/recentProjects/RecentProjectTreeItem;)Ljava/lang/Long;", "(Lcom/intellij/openapi/actionSystem/AnAction;)Ljava/lang/Long;", "EP_NAME", "Lcom/intellij/ide/vcs/RecentProjectsBranchesProvider;", "getCurrentBranch", "projectPath", "nameIsDistinct", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nRecentProjectListActionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentProjectListActionProvider.kt\ncom/intellij/ide/RecentProjectListActionProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,512:1\n363#2,7:513\n*S KotlinDebug\n*F\n+ 1 RecentProjectListActionProvider.kt\ncom/intellij/ide/RecentProjectListActionProviderKt\n*L\n330#1:513,7\n*E\n"})
public final class RecentProjectListActionProviderKt {
    @NotNull
    private static final ExtensionPointName<RecentProjectProvider> EP = new ExtensionPointName("com.intellij.recentProjectsProvider");
    @NotNull
    private static final ExtensionPointName<RecentProjectsBranchesProvider> EP_NAME = new ExtensionPointName("com.intellij.recentProjectsBranchesProvider");

    private static final Sequence<ProviderRecentProjectItem> createProjectsFromProvider(RecentProjectProvider provider) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)provider.getRecentProjects()), arg_0 -> RecentProjectListActionProviderKt.createProjectsFromProvider$lambda$0(provider, arg_0));
    }

    private static final <T> List<T> insertProjectsFromProvider(List<? extends T> projects, List<? extends T> projectsFromEP, Function1<? super T, Long> timestampGetter) {
        if (projectsFromEP.isEmpty()) {
            return projects;
        }
        int cutIndex = RecentProjectListActionProviderKt.insertProjectsFromProvider$indexOfFirstOrSize(projects, arg_0 -> RecentProjectListActionProviderKt.insertProjectsFromProvider$lambda$0(timestampGetter, arg_0));
        List mergedPrefix = CollectionsKt.toMutableList((Collection)projects.subList(0, cutIndex));
        List mergedSuffix = CollectionsKt.toMutableList((Collection)projects.subList(cutIndex, projects.size()));
        for (T projectFromEP : projectsFromEP) {
            Long projectFromEPTimestamp = (Long)timestampGetter.invoke(projectFromEP);
            if (projectFromEPTimestamp == null) {
                mergedSuffix.add(projectFromEP);
                continue;
            }
            int insertIndex = RecentProjectListActionProviderKt.insertProjectsFromProvider$indexOfFirstOrSize(mergedPrefix, arg_0 -> RecentProjectListActionProviderKt.insertProjectsFromProvider$lambda$1(timestampGetter, projectFromEPTimestamp, arg_0));
            mergedPrefix.add(insertIndex, projectFromEP);
        }
        return CollectionsKt.plus((Collection)mergedPrefix, (Iterable)mergedSuffix);
    }

    private static final Sequence<AnAction> createActionsFromProvider(RecentProjectProvider provider, boolean allowCustomProjectActions) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)provider.getRecentProjects()), arg_0 -> RecentProjectListActionProviderKt.createActionsFromProvider$lambda$0(provider, allowCustomProjectActions, arg_0));
    }

    private static final Set<ProjectNameOrPathIfNotYetComputed> getDuplicateProjectNames(Set<String> openedPaths, Set<String> recentPaths, RecentProjectsManagerBase recentProjectManager) {
        HashSet<ProjectNameOrPathIfNotYetComputed> names = new HashSet<ProjectNameOrPathIfNotYetComputed>();
        HashSet<ProjectNameOrPathIfNotYetComputed> duplicates = new HashSet<ProjectNameOrPathIfNotYetComputed>();
        for (String path : SetsKt.plus(openedPaths, (Iterable)recentPaths)) {
            String name2 = ProjectNameOrPathIfNotYetComputed.constructor-impl(recentProjectManager.getProjectName(path));
            if (names.add(ProjectNameOrPathIfNotYetComputed.box-impl(name2))) continue;
            duplicates.add(ProjectNameOrPathIfNotYetComputed.box-impl(name2));
        }
        return duplicates;
    }

    private static final String getProviderProjectId(RecentProjectProvider provider, RecentProject project2) {
        String string = provider.getProviderId();
        String string2 = project2.getProjectId();
        if (string2 == null) {
            string2 = project2.getDisplayName();
        }
        return string + "$" + string2;
    }

    private static final Long getActivationTimestamp(RecentProjectTreeItem $this$activationTimestamp) {
        RecentProjectTreeItem recentProjectTreeItem = $this$activationTimestamp;
        return recentProjectTreeItem instanceof RecentProjectItem ? ((RecentProjectItem)$this$activationTimestamp).getActivationTimestamp() : (recentProjectTreeItem instanceof ProviderRecentProjectItem ? ((ProviderRecentProjectItem)$this$activationTimestamp).getActivationTimestamp() : null);
    }

    private static final Long getActivationTimestamp(AnAction $this$activationTimestamp) {
        return $this$activationTimestamp instanceof ProjectToolbarWidgetPresentable ? ((ProjectToolbarWidgetPresentable)$this$activationTimestamp).getActivationTimestamp() : null;
    }

    private static final String getCurrentBranch(String projectPath, boolean nameIsDistinct) {
        for (RecentProjectsBranchesProvider provider : EP_NAME.getExtensionList()) {
            String string = provider.getCurrentBranch(projectPath, nameIsDistinct);
            if (string == null) continue;
            String it = string;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private static final ProviderRecentProjectItem createProjectsFromProvider$lambda$0(RecentProjectProvider $provider, RecentProject project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new ProviderRecentProjectItem(RecentProjectListActionProviderKt.getProviderProjectId($provider, project2), project2);
    }

    private static final <T> int insertProjectsFromProvider$indexOfFirstOrSize(List<? extends T> $this$insertProjectsFromProvider_u24indexOfFirstOrSize, Function1<? super T, Boolean> predicate) {
        int n;
        block2: {
            List<T> $this$indexOfFirst$iv = $this$insertProjectsFromProvider_u24indexOfFirstOrSize;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (T item$iv : $this$indexOfFirst$iv) {
                if (((Boolean)predicate.invoke(item$iv)).booleanValue()) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = n;
        return index == -1 ? $this$insertProjectsFromProvider_u24indexOfFirstOrSize.size() : index;
    }

    private static final boolean insertProjectsFromProvider$lambda$0(Function1 $timestampGetter, Object it) {
        return $timestampGetter.invoke(it) == null;
    }

    private static final boolean insertProjectsFromProvider$lambda$1(Function1 $timestampGetter, Long $projectFromEPTimestamp, Object item) {
        Long l = (Long)$timestampGetter.invoke(item);
        long timestamp = l != null ? l : 0L;
        return timestamp < $projectFromEPTimestamp;
    }

    private static final AnAction createActionsFromProvider$lambda$0(RecentProjectProvider $provider, boolean $allowCustomProjectActions, RecentProject project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String projectId = RecentProjectListActionProviderKt.getProviderProjectId($provider, project2);
        return (AnAction)($allowCustomProjectActions ? new RemoteRecentProjectActionGroup(projectId, project2) : new RemoteRecentProjectAction(projectId, project2));
    }

    public static final /* synthetic */ Set access$getDuplicateProjectNames(Set openedPaths, Set recentPaths, RecentProjectsManagerBase recentProjectManager) {
        return RecentProjectListActionProviderKt.getDuplicateProjectNames(openedPaths, recentPaths, recentProjectManager);
    }

    public static final /* synthetic */ ExtensionPointName access$getEP$p() {
        return EP;
    }

    public static final /* synthetic */ Sequence access$createProjectsFromProvider(RecentProjectProvider provider) {
        return RecentProjectListActionProviderKt.createProjectsFromProvider(provider);
    }

    public static final /* synthetic */ List access$insertProjectsFromProvider(List projects, List projectsFromEP, Function1 timestampGetter) {
        return RecentProjectListActionProviderKt.insertProjectsFromProvider(projects, projectsFromEP, timestampGetter);
    }

    public static final /* synthetic */ Sequence access$createActionsFromProvider(RecentProjectProvider provider, boolean allowCustomProjectActions) {
        return RecentProjectListActionProviderKt.createActionsFromProvider(provider, allowCustomProjectActions);
    }

    public static final /* synthetic */ String access$getCurrentBranch(String projectPath, boolean nameIsDistinct) {
        return RecentProjectListActionProviderKt.getCurrentBranch(projectPath, nameIsDistinct);
    }

    public static final /* synthetic */ Long access$getActivationTimestamp(RecentProjectTreeItem $receiver) {
        return RecentProjectListActionProviderKt.getActivationTimestamp($receiver);
    }

    public static final /* synthetic */ Long access$getActivationTimestamp(AnAction $receiver) {
        return RecentProjectListActionProviderKt.getActivationTimestamp($receiver);
    }
}

