/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.ide.actions.CopyAction;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehavior;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.IconUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteAction
extends AnAction
implements DumbAware,
LightEditCompatible,
ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
    private static final Logger LOG = Logger.getInstance(DeleteAction.class);

    public DeleteAction() {
    }

    public DeleteAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
        super(text2, description, icon2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext2;
        DeleteProvider provider;
        if (e == null) {
            DeleteAction.$$$reportNull$$$0(0);
        }
        if ((provider = this.getDeleteProvider(dataContext2 = e.getDataContext())) == null) {
            return;
        }
        try {
            provider.deleteElement(dataContext2);
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    @Nullable
    protected DeleteProvider getDeleteProvider(DataContext dataContext2) {
        return (DeleteProvider)PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getData(dataContext2);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DeleteAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        presentation2.putClientProperty(ActionRemoteBehavior.SKIP_FALLBACK_UPDATE, null);
        if (e.isFromContextMenu()) {
            presentation2.setText(IdeBundle.messagePointer((String)"action.delete.ellipsis", (Object[])new Object[0]));
        } else {
            presentation2.setText(IdeBundle.messagePointer((String)"action.delete", (Object[])new Object[0]));
        }
        if (e.isFromActionToolbar() && presentation2.getIcon() == null) {
            presentation2.setIcon(IconUtil.getRemoveIcon());
        }
        if (e.getProject() == null) {
            presentation2.setEnabled(false);
            return;
        }
        CopyAction.updateWithProvider(e, this.getDeleteProvider(e.getDataContext()), false, provider -> {
            presentation2.putClientProperty(ActionRemoteBehavior.SKIP_FALLBACK_UPDATE, (Object)true);
            boolean isPopupPlace = e.isFromContextMenu();
            boolean enabled2 = provider != null && provider.canDeleteElement(e.getDataContext());
            presentation2.setEnabled(enabled2);
            presentation2.setVisible(!isPopupPlace || enabled2);
            if (provider instanceof TitledHandler) {
                TitledHandler th = (TitledHandler)provider;
                presentation2.setText(th.getActionTitle());
            }
        });
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DeleteAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/DeleteAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/DeleteAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

