/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfoKt;
import com.intellij.ide.ui.laf.UiThemeProviderListManager;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.colors.EditorColorSchemesSorter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class QuickChangeColorSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project2, @NotNull DefaultActionGroup group2, @NotNull DataContext dataContext2) {
        if (group2 == null) {
            QuickChangeColorSchemeAction.$$$reportNull$$$0(0);
        }
        if (dataContext2 == null) {
            QuickChangeColorSchemeAction.$$$reportNull$$$0(1);
        }
        EditorColorsScheme current = EditorColorsManager.getInstance().getGlobalScheme();
        EditorColorsScheme[] schemes = EditorColorsManager.getInstance().getAllSchemes();
        for (EditorColorsScheme scheme : EditorColorSchemesSorter.getInstance().getOrderedSchemesFromArray(schemes).getItems()) {
            QuickChangeColorSchemeAction.addScheme(group2, current, scheme, false);
        }
    }

    private static void addScheme(DefaultActionGroup group2, EditorColorsScheme current, final EditorColorsScheme scheme, final boolean addScheme) {
        String name2 = scheme.getDisplayName();
        group2.add((AnAction)new DumbAwareAction(name2, "", scheme == current ? AllIcons.Actions.Forward : ourNotCurrentAction){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (addScheme) {
                    EditorColorsManager.getInstance().addColorScheme(scheme);
                }
                EditorColorsScheme oldScheme = EditorColorsManager.getInstance().getGlobalScheme();
                EditorColorsManager.getInstance().setGlobalScheme(scheme);
                QuickChangeColorSchemeAction.changeLafIfNecessary(oldScheme, scheme);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (UIThemeLookAndFeelInfoKt.isDefaultForTheme((EditorColorsScheme)scheme, (UIThemeLookAndFeelInfo)LafManager.getInstance().getCurrentUIThemeLookAndFeel())) {
                    e.getPresentation().putClientProperty(ActionUtil.SECONDARY_TEXT, (Object)IdeBundle.message((String)"scheme.theme.default", (Object[])new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/QuickChangeColorSchemeAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/QuickChangeColorSchemeAction$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
    }

    public static void changeLafIfNecessary(@NotNull EditorColorsScheme oldScheme, EditorColorsScheme newScheme) {
        if (oldScheme == null) {
            QuickChangeColorSchemeAction.$$$reportNull$$$0(2);
        }
        QuickChangeColorSchemeAction.changeLafIfNecessary(oldScheme, newScheme, null);
    }

    public static void changeLafIfNecessary(@NotNull EditorColorsScheme oldScheme, EditorColorsScheme newScheme, @Nullable Runnable onDone) {
        UIThemeLookAndFeelInfo currentLafInfo;
        Boolean isDark;
        if (oldScheme == null) {
            QuickChangeColorSchemeAction.$$$reportNull$$$0(3);
        }
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        LafManager lafManager = LafManager.getInstance();
        boolean isDarkEditorTheme = ColorUtil.isDark((Color)newScheme.getDefaultBackground());
        lafManager.rememberSchemeForLaf(oldScheme);
        lafManager.setRememberSchemeForLaf(false);
        boolean lafChanged = false;
        UIThemeLookAndFeelInfo suitableLaf = null;
        String schemeName = Scheme.getBaseName((String)newScheme.getName());
        for (UIThemeLookAndFeelInfo laf : SequencesKt.asIterable(UiThemeProviderListManager.Companion.getInstance().getLaFs())) {
            if (!schemeName.equals(laf.getEditorSchemeId())) continue;
            suitableLaf = laf;
            break;
        }
        Boolean bl = isDark = (currentLafInfo = lafManager.getCurrentUIThemeLookAndFeel()) == null ? null : Boolean.valueOf(currentLafInfo.isDark());
        if (isDarkEditorTheme && isDark != null && !isDark.booleanValue()) {
            if (Messages.showYesNoDialog((String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation", (Object[])new Object[]{"dark", productName}), (String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation.title", (Object[])new Object[]{productName}), (String)Messages.getYesButton(), (String)Messages.getNoButton(), (Icon)Messages.getQuestionIcon()) == 0) {
                lafManager.setCurrentLookAndFeel(suitableLaf == null ? Objects.requireNonNull(lafManager.getDefaultDarkLaf()) : suitableLaf, true);
                lafChanged = true;
                lafManager.updateUI();
                SwingUtilities.invokeLater(DarculaInstaller::install);
            }
        } else if (!isDarkEditorTheme && isDark != null && isDark.booleanValue() && Messages.showYesNoDialog((String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation", (Object[])new Object[]{"bright", productName}), (String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation.title", (Object[])new Object[]{productName}), (String)Messages.getYesButton(), (String)Messages.getNoButton(), (Icon)Messages.getQuestionIcon()) == 0) {
            lafManager.setCurrentLookAndFeel(suitableLaf == null ? Objects.requireNonNull(lafManager.getDefaultLightLaf()) : suitableLaf, true);
            lafChanged = true;
            lafManager.updateUI();
            SwingUtilities.invokeLater(DarculaInstaller::uninstall);
        }
        lafManager.setRememberSchemeForLaf(true);
        if (!lafChanged) {
            lafManager.rememberSchemeForLaf(newScheme);
        }
        if (onDone != null) {
            SwingUtilities.invokeLater(onDone);
        }
    }

    protected boolean isEnabled() {
        return EditorColorsManager.getInstance().getAllSchemes().length > 1 && !LafManager.getInstance().getAutodetect();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldScheme";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/QuickChangeColorSchemeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillActions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "changeLafIfNecessary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

