/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RecentLocationsAction;
import com.intellij.ide.actions.Switcher;
import com.intellij.ide.actions.SwitcherListItem;
import com.intellij.ide.actions.SwitcherRenderingKt;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.JBUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/actions/SwitcherRecentLocations;", "Lcom/intellij/ide/actions/SwitcherListItem;", "switcher", "Lcom/intellij/ide/actions/Switcher$SwitcherPanel;", "<init>", "(Lcom/intellij/ide/actions/Switcher$SwitcherPanel;)V", "getSwitcher", "()Lcom/intellij/ide/actions/Switcher$SwitcherPanel;", "separatorAbove", "", "getSeparatorAbove", "()Z", "mainText", "", "getMainText", "()Ljava/lang/String;", "statusText", "getStatusText", "shortcutText", "getShortcutText", "navigate", "", "mode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "prepareMainRenderer", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "selected", "intellij.platform.ide.impl"})
public final class SwitcherRecentLocations
implements SwitcherListItem {
    @NotNull
    private final Switcher.SwitcherPanel switcher;
    private final boolean separatorAbove;

    public SwitcherRecentLocations(@NotNull Switcher.SwitcherPanel switcher) {
        Intrinsics.checkNotNullParameter((Object)((Object)switcher), (String)"switcher");
        this.switcher = switcher;
        this.separatorAbove = true;
    }

    @NotNull
    public final Switcher.SwitcherPanel getSwitcher() {
        return this.switcher;
    }

    @Override
    public boolean getSeparatorAbove() {
        return this.separatorAbove;
    }

    @Override
    @NotNull
    public String getMainText() {
        String string;
        if (this.switcher.isOnlyEditedFilesShown()) {
            String string2 = IdeBundle.message((String)"recent.locations.changed.locations", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = IdeBundle.message((String)"recent.locations.popup.title", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    @Override
    @NotNull
    public String getStatusText() {
        String string;
        if (this.switcher.isOnlyEditedFilesShown()) {
            String string2 = IdeBundle.message((String)"recent.files.accessible.open.recently.edited.locations", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = IdeBundle.message((String)"recent.files.accessible.open.recently.viewed.locations", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    @Override
    @Nullable
    public String getShortcutText() {
        return this.switcher.isOnlyEditedFilesShown() ? null : SwitcherRenderingKt.access$shortcutText("RecentLocations");
    }

    @Override
    public void navigate(@NotNull Switcher.SwitcherPanel switcher, @NotNull FileEditorManagerImpl.OpenMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)switcher), (String)"switcher");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        RecentLocationsAction.showPopup(switcher.getProject(), switcher.isOnlyEditedFilesShown());
    }

    @Override
    public void prepareMainRenderer(@NotNull SimpleColoredComponent component2, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.setIconTextGap(JBUI.CurrentTheme.ActionsList.elementIconGap());
        component2.append(this.getMainText());
    }
}

