/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.mac.MacFullScreenControlsManager;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TogglePresentationModeAction
extends AnAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    private static final Logger LOG = Logger.getInstance(TogglePresentationModeAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TogglePresentationModeAction.$$$reportNull$$$0(0);
        }
        boolean selected = UISettings.getInstance().getPresentationMode();
        e.getPresentation().setText(selected ? ActionsBundle.message((String)"action.TogglePresentationMode.exit", (Object[])new Object[0]) : ActionsBundle.message((String)"action.TogglePresentationMode.enter", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TogglePresentationModeAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            TogglePresentationModeAction.$$$reportNull$$$0(2);
        }
        TogglePresentationModeAction.setPresentationMode(e.getProject(), !UISettings.getInstance().getPresentationMode());
    }

    public static void setPresentationMode(@Nullable Project project2, boolean inPresentation) {
        TogglePresentationModeAction.storeToolWindows(project2);
        TogglePresentationModeAction.log(String.format("Will tweak full screen mode for presentation=%b", inPresentation));
        UISettings.getInstance().setPresentationMode(inPresentation);
        float oldScale = UISettingsUtils.getInstance().getCurrentIdeScale();
        UISettings.getInstance().fireUISettingsChanged();
        if (oldScale == UISettingsUtils.getInstance().getCurrentIdeScale()) {
            LafManager.getInstance().updateUI();
        }
        CompletableDeferred callback = project2 == null ? CompletableDeferredKt.CompletableDeferred((Object)Unit.INSTANCE) : TogglePresentationModeAction.tweakFrameFullScreen(project2, inPresentation);
        callback.invokeOnCompletion(__ -> {
            SwingUtilities.invokeLater(() -> TogglePresentationModeAction.restoreToolWindows(project2));
            return Unit.INSTANCE;
        });
    }

    @NotNull
    private static Job tweakFrameFullScreen(Project project2, boolean inPresentation) {
        ProjectFrameHelper frame = ProjectFrameHelper.getFrameHelper(IdeFrameImpl.getActiveFrame());
        if (frame == null) {
            CompletableDeferred completableDeferred = CompletableDeferredKt.CompletableDeferred((Object)Unit.INSTANCE);
            if (completableDeferred == null) {
                TogglePresentationModeAction.$$$reportNull$$$0(3);
            }
            return completableDeferred;
        }
        if (SystemInfo.isMac) {
            MacFullScreenControlsManager.INSTANCE.updateForPresentationMode();
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project2);
        if (inPresentation) {
            propertiesComponent.setValue("full.screen.before.presentation.mode", String.valueOf(frame.isInFullScreen()));
            Job job2 = frame.toggleFullScreen(true);
            if (job2 == null) {
                TogglePresentationModeAction.$$$reportNull$$$0(4);
            }
            return job2;
        }
        if (frame.isInFullScreen()) {
            String value = propertiesComponent.getValue("full.screen.before.presentation.mode");
            Job job3 = frame.toggleFullScreen("true".equalsIgnoreCase(value));
            if (job3 == null) {
                TogglePresentationModeAction.$$$reportNull$$$0(5);
            }
            return job3;
        }
        CompletableDeferred completableDeferred = CompletableDeferredKt.CompletableDeferred((Object)Unit.INSTANCE);
        if (completableDeferred == null) {
            TogglePresentationModeAction.$$$reportNull$$$0(6);
        }
        return completableDeferred;
    }

    private static boolean hideAllToolWindows(@NotNull ToolWindowManagerEx manager2) {
        if (manager2 == null) {
            TogglePresentationModeAction.$$$reportNull$$$0(7);
        }
        manager2.clearSideStack();
        boolean hasVisible = false;
        for (ToolWindow toolWindow2 : manager2.getToolWindows()) {
            if (!toolWindow2.isVisible()) continue;
            toolWindow2.hide();
            hasVisible = true;
        }
        return hasVisible;
    }

    private static void storeToolWindows(@Nullable Project project2) {
        TogglePresentationModeAction.storeToolWindows(project2, DistractionFreeModeController.isDistractionFreeModeEnabled());
    }

    static void storeToolWindows(@Nullable Project project2, boolean inDistractionFree) {
        if (project2 == null) {
            return;
        }
        boolean inPresentation = UISettings.getInstance().getPresentationMode();
        ToolWindowManagerEx manager2 = ToolWindowManagerEx.getInstanceEx(project2);
        DesktopLayout layout2 = manager2.getLayout().copy();
        if (TogglePresentationModeAction.hideAllToolWindows(manager2)) {
            if (TogglePresentationModeAction.shouldStoreOrRestoreToolWindowLayout(inPresentation, inDistractionFree)) {
                manager2.setLayoutToRestoreLater(layout2);
            }
            manager2.activateEditorComponent();
        }
    }

    private static void restoreToolWindows(@Nullable Project project2) {
        TogglePresentationModeAction.restoreToolWindows(project2, DistractionFreeModeController.isDistractionFreeModeEnabled());
    }

    static void restoreToolWindows(@Nullable Project project2, boolean inDistractionFree) {
        if (project2 == null) {
            return;
        }
        boolean inPresentation = UISettings.getInstance().getPresentationMode();
        TogglePresentationModeAction.log(String.format("Will restore tool windows for presentation=%b", inPresentation));
        ToolWindowManagerEx manager2 = ToolWindowManagerEx.getInstanceEx(project2);
        DesktopLayout restoreLayout = manager2.getLayoutToRestoreLater();
        if (TogglePresentationModeAction.shouldStoreOrRestoreToolWindowLayout(inPresentation, inDistractionFree) && restoreLayout != null) {
            manager2.setLayout(restoreLayout);
            manager2.setLayoutToRestoreLater(null);
        }
    }

    private static boolean shouldStoreOrRestoreToolWindowLayout(boolean inPresentation, boolean inDistractionFree) {
        return !inPresentation && !inDistractionFree;
    }

    private static void log(String message) {
        if (ApplicationManager.getApplication().isEAP()) {
            LOG.info(message);
        } else {
            LOG.debug(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/TogglePresentationModeAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/TogglePresentationModeAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakFrameFullScreen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hideAllToolWindows";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

