/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.ui.StatusText;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class ToolWindowEmptyStateAction
extends ActivateToolWindowAction {
    protected ToolWindowEmptyStateAction(@NotNull String toolWindowId, Icon icon2) {
        if (toolWindowId == null) {
            ToolWindowEmptyStateAction.$$$reportNull$$$0(0);
        }
        super(toolWindowId);
        this.getTemplatePresentation().setIcon(icon2);
    }

    @Override
    protected boolean hasEmptyState(@NotNull Project project2) {
        if (project2 == null) {
            ToolWindowEmptyStateAction.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    protected void createEmptyState(@NotNull Project project2) {
        if (project2 == null) {
            ToolWindowEmptyStateAction.$$$reportNull$$$0(2);
        }
        this.ensureToolWindowCreated(project2);
        ToolWindow toolWindow2 = ToolWindowManager.getInstance((Project)project2).getToolWindow(this.getToolWindowId());
        if (toolWindow2 == null) {
            return;
        }
        toolWindow2.setAvailable(true);
        if (toolWindow2 instanceof ToolWindowImpl) {
            ToolWindowImpl windowImpl = (ToolWindowImpl)toolWindow2;
            StatusText emptyText = windowImpl.getEmptyText();
            this.setupEmptyText(project2, emptyText);
            ToolWindowEmptyStateAction.setEmptyStateBackground(toolWindow2);
        }
        ToolWindowEmptyStateAction.rebuildContentUi(toolWindow2);
        toolWindow2.show();
        toolWindow2.activate(null, true);
    }

    protected abstract void setupEmptyText(@NotNull Project var1, @NotNull StatusText var2);

    protected abstract void ensureToolWindowCreated(@NotNull Project var1);

    public static void setEmptyStateBackground(@NotNull ToolWindow toolWindow2) {
        if (toolWindow2 == null) {
            ToolWindowEmptyStateAction.$$$reportNull$$$0(3);
        }
        if (toolWindow2 instanceof ToolWindowImpl) {
            ((ToolWindowImpl)toolWindow2).setEmptyStateBackground(JBColor.background());
        }
    }

    public static void rebuildContentUi(@NotNull ToolWindow toolWindow2) {
        ContentUI ui;
        ContentManager manager2;
        if (toolWindow2 == null) {
            ToolWindowEmptyStateAction.$$$reportNull$$$0(4);
        }
        if ((manager2 = toolWindow2.getContentManager()) instanceof ContentManagerImpl && (ui = ((ContentManagerImpl)manager2).getUI()) instanceof ToolWindowContentUi) {
            ((ToolWindowContentUi)ui).rebuild();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/ToolWindowEmptyStateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasEmptyState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createEmptyState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setEmptyStateBackground";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "rebuildContentUi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

