/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToolwindowFusEventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.SquareStripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.toolWindow.ToolWindowDragHelper;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.UIBundle;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowMoveAction
extends DumbAwareAction
implements FusAwareAction,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    private final Anchor myAnchor;

    @Nullable
    private static ToolWindowManager getToolWindowManager(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(0);
        }
        return (project2 = e.getProject()) == null || project2.isDisposed() ? null : ToolWindowManager.getInstance((Project)project2);
    }

    @Nullable
    public static ToolWindow getToolWindow(@NotNull AnActionEvent e) {
        ToolWindowManager manager2;
        if (e == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(1);
        }
        if ((manager2 = ToolWindowMoveAction.getToolWindowManager(e)) == null) {
            return null;
        }
        ToolWindow window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (window != null) {
            return window;
        }
        Component component2 = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        if (component2 instanceof SquareStripeButton) {
            return ((SquareStripeButton)component2).getToolWindow();
        }
        if (component2 instanceof ToolWindowDragHelper.ToolWindowProvider) {
            ToolWindowDragHelper.ToolWindowProvider twp = (ToolWindowDragHelper.ToolWindowProvider)((Object)component2);
            return twp.getToolWindow();
        }
        String id2 = manager2.getActiveToolWindowId();
        return id2 == null ? null : manager2.getToolWindow(id2);
    }

    public ToolWindowMoveAction(@NotNull Anchor anchor) {
        if (anchor == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(2);
        }
        super(() -> anchor.toString(), null, () -> anchor.getIcon());
        this.myAnchor = anchor;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ToolWindow toolWindow2;
        if (e == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(3);
        }
        if ((toolWindow2 = ToolWindowMoveAction.getToolWindow(e)) != null) {
            this.myAnchor.applyTo(toolWindow2);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(4);
        }
        ToolWindow toolWindow2 = ToolWindowMoveAction.getToolWindow(e);
        e.getPresentation().setVisible(toolWindow2 != null);
        e.getPresentation().setEnabled(toolWindow2 != null && !this.myAnchor.isApplied(toolWindow2));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(5);
        }
        return actionUpdateThread;
    }

    @Override
    @NotNull
    public List<EventPair<?>> getAdditionalUsageData(@NotNull AnActionEvent event) {
        ToolWindow toolWindow2;
        if (event == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(6);
        }
        if ((toolWindow2 = ToolWindowMoveAction.getToolWindow(event)) != null) {
            List<EventPair<?>> list2 = Collections.singletonList(ToolwindowFusEventFields.TOOLWINDOW.with((Object)toolWindow2.getId()));
            if (list2 == null) {
                ToolWindowMoveAction.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List<EventPair<?>> list3 = Collections.emptyList();
        if (list3 == null) {
            ToolWindowMoveAction.$$$reportNull$$$0(8);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToolWindowMoveAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToolWindowMoveAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowManager";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalUsageData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static enum Anchor {
        LeftTop,
        LeftBottom,
        BottomLeft,
        BottomRight,
        RightBottom,
        RightTop,
        TopRight,
        TopLeft;


        @Nls
        public String toString() {
            String top = UIBundle.message((String)"tool.window.move.to.top.action.name", (Object[])new Object[0]);
            String left = UIBundle.message((String)"tool.window.move.to.left.action.name", (Object[])new Object[0]);
            String bottom = UIBundle.message((String)"tool.window.move.to.bottom.action.name", (Object[])new Object[0]);
            String right = UIBundle.message((String)"tool.window.move.to.right.action.name", (Object[])new Object[0]);
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> left + " " + top;
                case 2 -> bottom + " " + left;
                case 3 -> bottom + " " + right;
                case 5 -> right + " " + top;
                case 1 -> left + " " + bottom;
                case 4 -> right + " " + bottom;
                case 6 -> top + " " + right;
                case 7 -> top + " " + left;
            };
        }

        @NotNull
        public static Anchor fromWindowInfo(@NotNull WindowInfo info) {
            if (info == null) {
                Anchor.$$$reportNull$$$0(0);
            }
            return Anchor.getAnchor(info.getAnchor(), info.isSplit());
        }

        @NotNull
        public static Anchor getAnchor(@NotNull ToolWindowAnchor anchor, boolean split) {
            if (anchor == null) {
                Anchor.$$$reportNull$$$0(1);
            }
            if (split) {
                if (anchor == ToolWindowAnchor.LEFT) {
                    Anchor anchor2 = LeftBottom;
                    if (anchor2 == null) {
                        Anchor.$$$reportNull$$$0(2);
                    }
                    return anchor2;
                }
                if (anchor == ToolWindowAnchor.BOTTOM) {
                    Anchor anchor3 = BottomRight;
                    if (anchor3 == null) {
                        Anchor.$$$reportNull$$$0(3);
                    }
                    return anchor3;
                }
                if (anchor == ToolWindowAnchor.RIGHT) {
                    Anchor anchor4 = RightBottom;
                    if (anchor4 == null) {
                        Anchor.$$$reportNull$$$0(4);
                    }
                    return anchor4;
                }
                if (anchor == ToolWindowAnchor.TOP) {
                    Anchor anchor5 = TopRight;
                    if (anchor5 == null) {
                        Anchor.$$$reportNull$$$0(5);
                    }
                    return anchor5;
                }
            }
            if (anchor == ToolWindowAnchor.LEFT) {
                Anchor anchor6 = LeftTop;
                if (anchor6 == null) {
                    Anchor.$$$reportNull$$$0(6);
                }
                return anchor6;
            }
            if (anchor == ToolWindowAnchor.BOTTOM) {
                Anchor anchor7 = BottomLeft;
                if (anchor7 == null) {
                    Anchor.$$$reportNull$$$0(7);
                }
                return anchor7;
            }
            if (anchor == ToolWindowAnchor.RIGHT) {
                Anchor anchor8 = RightTop;
                if (anchor8 == null) {
                    Anchor.$$$reportNull$$$0(8);
                }
                return anchor8;
            }
            Anchor anchor9 = TopLeft;
            if (anchor9 == null) {
                Anchor.$$$reportNull$$$0(9);
            }
            return anchor9;
        }

        @NotNull
        public ToolWindowAnchor getAnchor() {
            ToolWindowAnchor toolWindowAnchor = switch (this.ordinal()) {
                case 0, 1 -> ToolWindowAnchor.LEFT;
                case 2, 3 -> ToolWindowAnchor.BOTTOM;
                case 4, 5 -> ToolWindowAnchor.RIGHT;
                default -> ToolWindowAnchor.TOP;
            };
            if (toolWindowAnchor == null) {
                Anchor.$$$reportNull$$$0(10);
            }
            return toolWindowAnchor;
        }

        public boolean isSplit() {
            return Arrays.asList(LeftBottom, BottomRight, RightBottom, TopRight).contains((Object)this);
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2 = switch (this.ordinal()) {
                case 0 -> AllIcons.Actions.MoveToLeftTop;
                case 1 -> AllIcons.Actions.MoveToLeftBottom;
                case 2 -> AllIcons.Actions.MoveToBottomLeft;
                case 3 -> AllIcons.Actions.MoveToBottomRight;
                case 4 -> AllIcons.Actions.MoveToRightBottom;
                case 5 -> AllIcons.Actions.MoveToRightTop;
                case 6 -> AllIcons.Actions.MoveToTopRight;
                default -> AllIcons.Actions.MoveToTopLeft;
            };
            if (icon2 == null) {
                Anchor.$$$reportNull$$$0(11);
            }
            return icon2;
        }

        boolean isApplied(@NotNull ToolWindow window) {
            if (window == null) {
                Anchor.$$$reportNull$$$0(12);
            }
            return this.getAnchor() == window.getAnchor() && window.isSplitMode() == this.isSplit();
        }

        public void applyTo(@NotNull ToolWindow window) {
            if (window == null) {
                Anchor.$$$reportNull$$$0(13);
            }
            this.applyTo(window, -1);
        }

        public void applyTo(@NotNull ToolWindow window, int order) {
            if (window == null) {
                Anchor.$$$reportNull$$$0(14);
            }
            if (window instanceof ToolWindowImpl) {
                ToolWindowImpl toolWindow2 = (ToolWindowImpl)window;
                toolWindow2.setSideToolAndAnchor(this.getAnchor(), this.isSplit(), order);
            } else {
                window.setAnchor(this.getAnchor(), null);
                window.setSplitMode(this.isSplit(), null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/ToolWindowMoveAction$Anchor";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/ToolWindowMoveAction$Anchor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnchor";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromWindowInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnchor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplied";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "applyTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Group
    extends DefaultActionGroup
    implements DumbAware {
        public Group() {
            super(UIBundle.messagePointer((String)"tool.window.move.to.action.group.name", (Object[])new Object[0]), true);
            this.addAll(Group.generateActions());
        }

        @NotNull
        private static List<? extends AnAction> generateActions() {
            List<ToolWindowMoveAction> list2 = Arrays.stream(Anchor.values()).filter(x -> Group.isAllowed(x)).map(x -> new ToolWindowMoveAction((Anchor)((Object)x))).toList();
            if (list2 == null) {
                Group.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static boolean isAllowed(Anchor anchor) {
            if (ExperimentalUI.isNewUI()) {
                return anchor != Anchor.TopLeft && anchor != Anchor.TopRight;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToolWindowMoveAction$Group", "generateActions"));
        }
    }
}

