/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.ConsentOptionsProvider;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.DataCollectionAgreement;
import com.intellij.ide.gdpr.localConsents.LocalConsentOptions;
import com.intellij.ide.gdpr.trace.TraceConsentManager;
import com.intellij.ide.gdpr.ui.consents.AiDataCollectionExternalSettings;
import com.intellij.ui.LicensingFacade;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class ConsentOptionsProviderImpl
implements ConsentOptionsProvider {
    private static final Set<String> productsSupportingForcedConsent = Set.of("QA", "RR", "WS", "RD", "CL", "RM", "DB");
    private static final int METADATA_LICENSE_TYPE_INDEX = 10;
    private volatile long myLastModificationCount = -1L;
    private volatile boolean mySendingAllowed = false;

    ConsentOptionsProviderImpl() {
    }

    public boolean isEAP() {
        return ConsentOptions.getInstance().isEAP();
    }

    public boolean isActivatedWithFreeLicense() {
        LicensingFacade facade2 = LicensingFacade.getInstance();
        if (facade2 == null || !productsSupportingForcedConsent.contains(facade2.platformProductCode)) {
            return false;
        }
        String meta = facade2.metadata;
        return meta != null && meta.length() > 10 && meta.charAt(10) == 'F';
    }

    public void setSendingUsageStatsAllowed(boolean allowed) {
        ConsentOptions.getInstance().setSendingUsageStatsAllowed(allowed);
    }

    public boolean isSendingUsageStatsAllowed() {
        boolean allowedNow;
        long modificationCount = ConsentOptions.getInstance().getModificationCount();
        if (this.myLastModificationCount == modificationCount) {
            return this.mySendingAllowed;
        }
        this.mySendingAllowed = allowedNow = ConsentOptions.getInstance().isSendingUsageStatsAllowed() == ConsentOptions.Permission.YES;
        this.myLastModificationCount = modificationCount;
        return allowedNow;
    }

    public boolean isTraceDataCollectionAllowed() {
        LicensingFacade facade2 = LicensingFacade.getInstance();
        if (facade2 == null) {
            return false;
        }
        String metadata = facade2.metadata;
        if (metadata == null) {
            return false;
        }
        AiDataCollectionExternalSettings settings = AiDataCollectionExternalSettings.findSettingsImplementedByAiAssistant();
        boolean isAllowed = ConsentOptionsProviderImpl.isTraceDataCollectionAllowedByMetadata(metadata);
        boolean isDisabled = settings != null && settings.isForciblyDisabled();
        return isAllowed && !isDisabled;
    }

    private static boolean isTraceDataCollectionAllowedByMetadata(@NotNull String metadata) {
        if (metadata == null) {
            ConsentOptionsProviderImpl.$$$reportNull$$$0(0);
        }
        if (metadata.length() <= 10) {
            return false;
        }
        TraceConsentManager traceConsentManager = TraceConsentManager.getInstance();
        if (traceConsentManager == null || !traceConsentManager.canDisplayTraceConsent()) {
            return false;
        }
        DataCollectionAgreement dataCollectionAgreement = DataCollectionAgreement.getInstance();
        ConsentOptions.Permission traceDataCollectionPermission = metadata.charAt(10) == 'F' ? LocalConsentOptions.INSTANCE.getTraceDataCollectionNonComPermission() : LocalConsentOptions.INSTANCE.getTraceDataCollectionComPermission();
        return dataCollectionAgreement == DataCollectionAgreement.YES || dataCollectionAgreement != DataCollectionAgreement.NO && traceDataCollectionPermission == ConsentOptions.Permission.YES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/intellij/ide/gdpr/ConsentOptionsProviderImpl", "isTraceDataCollectionAllowedByMetadata"));
    }
}

