/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class InstalledPluginsState {
    @NonNls
    public static final String RESTART_REQUIRED_MESSAGE = "Not allowing load/unload without restart because of pending restart operation";
    private final Object myLock = new Object();
    private final Map<PluginId, IdeaPluginDescriptor> myInstalledPlugins = new HashMap<PluginId, IdeaPluginDescriptor>();
    private final Set<PluginId> myInstalledWithoutRestartPlugins = new HashSet<PluginId>();
    private final Set<PluginId> myUpdatedPlugins = new HashSet<PluginId>();
    private final Set<PluginId> myUpdatedWithoutRestartPlugins = new HashSet<PluginId>();
    private final Set<PluginId> myUninstalledWithoutRestartPlugins = new HashSet<PluginId>();
    private final Set<String> myOutdatedPlugins = new HashSet<String>();
    private boolean myInstallationInProgress = false;
    private boolean myRestartRequired = false;
    private Runnable myShutdownCallback;
    private static List<IdeaPluginDescriptor> myPreInstalledPlugins;

    @Nullable
    public static InstalledPluginsState getInstanceIfLoaded() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() ? InstalledPluginsState.getInstance() : null;
    }

    public static InstalledPluginsState getInstance() {
        return (InstalledPluginsState)ApplicationManager.getApplication().getService(InstalledPluginsState.class);
    }

    public static void addPreInstalledPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(0);
        }
        if (myPreInstalledPlugins == null) {
            myPreInstalledPlugins = new ArrayList<IdeaPluginDescriptor>();
        }
        myPreInstalledPlugins.add(descriptor2);
    }

    public InstalledPluginsState() {
        if (myPreInstalledPlugins != null) {
            for (IdeaPluginDescriptor plugin : myPreInstalledPlugins) {
                if (PluginManagerCore.isPluginInstalled((PluginId)plugin.getPluginId())) continue;
                this.onPluginInstall(plugin, false, false);
            }
            myPreInstalledPlugins = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<IdeaPluginDescriptor> getInstalledPlugins() {
        Object object = this.myLock;
        // MONITORENTER : object
        Collection<IdeaPluginDescriptor> collection = Collections.unmodifiableCollection(this.myInstalledPlugins.values());
        // MONITOREXIT : object
        if (collection != null) return collection;
        InstalledPluginsState.$$$reportNull$$$0(1);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<PluginId> getInstalledWithoutRestartPlugins() {
        Object object = this.myLock;
        // MONITORENTER : object
        Collection<PluginId> collection = Collections.unmodifiableCollection(this.myInstalledWithoutRestartPlugins);
        // MONITOREXIT : object
        if (collection != null) return collection;
        InstalledPluginsState.$$$reportNull$$$0(2);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<PluginId> getUpdatedPlugins() {
        Object object = this.myLock;
        // MONITORENTER : object
        Collection<PluginId> collection = Collections.unmodifiableCollection(this.myUpdatedPlugins);
        // MONITOREXIT : object
        if (collection != null) return collection;
        InstalledPluginsState.$$$reportNull$$$0(3);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNewerVersion(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            return !this.wasUpdated(id2) && this.myOutdatedPlugins.contains(id2.getIdString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasInstalled(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myInstalledPlugins.containsKey(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasInstalledWithoutRestart(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myInstalledWithoutRestartPlugins.contains(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasUninstalledWithoutRestart(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myUninstalledWithoutRestartPlugins.contains(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasUpdated(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myUpdatedPlugins.contains(id2) || this.myUpdatedWithoutRestartPlugins.contains(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasUpdatedWithRestart(@NotNull PluginId id2) {
        if (id2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myUpdatedPlugins.contains(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void onDescriptorDownload(@NotNull PluginUiModel descriptor2) {
        PluginId id2;
        IdeaPluginDescriptor existing;
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(10);
        }
        if ((existing = PluginManagerCore.getPlugin((PluginId)(id2 = descriptor2.getPluginId()))) == null || existing.isBundled() && !existing.allowBundledUpdate() || this.wasUpdated(id2)) {
            return;
        }
        boolean supersedes = PluginManagerCore.isCompatible((IdeaPluginDescriptor)descriptor2.getDescriptor()) && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor2.getVersion(), existing) > 0;
        String idString = id2.getIdString();
        Object object = this.myLock;
        synchronized (object) {
            if (supersedes) {
                this.myOutdatedPlugins.add(idString);
            } else {
                this.myOutdatedPlugins.remove(idString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void onPluginInstall(@NotNull IdeaPluginDescriptor descriptor2, boolean isUpdate, boolean restartNeeded) {
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(11);
        }
        PluginId id2 = descriptor2.getPluginId();
        Object object = this.myLock;
        synchronized (object) {
            this.myOutdatedPlugins.remove(id2.getIdString());
            if (isUpdate) {
                if (restartNeeded) {
                    this.myUpdatedPlugins.add(id2);
                } else {
                    this.myUpdatedWithoutRestartPlugins.add(id2);
                }
            } else if (restartNeeded) {
                this.myInstalledPlugins.put(id2, descriptor2);
            } else {
                this.myInstalledWithoutRestartPlugins.add(id2);
            }
        }
        PluginManagerUsageCollector.pluginInstallationFinished(descriptor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void onPluginLoadAfterInstall(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myInstalledPlugins.remove(descriptor2.getPluginId());
            this.myInstalledWithoutRestartPlugins.add(descriptor2.getPluginId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void onPluginUninstall(@NotNull IdeaPluginDescriptor descriptor2, boolean isDynamicallyUnloadable) {
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(13);
        }
        PluginId id2 = descriptor2.getPluginId();
        if (isDynamicallyUnloadable) {
            Object object = this.myLock;
            synchronized (object) {
                this.myUninstalledWithoutRestartPlugins.add(id2);
            }
        }
        PluginManagerUsageCollector.pluginRemoved(id2);
    }

    @ApiStatus.Internal
    public void resetChangesAppliedWithoutRestart() {
        if (!this.myInstallationInProgress) {
            this.myInstalledWithoutRestartPlugins.clear();
            this.myUninstalledWithoutRestartPlugins.clear();
        }
    }

    @ApiStatus.Internal
    public void trackPluginInstallation(Runnable runnable2) {
        this.myInstallationInProgress = true;
        try {
            runnable2.run();
        }
        finally {
            this.myInstallationInProgress = false;
        }
    }

    @ApiStatus.Internal
    public void setShutdownCallback(Runnable runnable2) {
        if (this.myShutdownCallback == null) {
            this.myShutdownCallback = runnable2;
        }
    }

    @ApiStatus.Internal
    public void clearShutdownCallback() {
        this.myShutdownCallback = null;
    }

    @ApiStatus.Internal
    public synchronized void runShutdownCallback() {
        if (this.myShutdownCallback != null) {
            this.myShutdownCallback.run();
            this.myShutdownCallback = null;
        }
    }

    public boolean isRestartRequired() {
        return this.myRestartRequired;
    }

    @ApiStatus.Internal
    public void setRestartRequired(boolean restartRequired) {
        this.myRestartRequired = restartRequired;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/InstalledPluginsState";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPlugins";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledWithoutRestartPlugins";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPreInstalledPlugin";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasNewerVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wasInstalled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wasInstalledWithoutRestart";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wasUninstalledWithoutRestart";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wasUpdated";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wasUpdatedWithRestart";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onDescriptorDownload";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onPluginInstall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onPluginLoadAfterInstall";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onPluginUninstall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

