/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.CreateMarketplacePanelModel;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.ListPluginModel;
import com.intellij.ide.plugins.MarketplaceTabSearchSortByOptions;
import com.intellij.ide.plugins.PluginManagerConfigurablePanel;
import com.intellij.ide.plugins.PluginManagerPanelFactory;
import com.intellij.ide.plugins.PluginsGroupType;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.PluginSearchResult;
import com.intellij.ide.plugins.marketplace.ranking.MarketplaceLocalRanker;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.newui.LinkComponent;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.NoOpPluginsViewCustomizer;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginInstallationState;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginManagerCustomizer;
import com.intellij.ide.plugins.newui.PluginModelAsyncOperationsExecutor;
import com.intellij.ide.plugins.newui.PluginModelFacade;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.PluginsTab;
import com.intellij.ide.plugins.newui.PluginsViewCustomizer;
import com.intellij.ide.plugins.newui.PluginsViewCustomizerKt;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.SearchResultPanel;
import com.intellij.ide.plugins.newui.SearchUpDownPopupController;
import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.ide.plugins.newui.UiPluginManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserStartupActivityKt;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

@ApiStatus.Internal
class MarketplacePluginsTab
extends PluginsTab {
    private static final Logger LOG = Logger.getInstance(MarketplacePluginsTab.class);
    private static final int ITEMS_PER_GROUP = 9;
    @NotNull
    private final PluginModelFacade myPluginModelFacade;
    @NotNull
    private final CoroutineScope myCoroutineScope;
    @Nullable
    private final PluginManagerCustomizer myPluginManagerCustomizer;
    @NotNull
    private final PluginUpdatesService myPluginUpdatesService;
    private PluginsGroupComponentWithProgress myMarketplacePanel;
    private SearchResultPanel myMarketplaceSearchPanel;
    private Runnable myMarketplaceRunnable;
    private final DefaultActionGroup myMarketplaceSortByGroup;
    private LinkComponent myMarketplaceSortByAction;
    private List<String> myTagsSorted;
    private List<String> myVendorsSorted;

    MarketplacePluginsTab(@NotNull PluginModelFacade facade2, @NotNull CoroutineScope scope, @Nullable PluginManagerCustomizer customizer, @NotNull PluginUpdatesService service) {
        if (facade2 == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(1);
        }
        if (service == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(2);
        }
        this.myPluginModelFacade = facade2;
        this.myCoroutineScope = scope;
        this.myPluginManagerCustomizer = customizer;
        this.myPluginUpdatesService = service;
        this.myMarketplaceSortByGroup = new DefaultActionGroup();
        for (MarketplaceTabSearchSortByOptions option2 : MarketplaceTabSearchSortByOptions.getEntries()) {
            this.myMarketplaceSortByGroup.addAction((AnAction)new MarketplaceSortByAction(option2));
        }
        this.myTagsSorted = null;
        this.myVendorsSorted = null;
    }

    protected void resetCache() {
        this.myTagsSorted = null;
        this.myVendorsSorted = null;
    }

    @Override
    protected void createSearchTextField(int flyDelay) {
        super.createSearchTextField(250);
        this.searchTextField.setHistoryPropertyName("MarketplacePluginsSearchHistory");
    }

    @Override
    @NotNull
    protected PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> searchListener) {
        if (searchListener == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(3);
        }
        PluginDetailsPageComponent detailPanel = new PluginDetailsPageComponent(this.myPluginModelFacade, searchListener, true);
        this.myPluginModelFacade.getModel().addDetailPanel(detailPanel);
        PluginDetailsPageComponent pluginDetailsPageComponent = detailPanel;
        if (pluginDetailsPageComponent == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(4);
        }
        return pluginDetailsPageComponent;
    }

    @Override
    @NotNull
    protected JComponent createPluginsPanel(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
        if (selectionListener2 == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(5);
        }
        MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
        this.myMarketplacePanel = new PluginsGroupComponentWithProgress(eventHandler){

            @Override
            @NotNull
            protected ListPluginComponent createListComponent(@NotNull PluginUiModel model2, @NotNull PluginsGroup group2, @NotNull ListPluginModel listPluginModel) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (group2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (listPluginModel == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new ListPluginComponent(MarketplacePluginsTab.this.myPluginModelFacade, model2, group2, listPluginModel, (LinkListener<Object>)MarketplacePluginsTab.this.searchListener, MarketplacePluginsTab.this.myCoroutineScope, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "group";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listPluginModel";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/MarketplacePluginsTab$1";
                objectArray[2] = "createListComponent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myMarketplacePanel.setSelectionListener(selectionListener2);
        this.myMarketplacePanel.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"plugin.manager.marketplace.panel.accessible.name", (Object[])new Object[0]));
        PluginManagerConfigurablePanel.registerCopyProvider(this.myMarketplacePanel);
        ((SearchUpDownPopupController)this.myMarketplaceSearchPanel.controller).setEventHandler(eventHandler);
        Project project2 = ProjectUtil.getActiveProject();
        this.myMarketplaceRunnable = () -> {
            this.myMarketplacePanel.clear();
            this.myMarketplacePanel.showLoadingIcon();
            this.doCreateMarketplaceTab(selectionListener2, project2);
        };
        this.myMarketplacePanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.marketplace.plugins.not.loaded", (Object[])new Object[0])).appendSecondaryText(IdeBundle.message((String)"message.check.the.internet.connection.and", (Object[])new Object[0]) + " ", StatusText.DEFAULT_ATTRIBUTES, null).appendSecondaryText(IdeBundle.message((String)"message.link.refresh", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.myMarketplaceRunnable.run());
        this.doCreateMarketplaceTab(selectionListener2, project2);
        JComponent jComponent = PluginManagerConfigurablePanel.createScrollPane(this.myMarketplacePanel, false);
        if (jComponent == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    private void doCreateMarketplaceTab(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2, Project project2) {
        if (selectionListener2 == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(7);
        }
        PluginManagerPanelFactory.INSTANCE.createMarketplacePanel(this.myCoroutineScope, this.myPluginModelFacade.getModel(), project2, (Function1<? super CreateMarketplacePanelModel, Unit>)((Function1)model2 -> {
            ArrayList groups = new ArrayList();
            try {
                try {
                    PluginsViewCustomizer.PluginsGroupDescriptor internalPluginsGroupDescriptor;
                    if (project2 != null) {
                        this.addSuggestedGroup(groups, model2.getErrors(), model2.getSuggestedPlugins(), model2.getInstalledPlugins(), model2.getInstallationStates());
                    }
                    if ((internalPluginsGroupDescriptor = model2.getInternalPluginsGroupDescriptor()) != null) {
                        List customPlugins2 = ContainerUtil.map(internalPluginsGroupDescriptor.getPlugins(), it -> new PluginUiModelAdapter((IdeaPluginDescriptor)it));
                        this.addGroup(groups, internalPluginsGroupDescriptor.getName(), PluginsGroupType.INTERNAL, SearchWords.INTERNAL.getValue(), customPlugins2, group2 -> customPlugins2.size() >= 9, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                    }
                    Map<String, PluginSearchResult> marketplaceData = model2.getMarketplaceData();
                    this.addGroupViaLightDescriptor(groups, IdeBundle.message((String)"plugins.configurable.staff.picks", (Object[])new Object[0]), PluginsGroupType.STAFF_PICKS, "is_featured_search=true", SearchWords.STAFF_PICKS.getValue(), marketplaceData, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                    this.addGroupViaLightDescriptor(groups, IdeBundle.message((String)"plugins.configurable.new.and.updated", (Object[])new Object[0]), PluginsGroupType.NEW_AND_UPDATED, "orderBy=update+date", "/sortBy:updated", marketplaceData, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                    this.addGroupViaLightDescriptor(groups, IdeBundle.message((String)"plugins.configurable.top.downloads", (Object[])new Object[0]), PluginsGroupType.TOP_DOWNLOADS, "orderBy=downloads", "/sortBy:downloads", marketplaceData, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                    this.addGroupViaLightDescriptor(groups, IdeBundle.message((String)"plugins.configurable.top.rated", (Object[])new Object[0]), PluginsGroupType.TOP_RATED, "orderBy=rating", "/sortBy:rating", marketplaceData, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                }
                catch (IOException e) {
                    LOG.info("Main plugin repository is not available ('" + e.getMessage() + "'). Please check your network settings.");
                }
                for (String host : RepositoryHelper.getCustomPluginRepositoryHosts()) {
                    List<PluginUiModel> allDescriptors = model2.getCustomRepositories().get(host);
                    if (allDescriptors == null) continue;
                    String groupName = IdeBundle.message((String)"plugins.configurable.repository.0", (Object[])new Object[]{host});
                    LOG.info("Marketplace tab: '" + groupName + "' group load started");
                    this.addGroup(groups, groupName, PluginsGroupType.CUSTOM_REPOSITORY, "/repository:\"" + host + "\"", allDescriptors, group2 -> {
                        PluginsGroup.sortByName(group2.getModels());
                        return allDescriptors.size() > 9;
                    }, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                }
                if (this.myPluginManagerCustomizer != null) {
                    this.myPluginManagerCustomizer.ensurePluginStatesLoaded();
                }
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myMarketplacePanel.hideLoadingIcon();
                    try {
                        PluginLogo.startBatchMode();
                        for (PluginsGroup group2 : groups) {
                            this.myMarketplacePanel.addGroup(group2);
                        }
                    }
                    finally {
                        PluginLogo.endBatchMode();
                    }
                    this.myMarketplacePanel.doLayout();
                    this.myMarketplacePanel.initialSelection();
                    this.myPluginUpdatesService.calculateUpdates(updates -> {
                        if (ContainerUtil.isEmpty((Collection)updates)) {
                            PluginManagerConfigurablePanel.clearUpdates(this.myMarketplacePanel);
                            PluginManagerConfigurablePanel.clearUpdates(this.myMarketplaceSearchPanel.getPanel());
                        } else {
                            PluginManagerConfigurablePanel.applyUpdates(this.myMarketplacePanel, updates);
                            PluginManagerConfigurablePanel.applyUpdates(this.myMarketplaceSearchPanel.getPanel(), updates);
                        }
                        selectionListener2.accept(this.myMarketplacePanel);
                        selectionListener2.accept(this.myMarketplaceSearchPanel.getPanel());
                    });
                }, ModalityState.any());
            }
            return null;
        }));
    }

    @Override
    protected void updateMainSelection(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
        if (selectionListener2 == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(8);
        }
        selectionListener2.accept(this.myMarketplacePanel);
    }

    @Override
    @NotNull
    protected SearchResultPanel createSearchPanel(final @NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
        if (selectionListener2 == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(9);
        }
        SearchUpDownPopupController marketplaceController = new SearchUpDownPopupController(this.searchTextField){

            @Override
            @NotNull
            protected List<String> getAttributes() {
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.add(SearchWords.TAG.getValue());
                attributes.add(SearchWords.SORT_BY.getValue());
                attributes.add(SearchWords.VENDOR.getValue());
                if (!RepositoryHelper.getCustomPluginRepositoryHosts().isEmpty()) {
                    attributes.add(SearchWords.REPOSITORY.getValue());
                }
                attributes.add(SearchWords.STAFF_PICKS.getValue());
                attributes.add(SearchWords.SUGGESTED.getValue());
                if (PluginsViewCustomizerKt.getPluginsViewCustomizer() != NoOpPluginsViewCustomizer.INSTANCE) {
                    attributes.add(SearchWords.INTERNAL.getValue());
                }
                ArrayList<String> arrayList = attributes;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            @Nullable
            protected List<String> getValues(@NotNull String attribute) {
                SearchWords word;
                if (attribute == null) {
                    2.$$$reportNull$$$0(1);
                }
                SearchWords searchWords = word = SearchWords.find(attribute);
                int n = 0;
                return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TAG", "SORT_BY", "VENDOR", "REPOSITORY", "INTERNAL", "SUGGESTED", "STAFF_PICKS"}, (SearchWords)searchWords, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> MarketplacePluginsTab.this.getOrCalculateTags();
                    case 1 -> ContainerUtil.map(Arrays.asList(MarketplaceTabSearchSortByOptions.DOWNLOADS, MarketplaceTabSearchSortByOptions.NAME, MarketplaceTabSearchSortByOptions.RATING, MarketplaceTabSearchSortByOptions.UPDATE_DATE), sort -> sort.getQuery());
                    case 2 -> MarketplacePluginsTab.this.getOrCalculateVendors();
                    case 3 -> RepositoryHelper.getCustomPluginRepositoryHosts();
                    case 4, 5, 6 -> null;
                    case -1 -> null;
                };
            }

            @Override
            protected void showPopupForQuery() {
                MarketplacePluginsTab.this.showSearchPanel(MarketplacePluginsTab.this.searchTextField.getText());
            }

            @Override
            protected void handleEnter() {
                if (!MarketplacePluginsTab.this.searchTextField.getText().isEmpty()) {
                    this.handleTrigger("marketplace.suggest.popup.enter");
                }
            }

            @Override
            protected void handlePopupListFirstSelection() {
                this.handleTrigger("marketplace.suggest.popup.select");
            }

            private void handleTrigger(@NonNls String key) {
                if (this.myPopup != null && this.myPopup.type == SearchPopup.Type.SearchQuery) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed(key);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/MarketplacePluginsTab$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAttributes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/MarketplacePluginsTab$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getValues";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
        this.myMarketplaceSortByAction = new LinkComponent(){

            protected boolean isInClickableArea(Point pt) {
                return true;
            }

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleLinkComponent();
                }
                return this.accessibleContext;
            }

            protected class AccessibleLinkComponent
            extends LinkLabel.AccessibleLinkLabel {
                protected AccessibleLinkComponent() {
                    super((LinkLabel)this);
                }

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.COMBO_BOX;
                }
            }
        };
        this.myMarketplaceSortByAction.setIcon(new Icon(this){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                4.getIcon().paintIcon(c, g, x, y + 1);
            }

            @Override
            public int getIconWidth() {
                return 4.getIcon().getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return 4.getIcon().getIconHeight();
            }

            @NotNull
            private static Icon getIcon() {
                Icon icon2 = AllIcons.General.ButtonDropTriangle;
                if (icon2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return icon2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/MarketplacePluginsTab$4", "getIcon"));
            }
        });
        this.myMarketplaceSortByAction.setPaintUnderline(false);
        this.myMarketplaceSortByAction.setIconTextGap(JBUIScale.scale((int)4));
        this.myMarketplaceSortByAction.setHorizontalTextPosition(2);
        this.myMarketplaceSortByAction.setForeground(PluginsGroupComponent.SECTION_HEADER_FOREGROUND);
        this.myMarketplaceSortByAction.setListener((component2, __) -> PluginManagerConfigurablePanel.showRightBottomPopup(component2.getParent().getParent(), IdeBundle.message((String)"plugins.configurable.sort.by", (Object[])new Object[0]), (ActionGroup)this.myMarketplaceSortByGroup), null);
        DumbAwareAction.create(event -> this.myMarketplaceSortByAction.doClick()).registerCustomShortcutSet(40, 0, (JComponent)((Object)this.myMarketplaceSortByAction));
        MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
        marketplaceController.setSearchResultEventHandler(eventHandler);
        PluginsGroupComponentWithProgress panel2 = new PluginsGroupComponentWithProgress(eventHandler){

            @Override
            @NotNull
            protected ListPluginComponent createListComponent(@NotNull PluginUiModel model2, @NotNull PluginsGroup group2, @NotNull ListPluginModel listPluginModel) {
                if (model2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (group2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (listPluginModel == null) {
                    5.$$$reportNull$$$0(2);
                }
                return new ListPluginComponent(MarketplacePluginsTab.this.myPluginModelFacade, model2, group2, listPluginModel, (LinkListener<Object>)MarketplacePluginsTab.this.searchListener, MarketplacePluginsTab.this.myCoroutineScope, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "group";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listPluginModel";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/MarketplacePluginsTab$5";
                objectArray[2] = "createListComponent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        panel2.setSelectionListener(selectionListener2);
        PluginManagerConfigurablePanel.registerCopyProvider(panel2);
        final Project project2 = ProjectUtil.getActiveProject();
        SearchResultPanel searchResultPanel = this.myMarketplaceSearchPanel = new SearchResultPanel(marketplaceController, panel2, true, 0, 0){

            @Override
            protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2, AtomicBoolean runQuery) {
                if (query == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    6.$$$reportNull$$$0(1);
                }
                int searchIndex = PluginManagerUsageCollector.updateAndGetSearchIndex();
                SearchQueryParser.Marketplace parser = new SearchQueryParser.Marketplace(query);
                Map pluginToScore = null;
                if (parser.internal) {
                    try {
                        PluginsViewCustomizer.PluginsGroupDescriptor groupDescriptor = PluginsViewCustomizerKt.getPluginsViewCustomizer().getInternalPluginsGroupDescriptor();
                        if (groupDescriptor != null) {
                            if (parser.searchQuery == null) {
                                result2.addDescriptors(groupDescriptor.getPlugins());
                            } else {
                                for (IdeaPluginDescriptor pluginDescriptor : groupDescriptor.getPlugins()) {
                                    if (!StringUtil.containsIgnoreCase((String)pluginDescriptor.getName(), (String)parser.searchQuery)) continue;
                                    result2.addDescriptor(pluginDescriptor);
                                }
                            }
                            result2.removeDuplicates();
                            result2.sortByName();
                            return;
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Error while loading internal plugins group", (Throwable)e);
                    }
                }
                PluginModelAsyncOperationsExecutor.INSTANCE.getCustomRepositoriesPluginMap(MarketplacePluginsTab.this.myCoroutineScope, (Function1<? super Map<String, ? extends List<? extends PluginUiModel>>, Unit>)((Function1)map2 -> {
                    Map customRepositoriesMap = map2;
                    if (parser.suggested && project2 != null) {
                        List<@NotNull PluginUiModel> plugins2 = PluginsAdvertiserStartupActivityKt.findSuggestedPlugins(project2, customRepositoriesMap);
                        result2.addModels(plugins2);
                        this.updateSearchPanel(result2, runQuery, plugins2);
                    } else if (!parser.repositories.isEmpty()) {
                        for (String repository : parser.repositories) {
                            List descriptors2 = (List)customRepositoriesMap.get(repository);
                            if (descriptors2 == null) continue;
                            if (parser.searchQuery == null) {
                                result2.addModels(descriptors2);
                                continue;
                            }
                            for (PluginUiModel descriptor2 : descriptors2) {
                                if (!StringUtil.containsIgnoreCase((String)descriptor2.getName(), (String)parser.searchQuery)) continue;
                                result2.addModel(descriptor2);
                            }
                        }
                        result2.removeDuplicates();
                        result2.sortByName();
                        this.updateSearchPanel(result2, runQuery, result2.getModels());
                    } else {
                        PluginModelAsyncOperationsExecutor.INSTANCE.performMarketplaceSearch(MarketplacePluginsTab.this.myCoroutineScope, parser.getUrlQuery(), !result2.getModels().isEmpty(), (Function2<? super PluginSearchResult, ? super List<? extends PluginUiModel>, Unit>)((Function2)(searchResult, updates) -> {
                            this.applySearchResult(result2, (PluginSearchResult)searchResult, (List<PluginUiModel>)updates, customRepositoriesMap, parser, pluginToScore, searchIndex);
                            this.updatePanel(runQuery);
                            return null;
                        }));
                    }
                    return null;
                }));
            }

            private void updateSearchPanel(@NonNull PluginsGroup result2, AtomicBoolean runQuery, List<@NotNull PluginUiModel> plugins2) {
                Set<PluginId> ids = plugins2.stream().map(it -> it.getPluginId()).collect(Collectors.toSet());
                result2.getPreloadedModel().setInstalledPlugins(UiPluginManager.getInstance().findInstalledPluginsSync(ids));
                result2.getPreloadedModel().setPluginInstallationStates(UiPluginManager.getInstance().getInstallationStatesSync());
                this.updatePanel(runQuery);
            }

            private void applySearchResult(@NotNull PluginsGroup result2, PluginSearchResult searchResult, List<PluginUiModel> updates, Map<String, List<PluginUiModel>> customRepositoriesMap, SearchQueryParser.Marketplace parser, Map<PluginUiModel, Double> pluginToScore, int searchIndex) {
                if (result2 == null) {
                    6.$$$reportNull$$$0(2);
                }
                if (searchResult.getError() != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.myPanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.search.result.not.loaded", (Object[])new Object[0])).appendSecondaryText(IdeBundle.message((String)"plugins.configurable.check.internet", (Object[])new Object[0]), StatusText.DEFAULT_ATTRIBUTES, null), ModalityState.any());
                }
                List customPlugins2 = ContainerUtil.flatten(customRepositoriesMap.values());
                Collection<PluginUiModel> plugins2 = RepositoryHelper.mergePluginModelsFromRepositories(searchResult.getPlugins(), customPlugins2, false);
                result2.addModels(0, new ArrayList<PluginUiModel>(plugins2));
                if (parser.searchQuery != null) {
                    List descriptors2 = ContainerUtil.filter((Collection)customPlugins2, descriptor2 -> StringUtil.containsIgnoreCase((String)descriptor2.getName(), (String)parser.searchQuery));
                    result2.addModels(0, descriptors2);
                }
                result2.removeDuplicates();
                MarketplaceLocalRanker localRanker = MarketplaceLocalRanker.getInstanceIfEnabled();
                if (localRanker != null) {
                    pluginToScore = localRanker.rankPlugins(parser, result2.getModels());
                }
                if (!result2.getModels().isEmpty()) {
                    String title2 = IdeBundle.message((String)"plugin.manager.action.label.sort.by.1", (Object[])new Object[0]);
                    for (AnAction action2 : MarketplacePluginsTab.this.myMarketplaceSortByGroup.getChildren(ActionManager.getInstance())) {
                        MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action2;
                        sortByAction.setState(parser);
                        if (!sortByAction.myState) continue;
                        title2 = IdeBundle.message((String)"plugin.manager.action.label.sort.by", (Object[])new Object[]{sortByAction.myOption.getPresentableNameSupplier().get()});
                    }
                    MarketplacePluginsTab.this.myMarketplaceSortByAction.setText(title2);
                    result2.addRightAction((JComponent)((Object)MarketplacePluginsTab.this.myMarketplaceSortByAction));
                    if (!ContainerUtil.isEmpty(updates)) {
                        this.myPostFillGroupCallback = () -> {
                            PluginManagerConfigurablePanel.applyUpdates(this.myPanel, updates);
                            selectionListener2.accept(MarketplacePluginsTab.this.myMarketplacePanel);
                            selectionListener2.accept(MarketplacePluginsTab.this.myMarketplaceSearchPanel.getPanel());
                        };
                    }
                }
                Set<PluginId> ids = result2.getModels().stream().map(it -> it.getPluginId()).collect(Collectors.toSet());
                result2.getPreloadedModel().setInstalledPlugins(UiPluginManager.getInstance().findInstalledPluginsSync(ids));
                result2.getPreloadedModel().setPluginInstallationStates(UiPluginManager.getInstance().getInstallationStatesSync());
                PluginManagerUsageCollector.INSTANCE.performMarketplaceSearch(ProjectUtil.getActiveProject(), parser, result2.getModels(), searchIndex, pluginToScore);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "query";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/MarketplacePluginsTab$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleQuery";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applySearchResult";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (searchResultPanel == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(10);
        }
        return searchResultPanel;
    }

    private List<String> getOrCalculateVendors() {
        if (this.myVendorsSorted == null || this.myVendorsSorted.isEmpty()) {
            LinkedHashSet vendors = new LinkedHashSet();
            try {
                ProcessIOExecutorService.INSTANCE.submit(() -> vendors.addAll(UiPluginManager.getInstance().getAllVendors())).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Error while getting vendors from marketplace", (Throwable)e);
            }
            this.myVendorsSorted = new ArrayList<String>(vendors);
        }
        return this.myVendorsSorted;
    }

    private List<String> getOrCalculateTags() {
        if (this.myTagsSorted == null || this.myTagsSorted.isEmpty()) {
            HashSet<String> allTags = new HashSet<String>();
            Set<String> customRepoTags = UiPluginManager.getInstance().getCustomRepoTags();
            if (!customRepoTags.isEmpty()) {
                allTags.addAll(customRepoTags);
            }
            try {
                ProcessIOExecutorService.INSTANCE.submit(() -> allTags.addAll(UiPluginManager.getInstance().getAllPluginsTags())).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Error while getting tags from marketplace", (Throwable)e);
            }
            this.myTagsSorted = ContainerUtil.sorted(allTags, String::compareToIgnoreCase);
        }
        return this.myTagsSorted;
    }

    private void handleSortByOptionSelection(MarketplaceSortByAction updateAction2) {
        String query;
        String query2;
        MarketplaceSortByAction removeAction = null;
        MarketplaceSortByAction addAction = null;
        if (updateAction2.myState) {
            for (AnAction action2 : this.myMarketplaceSortByGroup.getChildren(ActionManager.getInstance())) {
                MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action2;
                if (sortByAction == updateAction2 || !sortByAction.myState) continue;
                sortByAction.myState = false;
                removeAction = sortByAction;
                break;
            }
            addAction = updateAction2;
        } else {
            if (updateAction2.myOption == MarketplaceTabSearchSortByOptions.RELEVANCE) {
                updateAction2.myState = true;
                return;
            }
            for (AnAction action3 : this.myMarketplaceSortByGroup.getChildren(ActionManager.getInstance())) {
                MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action3;
                if (sortByAction.myOption != MarketplaceTabSearchSortByOptions.RELEVANCE) continue;
                sortByAction.myState = true;
                break;
            }
            removeAction = updateAction2;
        }
        final ArrayList<String> queries = new ArrayList<String>();
        new SearchQueryParser.Marketplace(this, this.searchTextField.getText()){

            @Override
            protected void addToSearchQuery(@NotNull String query) {
                if (query == null) {
                    7.$$$reportNull$$$0(0);
                }
                queries.add(query);
            }

            @Override
            protected void handleAttribute(@NotNull String name2, @NotNull String value) {
                if (name2 == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (value == null) {
                    7.$$$reportNull$$$0(2);
                }
                queries.add(name2 + SearchQueryParser.wrapAttribute(value));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "query";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/MarketplacePluginsTab$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addToSearchQuery";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleAttribute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (removeAction != null && (query2 = removeAction.getQuery()) != null) {
            queries.remove(query2);
        }
        if (addAction != null && (query = addAction.getQuery()) != null) {
            queries.add(query);
        }
        String query3 = StringUtil.join(queries, (String)" ");
        this.searchTextField.setTextIgnoreEvents(query3);
        if (query3.isEmpty()) {
            this.hideSearchPanel();
        } else {
            this.showSearchPanel(query3);
        }
    }

    @Override
    protected void onSearchReset() {
        PluginManagerUsageCollector.INSTANCE.searchReset();
    }

    private void addSuggestedGroup(@NotNull List<? super PluginsGroup> groups, @NotNull @NotNull Map<@NotNull PluginId, @NotNull List<@NotNull HtmlChunk>> errors, @NotNull @NotNull List<@NotNull PluginUiModel> plugins2, @NotNull @NotNull Map<@NotNull PluginId, @NotNull PluginUiModel> installedPlugins, @NotNull @NotNull Map<@NotNull PluginId, @NotNull PluginInstallationState> installationStates) {
        if (groups == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(11);
        }
        if (errors == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(12);
        }
        if (plugins2 == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(13);
        }
        if (installedPlugins == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(14);
        }
        if (installationStates == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(15);
        }
        String groupName = IdeBundle.message((String)"plugins.configurable.suggested", (Object[])new Object[0]);
        LOG.info("Marketplace tab: '" + groupName + "' group load started");
        for (PluginUiModel plugin : plugins2) {
            if (plugin.isFromMarketplace()) {
                plugin.setInstallSource(FUSEventSource.PLUGINS_SUGGESTED_GROUP);
            }
            FUSEventSource.PLUGINS_SUGGESTED_GROUP.logPluginSuggested(plugin.getPluginId());
        }
        this.addGroup(groups, groupName, PluginsGroupType.SUGGESTED, "", plugins2, group2 -> false, errors, installedPlugins, installationStates);
    }

    private void addGroup(@NotNull List<? super PluginsGroup> groups, @NotNull @Nls String name2, @NotNull PluginsGroupType type, @NotNull String showAllQuery, @NotNull List<PluginUiModel> customPlugins2, @NotNull Predicate<? super PluginsGroup> showAllPredicate, @NotNull Map<PluginId, List<HtmlChunk>> errors, @NotNull Map<PluginId, PluginUiModel> installedPlugins, @NotNull Map<PluginId, PluginInstallationState> installationStates) {
        if (groups == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(16);
        }
        if (name2 == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(17);
        }
        if (type == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(18);
        }
        if (showAllQuery == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(19);
        }
        if (customPlugins2 == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(20);
        }
        if (showAllPredicate == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(21);
        }
        if (errors == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(22);
        }
        if (installedPlugins == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(23);
        }
        if (installationStates == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(24);
        }
        PluginsGroup group2 = new PluginsGroup(name2, type);
        group2.getPreloadedModel().setErrors(errors);
        group2.getPreloadedModel().setInstalledPlugins(installedPlugins);
        group2.getPreloadedModel().setPluginInstallationStates(installationStates);
        Iterator<PluginUiModel> iterator2 = customPlugins2.iterator();
        for (int i2 = 0; iterator2.hasNext() && i2 < 9; ++i2) {
            group2.addModel(iterator2.next());
        }
        if (showAllPredicate.test(group2)) {
            group2.rightAction = new PluginManagerConfigurablePanel.LinkLabelButton<String>(IdeBundle.message((String)"plugins.configurable.show.all", (Object[])new Object[0]), null, this.searchListener, showAllQuery);
            group2.rightAction.setBorder((Border)JBUI.Borders.emptyRight((int)5));
        }
        if (!group2.getModels().isEmpty()) {
            groups.add(group2);
        }
        LOG.info("Marketplace tab: '" + name2 + "' group load finished");
    }

    private void addGroupViaLightDescriptor(@NotNull List<? super PluginsGroup> groups, @NotNull @Nls String name2, @NotNull PluginsGroupType type, @NotNull @NonNls String query, @NotNull @NonNls String showAllQuery, @NotNull Map<String, PluginSearchResult> marketplaceData, @NotNull Map<PluginId, List<HtmlChunk>> errors, @NotNull Map<PluginId, PluginUiModel> installedPluginIds, @NotNull Map<PluginId, PluginInstallationState> installationStates) throws IOException {
        if (groups == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(25);
        }
        if (name2 == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(26);
        }
        if (type == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(27);
        }
        if (query == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(28);
        }
        if (showAllQuery == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(29);
        }
        if (marketplaceData == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(30);
        }
        if (errors == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(31);
        }
        if (installedPluginIds == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(32);
        }
        if (installationStates == null) {
            MarketplacePluginsTab.$$$reportNull$$$0(33);
        }
        LOG.info("Marketplace tab: '" + name2 + "' group load started");
        PluginSearchResult searchResult = marketplaceData.get(query);
        if (searchResult.getError() != null) {
            throw new IOException(searchResult.getError());
        }
        List<PluginUiModel> plugins2 = searchResult.getPlugins();
        for (PluginUiModel plugin : plugins2) {
            plugin.setInstallSource(FUSEventSource.PLUGINS_STAFF_PICKS_GROUP);
            FUSEventSource.PLUGINS_STAFF_PICKS_GROUP.logPluginSuggested(plugin.getPluginId());
        }
        this.addGroup(groups, name2, type, showAllQuery, plugins2, __ -> plugins2.size() >= 9, errors, installedPluginIds, installationStates);
    }

    @Override
    public void dispose() {
        if (this.myMarketplacePanel != null) {
            this.myMarketplacePanel.dispose();
        }
        if (this.myMarketplaceSearchPanel != null) {
            this.myMarketplaceSearchPanel.dispose();
        }
        super.dispose();
    }

    void onPanelReset(boolean isMarketplaceTabSelected) {
        if (this.myMarketplacePanel != null) {
            if (isMarketplaceTabSelected) {
                this.myMarketplaceRunnable.run();
            } else {
                this.myMarketplacePanel.setOnBecomingVisibleCallback(this.myMarketplaceRunnable);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/MarketplacePluginsTab";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionListener";
                break;
            }
            case 11: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 12: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPlugins";
                break;
            }
            case 15: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installationStates";
                break;
            }
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showAllQuery";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPlugins";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showAllPredicate";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marketplaceData";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPluginIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/MarketplacePluginsTab";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetailsPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginsPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsPanel";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPluginsPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCreateMarketplaceTab";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateMainSelection";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSearchPanel";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addSuggestedGroup";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addGroupViaLightDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 10 -> new IllegalStateException(string);
        };
    }

    private final class MarketplaceSortByAction
    extends ToggleAction
    implements DumbAware {
        private final MarketplaceTabSearchSortByOptions myOption;
        private boolean myState;
        private boolean myVisible;

        private MarketplaceSortByAction(MarketplaceTabSearchSortByOptions option2) {
            if (option2 == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(0);
            }
            super(option2.getPresentableNameSupplier());
            this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfRequested);
            this.myOption = option2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setVisible(this.myVisible);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(3);
            }
            return this.myState;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(4);
            }
            this.myState = state2;
            MarketplacePluginsTab.this.handleSortByOptionSelection(this);
        }

        public void setState(@NotNull SearchQueryParser.Marketplace parser) {
            if (parser == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(5);
            }
            if (this.myOption == MarketplaceTabSearchSortByOptions.RELEVANCE) {
                this.myState = parser.sortBy == null;
                this.myVisible = parser.sortBy == null || !parser.tags.isEmpty() || !parser.vendors.isEmpty() || parser.searchQuery != null;
            } else {
                this.myState = parser.sortBy != null && this.myOption == parser.sortBy;
                this.myVisible = true;
            }
        }

        @Nullable
        public String getQuery() {
            if (this.myOption == MarketplaceTabSearchSortByOptions.RELEVANCE) {
                return null;
            }
            return SearchWords.SORT_BY.getValue() + this.myOption.getQuery();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/MarketplacePluginsTab$MarketplaceSortByAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/MarketplacePluginsTab$MarketplaceSortByAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

