/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.CountIcon;
import com.intellij.ide.plugins.CustomPluginRepositoryService;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstallFromDiskAction;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTab;
import com.intellij.ide.plugins.MarketplacePluginsTab;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.ide.plugins.PluginHostsConfigurable;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCoroutineScopeHolder;
import com.intellij.ide.plugins.certificates.PluginCertificateManager;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginManagerCustomizer;
import com.intellij.ide.plugins.newui.PluginModelAsyncOperationsExecutor;
import com.intellij.ide.plugins.newui.PluginModelFacade;
import com.intellij.ide.plugins.newui.PluginPriceService;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsTab;
import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.ide.plugins.newui.TabbedPaneHeaderComponent;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ide.plugins.newui.UiPluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.updateSettings.impl.PluginAutoUpdateListener;
import com.intellij.openapi.updateSettings.impl.UpdateOptions;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.PluginsTabFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenEventCollector;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.HttpProxyConfigurable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PluginManagerConfigurablePanel
implements Disposable {
    private static final int MARKETPLACE_TAB = 0;
    private static final int INSTALLED_TAB = 1;
    private final CoroutineScope myCoroutineScope;
    private final PluginModelFacade myPluginModelFacade;
    private PluginUpdatesService myPluginUpdatesService;
    @Nullable
    private final PluginManagerCustomizer myPluginManagerCustomizer;
    private TabbedPaneHeaderComponent myTabHeaderComponent;
    private final CountIcon myInstalledTabHeaderUpdatesCountIcon = new CountIcon();
    private MarketplacePluginsTab myMarketplaceTab;
    private InstalledPluginsTab myInstalledTab;
    private MultiPanel myCardPanel;
    private String myLaterSearchQuery;
    private boolean myForceShowInstalledTabForTag = false;
    private boolean myShowMarketplaceTab;
    private Boolean myPluginsAutoUpdateEnabled;
    private volatile Boolean myDisposeStarted = false;

    public PluginManagerConfigurablePanel() {
        this.myPluginModelFacade = new PluginModelFacade(new MyPluginModel(null));
        this.myPluginManagerCustomizer = PluginManagerCustomizer.getInstance();
        CoroutineScope parentScope = ((PluginManagerCoroutineScopeHolder)ApplicationManager.getApplication().getService(PluginManagerCoroutineScopeHolder.class)).getCoroutineScope();
        CoroutineScope childScope = com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope((CoroutineScope)parentScope, (String)this.getClass().getName(), (CoroutineContext)Dispatchers.getIO(), (boolean)true);
        this.myPluginModelFacade.getModel().setCoroutineScope(childScope);
        this.myCoroutineScope = childScope;
    }

    @NotNull
    public JComponent getCenterComponent(@NotNull Configurable.TopComponentController controller) {
        if (controller == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(0);
        }
        this.myPluginModelFacade.getModel().setTopController(controller);
        TabbedPaneHeaderComponent tabbedPaneHeaderComponent = this.myTabHeaderComponent;
        if (tabbedPaneHeaderComponent == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(1);
        }
        return tabbedPaneHeaderComponent;
    }

    @NotNull
    public JComponent getTopComponent() {
        JComponent jComponent = this.getCenterComponent(Configurable.TopComponentController.EMPTY);
        if (jComponent == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public void init(@Nullable String searchQuery) {
        this.myTabHeaderComponent = new TabbedPaneHeaderComponent(this.createGearActions(), index -> {
            this.myCardPanel.select(index, true);
            PluginManagerConfigurablePanel.storeSelectionTab(index);
            String query = (index == 0 ? this.myInstalledTab : this.myMarketplaceTab).getSearchQuery();
            (index == 0 ? this.myMarketplaceTab : this.myInstalledTab).setSearchQuery(query);
        }){

            @Override
            public void uiDataSnapshot(@NotNull DataSink sink) {
                if (sink == null) {
                    1.$$$reportNull$$$0(0);
                }
                sink.set(PluginManagerConfigurable.PLUGIN_INSTALL_CALLBACK_DATA_KEY, PluginManagerConfigurablePanel.this::onPluginInstalledFromDisk);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$1", "uiDataSnapshot"));
            }
        };
        this.createGearGotIt();
        this.myLaterSearchQuery = searchQuery;
        this.myTabHeaderComponent.addTab(IdeBundle.message((String)"plugin.manager.tab.marketplace", (Object[])new Object[0]), null);
        this.myTabHeaderComponent.addTab(IdeBundle.message((String)"plugin.manager.tab.installed", (Object[])new Object[0]), this.myInstalledTabHeaderUpdatesCountIcon);
        CustomPluginRepositoryService.getInstance().clearCache();
        this.myPluginUpdatesService = UiPluginManager.getInstance().subscribeToUpdatesCount(this.myPluginModelFacade.getModel().getSessionId(), (Function1<? super Integer, Unit>)((Function1)updatesCount -> {
            ApplicationManager.getApplication().invokeLater(() -> this.onPluginUpdatesRecalculation((Integer)updatesCount));
            return null;
        }));
        this.myPluginModelFacade.getModel().setPluginUpdatesService(this.myPluginUpdatesService);
        UiPluginManager.getInstance().updateDescriptorsForInstalledPlugins();
        this.createMarketplaceTab();
        this.createInstalledTab();
        PluginManagerUsageCollector.sessionStarted();
        this.myCardPanel = new MultiPanel(){

            @Override
            protected JComponent create(Integer key) {
                if (key == 0) {
                    return PluginManagerConfigurablePanel.this.myMarketplaceTab.createPanel();
                }
                if (key == 1) {
                    return PluginManagerConfigurablePanel.this.myInstalledTab.createPanel();
                }
                return super.create(key);
            }
        };
        this.myCardPanel.setMinimumSize((Dimension)new JBDimension(580, 380));
        this.myCardPanel.setPreferredSize((Dimension)new JBDimension(800, 600));
        this.myTabHeaderComponent.setListener();
        int selectionTab = PluginManagerConfigurablePanel.getStoredSelectionTab();
        this.myTabHeaderComponent.setSelection(selectionTab);
        this.myCardPanel.select(selectionTab, true);
        if (this.myLaterSearchQuery != null) {
            Runnable search = this.enableSearch(this.myLaterSearchQuery, this.myForceShowInstalledTabForTag);
            if (search != null) {
                ApplicationManager.getApplication().invokeLater(search, ModalityState.any());
            }
            this.myLaterSearchQuery = null;
            this.myForceShowInstalledTabForTag = false;
        }
        if (this.myPluginManagerCustomizer != null) {
            this.myPluginManagerCustomizer.initCustomizer(this.myCardPanel);
        }
    }

    @NotNull
    public JComponent getComponent() {
        MultiPanel multiPanel2 = this.myCardPanel;
        if (multiPanel2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(3);
        }
        return multiPanel2;
    }

    public boolean isMarketplaceTabShowing() {
        return this.myTabHeaderComponent.getSelectionTab() == 0;
    }

    public boolean isInstalledTabShowing() {
        return this.myTabHeaderComponent.getSelectionTab() == 1;
    }

    @NotNull
    private DefaultActionGroup createGearActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        if (PluginManagementPolicy.getInstance().isPluginAutoUpdateAllowed()) {
            final UpdateOptions state2 = UpdateSettings.getInstance().getState();
            this.myPluginsAutoUpdateEnabled = state2.isPluginsAutoUpdateEnabled();
            MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect(CoroutineScopeKt.asDisposable((CoroutineScope)this.myCoroutineScope));
            connect.subscribe(PluginAutoUpdateListener.Companion.getTOPIC(), (Object)new PluginAutoUpdateListener(){

                @Override
                public void settingsChanged() {
                    PluginManagerConfigurablePanel.this.myPluginsAutoUpdateEnabled = state2.isPluginsAutoUpdateEnabled();
                }
            });
            actions.add((AnAction)new UpdatePluginsAutomaticallyToggleAction());
            actions.addSeparator();
        }
        actions.add((AnAction)new ManagePluginRepositoriesAction());
        actions.add((AnAction)new OpenHttpProxyConfigurableAction());
        actions.addSeparator();
        actions.add((AnAction)new ManagePluginCertificatesAction());
        actions.add((AnAction)new CustomInstallPluginFromDiskAction());
        if (this.myPluginManagerCustomizer != null) {
            actions.addAll(this.myPluginManagerCustomizer.getExtraPluginsActions());
        }
        actions.addSeparator();
        actions.add((AnAction)new ChangePluginStateAction(false));
        actions.add((AnAction)new ChangePluginStateAction(true));
        if (ApplicationManager.getApplication().isInternal()) {
            actions.addSeparator();
            actions.add((AnAction)new ResetConfigurableAction());
        }
        DefaultActionGroup defaultActionGroup = actions;
        if (defaultActionGroup == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    private void createGearGotIt() {
        if (!PluginManagementPolicy.getInstance().isPluginAutoUpdateAllowed() || UpdateSettings.getInstance().getState().isPluginsAutoUpdateEnabled() || AppMode.isRemoteDevHost()) {
            return;
        }
        String title2 = IdeBundle.message((String)"plugin.manager.plugins.auto.update.title", (Object[])new Object[0]);
        GotItTooltip tooltip = new GotItTooltip(title2, IdeBundle.message((String)"plugin.manager.plugins.auto.update.description", (Object[])new Object[0]), (Disposable)this);
        tooltip.withHeader(title2);
        tooltip.show((JComponent)this.myTabHeaderComponent.getComponent(1), (Function2<? super Component, ? super Balloon, ? extends Point>)((Function2)(component2, balloon) -> new Point(component2.getWidth() / 2, ((JComponent)component2).getVisibleRect().height)));
    }

    static void showRightBottomPopup(final @NotNull Component component2, @NotNull @Nls String title2, @NotNull ActionGroup group2) {
        if (component2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(5);
        }
        if (title2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(6);
        }
        if (group2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(7);
        }
        GroupByActionGroup actions = new GroupByActionGroup();
        actions.addSeparator("  " + title2);
        actions.addAll(group2);
        DataContext context2 = DataManager.getInstance().getDataContext(component2);
        final PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, null, (ActionGroup)actions, context2, "popup", new PresentationFactory(), ActionPopupOptions.honorMnemonics(), null){};
        popup2.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                Point location = component2.getLocationOnScreen();
                Dimension size2 = popup2.getSize();
                popup2.setLocation(new Point(location.x + component2.getWidth() - size2.width, location.y + component2.getHeight()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$5", "beforeShown"));
            }
        });
        popup2.show(component2);
    }

    private void resetPanels() {
        CustomPluginRepositoryService.getInstance().clearCache();
        if (this.myMarketplaceTab != null) {
            this.myMarketplaceTab.resetCache();
        }
        this.myPluginUpdatesService.recalculateUpdates();
        if (this.myMarketplaceTab != null) {
            this.myMarketplaceTab.onPanelReset(this.myTabHeaderComponent.getSelectionTab() == 0);
        }
    }

    private void onPluginUpdatesRecalculation(Integer updatesCount) {
        int count = updatesCount == null ? 0 : updatesCount;
        String text2 = Integer.toString(count);
        String tooltip = PluginUpdatesService.getUpdatesTooltip();
        this.myTabHeaderComponent.setTabTooltip(1, tooltip);
        this.myInstalledTab.onPluginUpdatesRecalculation(updatesCount, tooltip);
        this.myInstalledTabHeaderUpdatesCountIcon.setText(text2);
        this.myTabHeaderComponent.update();
    }

    private static int getStoredSelectionTab() {
        int value = PropertiesComponent.getInstance().getInt("PluginConfigurable.selectionTab", 0);
        return value < 0 || value > 1 ? 0 : value;
    }

    private static void storeSelectionTab(int value) {
        PropertiesComponent.getInstance().setValue("PluginConfigurable.selectionTab", value, 0);
    }

    private void createMarketplaceTab() {
        this.myMarketplaceTab = new MarketplacePluginsTab(this.myPluginModelFacade, this.myCoroutineScope, this.myPluginManagerCustomizer, this.myPluginUpdatesService);
    }

    private void createInstalledTab() {
        this.myInstalledTab = new InstalledPluginsTab(this.myPluginModelFacade, this.myPluginUpdatesService, this.myCoroutineScope, query -> this.myTabHeaderComponent.setSelectionWithEvents(0));
        this.myPluginModelFacade.getModel().setCancelInstallCallback((Function1<? super PluginUiModel, Unit>)((Function1)descriptor2 -> {
            if (this.myInstalledTab.getInstalledSearchPanel() == null) {
                return null;
            }
            PluginsGroup group2 = this.myInstalledTab.getInstalledSearchPanel().getGroup();
            if (group2.ui != null && group2.ui.findComponent(descriptor2.getPluginId()) != null) {
                this.myInstalledTab.getInstalledSearchPanel().getPanel().removeFromGroup(group2, (PluginUiModel)descriptor2);
                group2.titleWithCount();
                this.myInstalledTab.getInstalledSearchPanel().fullRepaint();
                if (group2.getModels().isEmpty()) {
                    this.myInstalledTab.getInstalledSearchPanel().removeGroup();
                }
            }
            return null;
        }));
    }

    static void setState(PluginModelFacade pluginModelFacade, Collection<PluginUiModel> models, boolean isEnable) {
        if (models.isEmpty()) {
            return;
        }
        List<PluginId> pluginsRequiringUltimate = UiPluginManager.getInstance().filterPluginsRequiringUltimateButItsDisabled(ContainerUtil.map(models, PluginUiModel::getPluginId));
        List<PluginUiModel> suitableDescriptors = models.stream().filter(descriptor2 -> !pluginsRequiringUltimate.contains(descriptor2.getPluginId())).toList();
        if (suitableDescriptors.isEmpty()) {
            return;
        }
        if (isEnable) {
            pluginModelFacade.enable(suitableDescriptors);
        } else {
            pluginModelFacade.disable(suitableDescriptors);
        }
    }

    static boolean containsQuery(PluginUiModel descriptor2, String searchQuery) {
        if (descriptor2.getName() == null) {
            return false;
        }
        if (StringUtil.containsIgnoreCase((String)descriptor2.getName(), (String)searchQuery)) {
            return true;
        }
        String description = descriptor2.getDescription();
        return description != null && StringUtil.containsIgnoreCase((String)description, (String)searchQuery);
    }

    static void clearUpdates(@NotNull PluginsGroupComponent panel2) {
        if (panel2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(8);
        }
        for (UIPluginGroup group2 : panel2.getGroups()) {
            for (ListPluginComponent plugin : group2.plugins) {
                plugin.setUpdateDescriptor((IdeaPluginDescriptor)null);
            }
        }
    }

    static void applyUpdates(@NotNull PluginsGroupComponent panel2, @NotNull Collection<PluginUiModel> updates) {
        if (panel2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(9);
        }
        if (updates == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(10);
        }
        block0: for (PluginUiModel descriptor2 : updates) {
            for (UIPluginGroup group2 : panel2.getGroups()) {
                ListPluginComponent component2 = group2.findComponent(descriptor2.getPluginId());
                if (component2 == null) continue;
                component2.setUpdateDescriptor(descriptor2);
                continue block0;
            }
        }
    }

    public static void registerCopyProvider(final @NotNull PluginsGroupComponent component2) {
        if (component2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(11);
        }
        CopyProvider copyProvider = new CopyProvider(){

            public void performCopy(@NotNull DataContext dataContext2) {
                if (dataContext2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                String text2 = StringUtil.join(component2.getSelection(), pluginComponent -> {
                    PluginUiModel model2 = pluginComponent.getPluginModel();
                    return String.format("%s (%s)", model2.getName(), model2.getVersion());
                }, (String)"\n");
                CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(text2));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    6.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext2) {
                if (dataContext2 == null) {
                    6.$$$reportNull$$$0(2);
                }
                return !component2.getSelection().isEmpty();
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext2) {
                if (dataContext2 == null) {
                    6.$$$reportNull$$$0(3);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "performCopy";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isCopyEnabled";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isCopyVisible";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        DataManager.registerDataProvider((JComponent)((Object)component2), dataId -> PlatformDataKeys.COPY_PROVIDER.is(dataId) ? copyProvider : null);
    }

    void setInstallSource(@Nullable FUSEventSource source) {
        this.myPluginModelFacade.getModel().setInstallSource(source);
    }

    @NotNull
    public static JComponent createScrollPane(@NotNull PluginsGroupComponent panel2, boolean initSelection) {
        if (panel2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(12);
        }
        JBScrollPane pane2 = new JBScrollPane((Component)((Object)panel2), 20, 31);
        pane2.setBorder((Border)JBUI.Borders.empty());
        if (initSelection) {
            panel2.initialSelection();
        }
        JBScrollPane jBScrollPane = pane2;
        if (jBScrollPane == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(13);
        }
        return jBScrollPane;
    }

    public void dispose() {
        this.myDisposeStarted = true;
        if (ComponentUtil.getParentOfType(WelcomeScreen.class, (Component)this.myCardPanel) != null && this.isModified()) {
            this.scheduleApply();
        }
        InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
        if (this.myPluginModelFacade.getModel().toBackground()) {
            pluginsState.clearShutdownCallback();
        }
        if (this.myMarketplaceTab != null) {
            this.myMarketplaceTab.dispose();
        }
        if (this.myInstalledTab != null) {
            this.myInstalledTab.dispose();
        }
        if (this.myMarketplaceTab != null) {
            this.myMarketplaceTab.dispose();
        }
        if (this.myInstalledTab.getInstalledSearchPanel() != null) {
            this.myInstalledTab.getInstalledSearchPanel().dispose();
        }
        this.myPluginUpdatesService.dispose();
        PluginPriceService.cancel();
        pluginsState.runShutdownCallback();
        pluginsState.resetChangesAppliedWithoutRestart();
        Disposer.dispose((Disposable)this);
        kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)this.myCoroutineScope, null);
    }

    public void cancel() {
        this.myPluginModelFacade.getModel().cancel(this.myCardPanel, true);
    }

    public boolean isModified() {
        if (this.myPluginsAutoUpdateEnabled != null && UpdateSettings.getInstance().getState().isPluginsAutoUpdateEnabled() != this.myPluginsAutoUpdateEnabled.booleanValue()) {
            return true;
        }
        return this.myPluginModelFacade.getModel().isModified();
    }

    public void scheduleApply() {
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                this.apply();
                WelcomeScreenEventCollector.logPluginsModified();
                if (this.myDisposeStarted.booleanValue()) {
                    InstalledPluginsState.getInstance().runShutdownCallback();
                }
            }
            catch (ConfigurationException exception) {
                Logger.getInstance(PluginsTabFactory.class).error((Throwable)exception);
            }
        }, ModalityState.nonModal());
    }

    public void apply() throws ConfigurationException {
        UpdateOptions state2;
        if (this.myPluginsAutoUpdateEnabled != null && (state2 = UpdateSettings.getInstance().getState()).isPluginsAutoUpdateEnabled() != this.myPluginsAutoUpdateEnabled.booleanValue()) {
            UiPluginManager.getInstance().setPluginsAutoUpdateEnabled(this.myPluginsAutoUpdateEnabled);
        }
        this.myPluginModelFacade.getModel().applyWithCallback(this.myCardPanel, installedWithoutRestart -> {
            if (installedWithoutRestart.booleanValue()) {
                return;
            }
            InstalledPluginsState installedPluginsState = InstalledPluginsState.getInstance();
            if (this.myPluginModelFacade.getModel().createShutdownCallback) {
                installedPluginsState.setShutdownCallback(() -> ApplicationManager.getApplication().invokeLater(() -> {
                    if (ApplicationManager.getApplication().isExitInProgress()) {
                        return;
                    }
                    if (this.myPluginManagerCustomizer != null) {
                        this.myPluginManagerCustomizer.requestRestart(this.myPluginModelFacade, this.myTabHeaderComponent);
                        return;
                    }
                    this.myPluginModelFacade.closeSession();
                    PluginManagerConfigurable.shutdownOrRestartApp();
                }));
            }
            if (this.myDisposeStarted.booleanValue()) {
                installedPluginsState.runShutdownCallback();
            }
        });
    }

    public void reset() {
        if (this.myPluginsAutoUpdateEnabled != null) {
            this.myPluginsAutoUpdateEnabled = UpdateSettings.getInstance().getState().isPluginsAutoUpdateEnabled();
        }
        this.myPluginModelFacade.getModel().clear(this.myCardPanel);
    }

    void selectAndEnable(@NotNull Set<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(14);
        }
        this.myPluginModelFacade.getModel().enable(descriptors2);
        this.select(ContainerUtil.map(descriptors2, PluginDescriptor::getPluginId));
    }

    void select(@NotNull Collection<PluginId> pluginIds) {
        if (pluginIds == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(15);
        }
        this.updateSelectionTab(1);
        ArrayList<ListPluginComponent> components = new ArrayList<ListPluginComponent>();
        for (PluginId pluginId : pluginIds) {
            ListPluginComponent component2 = this.findInstalledPluginById(pluginId);
            if (component2 == null) continue;
            components.add(component2);
        }
        if (!components.isEmpty()) {
            this.myInstalledTab.getInstalledPanel().setSelection(components);
        }
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        return this.enableSearch(option2, false);
    }

    @Nullable
    public Runnable enableSearch(String option2, boolean ignoreTagMarketplaceTab) {
        if (StringUtil.isEmpty((String)option2) && (this.myTabHeaderComponent.getSelectionTab() == 0 || this.myInstalledTab.getInstalledSearchPanel().isEmpty())) {
            return null;
        }
        return () -> {
            boolean marketplace;
            boolean bl = marketplace = !ignoreTagMarketplaceTab && option2 != null && option2.startsWith(SearchWords.TAG.getValue());
            if (this.myShowMarketplaceTab) {
                marketplace = true;
                this.myShowMarketplaceTab = false;
            }
            this.updateSelectionTab(marketplace ? 0 : 1);
            PluginsTab tab = marketplace ? this.myMarketplaceTab : this.myInstalledTab;
            tab.clearSearchPanel(option2);
            if (!StringUtil.isEmpty((String)option2)) {
                tab.showSearchPanel(option2);
            }
        };
    }

    public void openMarketplaceTab(@NotNull String option2) {
        if (option2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(16);
        }
        this.myLaterSearchQuery = option2;
        this.myShowMarketplaceTab = true;
        if (this.myTabHeaderComponent != null) {
            this.updateSelectionTab(0);
        }
        if (this.myMarketplaceTab != null) {
            this.myMarketplaceTab.clearSearchPanel(option2);
            this.myMarketplaceTab.showSearchPanel(option2);
        }
    }

    public void openInstalledTab(@NotNull String option2) {
        if (option2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(17);
        }
        this.myLaterSearchQuery = option2;
        this.myShowMarketplaceTab = false;
        this.myForceShowInstalledTabForTag = true;
        if (this.myTabHeaderComponent != null) {
            this.updateSelectionTab(1);
        }
    }

    @RequiresEdt
    private void onPluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData) {
        if (callbackData == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(18);
        }
        ThreadingAssertions.assertEventDispatchThread();
        PluginModelAsyncOperationsExecutor.INSTANCE.updateErrors(this.myCoroutineScope, this.myPluginModelFacade.getModel().getSessionId(), callbackData.getPluginDescriptor().getPluginId(), (Function1<? super List<? extends HtmlChunk>, Unit>)((Function1)errors -> {
            this.updateAfterPluginInstalledFromDisk(callbackData, (List<HtmlChunk>)errors);
            return null;
        }));
    }

    private void updateAfterPluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData, List<HtmlChunk> errors) {
        ListPluginComponent component2;
        if (callbackData == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(19);
        }
        this.myPluginModelFacade.getModel().pluginInstalledFromDisk(callbackData, errors);
        boolean select = this.myInstalledTab.getInstalledPanel() == null;
        this.updateSelectionTab(1);
        this.myInstalledTab.clearSearchPanel("");
        ListPluginComponent listPluginComponent = component2 = select ? this.findInstalledPluginById(callbackData.getPluginDescriptor().getPluginId()) : null;
        if (component2 != null) {
            this.myInstalledTab.getInstalledPanel().setSelection(component2);
        }
    }

    private void updateSelectionTab(int tab) {
        if (this.myTabHeaderComponent.getSelectionTab() != tab) {
            this.myTabHeaderComponent.setSelectionWithEvents(tab);
        }
    }

    @Nullable
    private ListPluginComponent findInstalledPluginById(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(20);
        }
        for (UIPluginGroup group2 : this.myInstalledTab.getInstalledGroups()) {
            ListPluginComponent component2 = group2.findComponent(pluginId);
            if (component2 == null) continue;
            return component2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackData";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGearActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCenterComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showRightBottomPopup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clearUpdates";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyUpdates";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerCopyProvider";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectAndEnable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "openMarketplaceTab";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "openInstalledTab";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onPluginInstalledFromDisk";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateAfterPluginInstalledFromDisk";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findInstalledPluginById";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 13 -> new IllegalStateException(string);
        };
    }

    private class UpdatePluginsAutomaticallyToggleAction
    extends DumbAwareToggleAction {
        private UpdatePluginsAutomaticallyToggleAction() {
            super(IdeBundle.message((String)"updates.plugins.autoupdate.settings.action", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                UpdatePluginsAutomaticallyToggleAction.$$$reportNull$$$0(0);
            }
            return PluginManagerConfigurablePanel.this.myPluginsAutoUpdateEnabled;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            if (e == null) {
                UpdatePluginsAutomaticallyToggleAction.$$$reportNull$$$0(1);
            }
            PluginManagerConfigurablePanel.this.myPluginsAutoUpdateEnabled = state2;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                UpdatePluginsAutomaticallyToggleAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$UpdatePluginsAutomaticallyToggleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$UpdatePluginsAutomaticallyToggleAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class ManagePluginRepositoriesAction
    extends DumbAwareAction {
        private ManagePluginRepositoriesAction() {
            super(IdeBundle.message((String)"plugin.manager.repositories", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ManagePluginRepositoriesAction.$$$reportNull$$$0(0);
            }
            if (ShowSettingsUtil.getInstance().editConfigurable((Component)PluginManagerConfigurablePanel.this.myCardPanel, (Configurable)new PluginHostsConfigurable())) {
                PluginManagerCustomizer customizer;
                if (PluginManagerConfigurablePanel.this.myPluginManagerCustomizer == null) {
                    PluginManagerConfigurablePanel.this.resetPanels();
                }
                if ((customizer = PluginManagerCustomizer.getInstance()) != null) {
                    customizer.updateCustomRepositories(UpdateSettings.getInstance().getStoredPluginHosts(), (Function0<Unit>)((Function0)() -> {
                        PluginManagerConfigurablePanel.this.resetPanels();
                        return null;
                    }));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$ManagePluginRepositoriesAction", "actionPerformed"));
        }
    }

    private class OpenHttpProxyConfigurableAction
    extends DumbAwareAction {
        private OpenHttpProxyConfigurableAction() {
            super(IdeBundle.message((String)"button.http.proxy.settings", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenHttpProxyConfigurableAction.$$$reportNull$$$0(0);
            }
            if (HttpProxyConfigurable.editConfigurable((JComponent)PluginManagerConfigurablePanel.this.myCardPanel)) {
                PluginManagerConfigurablePanel.this.resetPanels();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$OpenHttpProxyConfigurableAction", "actionPerformed"));
        }
    }

    private class ManagePluginCertificatesAction
    extends DumbAwareAction {
        private ManagePluginCertificatesAction() {
            super(IdeBundle.message((String)"plugin.manager.custom.certificates", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ManagePluginCertificatesAction.$$$reportNull$$$0(0);
            }
            if (ShowSettingsUtil.getInstance().editConfigurable((Component)PluginManagerConfigurablePanel.this.myCardPanel, (Configurable)new PluginCertificateManager())) {
                PluginManagerConfigurablePanel.this.resetPanels();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$ManagePluginCertificatesAction", "actionPerformed"));
        }
    }

    private class CustomInstallPluginFromDiskAction
    extends InstallFromDiskAction {
        private CustomInstallPluginFromDiskAction() {
            super(PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel(), PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel(), PluginManagerConfigurablePanel.this.myCardPanel);
        }

        @Override
        @RequiresEdt
        protected void onPluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData, @Nullable Project project2) {
            if (callbackData == null) {
                CustomInstallPluginFromDiskAction.$$$reportNull$$$0(0);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (PluginManagerConfigurablePanel.this.myPluginManagerCustomizer != null) {
                PluginManagerConfigurablePanel.this.myPluginManagerCustomizer.updateAfterModification((Function0<Unit>)((Function0)() -> {
                    PluginManagerConfigurablePanel.this.onPluginInstalledFromDisk(callbackData);
                    return null;
                }));
                return;
            }
            PluginManagerConfigurablePanel.this.onPluginInstalledFromDisk(callbackData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callbackData", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$CustomInstallPluginFromDiskAction", "onPluginInstalledFromDisk"));
        }
    }

    private final class ChangePluginStateAction
    extends DumbAwareAction {
        private final boolean myEnable;

        private ChangePluginStateAction(boolean enable2) {
            super(enable2 ? IdeBundle.message((String)"plugins.configurable.enable.all.downloaded", (Object[])new Object[0]) : IdeBundle.message((String)"plugins.configurable.disable.all.downloaded", (Object[])new Object[0]));
            this.myEnable = enable2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangePluginStateAction.$$$reportNull$$$0(0);
            }
            PluginModelAsyncOperationsExecutor.INSTANCE.switchPlugins(PluginManagerConfigurablePanel.this.myCoroutineScope, PluginManagerConfigurablePanel.this.myPluginModelFacade, this.myEnable, (Function1<? super List<? extends PluginUiModel>, Unit>)((Function1)models -> {
                PluginManagerConfigurablePanel.setState(PluginManagerConfigurablePanel.this.myPluginModelFacade, models, this.myEnable);
                return null;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$ChangePluginStateAction", "actionPerformed"));
        }
    }

    private class ResetConfigurableAction
    extends DumbAwareAction {
        private ResetConfigurableAction() {
            super(IdeBundle.message((String)"plugin.manager.refresh", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetConfigurableAction.$$$reportNull$$$0(0);
            }
            PluginManagerConfigurablePanel.this.resetPanels();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$ResetConfigurableAction", "actionPerformed"));
        }
    }

    private static final class GroupByActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        private GroupByActionGroup() {
        }
    }

    static class LinkLabelButton<T>
    extends LinkLabel<T> {
        LinkLabelButton(@NlsContexts.LinkLabel String text2, @Nullable Icon icon2) {
            super(text2, icon2);
        }

        LinkLabelButton(@NlsContexts.LinkLabel String text2, @Nullable Icon icon2, @Nullable LinkListener<T> aListener) {
            super(text2, icon2, aListener);
        }

        LinkLabelButton(@NlsContexts.LinkLabel String text2, @Nullable Icon icon2, @Nullable LinkListener<T> aListener, @Nullable T aLinkData) {
            super(text2, icon2, aListener, aLinkData);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleLinkLabelButton();
            }
            return this.accessibleContext;
        }

        protected class AccessibleLinkLabelButton
        extends LinkLabel.AccessibleLinkLabel {
            protected AccessibleLinkLabelButton() {
                super((LinkLabel)LinkLabelButton.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PUSH_BUTTON;
            }
        }
    }
}

