/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginUpdateStatus;
import com.intellij.ide.plugins.StandalonePluginUpdateChecker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.PluginUpdateCheckService;
import com.intellij.openapi.updateSettings.PluginUpdateInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u001b\u001a\u00020\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00180\u001dH\u0004J\u001c\u0010\u001f\u001a\u00020\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00180\u001dH\u0004J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\b\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020\u001aH\u0002J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'H\u0002J>\u0010(\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0*2\u000e\b\u0002\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001a0*2\u000e\b\u0002\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001a0*J\u0012\u0010-\u001a\u00020\u001a2\b\u0010.\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010/\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lcom/intellij/ide/plugins/StandalonePluginUpdateChecker;", "Lcom/intellij/openapi/Disposable;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "updateTimestampProperty", "", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "notificationIcon", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/openapi/extensions/PluginId;Ljava/lang/String;Lcom/intellij/notification/NotificationGroup;Ljavax/swing/Icon;)V", "getPluginId", "()Lcom/intellij/openapi/extensions/PluginId;", "alarm", "Lcom/intellij/util/Alarm;", "updateDelay", "", "checkQueued", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentVersion", "getCurrentVersion", "()Ljava/lang/String;", "skipUpdateCheck", "", "pluginUsed", "", "queueUpdateCheck", "callback", "Lkotlin/Function1;", "Lcom/intellij/ide/plugins/PluginUpdateStatus;", "updateCheck", "initPluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "newVersion", "findPluginDescriptor", "recordSuccessfulUpdateCheck", "notifyPluginUpdateAvailable", "update", "Lcom/intellij/ide/plugins/PluginUpdateStatus$Update;", "installPluginUpdate", "successCallback", "Lkotlin/Function0;", "cancelCallback", "errorCallback", "notifyNotInstalled", "message", "dispose", "Companion", "intellij.platform.ide.impl"})
public class StandalonePluginUpdateChecker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginId pluginId;
    @NotNull
    private final String updateTimestampProperty;
    @Nullable
    private final NotificationGroup notificationGroup;
    @Nullable
    private final Icon notificationIcon;
    @NotNull
    private final Alarm alarm;
    private volatile long updateDelay;
    @NotNull
    private final AtomicBoolean checkQueued;
    private static final long INITIAL_UPDATE_DELAY = 2000L;
    private static final long CACHED_REQUEST_DELAY = TimeUnit.DAYS.toMillis(1L);
    @NotNull
    private static final Logger LOG;

    public StandalonePluginUpdateChecker(@NotNull PluginId pluginId, @NotNull String updateTimestampProperty, @Nullable NotificationGroup notificationGroup, @Nullable Icon notificationIcon) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)updateTimestampProperty, (String)"updateTimestampProperty");
        this.pluginId = pluginId;
        this.updateTimestampProperty = updateTimestampProperty;
        this.notificationGroup = notificationGroup;
        this.notificationIcon = notificationIcon;
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.updateDelay = 2000L;
        this.checkQueued = new AtomicBoolean(false);
    }

    @NotNull
    public final PluginId getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public String getCurrentVersion() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)this.pluginId);
        Intrinsics.checkNotNull((Object)ideaPluginDescriptor);
        String string = ideaPluginDescriptor.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        return string;
    }

    public boolean skipUpdateCheck() {
        return false;
    }

    public final void pluginUsed() {
        if (!UpdateSettings.getInstance().isPluginsCheckNeeded()) {
            return;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        long lastUpdateTime = PropertiesComponent.getInstance().getLong(this.updateTimestampProperty, 0L);
        if (lastUpdateTime == 0L || System.currentTimeMillis() - lastUpdateTime > CACHED_REQUEST_DELAY) {
            this.queueUpdateCheck((Function1<? super PluginUpdateStatus, Boolean>)((Function1)arg_0 -> StandalonePluginUpdateChecker.pluginUsed$lambda$0(this, arg_0)));
        }
    }

    protected final void queueUpdateCheck(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.checkQueued.compareAndSet(false, true)) {
            this.alarm.addRequest(() -> StandalonePluginUpdateChecker.queueUpdateCheck$lambda$0(this, callback), this.updateDelay);
            this.updateDelay *= (long)2;
        }
    }

    protected final void updateCheck(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Ref.ObjectRef updateStatus = new Ref.ObjectRef();
        if (this.skipUpdateCheck()) {
            updateStatus.element = PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        } else {
            PluginUpdateInfo checkResult = PluginUpdateCheckService.getPluginUpdate$default(PluginUpdateCheckService.Companion.getInstance(), this.pluginId, null, 2, null);
            PluginUpdateInfo pluginUpdateInfo = checkResult;
            if (pluginUpdateInfo instanceof PluginUpdateInfo.CheckFailed) {
                String string = IdeBundle.message((String)"plugin.updater.error.check.failed", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                v1 = PluginUpdateStatus.Companion.fromException(string, (Exception)CollectionsKt.first((Iterable)((PluginUpdateInfo.CheckFailed)checkResult).getErrors().values()));
            } else if (pluginUpdateInfo instanceof PluginUpdateInfo.UpdateAvailable) {
                String string = ((PluginUpdateInfo.UpdateAvailable)checkResult).getUpdate().getPluginVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPluginVersion(...)");
                v1 = new PluginUpdateStatus.Update(this.initPluginDescriptor(string), ((PluginUpdateInfo.UpdateAvailable)checkResult).getUpdate());
            } else {
                v1 = updateStatus.element = (PluginUpdateStatus)PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
            }
        }
        if (!(updateStatus.element instanceof PluginUpdateStatus.CheckFailed)) {
            this.recordSuccessfulUpdateCheck();
        }
        ApplicationManager.getApplication().invokeLater(() -> StandalonePluginUpdateChecker.updateCheck$lambda$0(callback, updateStatus), ModalityState.any());
    }

    private final IdeaPluginDescriptor initPluginDescriptor(String newVersion) {
        PluginNode pluginNode;
        IdeaPluginDescriptor originalPlugin = this.findPluginDescriptor();
        PluginNode $this$initPluginDescriptor_u24lambda_u240 = pluginNode = new PluginNode(this.pluginId);
        boolean bl = false;
        $this$initPluginDescriptor_u24lambda_u240.setVersion(newVersion);
        $this$initPluginDescriptor_u24lambda_u240.setName(originalPlugin.getName());
        $this$initPluginDescriptor_u24lambda_u240.setDescription(originalPlugin.getDescription());
        return pluginNode;
    }

    private final IdeaPluginDescriptor findPluginDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)this.pluginId);
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException(("Plugin ID " + this.pluginId + " not found when checking updates").toString());
        }
        return ideaPluginDescriptor;
    }

    private final void recordSuccessfulUpdateCheck() {
        PropertiesComponent.getInstance().setValue(this.updateTimestampProperty, String.valueOf(System.currentTimeMillis()));
        this.updateDelay = 2000L;
    }

    private final void notifyPluginUpdateAvailable(PluginUpdateStatus.Update update2) {
        if (this.notificationGroup == null) {
            return;
        }
        String pluginName = this.findPluginDescriptor().getName();
        Intrinsics.checkNotNull((Object)pluginName);
        Object[] objectArray = new Object[]{update2.getPluginDescriptor().getVersion(), pluginName};
        String string = IdeBundle.message((String)"plugin.updater.notification.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.notificationGroup.createNotification(pluginName, string, NotificationType.INFORMATION).setSuggestionType(true).addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"plugin.updater.install", (Object[])new Object[0]), () -> StandalonePluginUpdateChecker.notifyPluginUpdateAvailable$lambda$0(this, update2))).setIcon(this.notificationIcon).notify(null);
    }

    public final void installPluginUpdate(@NotNull PluginUpdateStatus.Update update2, @NotNull Function0<Unit> successCallback, @NotNull Function0<Unit> cancelCallback, @NotNull Function0<Unit> errorCallback) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        Intrinsics.checkNotNullParameter(successCallback, (String)"successCallback");
        Intrinsics.checkNotNullParameter(cancelCallback, (String)"cancelCallback");
        Intrinsics.checkNotNullParameter(errorCallback, (String)"errorCallback");
        PluginDownloader pluginDownloader = update2.getPluginDownloader();
        String string = IdeBundle.message((String)"plugin.updater.downloading", (Object[])new Object[0]);
        PluginManagerUISettings pluginManagerUISettings = PluginManagerUISettings.getInstance();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(pluginDownloader, errorCallback, this, successCallback, cancelCallback, string, pluginManagerUISettings){
            final /* synthetic */ PluginDownloader $pluginDownloader;
            final /* synthetic */ Function0<Unit> $errorCallback;
            final /* synthetic */ StandalonePluginUpdateChecker this$0;
            final /* synthetic */ Function0<Unit> $successCallback;
            final /* synthetic */ Function0<Unit> $cancelCallback;
            {
                this.$pluginDownloader = $pluginDownloader;
                this.$errorCallback = $errorCallback;
                this.this$0 = $receiver;
                this.$successCallback = $successCallback;
                this.$cancelCallback = $cancelCallback;
                super(null, $super_call_param$1, true, (PerformInBackgroundOption)$super_call_param$2);
            }

            public void run(ProgressIndicator indicator2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                Ref.BooleanRef installed = new Ref.BooleanRef();
                Ref.ObjectRef message = new Ref.ObjectRef();
                try {
                    bl = this.$pluginDownloader.prepareToInstall(indicator2);
                }
                catch (IOException e) {
                    StandalonePluginUpdateChecker.access$getLOG$cp().info((Throwable)e);
                    message.element = e.getMessage();
                    bl = false;
                }
                boolean prepareResult = bl;
                if (prepareResult) {
                    installed.element = true;
                    this.$pluginDownloader.install();
                    ApplicationManager.getApplication().invokeLater(installPluginUpdate.4::run$lambda$0);
                }
                ApplicationManager.getApplication().invokeLater(() -> installPluginUpdate.4.run$lambda$1(installed, this.$errorCallback, this.this$0, message, this.$successCallback));
            }

            public void onCancel() {
                this.$cancelCallback.invoke();
            }

            private static final void run$lambda$0() {
                PluginManagerMain.notifyPluginsUpdated(null);
            }

            private static final void run$lambda$1(Ref.BooleanRef $installed, Function0 $errorCallback, StandalonePluginUpdateChecker this$0, Ref.ObjectRef $message, Function0 $successCallback) {
                if (!$installed.element) {
                    $errorCallback.invoke();
                    StandalonePluginUpdateChecker.access$notifyNotInstalled(this$0, (String)$message.element);
                } else {
                    $successCallback.invoke();
                }
            }
        });
    }

    public static /* synthetic */ void installPluginUpdate$default(StandalonePluginUpdateChecker standalonePluginUpdateChecker, PluginUpdateStatus.Update update2, Function0 function0, Function0 function02, Function0 function03, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: installPluginUpdate");
        }
        if ((n & 2) != 0) {
            function0 = StandalonePluginUpdateChecker::installPluginUpdate$lambda$0;
        }
        if ((n & 4) != 0) {
            function02 = StandalonePluginUpdateChecker::installPluginUpdate$lambda$1;
        }
        if ((n & 8) != 0) {
            function03 = StandalonePluginUpdateChecker::installPluginUpdate$lambda$2;
        }
        standalonePluginUpdateChecker.installPluginUpdate(update2, (Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<Unit>)function03);
    }

    private final void notifyNotInstalled(String message) {
        String string;
        if (this.notificationGroup == null) {
            return;
        }
        if (message == null) {
            string = IdeBundle.message((String)"plugin.updater.not.installed", (Object[])new Object[0]);
        } else {
            Object[] objectArray = new Object[]{message};
            string = IdeBundle.message((String)"plugin.updater.not.installed.misc", (Object[])objectArray);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String content2 = string2;
        String string3 = this.findPluginDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        this.notificationGroup.createNotification(string3, content2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"plugin.updater.not.installed.see.log.action", (Object[])new Object[0]), StandalonePluginUpdateChecker::notifyNotInstalled$lambda$0)).notify(null);
    }

    public void dispose() {
    }

    private static final boolean pluginUsed$lambda$0(StandalonePluginUpdateChecker this$0, PluginUpdateStatus updateStatus) {
        block1: {
            PluginUpdateStatus pluginUpdateStatus;
            block0: {
                Intrinsics.checkNotNullParameter((Object)updateStatus, (String)"updateStatus");
                pluginUpdateStatus = updateStatus;
                if (!(pluginUpdateStatus instanceof PluginUpdateStatus.Update)) break block0;
                this$0.notifyPluginUpdateAvailable((PluginUpdateStatus.Update)updateStatus);
                break block1;
            }
            if (!(pluginUpdateStatus instanceof PluginUpdateStatus.CheckFailed)) break block1;
            LOG.info("Plugin update check failed: " + ((PluginUpdateStatus.CheckFailed)updateStatus).getMessage() + ", details: " + ((PluginUpdateStatus.CheckFailed)updateStatus).getDetail());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void queueUpdateCheck$lambda$0(StandalonePluginUpdateChecker this$0, Function1 $callback) {
        try {
            this$0.updateCheck((Function1<? super PluginUpdateStatus, Boolean>)$callback);
        }
        finally {
            this$0.checkQueued.set(false);
        }
    }

    private static final void updateCheck$lambda$0(Function1 $callback, Ref.ObjectRef $updateStatus) {
        $callback.invoke($updateStatus.element);
    }

    private static final void notifyPluginUpdateAvailable$lambda$0(StandalonePluginUpdateChecker this$0, PluginUpdateStatus.Update $update) {
        StandalonePluginUpdateChecker.installPluginUpdate$default(this$0, $update, null, null, null, 14, null);
    }

    private static final Unit installPluginUpdate$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit installPluginUpdate$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final Unit installPluginUpdate$lambda$2() {
        return Unit.INSTANCE;
    }

    private static final void notifyNotInstalled$lambda$0() {
        ShowLogAction.showLog();
    }

    protected static final long getCACHED_REQUEST_DELAY() {
        return Companion.getCACHED_REQUEST_DELAY();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$notifyNotInstalled(StandalonePluginUpdateChecker $this, String message) {
        $this.notifyNotInstalled(message);
    }

    static {
        Logger logger2 = Logger.getInstance(StandalonePluginUpdateChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/plugins/StandalonePluginUpdateChecker$Companion;", "", "<init>", "()V", "INITIAL_UPDATE_DELAY", "", "CACHED_REQUEST_DELAY", "getCACHED_REQUEST_DELAY$annotations", "getCACHED_REQUEST_DELAY", "()J", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        protected final long getCACHED_REQUEST_DELAY() {
            return CACHED_REQUEST_DELAY;
        }

        @JvmStatic
        protected static /* synthetic */ void getCACHED_REQUEST_DELAY$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

