/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.newui.PluginLogoIconProvider;
import com.intellij.ide.plugins.newui.PluginLogoKt;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.icons.FilteredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.GrayFilter;
import com.intellij.util.ui.JBImageIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class PluginLogoIcon
implements PluginLogoIconProvider {
    private static final GrayFilter grayFilter = new GrayFilter();
    static final LoadingCache<JBImageIcon, Icon> disabledIcons = Caffeine.newBuilder().weakKeys().maximumSize(256L).build(key -> new FilteredIcon((Icon)key, () -> new GrayFilter(JBColor.isBright() ? 20 : 19, 0, 100)));
    static final LoadingCache<JBImageIcon, Icon> baseDisabledIcons = Caffeine.newBuilder().weakKeys().maximumSize(256L).build(key -> new FilteredIcon((Icon)key, () -> grayFilter));
    private final Icon myPluginLogo;
    private final Icon myPluginLogoError;
    private final Icon myPluginLogoDisabled;
    private final Icon myPluginLogoDisabledError;
    private final Icon myPluginLogoBig;
    private final Icon myPluginLogoErrorBig;
    private final Icon myPluginLogoDisabledBig;
    private final Icon myPluginLogoDisabledErrorBig;

    PluginLogoIcon(@NotNull Icon logo, @NotNull Icon logoDisabled, @NotNull Icon logoBig, @NotNull Icon logoDisabledBig) {
        if (logo == null) {
            PluginLogoIcon.$$$reportNull$$$0(0);
        }
        if (logoDisabled == null) {
            PluginLogoIcon.$$$reportNull$$$0(1);
        }
        if (logoBig == null) {
            PluginLogoIcon.$$$reportNull$$$0(2);
        }
        if (logoDisabledBig == null) {
            PluginLogoIcon.$$$reportNull$$$0(3);
        }
        this.myPluginLogo = logo;
        this.myPluginLogoError = PluginLogoIcon.setSouthWest(logo, AllIcons.Plugins.ModifierInvalid);
        this.myPluginLogoDisabled = logoDisabled;
        this.myPluginLogoDisabledError = PluginLogoIcon.setSouthWest(logoDisabled, AllIcons.Plugins.ModifierInvalid);
        Icon errorLogo2x = this.getErrorLogo2x();
        this.myPluginLogoBig = logoBig;
        this.myPluginLogoErrorBig = PluginLogoIcon.setSouthWest(logoBig, errorLogo2x);
        this.myPluginLogoDisabledBig = logoDisabledBig;
        this.myPluginLogoDisabledErrorBig = PluginLogoIcon.setSouthWest(logoDisabledBig, errorLogo2x);
    }

    @NotNull
    protected Icon getDisabledIcon(@NotNull JBImageIcon icon2, boolean base) {
        if (icon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(4);
        }
        return PluginLogoIcon.calculateDisabledIcon(icon2, base);
    }

    @NotNull
    static Icon calculateDisabledIcon(@NotNull JBImageIcon icon2, boolean base) {
        if (icon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(5);
        }
        Icon icon3 = base ? (Icon)baseDisabledIcons.get((Object)icon2) : (Icon)disabledIcons.get((Object)icon2);
        if (icon3 == null) {
            PluginLogoIcon.$$$reportNull$$$0(6);
        }
        return icon3;
    }

    @NotNull
    protected Icon getScaled2xIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(7);
        }
        Icon icon3 = IconUtil.scale((Icon)icon2, null, (float)2.0f);
        if (icon3 == null) {
            PluginLogoIcon.$$$reportNull$$$0(8);
        }
        return icon3;
    }

    @NotNull
    private static Icon setSouthWest(@NotNull Icon main2, @NotNull Icon southWest) {
        if (main2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(9);
        }
        if (southWest == null) {
            PluginLogoIcon.$$$reportNull$$$0(10);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(main2, 0);
        layeredIcon.setIcon(southWest, 1, 6);
        LayeredIcon layeredIcon2 = layeredIcon;
        if (layeredIcon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(11);
        }
        return layeredIcon2;
    }

    @NotNull
    protected Icon getErrorLogo2x() {
        Icon icon2 = PluginLogoKt.reloadPluginIcon(AllIcons.Plugins.ModifierInvalid, 20, 20);
        if (icon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(12);
        }
        return icon2;
    }

    @Override
    @NotNull
    public Icon getIcon(boolean big, boolean error2, boolean disabled) {
        if (error2) {
            if (big) {
                Icon icon2 = disabled ? this.myPluginLogoDisabledErrorBig : this.myPluginLogoErrorBig;
                if (icon2 == null) {
                    PluginLogoIcon.$$$reportNull$$$0(13);
                }
                return icon2;
            }
            Icon icon3 = disabled ? this.myPluginLogoDisabledError : this.myPluginLogoError;
            if (icon3 == null) {
                PluginLogoIcon.$$$reportNull$$$0(14);
            }
            return icon3;
        }
        if (big) {
            Icon icon4 = disabled ? this.myPluginLogoDisabledBig : this.myPluginLogoBig;
            if (icon4 == null) {
                PluginLogoIcon.$$$reportNull$$$0(15);
            }
            return icon4;
        }
        Icon icon5 = disabled ? this.myPluginLogoDisabled : this.myPluginLogo;
        if (icon5 == null) {
            PluginLogoIcon.$$$reportNull$$$0(16);
        }
        return icon5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 11, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logoDisabled";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logoBig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logoDisabledBig";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginLogoIcon";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "southWest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginLogoIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDisabledIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getScaled2xIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setSouthWest";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorLogo2x";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDisabledIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateDisabledIcon";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScaled2xIcon";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setSouthWest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 11, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

