/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ColorBlindnessMatrix;
import com.intellij.ide.ui.ColorConverter;
import com.intellij.ide.ui.DaltonizationFilter;
import com.intellij.ide.ui.MatrixConverter;
import com.intellij.ide.ui.MatrixFilter;
import com.intellij.ide.ui.SimulationFilter;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.Matrix;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ColorBlindnessInternalAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            ColorBlindnessInternalAction.$$$reportNull$$$0(0);
        }
        new ColorDialog(event).show();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ColorBlindnessInternalAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/ColorBlindnessInternalAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/ColorBlindnessInternalAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class ColorDialog
    extends DialogWrapper {
        private final ColorView myView = new ColorView();
        private final JComboBox myCombo = new ComboBox((Object[])FilterItem.ALL);
        private final JSlider myFirstSlider = ColorDialog.createSlider();
        private final JSlider mySecondSlider = ColorDialog.createSlider();

        private static JSlider createSlider() {
            JSlider slider = new JSlider(0, 100);
            slider.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            slider.setMajorTickSpacing(10);
            slider.setMinorTickSpacing(1);
            slider.setPaintTicks(true);
            slider.setPaintLabels(true);
            slider.setVisible(false);
            return slider;
        }

        private static void showSlider(JSlider slider, ChangeListener listener2) {
            slider.setValue(70);
            slider.setVisible(true);
            slider.addChangeListener(listener2);
        }

        private static void hideSlider(JSlider slider, ChangeListener listener2) {
            slider.removeChangeListener(listener2);
            slider.setVisible(false);
        }

        private void updateFilter(MutableFilter filter2) {
            filter2.update((double)this.myFirstSlider.getValue() / 100.0, (double)this.mySecondSlider.getValue() / 100.0);
            this.myView.setFilter(filter2);
        }

        private ColorDialog(AnActionEvent event) {
            super(event.getProject());
            this.init();
            this.setTitle("ColorBlindness");
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myCombo;
        }

        protected JComponent createCenterPanel() {
            this.myView.setBorder(BorderFactory.createEtchedBorder());
            this.myView.setMinimumSize((Dimension)new JBDimension(360, 200));
            this.myView.setPreferredSize((Dimension)new JBDimension(720, 400));
            this.myView.addMouseListener(new MouseAdapter(){
                private JFileChooser myFileChooser;

                @Override
                public void mousePressed(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        File file2;
                        if (this.myFileChooser == null) {
                            this.myFileChooser = new JFileChooser();
                            this.myFileChooser.setFileSelectionMode(0);
                            this.myFileChooser.setMultiSelectionEnabled(false);
                        }
                        File file3 = file2 = 0 != this.myFileChooser.showOpenDialog(myView) ? null : this.myFileChooser.getSelectedFile();
                        if (file2 != null) {
                            try {
                                myView.setImage(ImageIO.read(file2));
                            }
                            catch (Exception exception) {
                                myView.setImage(null);
                            }
                        }
                    }
                }
            });
            ChangeListener listener2 = event -> {
                if (this.myView.myFilter instanceof MutableFilter) {
                    this.updateFilter((MutableFilter)this.myView.myFilter);
                }
            };
            this.myCombo.addItemListener(event -> {
                Object object;
                if (1 == event.getStateChange() && (object = event.getItem()) instanceof FilterItem) {
                    FilterItem item = (FilterItem)object;
                    if (item.myFilter instanceof MutableFilter) {
                        ColorDialog.showSlider(this.myFirstSlider, listener2);
                        ColorDialog.showSlider(this.mySecondSlider, listener2);
                        this.updateFilter((MutableFilter)item.myFilter);
                    } else {
                        ColorDialog.hideSlider(this.myFirstSlider, listener2);
                        ColorDialog.hideSlider(this.mySecondSlider, listener2);
                        this.myView.setFilter(item.myFilter);
                    }
                }
            });
            JPanel control = new JPanel((LayoutManager)new VerticalLayout(10));
            control.add("TOP", this.myCombo);
            control.add("TOP", this.myFirstSlider);
            control.add("TOP", this.mySecondSlider);
            JPanel panel2 = new JPanel(new BorderLayout(10, 10));
            panel2.add("Center", this.myView);
            panel2.add("South", control);
            return panel2;
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getCancelAction()};
            if (actionArray == null) {
                ColorDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/ColorBlindnessInternalAction$ColorDialog", "createActions"));
        }
    }

    private static abstract class MutableFilter
    extends RGBImageFilter {
        private final String myName;
        private ColorConverter myConverter;

        private MutableFilter(String name2) {
            this.myName = name2;
            this.update(0.7, 0.7);
        }

        private void update(double first, double second) {
            this.myConverter = this.getConverter(first, second);
        }

        abstract ColorConverter getConverter(double var1, double var3);

        public String toString() {
            return this.myName;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            return this.myConverter.convert(rgb);
        }
    }

    private static final class ColorView
    extends JComponent {
        private BufferedImage myBackground;
        private ImageFilter myFilter;
        private Image myImage;

        private ColorView() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
            if (bounds.isEmpty()) {
                return;
            }
            if (this.myBackground != null) {
                if (this.myImage == null) {
                    this.myImage = ImageUtil.filter((Image)this.myBackground, (ImageFilter)this.myFilter);
                }
            } else if (this.myImage == null || bounds.width != this.myImage.getWidth(this) || bounds.height != this.myImage.getHeight(this)) {
                int[] array = new int[bounds.width * bounds.height];
                float width = bounds.width - 1;
                float height = bounds.height - 1;
                int i2 = 0;
                for (int h = 0; h < bounds.height; ++h) {
                    int w = 0;
                    while (w < bounds.width) {
                        float level = (float)(2 * h) / height;
                        float saturation = level > 1.0f ? 1.0f : level;
                        float brightness = level > 1.0f ? 2.0f - level : 1.0f;
                        array[i2] = Color.HSBtoRGB((float)w / width, saturation, brightness);
                        ++w;
                        ++i2;
                    }
                }
                BufferedImage image2 = ImageUtil.createImage((Graphics)g, (int)bounds.width, (int)bounds.height, (int)1);
                image2.setRGB(0, 0, bounds.width, bounds.height, array, 0, bounds.width);
                this.myImage = ImageUtil.filter((Image)image2, (ImageFilter)this.myFilter);
            }
            g.drawImage(this.myImage, bounds.x, bounds.y, bounds.width, bounds.height, this);
        }

        void setImage(BufferedImage image2) {
            this.myImage = null;
            this.myBackground = image2;
            this.repaint();
        }

        void setFilter(ImageFilter filter2) {
            this.myImage = null;
            this.myFilter = filter2;
            this.repaint();
        }
    }

    private static final class FilterItem {
        private final ImageFilter myFilter;
        private static final FilterItem[] ALL = new FilterItem[]{new FilterItem(null), new FilterItem(DaltonizationFilter.protanopia), new FilterItem(MatrixFilter.protanopia), new FilterItem(new MutableFilter("Protanopia (mutable)"){

            @Override
            ColorConverter getConverter(double first, double second) {
                Matrix matrix = Matrix.create((int)3, (double[])new double[]{1.0, first, second, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0});
                return new MatrixConverter(ColorBlindnessMatrix.Protanopia.calculate((Matrix)matrix));
            }
        }), new FilterItem(DaltonizationFilter.deuteranopia), new FilterItem(MatrixFilter.deuteranopia), new FilterItem(new MutableFilter("Deuteranopia (mutable)"){

            @Override
            ColorConverter getConverter(double first, double second) {
                Matrix matrix = Matrix.create((int)3, (double[])new double[]{1.0, 0.0, 0.0, first, 1.0, second, 0.0, 0.0, 1.0});
                return new MatrixConverter(ColorBlindnessMatrix.Deuteranopia.calculate((Matrix)matrix));
            }
        }), new FilterItem(DaltonizationFilter.tritanopia), new FilterItem(MatrixFilter.tritanopia), new FilterItem(new MutableFilter("Tritanopia (mutable)"){

            @Override
            ColorConverter getConverter(double first, double second) {
                Matrix matrix = Matrix.create((int)3, (double[])new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, first, second, 1.0});
                return new MatrixConverter(ColorBlindnessMatrix.Tritanopia.calculate((Matrix)matrix));
            }
        }), new FilterItem(SimulationFilter.protanopia), new FilterItem(SimulationFilter.deuteranopia), new FilterItem(SimulationFilter.tritanopia), new FilterItem(SimulationFilter.achromatopsia)};

        FilterItem(ImageFilter filter2) {
            this.myFilter = filter2;
        }

        public String toString() {
            return this.myFilter == null ? "No filtering" : this.myFilter.toString();
        }
    }
}

