/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.ide.ui.ColorMapKt;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.UIThemeBean;
import com.intellij.ide.ui.UIThemeBeanKt;
import com.intellij.ide.ui.UIThemeKt;
import com.intellij.ide.ui.UiThemePaletteScope;
import com.intellij.ide.ui.UiThemePaletteScopeManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.svg.SvgAttributePatcher;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.InsecureHashBuilder;
import com.intellij.util.SVGLoader;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.UIDefaults;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001ae\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0018\b\u0002\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b2\u000b\u0010\n\u001a\u00070\t\u00a2\u0006\u0002\b\u000b2\u001a\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a$\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a$\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\"\u001f\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0015\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001f\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0015\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001f\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0015\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"createTheme", "Lcom/intellij/ide/ui/UITheme;", "theme", "Lcom/intellij/ide/ui/UIThemeBean;", "parentTheme", "classLoader", "Ljava/lang/ClassLoader;", "iconMapper", "Lkotlin/Function1;", "", "themeId", "Lorg/jetbrains/annotations/NonNls;", "warn", "Lkotlin/Function2;", "", "", "toColorString", "key", "darkTheme", "", "colorPaletteClassic", "", "colorPaletteNewLight", "colorPaletteNewDark", "addPattern", "value", "", "defaults", "Ljavax/swing/UIDefaults;", "createWarnFunction", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nUITheme.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UITheme.kt\ncom/intellij/ide/ui/UIThemeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,530:1\n1#2:531\n13#3:532\n*S KotlinDebug\n*F\n+ 1 UITheme.kt\ncom/intellij/ide/ui/UIThemeKt\n*L\n528#1:532\n*E\n"})
public final class UIThemeKt {
    @NotNull
    private static final Map<String, String> colorPaletteClassic;
    @NotNull
    private static final Map<String, String> colorPaletteNewLight;
    @NotNull
    private static final Map<String, String> colorPaletteNewDark;

    private static final UITheme createTheme(UIThemeBean theme, UIThemeBean parentTheme, ClassLoader classLoader, Function1<? super String, String> iconMapper, String themeId, Function2<? super String, ? super Throwable, Unit> warn) {
        if (parentTheme != null) {
            UIThemeBeanKt.importFromParentTheme(theme, parentTheme);
        }
        ColorMapKt.initializeNamedColors(theme, warn);
        UiThemePaletteScopeManager paletteScopeManager = new UiThemePaletteScopeManager(theme);
        Map<String, ? extends Object> iconMap = theme.icons;
        SVGLoader.SvgElementColorPatcherProvider colorPatcher = null;
        IconPathPatcher patcher = null;
        Map<String, ? extends Object> map2 = iconMap;
        if (!(map2 == null || map2.isEmpty())) {
            patcher = new IconPathPatcher(iconMapper, iconMap, classLoader){
                private final Function1<String, String> iconMapper;
                final /* synthetic */ Map<String, Object> $iconMap;
                final /* synthetic */ ClassLoader $classLoader;
                {
                    this.$iconMap = $iconMap;
                    this.$classLoader = $classLoader;
                    Function1 function1 = $iconMapper;
                    if (function1 == null) {
                        function1 = createTheme.1::iconMapper$lambda$0;
                    }
                    this.iconMapper = function1;
                }

                public String patchPath(String path, ClassLoader classLoader) {
                    V pluginIconPath;
                    Object icons;
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    if (classLoader instanceof PluginAwareClassLoader && (icons = this.$iconMap.get(((PluginAwareClassLoader)classLoader).getPluginId().getIdString())) instanceof Map && (pluginIconPath = ((Map)icons).get(path)) instanceof String) {
                        return (String)this.iconMapper.invoke(pluginIconPath);
                    }
                    Object value = this.$iconMap.get(path);
                    if (value == null && path.charAt(0) != '/') {
                        value = this.$iconMap.get("/" + path);
                    }
                    return value instanceof String ? (String)this.iconMapper.invoke(value) : null;
                }

                public ClassLoader getContextClassLoader(String path, ClassLoader originalClassLoader) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    return this.$classLoader;
                }

                private static final String iconMapper$lambda$0(String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it;
                }
            };
            colorPatcher = paletteScopeManager.configureIcons(theme, iconMap);
        }
        Map<String, ? extends Color> colorsOnSelection = theme.iconColorOnSelectionMap.map;
        SVGLoader.SvgElementColorPatcherProvider selectionColorPatcher = null;
        if (!colorsOnSelection.isEmpty()) {
            HashMap<String, String> colors = new HashMap<String, String>(colorsOnSelection.size());
            HashSet<String> alphaColors = new HashSet<String>(colorsOnSelection.size());
            for (Map.Entry<String, ? extends Color> entry : colorsOnSelection.entrySet()) {
                String key = entry.getKey();
                Color v = entry.getValue();
                String value = "#" + ColorUtil.toHex((Color)v, (boolean)false);
                colors.put(key, value);
                alphaColors.add(value);
            }
            long[] digest = paletteScopeManager.computeDigest(new InsecureHashBuilder()).putStringMap((Map)colors).putLong(453973187376924038L).build();
            selectionColorPatcher = new SVGLoader.SvgElementColorPatcherProvider(colors, alphaColors, digest, paletteScopeManager){
                private final ConcurrentHashMap<UiThemePaletteScope, SvgAttributePatcher> svgPatcher;
                private final SvgAttributePatcher paletteSvgPatcher;
                final /* synthetic */ HashMap<String, String> $colors;
                final /* synthetic */ HashSet<String> $alphaColors;
                final /* synthetic */ long[] $digest;
                final /* synthetic */ UiThemePaletteScopeManager $paletteScopeManager;
                {
                    this.$colors = $colors;
                    this.$alphaColors = $alphaColors;
                    this.$digest = $digest;
                    this.$paletteScopeManager = $paletteScopeManager;
                    this.svgPatcher = new ConcurrentHashMap<K, V>();
                    this.paletteSvgPatcher = SvgKt.newSvgPatcher((Map)$colors, arg_0 -> createTheme.2.paletteSvgPatcher$lambda$0($alphaColors, arg_0));
                }

                public long[] digest() {
                    return this.$digest;
                }

                public SvgAttributePatcher attributeForPath(String path) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    UiThemePaletteScope uiThemePaletteScope = this.$paletteScopeManager.getScopeByPath(path);
                    if (uiThemePaletteScope == null) {
                        return this.paletteSvgPatcher;
                    }
                    UiThemePaletteScope scope = uiThemePaletteScope;
                    SvgAttributePatcher svgAttributePatcher = this.svgPatcher.computeIfAbsent(scope, arg_0 -> createTheme.2.attributeForPath$lambda$2(arg_0 -> createTheme.2.attributeForPath$lambda$1(this.$colors, this.$alphaColors, arg_0), arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)svgAttributePatcher, (String)"computeIfAbsent(...)");
                    return svgAttributePatcher;
                }

                private static final Integer paletteSvgPatcher$lambda$0(HashSet $alphaColors, String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return $alphaColors.contains(it) ? Integer.valueOf(255) : null;
                }

                private static final Integer attributeForPath$lambda$1$0(HashSet $alphaColors, String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return $alphaColors.contains(it) ? Integer.valueOf(255) : null;
                }

                private static final SvgAttributePatcher attributeForPath$lambda$1(HashMap $colors, HashSet $alphaColors, UiThemePaletteScope it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return SvgKt.newSvgPatcher((Map)$colors, arg_0 -> createTheme.2.attributeForPath$lambda$1$0($alphaColors, arg_0));
                }

                private static final SvgAttributePatcher attributeForPath$lambda$2(Function1 $tmp0, Object p0) {
                    return (SvgAttributePatcher)$tmp0.invoke(p0);
                }
            };
        }
        return new UITheme(themeId, theme, colorPatcher, selectionColorPatcher, patcher, classLoader);
    }

    static /* synthetic */ UITheme createTheme$default(UIThemeBean uIThemeBean, UIThemeBean uIThemeBean2, ClassLoader classLoader, Function1 function1, String string, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        return UIThemeKt.createTheme(uIThemeBean, uIThemeBean2, classLoader, (Function1<? super String, String>)function1, string, (Function2<? super String, ? super Throwable, Unit>)function2);
    }

    @NotNull
    public static final String toColorString(@NotNull String key, boolean darkTheme) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, String> newUiPalette = darkTheme ? colorPaletteNewDark : colorPaletteNewLight;
        String string = newUiPalette.get(key);
        if (string != null) {
            String it = string;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }
        if (darkTheme && (string = colorPaletteClassic.get(key + ".Dark")) != null) {
            String it = string;
            boolean bl = false;
            String string3 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            return string3;
        }
        String string4 = colorPaletteClassic.get(key);
        if (string4 == null) {
            string4 = key;
        }
        String string5 = string4.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        return string5;
    }

    private static final void addPattern(String key, Object value, UIDefaults defaults) {
        HashMap o = defaults.get("*");
        if (!(o instanceof Map)) {
            o = new HashMap();
            defaults.put("*", o);
        }
        Map map2 = TypeIntrinsics.asMutableMap((Object)o);
        if (key != null && StringsKt.startsWith$default((String)key, (String)"*.", (boolean)false, (int)2, null)) {
            String string = key.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            map2.put(string, value);
        }
    }

    private static final Function2<String, Throwable, Unit> createWarnFunction(ClassLoader classLoader) {
        return (arg_0, arg_1) -> UIThemeKt.createWarnFunction$lambda$0(classLoader, arg_0, arg_1);
    }

    private static final Unit createWarnFunction$lambda$0(ClassLoader $classLoader, String message, Throwable error2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PluginId pluginId = PluginUtil.getPluginId((ClassLoader)$classLoader);
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        PluginId id2 = pluginId;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(UITheme.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.warn((Throwable)new PluginException(message, error2, id2));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Function2 access$createWarnFunction(ClassLoader classLoader) {
        return UIThemeKt.createWarnFunction(classLoader);
    }

    public static final /* synthetic */ void access$addPattern(String key, Object value, UIDefaults defaults) {
        UIThemeKt.addPattern(key, value, defaults);
    }

    public static final /* synthetic */ UITheme access$createTheme(UIThemeBean theme, UIThemeBean parentTheme, ClassLoader classLoader, Function1 iconMapper, String themeId, Function2 warn) {
        return UIThemeKt.createTheme(theme, parentTheme, classLoader, (Function1<? super String, String>)iconMapper, themeId, (Function2<? super String, ? super Throwable, Unit>)warn);
    }

    public static final /* synthetic */ Map access$getColorPaletteClassic$p() {
        return colorPaletteClassic;
    }

    static {
        Map.Entry[] entryArray = new Map.Entry[]{Map.entry("Actions.Red", "#DB5860"), Map.entry("Actions.Red.Dark", "#C75450"), Map.entry("Actions.Yellow", "#EDA200"), Map.entry("Actions.Yellow.Dark", "#F0A732"), Map.entry("Actions.Green", "#59A869"), Map.entry("Actions.Green.Dark", "#499C54"), Map.entry("Actions.Blue", "#389FD6"), Map.entry("Actions.Blue.Dark", "#3592C4"), Map.entry("Actions.Grey", "#6E6E6E"), Map.entry("Actions.Grey.Dark", "#AFB1B3"), Map.entry("Actions.GreyInline", "#7F8B91"), Map.entry("Actions.GreyInline.Dark", "#7F8B91"), Map.entry("Objects.Grey", "#9AA7B0"), Map.entry("Objects.Blue", "#40B6E0"), Map.entry("Objects.Green", "#62B543"), Map.entry("Objects.Yellow", "#F4AF3D"), Map.entry("Objects.YellowDark", "#D9A343"), Map.entry("Objects.Purple", "#B99BF8"), Map.entry("Objects.Pink", "#F98B9E"), Map.entry("Objects.Red", "#F26522"), Map.entry("Objects.RedStatus", "#E05555"), Map.entry("Objects.GreenAndroid", "#3DDC84"), Map.entry("Objects.BlackText", "#231F20"), Map.entry("Checkbox.Background.Default", "#FFFFFF"), Map.entry("Checkbox.Background.Default.Dark", "#43494A"), Map.entry("Checkbox.Background.Disabled", "#F2F2F2"), Map.entry("Checkbox.Background.Disabled.Dark", "#3C3F41"), Map.entry("Checkbox.Border.Default", "#b0b0b0"), Map.entry("Checkbox.Border.Default.Dark", "#6B6B6B"), Map.entry("Checkbox.Border.Disabled", "#BDBDBD"), Map.entry("Checkbox.Border.Disabled.Dark", "#545556"), Map.entry("Checkbox.Focus.Thin.Default", "#7B9FC7"), Map.entry("Checkbox.Focus.Thin.Default.Dark", "#466D94"), Map.entry("Checkbox.Focus.Wide", "#97C3F3"), Map.entry("Checkbox.Focus.Wide.Dark", "#3D6185"), Map.entry("Checkbox.Foreground.Disabled", "#ABABAB"), Map.entry("Checkbox.Foreground.Disabled.Dark", "#606060"), Map.entry("Checkbox.Background.Selected", "#4F9EE3"), Map.entry("Checkbox.Background.Selected.Dark", "#43494A"), Map.entry("Checkbox.Border.Selected", "#4B97D9"), Map.entry("Checkbox.Border.Selected.Dark", "#6B6B6B"), Map.entry("Checkbox.Foreground.Selected", "#FEFEFE"), Map.entry("Checkbox.Foreground.Selected.Dark", "#A7A7A7"), Map.entry("Checkbox.Focus.Thin.Selected", "#ACCFF7"), Map.entry("Checkbox.Focus.Thin.Selected.Dark", "#466D94"), Map.entry("Tree.iconColor", "#808080"), Map.entry("Tree.iconColor.Dark", "#AFB1B3")};
        Map map2 = Map.ofEntries(entryArray);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"ofEntries(...)");
        colorPaletteClassic = map2;
        entryArray = new Map.Entry[]{Map.entry("Gray.Fill", "#EBECF0"), Map.entry("Gray.SecondaryStroke", "#A8ADBD"), Map.entry("Gray.Stroke", "#6C707E"), Map.entry("Blue.Fill", "#EDF3FF"), Map.entry("Blue.Solid", "#4682FA"), Map.entry("Blue.Stroke", "#3574F0"), Map.entry("Green.Fill", "#F2FCF3"), Map.entry("Green.Solid", "#55A76A"), Map.entry("Green.Stroke", "#208A3C"), Map.entry("Red.Fill", "#FFF7F7"), Map.entry("Red.Solid", "#E55765"), Map.entry("Red.Stroke", "#DB3B4B"), Map.entry("Yellow.Fill", "#FFFAEB"), Map.entry("Yellow.Solid", "#FFAF0F"), Map.entry("Yellow.Stroke", "#C27D04"), Map.entry("Orange.Fill", "#FFF4EB"), Map.entry("Orange.Stroke", "#E56D17"), Map.entry("Purple.Fill", "#FAF5FF"), Map.entry("Purple.Stroke", "#834DF0"), Map.entry("Teal.Fill", "#F2FCFC"), Map.entry("Teal.Stroke", "#039BA1")};
        Map map3 = Map.ofEntries(entryArray);
        Intrinsics.checkNotNullExpressionValue(map3, (String)"ofEntries(...)");
        colorPaletteNewLight = map3;
        entryArray = new Map.Entry[]{Map.entry("Gray.Fill", "#43454A"), Map.entry("Gray.SecondaryStroke", "#6F737A"), Map.entry("Gray.Stroke", "#CED0D6"), Map.entry("Blue.Fill", "#25324D"), Map.entry("Blue.Stroke", "#548AF7"), Map.entry("Green.Fill", "#253627"), Map.entry("Green.Stroke", "#57965C"), Map.entry("Red.Fill", "#402929"), Map.entry("Red.Stroke", "#DB5C5C"), Map.entry("Yellow.Fill", "#3D3223"), Map.entry("Yellow.Solid", "#F2C55C"), Map.entry("Yellow.Stroke", "#D6AE58"), Map.entry("Orange.Fill", "#45322B"), Map.entry("Orange.Stroke", "#C77D55"), Map.entry("Purple.Fill", "#2F2936"), Map.entry("Purple.Stroke", "#A571E6"), Map.entry("Teal.Fill", "#1D3838"), Map.entry("Teal.Stroke", "#24A394")};
        Map map4 = Map.ofEntries(entryArray);
        Intrinsics.checkNotNullExpressionValue(map4, (String)"ofEntries(...)");
        colorPaletteNewDark = map4;
    }
}

