/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.util.ui.JLabelUtil;
import com.intellij.util.ui.SwingTextTrimmer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import sun.swing.SwingUtilities2;

public class DarculaLabelUI
extends BasicLabelUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaLabelUI();
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        g.setColor(l.getForeground());
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, this.getMnemonicIndex(l), textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        g.setColor(UIManager.getColor("Label.disabledForeground"));
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, -1, textX, textY);
    }

    protected int getMnemonicIndex(JLabel l) {
        return !SystemInfo.isMac ? l.getDisplayedMnemonicIndex() : -1;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        boolean canBeTrimmed;
        boolean bl = canBeTrimmed = c.getClientProperty("html") == null && ClientProperty.get((Component)c, (Key)JLabelUtil.TRIM_OVERFLOW_KEY) != null;
        if (!canBeTrimmed) {
            return super.getMinimumSize(c);
        }
        JLabel label2 = (JLabel)c;
        String text2 = label2.getText();
        Icon icon2 = label2.isEnabled() ? label2.getIcon() : label2.getDisabledIcon();
        Insets insets = label2.getInsets(null);
        Font font = label2.getFont();
        int xInsets = insets.left + insets.right;
        int yInsets = insets.top + insets.bottom;
        if (icon2 == null && (text2 == null || font == null)) {
            return new Dimension(xInsets, yInsets);
        }
        if (icon2 != null && (text2 == null || font == null)) {
            return new Dimension(icon2.getIconWidth() + xInsets, icon2.getIconHeight() + yInsets);
        }
        Rectangle allocation = new Rectangle();
        FontMetrics fm = label2.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        allocation.x = insets.left;
        allocation.y = insets.top;
        allocation.width = insets.right;
        allocation.height = insets.bottom;
        this.layoutCL(label2, fm, text2, icon2, allocation, iconR, textR);
        int x1 = Math.min(iconR.x, textR.x);
        int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
        int y1 = Math.min(iconR.y, textR.y);
        int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
        Dimension rv = new Dimension(x2 - x1, y2 - y1);
        rv.width += xInsets;
        rv.height += yInsets;
        return rv;
    }

    @Override
    protected String layoutCL(JLabel label2, FontMetrics fontMetrics, String text2, Icon icon2, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        String result2 = super.layoutCL(label2, fontMetrics, text2, icon2, viewR, iconR, textR);
        SwingTextTrimmer trimmer = (SwingTextTrimmer)ClientProperty.get((Component)label2, SwingTextTrimmer.KEY);
        if (!StringUtil.isEmpty((String)result2)) {
            if (trimmer != null && null == label2.getClientProperty("html") && !result2.equals(text2) && result2.endsWith("...")) {
                result2 = trimmer.trim(text2, fontMetrics, textR.width);
            }
        } else if (trimmer != null) {
            trimmer.setTrimmed(false);
        }
        return result2;
    }
}

