/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaNewUIUtil;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\rH\u0002J@\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\b\u001a\u00020\u0016H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/DarculaScrollPaneBorder;", "Ljavax/swing/border/Border;", "Ljavax/swing/plaf/UIResource;", "Lcom/intellij/openapi/ui/ErrorBorderCapable;", "<init>", "()V", "paintBorder", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "width", "height", "getBorderInsets", "Ljava/awt/Insets;", "isBorderOpaque", "", "getVisualPadding", "Ljavax/swing/JScrollPane;", "getUnscaledBorderLineWidth", "paintTextAreaBorder", "textArea", "Ljavax/swing/JTextArea;", "Ljava/awt/Graphics2D;", "getBackground", "Ljava/awt/Color;", "getTextArea", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class DarculaScrollPaneBorder
implements Border,
UIResource,
ErrorBorderCapable {
    @Override
    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!(c instanceof JScrollPane) || !(g instanceof Graphics2D)) {
            return;
        }
        JTextArea textArea = this.getTextArea(c);
        if (textArea == null) {
            ((Graphics2D)g).setColor(JBColor.border());
            g.drawRect(x, y, width - 1, height - 1);
        } else {
            this.paintTextAreaBorder((JScrollPane)c, textArea, (Graphics2D)g, x, y, width, height);
        }
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@NotNull Component c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        int inset = (c instanceof JScrollPane ? this.getVisualPadding((JScrollPane)c) : 0) + this.getUnscaledBorderLineWidth();
        return (Insets)new JBInsets(inset);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public final int getVisualPadding(@NotNull JScrollPane c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return this.getTextArea(c) == null ? 0 : 2;
    }

    private final int getUnscaledBorderLineWidth() {
        return (int)DarculaUIUtil.LW.getUnscaled();
    }

    private final void paintTextAreaBorder(JScrollPane c, JTextArea textArea, Graphics2D g, int x, int y, int width, int height) {
        Rectangle r = new Rectangle(x, y, width, height);
        JBInsets.removeFrom((Rectangle)r, (Insets)this.getBorderInsets(c));
        JBInsets.addTo((Rectangle)r, (Insets)((Insets)JBUI.insets((int)this.getUnscaledBorderLineWidth())));
        float arc = DarculaUIUtil.COMPONENT_ARC.getFloat();
        Area shape = new Area(new Rectangle(x, y, width, height));
        shape.subtract(new Area(new RoundRectangle2D.Float((float)r.x + 0.5f, (float)r.y + 0.5f, (float)r.width - 1.0f, (float)r.height - 1.0f, arc, arc)));
        g.setColor(this.getBackground(c));
        g.fill(shape);
        DarculaUIUtil.Outline outline = DarculaUIUtil.getOutline(textArea);
        DarculaNewUIUtil.paintComponentBorder$default(DarculaNewUIUtil.INSTANCE, g, r, outline, textArea.hasFocus(), textArea.isEnabled(), 0, 0.0f, 96, null);
    }

    private final Color getBackground(JScrollPane c) {
        if (c.isOpaque()) {
            return UIManager.getColor("Panel.background");
        }
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isOpaque()) continue;
            return parent.getBackground();
        }
        return null;
    }

    private final JTextArea getTextArea(Component c) {
        if (!(c instanceof JBScrollPane)) {
            return null;
        }
        Component component2 = ((JBScrollPane)c).getViewport().getView();
        return component2 instanceof JTextArea ? (JTextArea)component2 : null;
    }
}

