/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseElementsDialog<T>
extends DialogWrapper {
    protected ElementsChooser<T> myChooser;
    private final @NlsContexts.Label String myDescription;

    public ChooseElementsDialog(Project project2, List<? extends T> items2, @NlsContexts.DialogTitle String title2, @NlsContexts.Label String description) {
        this(project2, items2, title2, description, false);
    }

    public ChooseElementsDialog(Project project2, List<? extends T> items2, @NlsContexts.DialogTitle String title2, @NlsContexts.Label String description, boolean sort) {
        super(project2, true);
        this.myDescription = description;
        this.initializeDialog(items2, title2, sort);
    }

    public ChooseElementsDialog(Component parent, List<? extends T> items2, @NlsContexts.DialogTitle String title2) {
        this(parent, items2, title2, null, false);
    }

    public ChooseElementsDialog(Component parent, List<? extends T> items2, @NlsContexts.DialogTitle String title2, @NlsContexts.Label @Nullable String description, boolean sort) {
        super(parent, true);
        this.myDescription = description;
        this.initializeDialog(items2, title2, sort);
    }

    @Nullable
    public Dimension getInitialSize() {
        return JBUI.DialogSizes.medium();
    }

    protected boolean canElementsBeMarked() {
        return false;
    }

    private void initializeDialog(List<? extends T> items2, @NlsContexts.DialogTitle String title2, boolean sort) {
        this.setTitle(title2);
        this.myChooser = new ElementsChooser<T>(this.canElementsBeMarked()){

            @Override
            protected String getItemText(@NotNull T item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ChooseElementsDialog.this.getItemText(item);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/util/ChooseElementsDialog$1", "getItemText"));
            }
        };
        this.myChooser.setColorUnmarkedElements(false);
        ArrayList<T> elements = new ArrayList<T>(items2);
        if (sort) {
            elements.sort((o1, o2) -> this.getItemText(o1).compareToIgnoreCase(this.getItemText(o2)));
        }
        this.setElements(elements, ContainerUtil.getFirstItems(elements, (int)1));
        this.myChooser.getComponent().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseElementsDialog.this.doOKAction();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ChooseElementsDialog.this.doOKAction();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/ChooseElementsDialog$3", "onDoubleClick"));
            }
        }.installOn((Component)this.myChooser.getComponent());
        this.init();
    }

    @NotNull
    public List<T> showAndGetResult() {
        this.show();
        List<T> list2 = this.getChosenElements();
        if (list2 == null) {
            ChooseElementsDialog.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NlsContexts.ListItem
    protected abstract String getItemText(T var1);

    @Nullable
    protected abstract Icon getItemIcon(T var1);

    @Nullable
    protected Color getItemBackgroundColor(T item) {
        return null;
    }

    @Nls
    protected String getItemLocation(T item) {
        return null;
    }

    @NotNull
    public List<T> getChosenElements() {
        List list2 = this.isOK() ? this.myChooser.getSelectedElements() : Collections.emptyList();
        if (list2 == null) {
            ChooseElementsDialog.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void selectElements(@NotNull List<? extends T> elements) {
        if (elements == null) {
            ChooseElementsDialog.$$$reportNull$$$0(2);
        }
        this.myChooser.selectElements(elements);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChooser.getComponent();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myChooser.getComponent()), "Center");
        if (this.myDescription != null) {
            panel2.add((Component)new JLabel(this.myDescription), "North");
        }
        return panel2;
    }

    private void setElements(Collection<? extends T> elements, Collection<? extends T> elementsToSelect) {
        this.myChooser.clear();
        for (T item : elements) {
            this.myChooser.addElement(item, this.isElementMarkedByDefault(item), this.createElementProperties(item));
        }
        this.myChooser.selectElements(elementsToSelect);
    }

    protected boolean isElementMarkedByDefault(T element) {
        return false;
    }

    public List<T> getMarkedElements() {
        return this.myChooser.getMarkedElements();
    }

    private MultiStateElementsChooser.ElementProperties createElementProperties(final T item) {
        return new MultiStateElementsChooser.ElementProperties(){

            @Override
            @Nullable
            public Icon getIcon() {
                return ChooseElementsDialog.this.getItemIcon(item);
            }

            @Override
            @Nullable
            @Nls
            public String getLocation() {
                return ChooseElementsDialog.this.getItemLocation(item);
            }

            @Override
            @Nullable
            public Color getBackgroundColor() {
                return ChooseElementsDialog.this.getItemBackgroundColor(item);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/ChooseElementsDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "showAndGetResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChosenElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/ChooseElementsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

