/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableCell;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiStateElementsChooser<T, S>
extends JPanel
implements ComponentWithEmptyText,
ComponentWithExpandableItems<TableCell> {
    private final MarkStateDescriptor<T, S> myMarkStateDescriptor;
    private final JBTable myTable;
    private final MyTableModel myTableModel;
    private boolean myColorUnmarkedElements = true;
    private final List<ElementsMarkStateListener<T, S>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<T, ElementProperties> myElementToPropertiesMap = new HashMap<T, ElementProperties>();
    private final Map<T, Boolean> myDisabledMap = new HashMap<T, Boolean>();
    private int[] mySavedSelection = null;

    public MultiStateElementsChooser(boolean elementsCanBeMarked, MarkStateDescriptor<T, S> markStateDescriptor) {
        this(null, null, elementsCanBeMarked, markStateDescriptor);
    }

    public MultiStateElementsChooser(List<T> elements, S markState, MarkStateDescriptor<T, S> markStateDescriptor) {
        this(elements, markState, true, markStateDescriptor);
    }

    private MultiStateElementsChooser(@Nullable List<T> elements, S markState, boolean elementsCanBeMarked, MarkStateDescriptor<T, S> markStateDescriptor) {
        super(new BorderLayout());
        this.myMarkStateDescriptor = markStateDescriptor;
        this.myTableModel = new MyTableModel(elementsCanBeMarked);
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myTable.setTableHeader(null);
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.resetDefaultFocusTraversalKeys();
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        pane2.setPreferredSize((Dimension)JBUI.size((int)100, (int)155));
        TableColumnModel columnModel = this.myTable.getColumnModel();
        if (elementsCanBeMarked) {
            TableColumn checkMarkColumn = columnModel.getColumn(this.myTableModel.CHECK_MARK_COLUM_INDEX);
            TableUtil.setupCheckboxColumn((TableColumn)checkMarkColumn, (int)0);
            TableCellRenderer checkMarkRenderer = this.myMarkStateDescriptor.getMarkRenderer();
            if (checkMarkRenderer == null) {
                checkMarkRenderer = new CheckMarkColumnCellRenderer(this.myTable.getDefaultRenderer(Boolean.class));
            }
            checkMarkColumn.setCellRenderer(checkMarkRenderer);
        }
        columnModel.getColumn(this.myTableModel.ELEMENT_COLUMN_INDEX).setCellRenderer((TableCellRenderer)((Object)new MyElementColumnCellRenderer()));
        this.add((Component)pane2, "Center");
        TableSpeedSearch speedSearch2 = TableSpeedSearch.installOn((JTable)this.myTable);
        speedSearch2.setFilteringMode(true);
        this.myTable.setRowSorter(new TableRowSorter<TableModel>(this.myTable.getModel()));
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] viewRows = MultiStateElementsChooser.this.myTable.getSelectedRows();
                int[] modelRows = new int[viewRows.length];
                LinkedHashMap selectedElements = new LinkedHashMap(viewRows.length);
                for (int i2 = 0; i2 < viewRows.length; ++i2) {
                    int viewRow = viewRows[i2];
                    int modelRow = MultiStateElementsChooser.this.myTable.convertRowIndexToModel(viewRow);
                    Object element = MultiStateElementsChooser.this.myTableModel.getElementAt(modelRow);
                    selectedElements.put(element, MultiStateElementsChooser.this.myTableModel.getElementMarkState(element));
                    modelRows[i2] = modelRow;
                }
                Object nextState = MultiStateElementsChooser.this.myMarkStateDescriptor.getNextState(selectedElements);
                if (nextState != null) {
                    MultiStateElementsChooser.this.myTableModel.setMarkState(modelRows, nextState);
                }
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.setElements(elements, markState);
        MultiStateElementsChooser.installActions((JTable)this.myTable);
    }

    private static void installActions(JTable table2) {
        InputMap inputMap = table2.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "selectLastRow");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "selectFirstRow");
        inputMap.put(KeyStroke.getKeyStroke(36, 64), "selectFirstRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(35, 64), "selectLastRowExtendSelection");
    }

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTable.getEmptyText();
        if (statusText == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(0);
        }
        return statusText;
    }

    @NotNull
    public ExpandableItemsHandler<TableCell> getExpandableItemsHandler() {
        ExpandableItemsHandler expandableItemsHandler = this.myTable.getExpandableItemsHandler();
        if (expandableItemsHandler == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(1);
        }
        return expandableItemsHandler;
    }

    public void setExpandableItemsEnabled(boolean enabled2) {
        this.myTable.setExpandableItemsEnabled(enabled2);
    }

    public void setSingleSelectionMode() {
        int selectedRow = this.myTable.getSelectedRow();
        this.myTable.setSelectionMode(0);
        if (selectedRow != -1) {
            this.myTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
    }

    public void refresh() {
        this.myTableModel.fireTableDataChanged();
    }

    public void refresh(T element) {
        int row2 = this.myTableModel.getElementRow(element);
        if (row2 >= 0) {
            this.myTableModel.fireTableRowsUpdated(row2, row2);
        }
    }

    public void saveSelection() {
        this.mySavedSelection = this.myTable.getSelectedRows();
    }

    public void restoreSelection() {
        if (this.mySavedSelection != null) {
            TableUtil.selectRows((JTable)this.myTable, (int[])this.mySavedSelection);
            this.mySavedSelection = null;
        }
    }

    public void setColorUnmarkedElements(boolean colorUnmarkedElements) {
        this.myColorUnmarkedElements = colorUnmarkedElements;
    }

    public void addElementsMarkListener(ElementsMarkStateListener<T, S> listener2) {
        this.myListeners.add(listener2);
    }

    public void removeElementsMarkListener(ElementsMarkStateListener<T, S> listener2) {
        this.myListeners.remove(listener2);
    }

    public void addListSelectionListener(ListSelectionListener listener2) {
        this.myTable.getSelectionModel().addListSelectionListener(listener2);
    }

    public void removeListSelectionListener(ListSelectionListener listener2) {
        this.myTable.getSelectionModel().removeListSelectionListener(listener2);
    }

    public void addElement(T element, S markState) {
        this.addElement(element, markState, element instanceof ElementProperties ? (ElementProperties)element : null);
    }

    public S getElementMarkState(T element) {
        return this.myTableModel.getElementMarkState(element);
    }

    public void setElementMarkState(T element, S markState) {
        int elementRow = this.myTableModel.getElementRow(element);
        this.myTableModel.setMarkState(elementRow, markState);
    }

    public void removeElement(T element) {
        int modelRow = this.myTableModel.getElementRow(element);
        if (modelRow < 0) {
            return;
        }
        int viewRow = this.myTable.convertRowIndexToView(modelRow);
        boolean wasSelected = this.myTable.getSelectionModel().isSelectedIndex(viewRow);
        this.myTableModel.removeElement(element);
        this.myElementToPropertiesMap.remove(element);
        if (wasSelected) {
            int rowCount = this.myTableModel.getRowCount();
            if (rowCount > 0) {
                this.selectRow(viewRow % rowCount);
            } else {
                this.myTable.getSelectionModel().clearSelection();
            }
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
    }

    public void removeAllElements() {
        this.myTableModel.removeAllElements();
        this.myTable.getSelectionModel().clearSelection();
    }

    private void selectRow(int row2) {
        this.myTable.getSelectionModel().setSelectionInterval(row2, row2);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(row2, 0, true));
    }

    public void moveElement(T element, int newRow) {
        int modelRow = this.myTableModel.getElementRow(element);
        if (modelRow < 0 || modelRow == newRow || newRow < 0 || newRow >= this.myTableModel.getRowCount()) {
            return;
        }
        int viewRow = this.myTable.convertRowIndexToView(modelRow);
        boolean wasSelected = this.myTable.getSelectionModel().isSelectedIndex(viewRow);
        this.myTableModel.changeElementRow(element, newRow);
        if (wasSelected) {
            this.selectRow(newRow);
        }
    }

    public void addElement(T element, S markState, ElementProperties elementProperties) {
        this.myTableModel.addElement(element, markState);
        this.myElementToPropertiesMap.put(element, elementProperties);
        this.selectRow(this.myTableModel.getRowCount() - 1);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
    }

    public void setElementProperties(T element, ElementProperties properties) {
        this.myElementToPropertiesMap.put(element, properties);
    }

    public void setElements(List<? extends T> elements, S markState) {
        this.myTableModel.clear();
        this.myTableModel.addElements(elements, markState);
    }

    @Nullable
    public T getSelectedElement() {
        int viewRow = this.getSelectedElementRow();
        int modelRow = viewRow < 0 ? -1 : this.myTable.convertRowIndexToModel(viewRow);
        return modelRow < 0 ? null : (T)this.myTableModel.getElementAt(modelRow);
    }

    public int getSelectedElementRow() {
        return this.myTable.getSelectedRow();
    }

    @NotNull
    public List<T> getSelectedElements() {
        int[] viewRows;
        ArrayList elements = new ArrayList();
        for (int viewRow : viewRows = this.myTable.getSelectedRows()) {
            if (viewRow < 0) continue;
            int modelRow = this.myTable.convertRowIndexToModel(viewRow);
            elements.add(this.myTableModel.getElementAt(modelRow));
        }
        ArrayList arrayList = elements;
        if (arrayList == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public void selectElements(Collection<? extends T> elements) {
        if (elements.isEmpty()) {
            this.myTable.clearSelection();
            return;
        }
        int[] rows = new int[elements.size()];
        int index = 0;
        for (T element : elements) {
            rows[index++] = this.myTable.convertRowIndexToView(this.myTableModel.getElementRow(element));
        }
        TableUtil.selectRows((JTable)this.myTable, (int[])rows);
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
    }

    public void markElements(Collection<? extends T> elements, S markState) {
        int[] rows = new int[elements.size()];
        int index = 0;
        for (T element : elements) {
            rows[index++] = this.myTableModel.getElementRow(element);
        }
        this.myTableModel.setMarkState(rows, markState);
    }

    @NotNull
    public Map<T, S> getElementMarkStates() {
        int count = this.myTableModel.getRowCount();
        LinkedHashMap elements = new LinkedHashMap();
        for (int idx = 0; idx < count; ++idx) {
            Object element = this.myTableModel.getElementAt(idx);
            elements.put(element, this.myTableModel.getElementMarkState(idx));
        }
        LinkedHashMap linkedHashMap = elements;
        if (linkedHashMap == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    public void sort(Comparator<? super T> comparator) {
        this.myTableModel.sort(comparator);
    }

    @Override
    public void setEnabled(boolean enabled2) {
        super.setEnabled(enabled2);
        this.myTable.setRowSelectionAllowed(enabled2);
        this.myTableModel.fireTableDataChanged();
    }

    public void stopEditing() {
        TableCellEditor editor2 = this.myTable.getCellEditor();
        if (editor2 != null) {
            editor2.stopCellEditing();
        }
    }

    public JComponent getComponent() {
        return this.myTable;
    }

    public void setAllElementsMarked(S markState) {
        int[] rows = new int[this.myTableModel.getRowCount()];
        for (int idx = 0; idx < rows.length; ++idx) {
            rows[idx] = idx;
        }
        this.myTableModel.setMarkState(rows, markState);
    }

    private void notifyElementMarked(T element, S markState) {
        for (ElementsMarkStateListener<T, S> listener2 : this.myListeners) {
            listener2.elementMarkChanged(element, markState);
        }
    }

    public void clear() {
        this.myTableModel.clear();
        this.myElementToPropertiesMap.clear();
    }

    public int getElementCount() {
        return this.myTableModel.getRowCount();
    }

    public T getElementAt(int row2) {
        return this.myTableModel.getElementAt(row2);
    }

    public void disableElement(T element) {
        this.myDisabledMap.put(element, Boolean.TRUE);
    }

    @NlsContexts.ListItem
    protected String getItemText(@NotNull T value) {
        if (value == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(4);
        }
        @NlsSafe String text2 = value.toString();
        return text2;
    }

    @Nullable
    protected Icon getItemIcon(@NotNull T value) {
        if (value == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/MultiStateElementsChooser";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandableItemsHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementMarkStates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/MultiStateElementsChooser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItemText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }

    public static interface MarkStateDescriptor<T, S> {
        @NotNull
        public S getDefaultState(@NotNull T var1);

        @NotNull
        public S getNextState(@NotNull T var1, @NotNull S var2);

        @Nullable
        public S getNextState(@NotNull Map<T, S> var1);

        public boolean isMarked(@NotNull S var1);

        @Nullable
        public S getMarkState(@Nullable Object var1);

        @Nullable
        public TableCellRenderer getMarkRenderer();
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private final List<T> myElements = new ArrayList();
        private final Map<T, S> myMarkedMap = new HashMap();
        public final int CHECK_MARK_COLUM_INDEX;
        public final int ELEMENT_COLUMN_INDEX;
        private final boolean myElementsCanBeMarked;

        MyTableModel(boolean elementsCanBeMarked) {
            this.myElementsCanBeMarked = elementsCanBeMarked;
            if (elementsCanBeMarked) {
                this.CHECK_MARK_COLUM_INDEX = 0;
                this.ELEMENT_COLUMN_INDEX = 1;
            } else {
                this.CHECK_MARK_COLUM_INDEX = -1;
                this.ELEMENT_COLUMN_INDEX = 0;
            }
        }

        public void sort(Comparator<? super T> comparator) {
            this.myElements.sort(comparator);
            this.fireTableDataChanged();
        }

        public T getElementAt(int index) {
            return this.myElements.get(index);
        }

        public S getElementMarkState(int index) {
            Object element = this.myElements.get(index);
            return this.getElementMarkState(element);
        }

        public S getElementMarkState(T element) {
            return this.myMarkedMap.get(element);
        }

        private void addElement(T element, S markState) {
            this.myElements.add(element);
            this.myMarkedMap.put(element, this.notNullMarkState(element, markState));
            int row2 = this.myElements.size() - 1;
            this.fireTableRowsInserted(row2, row2);
        }

        private void addElements(@Nullable List<? extends T> elements, S markState) {
            if (elements == null || elements.isEmpty()) {
                return;
            }
            for (Object element : elements) {
                this.myElements.add(element);
                this.myMarkedMap.put(element, this.notNullMarkState(element, markState));
            }
            this.fireTableRowsInserted(this.myElements.size() - elements.size(), this.myElements.size() - 1);
        }

        public void removeElement(T element) {
            boolean reallyRemoved = this.myElements.remove(element);
            if (reallyRemoved) {
                this.myMarkedMap.remove(element);
                this.fireTableDataChanged();
            }
        }

        public void changeElementRow(T element, int row2) {
            boolean reallyRemoved = this.myElements.remove(element);
            if (reallyRemoved) {
                this.myElements.add(row2, element);
                this.fireTableDataChanged();
            }
        }

        public int getElementRow(T element) {
            return this.myElements.indexOf(element);
        }

        public void removeAllElements() {
            this.myElements.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.myElements.size();
        }

        @Override
        public int getColumnCount() {
            return this.myElementsCanBeMarked ? 2 : 1;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object element = this.myElements.get(rowIndex);
            if (columnIndex == this.ELEMENT_COLUMN_INDEX) {
                return element;
            }
            if (columnIndex == this.CHECK_MARK_COLUM_INDEX) {
                return this.getElementMarkState(element);
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == this.CHECK_MARK_COLUM_INDEX) {
                Object nextState = MultiStateElementsChooser.this.myMarkStateDescriptor.getMarkState(aValue);
                if (nextState == null) {
                    Object element = MultiStateElementsChooser.this.myTableModel.getElementAt(rowIndex);
                    Object currentState = MultiStateElementsChooser.this.myTableModel.getElementMarkState((Object)rowIndex);
                    nextState = MultiStateElementsChooser.this.myMarkStateDescriptor.getNextState(element, currentState);
                }
                this.setMarkState(rowIndex, nextState);
            }
        }

        private void setMarkState(int rowIndex, S markState) {
            Object element = this.myElements.get(rowIndex);
            Object newValue = this.notNullMarkState(element, markState);
            Object prevValue = this.myMarkedMap.put(element, newValue);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
            if (!newValue.equals(prevValue)) {
                MultiStateElementsChooser.this.notifyElementMarked(element, newValue);
            }
        }

        private void setMarkState(int[] rows, S markState) {
            if (rows == null || rows.length == 0) {
                return;
            }
            int firstRow = Integer.MAX_VALUE;
            int lastRow = Integer.MIN_VALUE;
            for (int row2 : rows) {
                Object prevValue;
                Object element = this.myElements.get(row2);
                Object newValue = this.notNullMarkState(element, markState);
                if (!newValue.equals(prevValue = this.myMarkedMap.put(element, newValue))) {
                    MultiStateElementsChooser.this.notifyElementMarked(element, newValue);
                }
                firstRow = Math.min(firstRow, row2);
                lastRow = Math.max(lastRow, row2);
            }
            this.fireTableRowsUpdated(firstRow, lastRow);
        }

        @NotNull
        private S notNullMarkState(T element, S markState) {
            Object s = markState != null ? markState : MultiStateElementsChooser.this.myMarkStateDescriptor.getDefaultState(element);
            if (s == null) {
                MyTableModel.$$$reportNull$$$0(0);
            }
            return s;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == this.CHECK_MARK_COLUM_INDEX) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!MultiStateElementsChooser.this.isEnabled() || columnIndex != this.CHECK_MARK_COLUM_INDEX) {
                return false;
            }
            Object o = this.getValueAt(rowIndex, this.ELEMENT_COLUMN_INDEX);
            return MultiStateElementsChooser.this.myDisabledMap.get(o) == null;
        }

        public void clear() {
            this.myElements.clear();
            this.myMarkedMap.clear();
            this.fireTableDataChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/MultiStateElementsChooser$MyTableModel", "notNullMarkState"));
        }
    }

    private final class CheckMarkColumnCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer myDelegate;

        CheckMarkColumnCellRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
            Component component2 = this.myDelegate.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row2, column);
            component2.setEnabled(MultiStateElementsChooser.this.isEnabled());
            if (component2 instanceof JComponent) {
                ((JComponent)component2).setBorder(null);
            }
            return component2;
        }
    }

    private final class MyElementColumnCellRenderer
    extends ColoredTableCellRenderer {
        private MyElementColumnCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value, boolean selected, boolean hasFocus, int row2, int column) {
            Icon icon2;
            String location;
            Object item;
            if (table2 == null) {
                MyElementColumnCellRenderer.$$$reportNull$$$0(0);
            }
            String text2 = (item = value) == null ? "" : MultiStateElementsChooser.this.getItemText(item);
            SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)table2, (String)text2, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)selected, (SimpleColoredComponent)this);
            ElementProperties properties = MultiStateElementsChooser.this.myElementToPropertiesMap.get(item);
            if (properties != null && StringUtil.isNotEmpty((String)(location = properties.getLocation()))) {
                this.append(" (" + location + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            this.setTransparentIconBackground(true);
            Icon icon3 = properties != null ? properties.getIcon() : (icon2 = item != null ? MultiStateElementsChooser.this.getItemIcon(item) : null);
            if (icon2 != null) {
                this.setIcon(icon2);
            }
            this.setForeground(properties != null && properties.getColor() != null ? properties.getColor() : (selected ? table2.getSelectionForeground() : table2.getForeground()));
            this.setBackground(selected ? table2.getSelectionBackground() : (properties != null && properties.getBackgroundColor() != null ? properties.getBackgroundColor() : table2.getBackground()));
            MyTableModel model2 = (MyTableModel)table2.getModel();
            this.setEnabled(selected || MultiStateElementsChooser.this.isEnabled() && (!MultiStateElementsChooser.this.myColorUnmarkedElements || MultiStateElementsChooser.this.myMarkStateDescriptor.isMarked(model2.getElementMarkState(item))));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/ide/util/MultiStateElementsChooser$MyElementColumnCellRenderer", "customizeCellRenderer"));
        }
    }

    public static interface ElementProperties {
        @Nullable
        default public Icon getIcon() {
            return null;
        }

        @Nullable
        default public Color getColor() {
            return null;
        }

        @Nullable
        default public Color getBackgroundColor() {
            return null;
        }

        @Nullable
        @Nls
        default public String getLocation() {
            return null;
        }
    }

    public static interface ElementsMarkStateListener<T, S> {
        public void elementMarkChanged(T var1, S var2);
    }
}

