/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageCounterCollector;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

class FileTypeUsageActionListener
implements AnActionListener {
    private static final Key<Long> LAST_EDIT_USAGE = Key.create((String)"LAST_EDIT_USAGE");

    FileTypeUsageActionListener() {
    }

    public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        if (action2 == null) {
            FileTypeUsageActionListener.$$$reportNull$$$0(0);
        }
        if (event == null) {
            FileTypeUsageActionListener.$$$reportNull$$$0(1);
        }
        if (action2 instanceof EditorAction && ((EditorAction)action2).getHandlerOfType(EditorWriteActionHandler.class) != null) {
            FileTypeUsageActionListener.onChange(event.getDataContext());
        }
    }

    private static void onChange(DataContext dataContext2) {
        Long lastEdit;
        Editor editor2 = (Editor)CommonDataKeys.HOST_EDITOR.getData(dataContext2);
        if (editor2 == null) {
            return;
        }
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        if (file2 != null && ((lastEdit = (Long)editor2.getUserData(LAST_EDIT_USAGE)) == null || System.currentTimeMillis() - lastEdit > 60000L)) {
            editor2.putUserData(LAST_EDIT_USAGE, (Object)System.currentTimeMillis());
            FileTypeUsageCounterCollector.triggerEdit(project2, file2);
        }
    }

    public void beforeEditorTyping(char c, @NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            FileTypeUsageActionListener.$$$reportNull$$$0(2);
        }
        FileTypeUsageActionListener.onChange(dataContext2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageActionListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeActionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeEditorTyping";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

