/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00032\b\b\u0001\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J2\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00032\b\b\u0001\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0006\u0010\u0015\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/notification/SingletonNotificationManager;", "", "groupId", "", "type", "Lcom/intellij/notification/NotificationType;", "<init>", "(Ljava/lang/String;Lcom/intellij/notification/NotificationType;)V", "notification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/notification/Notification;", "notify", "", "title", "content", "project", "Lcom/intellij/openapi/project/Project;", "customizer", "Ljava/util/function/Consumer;", "isVisible", "", "clear", "intellij.platform.ide.impl"})
public final class SingletonNotificationManager {
    @NotNull
    private final String groupId;
    @NotNull
    private final NotificationType type;
    @NotNull
    private final AtomicReference<Notification> notification;

    public SingletonNotificationManager(@NotNull String groupId, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.groupId = groupId;
        this.type = type;
        this.notification = new AtomicReference();
    }

    public final void notify(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String content2, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.notify(title2, content2, project2, SingletonNotificationManager::notify$lambda$0);
    }

    public final void notify(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String content2, @Nullable Project project2, @NotNull Consumer<Notification> customizer) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter(customizer, (String)"customizer");
        Notification oldNotification = this.notification.get();
        if (oldNotification != null) {
            if (this.isVisible(oldNotification, project2)) {
                return;
            }
            oldNotification.expire();
        }
        String string = this.groupId;
        NotificationType notificationType = this.type;
        var newNotification2 = new Notification(title2, content2, this, string, notificationType){
            final /* synthetic */ SingletonNotificationManager this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $title, $content, $super_call_param$2);
            }

            public void expire() {
                super.expire();
                SingletonNotificationManager.access$getNotification$p(this.this$0).compareAndSet(this, null);
            }
        };
        customizer.accept(newNotification2);
        if (this.notification.compareAndSet(oldNotification, newNotification2)) {
            newNotification2.notify(project2);
        } else {
            newNotification2.expire();
        }
    }

    private final boolean isVisible(Notification notification2, Project project2) {
        Balloon balloon;
        NotificationGroup group2 = NotificationGroupManager.getInstance().getNotificationGroup(this.groupId);
        if (group2.getDisplayType() != NotificationDisplayType.TOOL_WINDOW) {
            balloon = notification2.getBalloon();
        } else {
            Project project3 = project2;
            if (project3 != null) {
                ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project3);
                String string = group2.getToolWindowId();
                Intrinsics.checkNotNull((Object)string);
                balloon = toolWindowManager.getToolWindowBalloon(string);
            } else {
                balloon = null;
            }
        }
        Balloon balloon2 = balloon;
        return balloon2 != null && !balloon2.isDisposed();
    }

    public final void clear() {
        block0: {
            Notification notification2 = this.notification.getAndSet(null);
            if (notification2 == null) break block0;
            notification2.expire();
        }
    }

    private static final void notify$lambda$0(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    public static final /* synthetic */ AtomicReference access$getNotification$p(SingletonNotificationManager $this) {
        return $this.notification;
    }
}

