/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0016J\u0006\u0010\u001a\u001a\u00020\u0016J\n\u0010\u001d\u001a\u00020\u000fH\u0096\u0080\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R\u0011\u0010\u001b\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011R$\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u000b\"\u0004\b \u0010\rR$\u0010\"\u001a\u00020\n2\u0006\u0010!\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u000b\"\u0004\b#\u0010\rR$\u0010%\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u000b\"\u0004\b&\u0010\rR$\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lcom/intellij/notification/impl/ui/NotificationSettingsWrapper;", "", "version", "Lcom/intellij/notification/impl/NotificationSettings;", "<init>", "(Lcom/intellij/notification/impl/NotificationSettings;)V", "getVersion", "()Lcom/intellij/notification/impl/NotificationSettings;", "setVersion", "isRemoved", "", "()Z", "setRemoved", "(Z)V", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "hasChanged", "remove", "", "originalSettings", "getOriginalSettings", "apply", "reset", "groupId", "getGroupId", "toString", "shouldLog", "isShouldLog", "setShouldLog", "readAloud", "isShouldReadAloud", "setShouldReadAloud", "playSound", "isPlaySound", "setPlaySound", "type", "Lcom/intellij/notification/NotificationDisplayType;", "displayType", "getDisplayType", "()Lcom/intellij/notification/NotificationDisplayType;", "setDisplayType", "(Lcom/intellij/notification/NotificationDisplayType;)V", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class NotificationSettingsWrapper {
    @NotNull
    private NotificationSettings version;
    private boolean isRemoved;
    @Nullable
    private String title;

    public NotificationSettingsWrapper(@NotNull NotificationSettings version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.version = version;
    }

    @NotNull
    public final NotificationSettings getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull NotificationSettings notificationSettings) {
        Intrinsics.checkNotNullParameter((Object)notificationSettings, (String)"<set-?>");
        this.version = notificationSettings;
    }

    public final boolean isRemoved() {
        return this.isRemoved;
    }

    public final void setRemoved(boolean bl) {
        this.isRemoved = bl;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    public final boolean hasChanged() {
        return this.isRemoved || !Intrinsics.areEqual((Object)this.getOriginalSettings(), (Object)this.version);
    }

    public final void remove() {
        this.isRemoved = true;
    }

    @NotNull
    public final NotificationSettings getOriginalSettings() {
        NotificationSettings notificationSettings = NotificationsConfigurationImpl.getSettings(this.getGroupId());
        Intrinsics.checkNotNullExpressionValue((Object)notificationSettings, (String)"getSettings(...)");
        return notificationSettings;
    }

    public final void apply() {
        if (this.isRemoved) {
            String[] stringArray = new String[]{this.getGroupId()};
            NotificationsConfigurationImpl.remove(stringArray);
        } else {
            NotificationsConfigurationImpl.getInstanceImpl().changeSettings(this.version);
        }
    }

    public final void reset() {
        this.version = this.getOriginalSettings();
        this.isRemoved = false;
    }

    @NotNull
    public final String getGroupId() {
        return this.version.getGroupId();
    }

    @NotNull
    public String toString() {
        if (this.title == null) {
            String groupId = this.getGroupId();
            String title2 = NotificationGroup.Companion.getGroupTitle(groupId);
            String string = title2;
            if (string == null) {
                string = groupId;
            }
            return string;
        }
        String string = this.title;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final boolean isShouldLog() {
        return this.version.isShouldLog();
    }

    public final void setShouldLog(boolean shouldLog) {
        this.version = this.version.withShouldLog(shouldLog);
    }

    public final boolean isShouldReadAloud() {
        return this.version.isShouldReadAloud();
    }

    public final void setShouldReadAloud(boolean readAloud) {
        this.version = this.version.withShouldReadAloud(readAloud);
    }

    public final boolean isPlaySound() {
        return this.version.isPlaySound();
    }

    public final void setPlaySound(boolean playSound) {
        this.version = this.version.withPlaySound(playSound);
    }

    @NotNull
    public final NotificationDisplayType getDisplayType() {
        return this.version.getDisplayType();
    }

    public final void setDisplayType(@NotNull NotificationDisplayType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.version = this.version.withDisplayType(type);
    }
}

