/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.MentionOnlyUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J6\u0010\u0015\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u0006H\u0007J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/command/impl/UndoDocumentUtil;", "", "<init>", "()V", "getDocRefs", "", "Lcom/intellij/openapi/command/undo/DocumentReference;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getDocumentReferences", "getDocReference", "project", "Lcom/intellij/openapi/project/Project;", "editorProvider", "Lcom/intellij/openapi/fileEditor/impl/CurrentEditorProvider;", "isDocumentOpened", "", "docRef", "isCopy", "document", "Lcom/intellij/openapi/editor/Document;", "separateLocalAndNonLocalActions", "Lcom/intellij/openapi/util/Pair;", "", "Lcom/intellij/openapi/command/undo/UndoableAction;", "actions", "affectedDocument", "collectReadOnlyAffectedFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectReadOnlyDocuments", "getCurrentEditor", "Lcom/intellij/openapi/editor/Editor;", "getOriginalDocument", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUndoDocumentUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UndoDocumentUtil.kt\ncom/intellij/openapi/command/impl/UndoDocumentUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n3938#2:166\n4474#2,2:167\n1586#3:169\n1661#3,3:170\n*S KotlinDebug\n*F\n+ 1 UndoDocumentUtil.kt\ncom/intellij/openapi/command/impl/UndoDocumentUtil\n*L\n43#1:166\n43#1:167,2\n47#1:169\n47#1:170,3\n*E\n"})
public final class UndoDocumentUtil {
    @NotNull
    public static final UndoDocumentUtil INSTANCE = new UndoDocumentUtil();

    private UndoDocumentUtil() {
    }

    @JvmStatic
    @Nullable
    public static final Collection<DocumentReference> getDocRefs(@Nullable FileEditor editor2) {
        if (editor2 instanceof TextEditor && ((TextEditor)editor2).getEditor().isViewer()) {
            return null;
        }
        if (editor2 == null) {
            return CollectionsKt.emptyList();
        }
        return UndoDocumentUtil.getDocumentReferences(editor2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Collection<DocumentReference> getDocumentReferences(@NotNull FileEditor editor2) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (editor2 instanceof DocumentReferenceProvider) {
            Collection collection = ((DocumentReferenceProvider)editor2).getDocumentReferences();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDocumentReferences(...)");
            return collection;
        }
        Document[] $this$filter$iv = TextEditorProvider.Companion.getDocuments(editor2);
        boolean $i$f$filter = false;
        Document[] documentArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Document element$iv$iv : $this$filterTo$iv$iv) {
            void document2 = element$iv$iv;
            boolean bl = false;
            VirtualFile file2 = FileDocumentManager.getInstance().getFile((Document)document2);
            if (!(file2 == null || file2.isValid())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void document3;
            Document element$iv$iv;
            element$iv$iv = (Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Document original = INSTANCE.getOriginalDocument((Document)document3);
            collection.add(DocumentReferenceManager.getInstance().create(original));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    @Nullable
    public static final DocumentReference getDocReference(@NotNull Project project2, @NotNull CurrentEditorProvider editorProvider) {
        VirtualFile file2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editorProvider, (String)"editorProvider");
        Editor editor2 = INSTANCE.getCurrentEditor(project2, editorProvider);
        if (editor2 != null && (file2 = FileDocumentManager.getInstance().getFile(editor2.getDocument())) != null && file2.isValid()) {
            return DocumentReferenceManager.getInstance().create(file2);
        }
        return null;
    }

    @JvmStatic
    public static final boolean isDocumentOpened(@Nullable Project project2, @NotNull DocumentReference docRef) {
        Document document2;
        Intrinsics.checkNotNullParameter((Object)docRef, (String)"docRef");
        VirtualFile file2 = docRef.getFile();
        return file2 != null ? project2 != null && FileEditorManager.getInstance((Project)project2).isFileOpen(file2) : (document2 = docRef.getDocument()) != null && EditorFactory.getInstance().editors(document2, project2).findAny().isPresent();
    }

    @JvmStatic
    public static final boolean isCopy(@NotNull Document document2) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        return document2.getUserData(UndoManager.ORIGINAL_DOCUMENT) != null;
    }

    @JvmStatic
    @NotNull
    public static final Pair<List<UndoableAction>, List<UndoableAction>> separateLocalAndNonLocalActions(@NotNull List<? extends UndoableAction> actions, @NotNull DocumentReference affectedDocument) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)affectedDocument, (String)"affectedDocument");
        List localActions = (List)new SmartList();
        List nonLocalActions = (List)new SmartList();
        for (UndoableAction undoableAction : actions) {
            DocumentReference[] affectedDocuments = undoableAction.getAffectedDocuments();
            boolean bl = affectedDocuments != null && affectedDocuments.length == 1 && Intrinsics.areEqual((Object)affectedDocuments[0], (Object)affectedDocument) ? localActions.add(undoableAction) : nonLocalActions.add(undoableAction);
        }
        return new Pair((Object)localActions, (Object)nonLocalActions);
    }

    @JvmStatic
    @NotNull
    public static final Collection<VirtualFile> collectReadOnlyAffectedFiles(@NotNull List<? extends UndoableAction> actions) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (UndoableAction undoableAction : actions) {
            DocumentReference[] refs;
            if (undoableAction instanceof MentionOnlyUndoableAction || (refs = undoableAction.getAffectedDocuments()) == null) continue;
            for (DocumentReference ref2 : refs) {
                VirtualFile file2 = ref2.getFile();
                if (file2 == null || !file2.isValid() || file2.isWritable()) continue;
                readOnlyFiles.add(file2);
            }
        }
        return readOnlyFiles;
    }

    @JvmStatic
    @NotNull
    public static final Collection<Document> collectReadOnlyDocuments(@NotNull List<? extends UndoableAction> actions) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        ArrayList<Document> readOnlyDocs = new ArrayList<Document>();
        for (UndoableAction undoableAction : actions) {
            DocumentReference[] refs;
            if (undoableAction instanceof MentionOnlyUndoableAction || (refs = undoableAction.getAffectedDocuments()) == null) continue;
            for (DocumentReference ref2 : refs) {
                Document doc;
                if (!(ref2 instanceof DocumentReferenceByDocument)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)((DocumentReferenceByDocument)ref2).getDocument(), (String)"getDocument(...)");
                if (doc.isWritable()) continue;
                readOnlyDocs.add(doc);
            }
        }
        return readOnlyDocs;
    }

    private final Editor getCurrentEditor(Project project2, CurrentEditorProvider editorProvider) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            DataContext dataContext2 = DataManager.getInstance().getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            return (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        }
        FileEditor fileEditor = editorProvider.getCurrentEditor(project2);
        if (fileEditor instanceof TextEditor) {
            return ((TextEditor)fileEditor).getEditor();
        }
        return null;
    }

    private final Document getOriginalDocument(Document document2) {
        Document document3 = (Document)document2.getUserData(UndoManager.ORIGINAL_DOCUMENT);
        if (document3 == null) {
            document3 = document2;
        }
        return document3;
    }
}

