/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.DuplicateAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public final class DuplicateLinesAction
extends EditorAction {
    public DuplicateLinesAction() {
        super((EditorActionHandler)new Handler());
    }

    private static final class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (editor2.getSelectionModel().hasSelection()) {
                int selStart = editor2.getSelectionModel().getSelectionStart();
                int selEnd = editor2.getSelectionModel().getSelectionEnd();
                if (selEnd > selStart && DocumentUtil.isAtLineStart((int)selEnd, (Document)editor2.getDocument())) {
                    --selEnd;
                }
                VisualPosition rangeStart = editor2.offsetToVisualPosition(Math.min(selStart, selEnd));
                VisualPosition rangeEnd = editor2.offsetToVisualPosition(Math.max(selStart, selEnd));
                TextRange copiedRange = DuplicateAction.duplicateLinesRange(editor2, rangeStart, rangeEnd);
                editor2.getSelectionModel().setSelection(copiedRange.getStartOffset(), copiedRange.getEndOffset());
            } else {
                VisualPosition caretPos = editor2.getCaretModel().getVisualPosition();
                DuplicateAction.duplicateLinesRange(editor2, caretPos, caretPos);
            }
        }

        public boolean reverseCaretOrder() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/DuplicateLinesAction$Handler";
            objectArray[2] = "executeWriteAction";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

