/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.util.MathUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToggleCaseAction
extends TextComponentEditorAction {
    public ToggleCaseAction() {
        super((EditorActionHandler)new Handler());
    }

    private static final class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            Ref toLowerCase = new Ref((Object)Boolean.FALSE);
            Handler.runForCaret(editor2, caret, c -> {
                if (!c.hasSelection()) {
                    c.selectWordAtCaret(true);
                }
                int selectionStartOffset = c.getSelectionStart();
                int selectionEndOffset = c.getSelectionEnd();
                String originalText = editor2.getDocument().getText(new TextRange(selectionStartOffset, selectionEndOffset));
                if (!originalText.equals(Handler.toCase(editor2, selectionStartOffset, selectionEndOffset, true))) {
                    toLowerCase.set((Object)Boolean.TRUE);
                }
            });
            Handler.runForCaret(editor2, caret, c -> {
                VisualPosition caretPosition = c.getVisualPosition();
                int selectionStartOffset = c.getSelectionStart();
                int selectionEndOffset = c.getSelectionEnd();
                String originalText = editor2.getDocument().getText(new TextRange(selectionStartOffset, selectionEndOffset));
                String result2 = Handler.toCase(editor2, selectionStartOffset, selectionEndOffset, (Boolean)toLowerCase.get());
                editor2.getDocument().replaceString(selectionStartOffset, selectionEndOffset, (CharSequence)result2);
                c.moveToVisualPosition(caretPosition);
                if (!c.hasSelection()) {
                    c.setSelection(selectionStartOffset, selectionEndOffset + result2.length() - originalText.length());
                }
            });
        }

        private static void runForCaret(Editor editor2, Caret caret, CaretAction action2) {
            if (caret == null) {
                editor2.getCaretModel().runForEachCaret(action2);
            } else {
                action2.perform(caret);
            }
        }

        private static String toCase(Editor editor2, int startOffset, int endOffset, boolean lower) {
            CharSequence text2 = editor2.getDocument().getImmutableCharSequence();
            EditorHighlighter highlighter = editor2.getHighlighter();
            HighlighterIterator iterator2 = highlighter.createIterator(startOffset);
            StringBuilder builder = new StringBuilder(endOffset - startOffset);
            while (!iterator2.atEnd()) {
                int start2 = MathUtil.clamp((int)iterator2.getStart(), (int)startOffset, (int)endOffset);
                int end = MathUtil.clamp((int)iterator2.getEnd(), (int)startOffset, (int)endOffset);
                CharSequence fragment = text2.subSequence(start2, end);
                builder.append(iterator2.getTokenType() == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN ? fragment : (lower ? fragment.toString().toLowerCase(Locale.getDefault()) : fragment.toString().toUpperCase(Locale.getDefault())));
                if (end == endOffset) break;
                iterator2.advance();
            }
            return builder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/ToggleCaseAction$Handler", "executeWriteAction"));
        }
    }
}

