/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditorFragmentRenderer {
    static final int PREVIEW_LINES = Math.max(2, Math.min(25, Integer.getInteger("preview.lines", 5)));
    static final int EDITOR_FRAGMENT_POPUP_BORDER = 1;
    private static final int CACHE_PREVIEW_LINES = 100;
    private final EditorImpl myEditor;
    private int myVisualLine;
    private int myStartVisualLine;
    private int myEndVisualLine;
    private int myRelativeY;
    private boolean myDelayed;
    private boolean isDirty;
    private final AtomicReference<Point> myPointHolder = new AtomicReference();
    private final AtomicReference<HintHint> myHintHolder = new AtomicReference();
    @Nullable
    private LightweightHint myEditorPreviewHint;

    EditorFragmentRenderer(EditorImpl editor2) {
        this.myEditor = editor2;
    }

    @Nullable
    LightweightHint getEditorPreviewHint() {
        return this.myEditorPreviewHint;
    }

    int getStartVisualLine() {
        return this.myStartVisualLine;
    }

    int getRelativeY() {
        return this.myRelativeY;
    }

    private void update(int visualLine, boolean showInstantly) {
        this.myVisualLine = visualLine;
        if (this.myVisualLine == -1) {
            return;
        }
        int oldStartLine = this.myStartVisualLine;
        int oldEndLine = this.myEndVisualLine;
        this.myStartVisualLine = EditorMarkupModelImpl.fitLineToEditor(this.myEditor, this.myVisualLine - PREVIEW_LINES);
        this.myEndVisualLine = EditorMarkupModelImpl.fitLineToEditor(this.myEditor, this.myVisualLine + PREVIEW_LINES);
        this.isDirty |= oldStartLine != this.myStartVisualLine || oldEndLine != this.myEndVisualLine;
    }

    public void show(int visualLine, @NotNull Collection<? extends RangeHighlighterEx> rangeHighlighters, boolean showInstantly, @NotNull HintHint hintInfo) {
        if (rangeHighlighters == null) {
            EditorFragmentRenderer.$$$reportNull$$$0(0);
        }
        if (hintInfo == null) {
            EditorFragmentRenderer.$$$reportNull$$$0(1);
        }
        this.update(visualLine, showInstantly);
        ArrayList<? extends RangeHighlighterEx> highlighters = new ArrayList<RangeHighlighterEx>(rangeHighlighters);
        highlighters.sort((ex1, ex2) -> {
            LogicalPosition startPos1 = this.myEditor.offsetToLogicalPosition(ex1.getAffectedAreaStartOffset());
            LogicalPosition startPos2 = this.myEditor.offsetToLogicalPosition(ex2.getAffectedAreaStartOffset());
            if (startPos1.line != startPos2.line) {
                return 0;
            }
            return startPos1.column - startPos2.column;
        });
        int contentInsets = JBUIScale.scale((int)2);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        boolean needDelay = false;
        if (this.myEditorPreviewHint == null) {
            needDelay = true;
            EditorFragmentPreviewPanel editorFragmentPreviewPanel = new EditorFragmentPreviewPanel(contentInsets, highlighters);
            editorFragmentPreviewPanel.putClientProperty(BalloonImpl.FORCED_NO_SHADOW, Boolean.TRUE);
            this.myEditorPreviewHint = new LightweightHint(editorFragmentPreviewPanel){

                @Override
                public void hide(boolean ok) {
                    super.hide(ok);
                    EditorFragmentRenderer.this.myDelayed = false;
                }
            };
            this.myEditorPreviewHint.setForceLightweightPopup(true);
        }
        Point point = new Point(hintInfo.getOriginalPoint());
        hintInfo.setTextBg(this.myEditor.getBackgroundColor());
        Color borderColor = this.myEditor.getColorsScheme().getAttributes(EditorColors.CODE_LENS_BORDER_COLOR).getEffectColor();
        hintInfo.setBorderColor(borderColor != null ? borderColor : this.myEditor.getColorsScheme().getDefaultForeground());
        point = SwingUtilities.convertPoint((Component)((Object)this.myEditor.getVerticalScrollBar()), point, this.myEditor.getComponent().getRootPane());
        this.myPointHolder.set(point);
        this.myHintHolder.set(hintInfo);
        if (needDelay && !showInstantly) {
            this.myDelayed = true;
            EdtScheduler.getInstance().schedule(300, () -> {
                if (this.myEditorPreviewHint != null && this.myDelayed) {
                    this.showEditorHint(hintManager, this.myPointHolder.get(), this.myHintHolder.get());
                    this.myDelayed = false;
                }
            });
        } else if (!this.myDelayed) {
            this.showEditorHint(hintManager, point, hintInfo);
        }
    }

    private void showEditorHint(@NotNull HintManagerImpl hintManager, @NotNull Point point, HintHint hintInfo) {
        if (hintManager == null) {
            EditorFragmentRenderer.$$$reportNull$$$0(2);
        }
        if (point == null) {
            EditorFragmentRenderer.$$$reportNull$$$0(3);
        }
        int flags = 299;
        hintManager.showEditorHint(this.myEditorPreviewHint, (Editor)this.myEditor, point, flags, 0, false, hintInfo);
    }

    void clearHint() {
        this.myEditorPreviewHint = null;
    }

    void hideHint() {
        if (this.myEditorPreviewHint != null) {
            this.myEditorPreviewHint.hide();
            this.myEditorPreviewHint = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeHighlighters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/EditorFragmentRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showEditorHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class EditorFragmentPreviewPanel
    extends JPanel {
        private static final int R = 6;
        private final int myContentInsets;
        private final List<? extends RangeHighlighterEx> myHighlighters;
        @Nullable
        private BufferedImage myCacheLevel1;
        @Nullable
        private BufferedImage myCacheLevel2;
        private int myCacheFromY;
        private int myCacheToY;

        private EditorFragmentPreviewPanel(int contentInsets, List<? extends RangeHighlighterEx> highlighters) {
            this.myContentInsets = contentInsets;
            this.myHighlighters = highlighters;
        }

        @Override
        @DirtyUI
        @NotNull
        public Dimension getPreferredSize() {
            int width = EditorFragmentRenderer.this.myEditor.getGutterComponentEx().getWidth() + EditorFragmentRenderer.this.myEditor.getScrollingModel().getVisibleArea().width - EditorFragmentRenderer.this.myEditor.getVerticalScrollBar().getWidth();
            return new Dimension((width -= JBUIScale.scale((int)1) * 2 + this.myContentInsets) - BalloonImpl.POINTER_LENGTH.get(), Math.min(2 * PREVIEW_LINES * EditorFragmentRenderer.this.myEditor.getLineHeight(), EditorFragmentRenderer.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myEndVisualLine) - EditorFragmentRenderer.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myStartVisualLine)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @DirtyUI
        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                EditorFragmentPreviewPanel.$$$reportNull$$$0(0);
            }
            if (EditorFragmentRenderer.this.myVisualLine == -1 || EditorFragmentRenderer.this.myEditor.isDisposed()) {
                return;
            }
            Dimension size2 = this.getPreferredSize();
            if (size2.width <= 0 || size2.height <= 0) {
                return;
            }
            EditorGutterComponentEx gutter = EditorFragmentRenderer.this.myEditor.getGutterComponentEx();
            EditorComponentImpl content2 = EditorFragmentRenderer.this.myEditor.getContentComponent();
            int gutterWidth = gutter.getWidth();
            int lineHeight = EditorFragmentRenderer.this.myEditor.getLineHeight();
            if (this.myCacheLevel2 != null && (EditorFragmentRenderer.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myStartVisualLine) < this.myCacheFromY || EditorFragmentRenderer.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myEndVisualLine) + lineHeight > this.myCacheToY)) {
                this.myCacheLevel2 = null;
            }
            if (this.myCacheLevel2 == null) {
                this.myCacheFromY = Math.max(0, EditorFragmentRenderer.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myVisualLine) - 100 * lineHeight);
                this.myCacheToY = Math.min(EditorFragmentRenderer.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myEditor.getVisibleLineCount()), this.myCacheFromY + 201 * lineHeight);
                this.myCacheLevel2 = ImageUtil.createImage((Graphics)g, (int)size2.width, (int)(this.myCacheToY - this.myCacheFromY), (int)1);
                Graphics2D cg = this.myCacheLevel2.createGraphics();
                AffineTransform t = cg.getTransform();
                EditorUIUtil.setupAntialiasing(cg);
                int lineShift = -this.myCacheFromY;
                int shift = JBUIScale.scale((int)1) + this.myContentInsets;
                AffineTransform gutterAT = AffineTransform.getTranslateInstance(-shift, lineShift);
                AffineTransform contentAT = AffineTransform.getTranslateInstance(gutterWidth - shift, lineShift);
                gutterAT.preConcatenate(t);
                contentAT.preConcatenate(t);
                EditorTextField.SUPPLEMENTARY_KEY.set((UserDataHolder)EditorFragmentRenderer.this.myEditor, (Object)Boolean.TRUE);
                try {
                    cg.setTransform(gutterAT);
                    cg.setClip(0, -lineShift, gutterWidth, this.myCacheLevel2.getHeight());
                    gutter.paint(cg);
                    cg.setTransform(contentAT);
                    cg.setClip(0, -lineShift, content2.getWidth(), this.myCacheLevel2.getHeight());
                    content2.paint(cg);
                }
                finally {
                    EditorTextField.SUPPLEMENTARY_KEY.set((UserDataHolder)EditorFragmentRenderer.this.myEditor, null);
                }
            }
            if (this.myCacheLevel1 == null) {
                this.myCacheLevel1 = ImageUtil.createImage((Graphics)g, (int)size2.width, (int)(lineHeight * (2 * PREVIEW_LINES + 1)), (int)1);
                EditorFragmentRenderer.this.isDirty = true;
            }
            if (EditorFragmentRenderer.this.isDirty) {
                EditorFragmentRenderer.this.myRelativeY = SwingUtilities.convertPoint((Component)this, (int)0, (int)0, (Component)EditorFragmentRenderer.this.myEditor.getScrollPane()).y;
                Graphics2D g2d = this.myCacheLevel1.createGraphics();
                AffineTransform transform = g2d.getTransform();
                EditorUIUtil.setupAntialiasing(g2d);
                GraphicsUtil.setupAAPainting((Graphics)g2d);
                g2d.setColor(EditorFragmentRenderer.this.myEditor.getBackgroundColor());
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                int topDisplayedY = Math.max(EditorFragmentRenderer.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myStartVisualLine), EditorFragmentRenderer.this.myEditor.visualLineToY(EditorFragmentRenderer.this.myVisualLine) - PREVIEW_LINES * lineHeight);
                AffineTransform translateInstance = AffineTransform.getTranslateInstance(gutterWidth, this.myCacheFromY - topDisplayedY);
                translateInstance.preConcatenate(transform);
                g2d.setTransform(translateInstance);
                UIUtil.drawImage((Graphics)g2d, (Image)this.myCacheLevel2, (int)(-gutterWidth), (int)0, null);
                Int2IntOpenHashMap rightEdges = new Int2IntOpenHashMap();
                int h = lineHeight - 2;
                EditorColorsScheme colorsScheme = EditorFragmentRenderer.this.myEditor.getColorsScheme();
                FontUIResource font = UIUtil.getFontWithFallback((Font)colorsScheme.getFont(EditorFontType.PLAIN));
                g2d.setFont(font.deriveFont((float)font.getSize() * 0.8f));
                for (RangeHighlighterEx rangeHighlighterEx : this.myHighlighters) {
                    String s;
                    if (!rangeHighlighterEx.isValid()) continue;
                    int hEndOffset = rangeHighlighterEx.getAffectedAreaEndOffset();
                    Object tooltip = rangeHighlighterEx.getErrorStripeTooltip();
                    if (tooltip == null) continue;
                    String string = s = tooltip instanceof HighlightInfo ? ((HighlightInfo)tooltip).getDescription() : String.valueOf(tooltip);
                    if (StringUtil.isEmpty((String)s)) continue;
                    s = s.replaceAll("&nbsp;", " ").replaceAll("\\s+", " ");
                    s = StringUtil.unescapeXmlEntities((String)s);
                    LogicalPosition logicalPosition = EditorFragmentRenderer.this.myEditor.offsetToLogicalPosition(hEndOffset);
                    int endOfLineOffset = EditorFragmentRenderer.this.myEditor.getDocument().getLineEndOffset(logicalPosition.line);
                    logicalPosition = EditorFragmentRenderer.this.myEditor.offsetToLogicalPosition(endOfLineOffset);
                    Point placeToShow = EditorFragmentRenderer.this.myEditor.logicalPositionToXY(logicalPosition);
                    logicalPosition = EditorFragmentRenderer.this.myEditor.xyToLogicalPosition(placeToShow);
                    placeToShow.x += 9;
                    placeToShow.y -= this.myCacheFromY - 1;
                    int w = g2d.getFontMetrics().stringWidth(s);
                    int rightEdge = rightEdges.get(logicalPosition.line);
                    placeToShow.x = Math.max(placeToShow.x, rightEdge);
                    rightEdge = Math.max(rightEdge, placeToShow.x + w + 18);
                    rightEdges.put(logicalPosition.line, rightEdge);
                    g2d.setColor(MessageType.WARNING.getPopupBackground());
                    g2d.fillRoundRect(placeToShow.x, placeToShow.y, w + 12, h, 6, 6);
                    g2d.setColor((Color)new JBColor((Color)JBColor.GRAY, (Color)Gray._200));
                    g2d.drawRoundRect(placeToShow.x, placeToShow.y, w + 12, h, 6, 6);
                    g2d.setColor(JBColor.foreground());
                    g2d.drawString(s, placeToShow.x + 6, placeToShow.y + h - g2d.getFontMetrics(g2d.getFont()).getDescent() / 2 - 2);
                }
                EditorFragmentRenderer.this.isDirty = false;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                GraphicsUtil.setupAAPainting((Graphics)g2);
                g2.setClip(new RoundRectangle2D.Double(0.0, 0.0, (double)size2.width - 0.5, (double)size2.height - 0.5, 2.0, 2.0));
                UIUtil.drawImage((Graphics)g2, (Image)this.myCacheLevel1, (int)0, (int)0, (ImageObserver)this);
                if (StartupUiUtil.isUnderDarcula() && !ExperimentalUI.isNewUI()) {
                    Rectangle s = new Rectangle(0, 0, size2.width, size2.height);
                    double cx = (double)size2.width / 2.0;
                    double rx = (double)size2.width / 10.0;
                    int ry = lineHeight * 3 / 2;
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, Gray._255.withAlpha(75), 0.0f, ry, Gray._255.withAlpha(10)));
                    double pseudoMajorAxis = (double)size2.width - rx * 9.0 / 5.0;
                    double d = 0.0;
                    Ellipse2D.Double topShape1 = new Ellipse2D.Double(cx - rx - pseudoMajorAxis / 2.0, d - (double)ry, 2.0 * rx, 2 * ry);
                    Ellipse2D.Double topShape2 = new Ellipse2D.Double(cx - rx + pseudoMajorAxis / 2.0, d - (double)ry, 2.0 * rx, 2 * ry);
                    Area topArea = new Area(topShape1);
                    topArea.add(new Area(topShape2));
                    topArea.add(new Area(new Rectangle2D.Double(cx - pseudoMajorAxis / 2.0, d, pseudoMajorAxis, ry)));
                    g2.fill(topArea);
                    Area bottomArea = new Area(s);
                    bottomArea.subtract(topArea);
                    g2.setPaint(new GradientPaint(0.0f, size2.height - ry, Gray._0.withAlpha(10), 0.0f, size2.height, Gray._255.withAlpha(30)));
                    g2.fill(bottomArea);
                }
            }
            finally {
                g2.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorFragmentRenderer$EditorFragmentPreviewPanel", "paintComponent"));
        }
    }
}

