/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class EditorGutterLayout {
    private static final String GAP_BETWEEN_AREAS = "Gap between areas";
    private static final String LINE_NUMBERS_AREA = "Line numbers";
    private static final String ADDITIONAL_LINE_NUMBERS_AREA = "Additional line numbers";
    private static final String ANNOTATIONS_AREA = "Annotations";
    private static final String LEFT_FREE_PAINTERS_AREA = "Left free painters";
    private static final String ICONS_AREA = "Icons";
    private static final String GAP_AFTER_ICONS_AREA = "Gap after icons";
    private static final String RIGHT_FREE_PAINTERS_AREA = "Right free painters";
    private static final String EXTRA_RIGHT_FREE_PAINTERS_AREA = "Extra Right free painters";
    private static final String FOLDING_AREA = "Free painters";
    private static final String VERTICAL_LINE_AREA = "Vertical line";
    private final EditorGutterComponentImpl myEditorGutter;
    private List<GutterArea> myNewUILayout;
    private List<GutterArea> myNewUIDFMLayout;
    private List<GutterArea> myClassicLayout;

    EditorGutterLayout(@NotNull EditorGutterComponentImpl editorGutter) {
        if (editorGutter == null) {
            EditorGutterLayout.$$$reportNull$$$0(0);
        }
        this.myEditorGutter = editorGutter;
    }

    public int getWidth() {
        return this.getLayout().stream().map(GutterArea::width).reduce(0, Integer::sum);
    }

    @Nullable
    public EditorMouseEventArea getEditorMouseAreaByOffset(int offset) {
        int off = 0;
        for (GutterArea area : this.getLayout()) {
            if ((off += area.width()) < offset) continue;
            return area.mouseEventAreaType;
        }
        return null;
    }

    List<GutterArea> getLayout() {
        if (ExperimentalUI.isNewUI()) {
            if (DistractionFreeModeController.isDistractionFreeModeEnabled()) {
                return this.getNewUIDFMLayout();
            }
            return this.getNewUiLayout();
        }
        return this.getClassicGutterLayout();
    }

    private List<GutterArea> getClassicGutterLayout() {
        if (this.myClassicLayout == null) {
            this.myClassicLayout = this.createClassicLayout();
        }
        return this.myClassicLayout;
    }

    private List<GutterArea> createClassicLayout() {
        ArrayList<GutterArea> layout2;
        List<GutterArea> lineNumbersAreas = List.of(EditorGutterLayout.areaGap().as(EditorMouseEventArea.LINE_NUMBERS_AREA).showIf(this::isLineNumbersShown), EditorGutterLayout.area(LINE_NUMBERS_AREA, () -> this.myEditorGutter.myLineNumberAreaWidth).showIf(this::isLineNumbersShown), EditorGutterLayout.area(ADDITIONAL_LINE_NUMBERS_AREA, () -> this.myEditorGutter.myAdditionalLineNumberAreaWidth).showIf(this::isLineNumbersShown), EditorGutterLayout.areaGap().as(EditorMouseEventArea.LINE_MARKERS_AREA).showIf(this::isLineNumbersShown));
        List<GutterArea> annotationAreas = List.of(EditorGutterLayout.area(ANNOTATIONS_AREA, () -> this.myEditorGutter.myTextAnnotationGuttersSize).showIf(() -> this.myEditorGutter.myTextAnnotationGuttersSize != 0), EditorGutterLayout.areaGap().as(EditorMouseEventArea.ANNOTATIONS_AREA).showIf(() -> this.myEditorGutter.isShowGapAfterAnnotations()));
        List<GutterArea> dfmMarginArea = List.of(EditorGutterLayout.area(ANNOTATIONS_AREA, () -> this.myEditorGutter.myTextAnnotationExtraSize).as(EditorMouseEventArea.LINE_MARKERS_AREA).showIf(() -> this.myEditorGutter.myTextAnnotationExtraSize != 0));
        List<GutterArea> iconRelatedAreas = List.of(EditorGutterLayout.area(LEFT_FREE_PAINTERS_AREA, this.myEditorGutter::getLeftFreePaintersAreaWidth).showIf(this.myEditorGutter::isLineMarkersShown), EditorGutterLayout.area(ICONS_AREA, this.myEditorGutter::getIconsAreaWidth).showIf(this.myEditorGutter::isLineMarkersShown), EditorGutterLayout.area(GAP_AFTER_ICONS_AREA, this.myEditorGutter::getGapAfterIconsArea).showIf(this.myEditorGutter::isLineMarkersShown));
        List<GutterArea> rightEdgeAreas = List.of(EditorGutterLayout.area(RIGHT_FREE_PAINTERS_AREA, this.myEditorGutter::getRightFreePaintersAreaWidth).showIf(this.myEditorGutter::isLineMarkersShown), EditorGutterLayout.area(FOLDING_AREA, this.myEditorGutter::getFoldingAreaWidth));
        if (this.isLineNumbersAfterIcons()) {
            layout2 = new ArrayList<GutterArea>();
            layout2.addAll(annotationAreas);
            layout2.addAll(dfmMarginArea);
            layout2.addAll(iconRelatedAreas);
            layout2.addAll(lineNumbersAreas);
            layout2.addAll(rightEdgeAreas);
        } else {
            layout2 = new ArrayList();
            layout2.addAll(lineNumbersAreas);
            layout2.addAll(annotationAreas);
            layout2.addAll(dfmMarginArea);
            layout2.addAll(iconRelatedAreas);
            layout2.addAll(rightEdgeAreas);
        }
        return layout2;
    }

    private boolean isLineNumbersShown() {
        return this.myEditorGutter.isLineNumbersShown();
    }

    private boolean isLineNumbersAfterIcons() {
        return this.myEditorGutter.isLineNumbersAfterIcons();
    }

    private List<GutterArea> createNewUILayout(boolean isDistractionFreeMode) {
        List<GutterArea> annotationAreas = List.of(EditorGutterLayout.areaGap().as(EditorMouseEventArea.ANNOTATIONS_AREA).showIf(() -> this.isLineNumbersAfterIcons()), EditorGutterLayout.area(ANNOTATIONS_AREA, () -> ((JBValue)EditorGutterComponentImpl.EMPTY_ANNOTATION_AREA_WIDTH).get()).showIf(() -> this.myEditorGutter.myTextAnnotationGuttersSize == 0 && this.myEditorGutter.isLineMarkersShown()), EditorGutterLayout.areaGap().as(EditorMouseEventArea.ANNOTATIONS_AREA).showIf(() -> this.myEditorGutter.isShowGapAfterAnnotations() && this.myEditorGutter.isLineMarkersShown()), EditorGutterLayout.area(ANNOTATIONS_AREA, () -> this.myEditorGutter.myTextAnnotationGuttersSize).showIf(() -> this.myEditorGutter.myTextAnnotationGuttersSize != 0));
        List<GutterArea> lineNumbersAreas = List.of(EditorGutterLayout.areaGap(EditorGutterLayout.gapBeforeLineMarkersWidth()).as(EditorMouseEventArea.LINE_NUMBERS_AREA).showIf(this::isLineNumbersShown), EditorGutterLayout.area(LINE_NUMBERS_AREA, () -> this.myEditorGutter.myLineNumberAreaWidth).showIf(this::isLineNumbersShown), EditorGutterLayout.areaGap(12).showIf(() -> this.isLineNumbersShown() && !this.myEditorGutter.isLineMarkersShown()), EditorGutterLayout.area(ADDITIONAL_LINE_NUMBERS_AREA, () -> this.myEditorGutter.myAdditionalLineNumberAreaWidth).showIf(this::isLineNumbersShown), EditorGutterLayout.area(ADDITIONAL_LINE_NUMBERS_AREA, () -> Math.max(this.myEditorGutter.isLineMarkersShown() ? EditorGutterComponentImpl.GAP_AFTER_LINE_NUMBERS_WIDTH.get() : 0, this.myEditorGutter.myAdditionalLineNumberAreaWidth > 0 ? EditorGutterComponentImpl.getGapBetweenAreas() : 0)).showIf(() -> this.isLineNumbersShown()));
        List<GutterArea> dfmMarginArea = List.of(EditorGutterLayout.area(ANNOTATIONS_AREA, () -> this.myEditorGutter.myTextAnnotationExtraSize).as(EditorMouseEventArea.LINE_MARKERS_AREA).showIf(() -> this.myEditorGutter.myTextAnnotationExtraSize != 0));
        List<GutterArea> iconRelatedAreas = List.of(EditorGutterLayout.area(LEFT_FREE_PAINTERS_AREA, this.myEditorGutter::getLeftFreePaintersAreaWidth).showIf(this.myEditorGutter::isLineMarkersShown), EditorGutterLayout.area(ICONS_AREA, this.myEditorGutter::getIconsAreaWidth).showIf(this.myEditorGutter::isLineMarkersShown), EditorGutterLayout.area(GAP_AFTER_ICONS_AREA, this.myEditorGutter::getGapAfterIconsArea).showIf(() -> this.myEditorGutter.isLineMarkersShown() && !this.isLineNumbersAfterIcons()));
        List<GutterArea> rightEdgeAreas = List.of(EditorGutterLayout.area(RIGHT_FREE_PAINTERS_AREA, this.myEditorGutter::getRightFreePaintersAreaWidth).showIf(this.myEditorGutter::isLineMarkersShown), EditorGutterLayout.area(FOLDING_AREA, this.myEditorGutter::getFoldingAreaWidth));
        List<GutterArea> rightEdgeAreasForLineNumbersAfterIcons = List.of(EditorGutterLayout.area(FOLDING_AREA, this.myEditorGutter::getFoldingAreaWidthForLineNumbersAfterIcons));
        List<GutterArea> extraRightFreePainters = List.of(EditorGutterLayout.area(EXTRA_RIGHT_FREE_PAINTERS_AREA, this.myEditorGutter::getExtraRightFreePaintersAreaWidth).showIf(() -> this.myEditorGutter.isLineMarkersShown()), EditorGutterLayout.areaGap(1).showIf(() -> this.myEditorGutter.isLineMarkersShown()));
        ArrayList<GutterArea> layout2 = new ArrayList<GutterArea>();
        if (isDistractionFreeMode) {
            layout2.addAll(annotationAreas);
            layout2.addAll(dfmMarginArea);
            layout2.addAll(lineNumbersAreas);
            layout2.addAll(iconRelatedAreas);
            layout2.addAll(rightEdgeAreas);
            layout2.addAll(extraRightFreePainters);
        } else if (this.isLineNumbersAfterIcons()) {
            layout2.addAll(annotationAreas);
            layout2.addAll(dfmMarginArea);
            layout2.addAll(iconRelatedAreas);
            layout2.addAll(lineNumbersAreas);
            layout2.addAll(rightEdgeAreasForLineNumbersAfterIcons);
            layout2.addAll(extraRightFreePainters);
        } else {
            layout2.addAll(annotationAreas);
            layout2.addAll(lineNumbersAreas);
            layout2.addAll(dfmMarginArea);
            layout2.addAll(iconRelatedAreas);
            layout2.addAll(rightEdgeAreas);
            layout2.addAll(extraRightFreePainters);
        }
        return layout2;
    }

    private static int gapBeforeLineMarkersWidth() {
        return JBUI.CurrentTheme.Editor.Gutter.gapAfterVcsMarkersWidth();
    }

    @NotNull
    private static GutterArea areaGap() {
        GutterArea gutterArea = EditorGutterLayout.area(GAP_BETWEEN_AREAS, EditorGutterComponentImpl::getGapBetweenAreas);
        if (gutterArea == null) {
            EditorGutterLayout.$$$reportNull$$$0(1);
        }
        return gutterArea;
    }

    @NotNull
    private static GutterArea areaGap(int width) {
        GutterArea gutterArea = EditorGutterLayout.area(GAP_BETWEEN_AREAS, () -> JBUI.scale((int)width));
        if (gutterArea == null) {
            EditorGutterLayout.$$$reportNull$$$0(2);
        }
        return gutterArea;
    }

    private List<GutterArea> getNewUiLayout() {
        if (this.myNewUILayout == null) {
            this.myNewUILayout = this.createNewUILayout(false);
        }
        return this.myNewUILayout;
    }

    private List<GutterArea> getNewUIDFMLayout() {
        if (this.myNewUIDFMLayout == null) {
            this.myNewUIDFMLayout = this.createNewUILayout(true);
        }
        return this.myNewUIDFMLayout;
    }

    private static GutterArea area(String id2, Supplier<Integer> areaWidth) {
        return new GutterArea(id2, areaWidth);
    }

    public int getAnnotationsAreaOffset() {
        return this.getOffset(ANNOTATIONS_AREA);
    }

    private int getOffset(String ID2) {
        int offset = 0;
        for (GutterArea area : this.getLayout()) {
            if (Strings.areSameInstance((String)area.id, (String)ID2)) {
                return offset;
            }
            offset += area.width();
        }
        return -1;
    }

    int getFoldingAreaOffset() {
        return this.getOffset(FOLDING_AREA);
    }

    int getIconAreaOffset() {
        return this.getOffset(ICONS_AREA);
    }

    int getExtraRightFreePaintersAreaOffset() {
        return this.getOffset(EXTRA_RIGHT_FREE_PAINTERS_AREA);
    }

    public int getLeftFreePaintersAreaOffset() {
        return this.getOffset(LEFT_FREE_PAINTERS_AREA);
    }

    int getLineMarkerAreaOffset() {
        return this.getOffset(LEFT_FREE_PAINTERS_AREA);
    }

    int getLineMarkerFreePaintersAreaOffset() {
        return this.getOffset(RIGHT_FREE_PAINTERS_AREA);
    }

    int getLineNumberAreaOffset() {
        return this.getOffset(LINE_NUMBERS_AREA);
    }

    public int getVerticalLineX() {
        return this.getOffset(VERTICAL_LINE_AREA);
    }

    public static int getInitialGutterWidth() {
        return EditorGutterComponentImpl.START_ICON_AREA_WIDTH.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorGutter";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorGutterLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorGutterLayout";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "areaGap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    static final class GutterArea {
        private final String id;
        private final Supplier<Integer> widthFunc;
        private EditorMouseEventArea mouseEventAreaType;
        private Supplier<Boolean> showIfFunc;

        GutterArea(String ID2, Supplier<Integer> areaWidth) {
            this.id = ID2;
            this.widthFunc = areaWidth;
            this.mouseEventAreaType = switch (ID2) {
                case EditorGutterLayout.LINE_NUMBERS_AREA, EditorGutterLayout.ADDITIONAL_LINE_NUMBERS_AREA -> EditorMouseEventArea.LINE_NUMBERS_AREA;
                case EditorGutterLayout.ANNOTATIONS_AREA -> EditorMouseEventArea.ANNOTATIONS_AREA;
                case EditorGutterLayout.LEFT_FREE_PAINTERS_AREA, EditorGutterLayout.RIGHT_FREE_PAINTERS_AREA, EditorGutterLayout.EXTRA_RIGHT_FREE_PAINTERS_AREA, EditorGutterLayout.GAP_AFTER_ICONS_AREA, EditorGutterLayout.ICONS_AREA -> EditorMouseEventArea.LINE_MARKERS_AREA;
                case EditorGutterLayout.FOLDING_AREA, EditorGutterLayout.VERTICAL_LINE_AREA -> EditorMouseEventArea.FOLDING_OUTLINE_AREA;
                default -> null;
            };
        }

        int width() {
            if (this.showIfFunc != null && !this.showIfFunc.get().booleanValue()) {
                return 0;
            }
            return this.widthFunc.get();
        }

        GutterArea as(EditorMouseEventArea type) {
            this.mouseEventAreaType = type;
            return this;
        }

        GutterArea showIf(Supplier<Boolean> showIf) {
            this.showIfFunc = showIf;
            return this;
        }

        public String toString() {
            return this.id + "=" + this.width();
        }
    }
}

