/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FoldRegionImpl
extends RangeMarkerImpl
implements FoldRegion {
    private static final Key<Boolean> MUTE_INNER_HIGHLIGHTERS = Key.create((String)"mute.inner.highlighters");
    private static final Key<Boolean> SHOW_GUTTER_MARK_FOR_SINGLE_LINE = Key.create((String)"show.gutter.mark.for.single.line");
    private boolean myIsExpanded;
    final EditorImpl myEditor;
    private String myPlaceholderText;
    private final FoldingGroup myGroup;
    private final boolean myShouldNeverExpand;
    private boolean myDocumentRegionWasChanged;
    int mySizeBeforeUpdate;

    FoldRegionImpl(@NotNull EditorImpl editor2, int startOffset, int endOffset, @NotNull String placeholder, @Nullable FoldingGroup group2, boolean shouldNeverExpand) {
        if (editor2 == null) {
            FoldRegionImpl.$$$reportNull$$$0(0);
        }
        if (placeholder == null) {
            FoldRegionImpl.$$$reportNull$$$0(1);
        }
        super(editor2.getDocument(), startOffset, endOffset, false, true);
        this.myGroup = group2;
        this.myShouldNeverExpand = shouldNeverExpand;
        this.myIsExpanded = true;
        this.myEditor = editor2;
        this.myPlaceholderText = placeholder;
    }

    public boolean isExpanded() {
        return this.myIsExpanded;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setExpanded(boolean bl) {
        void expanded;
        ThreadingAssertions.assertEventDispatchThread();
        this.setExpanded((boolean)expanded, true);
    }

    @RequiresEdt
    void setExpanded(boolean bl, boolean bl2) {
        ThreadingAssertions.assertEventDispatchThread();
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (this.myGroup == null) {
            FoldRegionImpl.doSetExpanded((boolean)expanded, foldingModel, this, (boolean)notify);
        } else {
            for (FoldRegion region : foldingModel.getGroupedRegions(this.myGroup)) {
                FoldRegionImpl.doSetExpanded((boolean)expanded, foldingModel, region, notify != false || region != this);
                if (region.isExpanded() == expanded) continue;
                for (FoldRegion regionToRevert : foldingModel.getGroupedRegions(this.myGroup)) {
                    if (regionToRevert == region) break;
                    FoldRegionImpl.doSetExpanded(expanded == false, foldingModel, regionToRevert, notify != false || region != this);
                }
                return;
            }
        }
    }

    @RequiresEdt
    private static void doSetExpanded(boolean bl, FoldingModelImpl foldingModelImpl, FoldRegion foldRegion, boolean bl2) {
        boolean expanded;
        ThreadingAssertions.assertEventDispatchThread();
        if (expanded) {
            foldingModel.expandFoldRegion((FoldRegion)region, (boolean)notify);
        } else {
            foldingModel.collapseFoldRegion((FoldRegion)region, (boolean)notify);
        }
    }

    public boolean isValid() {
        return super.isValid() && this.intervalStart() < this.intervalEnd();
    }

    void setExpandedInternal(boolean toExpand) {
        this.myIsExpanded = toExpand;
    }

    @NotNull
    public String getPlaceholderText() {
        String string = this.myPlaceholderText;
        if (string == null) {
            FoldRegionImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    public boolean shouldNeverExpand() {
        return this.myShouldNeverExpand;
    }

    boolean hasDocumentRegionChanged() {
        return this.myDocumentRegionWasChanged;
    }

    void resetDocumentRegionChanged() {
        this.myDocumentRegionWasChanged = false;
    }

    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            FoldRegionImpl.$$$reportNull$$$0(3);
        }
        if (this.isValid()) {
            int oldStart = this.intervalStart();
            int oldEnd = this.intervalEnd();
            int changeStart = e.getOffset();
            int changeEnd = e.getOffset() + e.getOldLength();
            if (changeStart < oldEnd && changeEnd > oldStart) {
                this.myDocumentRegionWasChanged = true;
            }
        }
        super.changedUpdateImpl(e);
        if (this.isValid()) {
            this.alignToValidBoundaries();
        }
    }

    protected void onReTarget(@NotNull DocumentEvent e) {
        if (e == null) {
            FoldRegionImpl.$$$reportNull$$$0(4);
        }
        this.alignToValidBoundaries();
    }

    void alignToValidBoundaries() {
        DocumentEx document2 = this.getDocument();
        long alignedRange = TextRangeScalarUtil.shift((long)this.toScalarRange(), (int)(DocumentUtil.isInsideCharacterPair((Document)document2, (int)this.getStartOffset()) ? -1 : 0), (int)(DocumentUtil.isInsideCharacterPair((Document)document2, (int)this.getEndOffset()) ? -1 : 0));
        if (alignedRange != this.toScalarRange()) {
            this.myEditor.getFoldingModel().setComplexDocumentChange(true);
        }
        this.setRange(alignedRange);
    }

    public void setGreedyToLeft(boolean greedy) {
    }

    public void setGreedyToRight(boolean greedy) {
    }

    public void setStickingToRight(boolean value) {
    }

    public void setInnerHighlightersMuted(boolean value) {
        this.putUserData(MUTE_INNER_HIGHLIGHTERS, value ? Boolean.TRUE : null);
    }

    public boolean areInnerHighlightersMuted() {
        return Boolean.TRUE.equals(this.getUserData(MUTE_INNER_HIGHLIGHTERS));
    }

    public void setGutterMarkEnabledForSingleLine(boolean value) {
        if (value != this.isGutterMarkEnabledForSingleLine()) {
            this.putUserData(SHOW_GUTTER_MARK_FOR_SINGLE_LINE, value ? Boolean.TRUE : null);
            this.myEditor.getGutterComponentEx().repaint();
        }
    }

    public boolean isGutterMarkEnabledForSingleLine() {
        return Boolean.TRUE.equals(this.getUserData(SHOW_GUTTER_MARK_FOR_SINGLE_LINE));
    }

    public void setPlaceholderText(@NotNull String text2) {
        if (text2 == null) {
            FoldRegionImpl.$$$reportNull$$$0(5);
        }
        this.myPlaceholderText = text2;
        this.myEditor.getFoldingModel().onPlaceholderTextChanged(this);
    }

    public void dispose() {
        this.myEditor.getFoldingModel().removeRegionFromTree(this);
    }

    public String toString() {
        return "FoldRegion " + (this.myIsExpanded ? "-" : "+") + "(" + this.getStartOffset() + ":" + this.getEndOffset() + ")" + (this.isValid() ? "" : "(invalid)") + ", placeholder='" + this.myPlaceholderText + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldRegionImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldRegionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onReTarget";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPlaceholderText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

