/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.TrailingSpacesOptions;
import com.intellij.openapi.fileEditor.TrailingSpacesOptionsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SlowOperations;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrailingSpacesStripper
implements FileDocumentManagerListener {
    private static final Key<Boolean> DISABLE_FOR_FILE_KEY = Key.create((String)"DISABLE_TRAILING_SPACE_STRIPPER_FOR_FILE_KEY");
    private final Set<Document> myDocumentsToStripLater = new HashSet<Document>();

    public void beforeAllDocumentsSaving() {
        HashSet<Document> documentsToStrip = new HashSet<Document>(this.myDocumentsToStripLater);
        this.myDocumentsToStripLater.clear();
        for (Document document2 : documentsToStrip) {
            this.strip(document2);
        }
    }

    public void beforeDocumentSaving(@NotNull Document document2) {
        if (document2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(0);
        }
        this.strip(document2);
    }

    private void strip(final @NotNull Document document2) {
        int end;
        int start2;
        boolean success2;
        TrailingSpacesOptions options2;
        if (document2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(1);
        }
        if ((options2 = TrailingSpacesStripper.getOptions(document2)) == null) {
            return;
        }
        if (options2.isStripTrailingSpaces() && !(success2 = TrailingSpacesStripper.strip(document2, options2.isChangedLinesOnly(), options2.isKeepTrailingSpacesOnCaretLine()))) {
            this.myDocumentsToStripLater.add(document2);
        }
        if (options2.isRemoveTrailingBlankLines()) {
            TrailingSpacesStripper.removeTrailngBlankLines(document2, options2.isEnsureNewLineAtEOF());
        }
        int lines = document2.getLineCount();
        if (options2.isEnsureNewLineAtEOF() && lines > 0 && (start2 = document2.getLineStartOffset(lines - 1)) != (end = document2.getLineEndOffset(lines - 1))) {
            final CharSequence content2 = document2.getCharsSequence();
            TrailingSpacesStripper.performUndoableWrite(new Runnable(){

                @Override
                public void run() {
                    if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)content2.subSequence(start2, end)) && options2.isStripTrailingSpaces() && (!options2.isKeepTrailingSpacesOnCaretLine() || !this.hasCaretIn(start2, end))) {
                        document2.deleteString(start2, end);
                    } else {
                        document2.insertString(end, (CharSequence)"\n");
                    }
                }

                private boolean hasCaretIn(int start22, int end2) {
                    for (Editor activeEditor : TrailingSpacesStripper.getActiveEditors(document2)) {
                        for (Caret caret : activeEditor.getCaretModel().getAllCarets()) {
                            int offset = caret.getOffset();
                            if (offset < start22 || offset > end2) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
    }

    private static void removeTrailngBlankLines(@NotNull Document document2, boolean keepLast) {
        if (document2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(2);
        }
        if (document2.getLineCount() > 0) {
            int firstNewLineOffset;
            int endOffset = document2.getTextLength() - 1;
            Ref deleteToExclusive = Ref.create((Object)(endOffset + 1));
            CharSequence content2 = document2.getCharsSequence();
            int blankAreaOffset = CharArrayUtil.shiftBackward((CharSequence)content2, (int)endOffset, (String)" \t\r\n");
            if (blankAreaOffset < endOffset && (firstNewLineOffset = CharArrayUtil.indexOf((CharSequence)content2, (CharSequence)"\n", (int)blankAreaOffset)) > 0) {
                int lastLNewLineOffset;
                if (keepLast && (lastLNewLineOffset = CharArrayUtil.lastIndexOf((CharSequence)content2, (String)"\n", (int)endOffset)) >= firstNewLineOffset) {
                    deleteToExclusive.set((Object)lastLNewLineOffset);
                }
                TrailingSpacesStripper.performUndoableWrite(() -> document2.deleteString(firstNewLineOffset, ((Integer)deleteToExclusive.get()).intValue()));
            }
        }
    }

    private static void performUndoableWrite(@NotNull Runnable documentRunnable) {
        if (documentRunnable == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(documentRunnable));
    }

    @ApiStatus.Internal
    public void clearLineModificationFlags(@NotNull Document document2) {
        int[] caretLines;
        if (document2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(4);
        }
        if (!((document2 = PsiDocumentManagerBase.getTopLevelDocument((Document)document2)) instanceof DocumentImpl)) {
            return;
        }
        TrailingSpacesOptions options2 = TrailingSpacesStripper.getOptions(document2);
        if (options2 == null) {
            return;
        }
        List<Editor> activeEditors = TrailingSpacesStripper.getActiveEditors(document2);
        ArrayList carets = new ArrayList();
        if (options2.isChangedLinesOnly() && options2.isStripTrailingSpaces()) {
            for (Editor activeEditor : activeEditors) {
                if (activeEditor.getSettings().isVirtualSpace()) continue;
                carets.addAll(activeEditor.getCaretModel().getAllCarets());
            }
        }
        if (!carets.isEmpty()) {
            caretLines = new int[carets.size()];
            for (int i2 = 0; i2 < carets.size(); ++i2) {
                Caret caret = (Caret)carets.get(i2);
                caretLines[i2] = caret.getLogicalPosition().line;
            }
        } else {
            caretLines = ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        ((DocumentImpl)document2).clearLineModificationFlagsExcept(caretLines);
    }

    @NotNull
    private static List<Editor> getActiveEditors(@NotNull Document document2) {
        Application application;
        if (document2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(5);
        }
        if ((application = ApplicationManager.getApplication()).isDisposed()) {
            List<Editor> list2 = Collections.emptyList();
            if (list2 == null) {
                TrailingSpacesStripper.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ArrayList<Editor> activeEditors = new ArrayList<Editor>();
        Editor localEditor = TrailingSpacesStripper.getActiveLocalEditor(document2);
        if (localEditor != null) {
            activeEditors.add(localEditor);
        }
        for (ClientEditorManager manager2 : application.getServices(ClientEditorManager.class, ClientKind.REMOTE)) {
            for (Editor editor2 : manager2.editorsSequence()) {
                if (!UIUtil.hasFocus((Component)editor2.getContentComponent()) || editor2.getDocument() != document2) continue;
                activeEditors.add(editor2);
            }
        }
        ArrayList<Editor> arrayList = activeEditors;
        if (arrayList == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static Editor getActiveLocalEditor(@NotNull Document document2) {
        if (document2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(8);
        }
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        DataContext dataContext2 = DataManager.getInstance().getDataContext(focusOwner);
        Editor activeEditor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (activeEditor != null && activeEditor.getDocument() != document2) {
            activeEditor = null;
        }
        return activeEditor;
    }

    @ApiStatus.Internal
    public static boolean strip(@NotNull Document document2, boolean inChangedLinesOnly, boolean skipCaretLines) {
        if (document2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(9);
        }
        if (!((document2 = PsiDocumentManagerBase.getTopLevelDocument((Document)document2)) instanceof DocumentImpl)) {
            return true;
        }
        List<Editor> activeEditors = TrailingSpacesStripper.getActiveEditors(document2);
        ArrayList carets = new ArrayList();
        for (Editor activeEditor : activeEditors) {
            carets.addAll(activeEditor.getCaretModel().getAllCarets());
        }
        ArrayList<VisualPosition> visualCarets = new ArrayList<VisualPosition>(carets.size());
        int[] caretOffsets = new int[carets.size()];
        for (int i2 = 0; i2 < carets.size(); ++i2) {
            Caret caret = (Caret)carets.get(i2);
            visualCarets.add(caret.getVisualPosition());
            caretOffsets[i2] = caret.getOffset();
        }
        boolean markAsNeedsStrippingLater = ((DocumentImpl)document2).stripTrailingSpaces(TrailingSpacesStripper.getProject(document2, activeEditors), inChangedLinesOnly, (int[])(skipCaretLines ? caretOffsets : null));
        if (!activeEditors.isEmpty() && !ShutDownTracker.isShutdownStarted()) {
            TrailingSpacesStripper.runBatchCaretOperation(activeEditors, () -> {
                for (int i2 = 0; i2 < carets.size(); ++i2) {
                    Caret caret = (Caret)carets.get(i2);
                    if (!caret.isValid()) continue;
                    caret.moveToVisualPosition((VisualPosition)visualCarets.get(i2));
                }
            });
        }
        return !markAsNeedsStrippingLater;
    }

    private static void runBatchCaretOperation(@NotNull List<? extends Editor> editors, @NotNull Runnable runnable2) {
        if (editors == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(10);
        }
        if (runnable2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(11);
        }
        TrailingSpacesStripper.runBatchCaretOperation(editors, 0, runnable2);
    }

    private static void runBatchCaretOperation(@NotNull List<? extends Editor> editors, int startIndex, @NotNull Runnable runnable2) {
        if (editors == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(12);
        }
        if (runnable2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(13);
        }
        if (startIndex >= editors.size()) {
            runnable2.run();
            return;
        }
        editors.get(startIndex).getCaretModel().runBatchCaretOperation(() -> TrailingSpacesStripper.runBatchCaretOperation(editors, startIndex + 1, runnable2));
    }

    @Nullable
    private static Project getProject(@NotNull Document document2, @NotNull List<? extends Editor> editors) {
        if (document2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(14);
        }
        if (editors == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(15);
        }
        for (Editor editor2 : editors) {
            Project project2 = editor2.getProject();
            if (project2 == null) continue;
            return project2;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document2);
        if (file2 != null) {
            try (AccessToken accessToken = SlowOperations.knownIssue((String)"IDEA-323372, EA-857522");){
                Project project2 = ProjectUtil.guessProjectForFile((VirtualFile)file2);
                return project2;
            }
        }
        return null;
    }

    @ApiStatus.Internal
    public void documentDeleted(@NotNull Document doc) {
        if (doc == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(16);
        }
        this.myDocumentsToStripLater.remove(doc);
    }

    public void unsavedDocumentsDropped() {
        this.myDocumentsToStripLater.clear();
    }

    public static void setEnabled(@NotNull VirtualFile file2, boolean enabled2) {
        if (file2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(17);
        }
        DISABLE_FOR_FILE_KEY.set((UserDataHolder)file2, (Object)(enabled2 ? null : Boolean.TRUE));
    }

    @ApiStatus.Internal
    public static boolean isEnabled(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(18);
        }
        return !Boolean.TRUE.equals(DISABLE_FOR_FILE_KEY.get((UserDataHolder)file2));
    }

    @ApiStatus.Internal
    @Nullable
    public static TrailingSpacesOptions getOptions(@NotNull Document document2) {
        EditorSettingsExternalizable editorSettings;
        FileDocumentManager fileDocumentManager;
        VirtualFile file2;
        if (document2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(19);
        }
        if (document2.isWritable() && (file2 = (fileDocumentManager = FileDocumentManager.getInstance()).getFile(document2)) != null && file2.isValid() && !Boolean.TRUE.equals(DISABLE_FOR_FILE_KEY.get((UserDataHolder)file2)) && (editorSettings = EditorSettingsExternalizable.getInstance()) != null) {
            List<Editor> activeEditors = TrailingSpacesStripper.getActiveEditors(document2);
            Project project2 = TrailingSpacesStripper.getProject(document2, activeEditors);
            MyTrailingSpacesOptions currOptions = new MyTrailingSpacesOptions();
            if (project2 != null) {
                for (TrailingSpacesOptionsProvider provider : TrailingSpacesOptionsProvider.EP_NAME.getExtensionList()) {
                    TrailingSpacesOptionsProvider.Options providerOptions = provider.getOptions(project2, file2);
                    if (providerOptions == null) continue;
                    currOptions.setStripTrailingSpaces(providerOptions.getStripTrailingSpaces());
                    currOptions.setEnsureNewLineAtEOF(providerOptions.getEnsureNewLineAtEOF());
                    currOptions.setRemoveTrailingBlankLines(providerOptions.getRemoveTrailingBlankLines());
                    currOptions.setChangedLinesOnly(providerOptions.getChangedLinesOnly());
                    currOptions.setKeepTrailingSpacesOnCaretLine(providerOptions.getKeepTrailingSpacesOnCaretLine());
                }
            }
            return currOptions;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentRunnable";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/TrailingSpacesStripper";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/TrailingSpacesStripper";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentSaving";
                break;
            }
            case 1: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeTrailngBlankLines";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performUndoableWrite";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearLineModificationFlags";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActiveEditors";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActiveLocalEditor";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runBatchCaretOperation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "documentDeleted";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    private static final class MyTrailingSpacesOptions
    implements TrailingSpacesOptions {
        @Nullable
        private Boolean myStripTrailingSpaces;
        @Nullable
        private Boolean myEnsureNewLineAtEOF;
        @Nullable
        private Boolean myRemoveTrailingBlankLines;
        @Nullable
        private Boolean myChangedLinesOnly;
        @Nullable
        private Boolean myKeepTrailingSpacesOnCaretLine;
        private final EditorSettingsExternalizable myEditorSettings = EditorSettingsExternalizable.getInstance();

        private MyTrailingSpacesOptions() {
        }

        private void setStripTrailingSpaces(@Nullable Boolean stripTrailingSpaces) {
            if (stripTrailingSpaces != null && this.myStripTrailingSpaces == null) {
                this.myStripTrailingSpaces = stripTrailingSpaces;
            }
        }

        private void setRemoveTrailingBlankLines(@Nullable Boolean removeTrailingBlankLines) {
            if (removeTrailingBlankLines != null && this.myRemoveTrailingBlankLines == null) {
                this.myRemoveTrailingBlankLines = removeTrailingBlankLines;
            }
        }

        private void setEnsureNewLineAtEOF(@Nullable Boolean ensureNewLineAtEOF) {
            if (ensureNewLineAtEOF != null && this.myEnsureNewLineAtEOF == null) {
                this.myEnsureNewLineAtEOF = ensureNewLineAtEOF;
            }
        }

        private void setChangedLinesOnly(@Nullable Boolean changedLinesOnly) {
            if (changedLinesOnly != null && this.myChangedLinesOnly == null) {
                this.myChangedLinesOnly = changedLinesOnly;
            }
        }

        private void setKeepTrailingSpacesOnCaretLine(@Nullable Boolean keepTrailingSpacesOnCaretLine) {
            if (keepTrailingSpacesOnCaretLine != null && this.myKeepTrailingSpacesOnCaretLine == null) {
                this.myKeepTrailingSpacesOnCaretLine = keepTrailingSpacesOnCaretLine;
            }
        }

        public boolean isStripTrailingSpaces() {
            return this.myStripTrailingSpaces != null ? this.myStripTrailingSpaces : !"None".equals(this.myEditorSettings.getStripTrailingSpaces());
        }

        public boolean isRemoveTrailingBlankLines() {
            return this.myRemoveTrailingBlankLines != null ? this.myRemoveTrailingBlankLines.booleanValue() : this.myEditorSettings.isRemoveTrailingBlankLines();
        }

        public boolean isEnsureNewLineAtEOF() {
            return this.myEnsureNewLineAtEOF != null ? this.myEnsureNewLineAtEOF.booleanValue() : this.myEditorSettings.isEnsureNewLineAtEOF();
        }

        public boolean isChangedLinesOnly() {
            return this.myChangedLinesOnly != null ? this.myChangedLinesOnly : !"Whole".equals(this.myEditorSettings.getStripTrailingSpaces());
        }

        public boolean isKeepTrailingSpacesOnCaretLine() {
            return this.myKeepTrailingSpacesOnCaretLine != null ? this.myKeepTrailingSpacesOnCaretLine.booleanValue() : this.myEditorSettings.isKeepTrailingSpacesOnCaretLine();
        }
    }
}

