/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.impl.stickyLines.StickyLinesModel;
import com.intellij.openapi.editor.impl.stickyLines.VisualStickyLine;
import com.intellij.openapi.editor.impl.stickyLines.VisualStickyLines;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineColors;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLinesPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u0014J\u0006\u0010\u001e\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0014J\u0006\u0010!\u001a\u00020\u001aJ\u0006\u0010\"\u001a\u00020\u001aJ\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001aH\u0016J\b\u0010'\u001a\u00020\u001aH\u0016J\u0012\u0010(\u001a\u00020\u001a2\b\b\u0002\u0010)\u001a\u00020\u0017H\u0002J\b\u0010*\u001a\u00020\u001aH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010,\u001a\u00020\u0017H\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesManager;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesModel$Listener;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "stickyModel", "Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesModel;", "stickyPanel", "Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLinesPanel;", "stickyColors", "Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineColors;", "visualStickyLines", "Lcom/intellij/openapi/editor/impl/stickyLines/VisualStickyLines;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesModel;Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLinesPanel;Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineColors;Lcom/intellij/openapi/editor/impl/stickyLines/VisualStickyLines;Lcom/intellij/openapi/Disposable;)V", "activeVisualArea", "Ljava/awt/Rectangle;", "activeVisualLine", "", "activeLineHeight", "activeIsEnabled", "", "activeLineLimit", "repaintLines", "", "startVisualLine", "endVisualLine", "panelHeight", "startDumb", "suppressHintForLine", "logicalLine", "reinitSettings", "clearStickyModel", "visibleAreaChanged", "event", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "linesUpdated", "dispose", "recalculateAndRepaintLines", "force", "resetLines", "isAreaChanged", "isLineChanged", "isYChanged", "isSizeChanged", "isPoint", "rectangle", "intellij.platform.ide.impl"})
public final class StickyLinesManager
implements VisibleAreaListener,
StickyLinesModel.Listener,
Disposable {
    @NotNull
    private final Editor editor;
    @NotNull
    private final StickyLinesModel stickyModel;
    @NotNull
    private final StickyLinesPanel stickyPanel;
    @NotNull
    private final StickyLineColors stickyColors;
    @NotNull
    private final VisualStickyLines visualStickyLines;
    @NotNull
    private Rectangle activeVisualArea;
    private int activeVisualLine;
    private int activeLineHeight;
    private boolean activeIsEnabled;
    private int activeLineLimit;

    public StickyLinesManager(@NotNull Editor editor2, @NotNull StickyLinesModel stickyModel, @NotNull StickyLinesPanel stickyPanel, @NotNull StickyLineColors stickyColors, @NotNull VisualStickyLines visualStickyLines, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)stickyModel, (String)"stickyModel");
        Intrinsics.checkNotNullParameter((Object)((Object)stickyPanel), (String)"stickyPanel");
        Intrinsics.checkNotNullParameter((Object)stickyColors, (String)"stickyColors");
        Intrinsics.checkNotNullParameter((Object)visualStickyLines, (String)"visualStickyLines");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.editor = editor2;
        this.stickyModel = stickyModel;
        this.stickyPanel = stickyPanel;
        this.stickyColors = stickyColors;
        this.visualStickyLines = visualStickyLines;
        this.activeVisualArea = new Rectangle();
        this.activeVisualLine = -1;
        this.activeLineHeight = -1;
        this.activeLineLimit = -1;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this, (Disposable)this);
        this.stickyModel.addListener(this);
    }

    public final void repaintLines(int startVisualLine, int endVisualLine) {
        this.stickyPanel.repaintLines(startVisualLine, endVisualLine);
    }

    public final int panelHeight() {
        return this.visualStickyLines.height();
    }

    public final void startDumb() {
        this.stickyPanel.startDumb();
    }

    public final boolean suppressHintForLine(int logicalLine) {
        for (VisualStickyLine line : this.visualStickyLines.lines(this.activeVisualArea)) {
            VisualPosition stickyVisualPos = new VisualPosition(line.primaryLine(), 0);
            int stickyLogicalLine = this.editor.visualToLogicalPosition((VisualPosition)stickyVisualPos).line;
            if (logicalLine != stickyLogicalLine && logicalLine != stickyLogicalLine - 1 && logicalLine != stickyLogicalLine + 1) continue;
            return true;
        }
        return false;
    }

    public final void reinitSettings() {
        boolean oldIsEnabled = this.activeIsEnabled;
        boolean newIsEnabled = this.editor.getSettings().areStickyLinesShown();
        int oldLineLimit = this.activeLineLimit;
        int newLineLimit = this.editor.getSettings().getStickyLinesLimit();
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        boolean colorsChanged = this.stickyColors.updateScheme(editorColorsScheme);
        this.activeIsEnabled = newIsEnabled;
        this.activeLineLimit = newLineLimit;
        if (newIsEnabled && !oldIsEnabled) {
            this.recalculateAndRepaintLines(true);
        } else if (!newIsEnabled && oldIsEnabled) {
            this.resetLines();
        } else if (newLineLimit != oldLineLimit) {
            StickyLinesManager.recalculateAndRepaintLines$default(this, false, 1, null);
        } else if (colorsChanged) {
            this.repaintLines();
        }
    }

    public final void clearStickyModel() {
        Project project2 = this.editor.getProject();
        Intrinsics.checkNotNull((Object)project2);
        this.stickyModel.removeAllStickyLines(project2);
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.editor.getSettings().areStickyLinesShown() && this.isAreaChanged(event)) {
            Rectangle rectangle = event.getNewRectangle();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getNewRectangle(...)");
            this.activeVisualArea = rectangle;
            if (this.activeVisualArea.y < 3) {
                this.resetLines();
            } else if (event.getOldRectangle() == null || this.isLineChanged()) {
                StickyLinesManager.recalculateAndRepaintLines$default(this, false, 1, null);
            } else if (this.isYChanged(event) || this.isSizeChanged(event)) {
                this.repaintLines();
            }
        }
    }

    @Override
    public void linesUpdated() {
        StickyLinesManager.recalculateAndRepaintLines$default(this, false, 1, null);
    }

    public void dispose() {
        this.stickyModel.removeListener(this);
    }

    private final void recalculateAndRepaintLines(boolean force) {
        if (force) {
            Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            this.activeVisualArea = rectangle;
            this.isLineChanged();
        }
        if (this.activeVisualLine != -1 && this.activeLineHeight != -1 && !this.isPoint(this.activeVisualArea)) {
            this.visualStickyLines.recalculate(this.activeVisualArea);
            this.repaintLines();
        }
    }

    static /* synthetic */ void recalculateAndRepaintLines$default(StickyLinesManager stickyLinesManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        stickyLinesManager.recalculateAndRepaintLines(bl);
    }

    private final void resetLines() {
        this.activeVisualLine = -1;
        this.activeLineHeight = -1;
        this.visualStickyLines.clear();
        this.repaintLines();
    }

    private final void repaintLines() {
        this.stickyPanel.repaintLines();
    }

    private final boolean isAreaChanged(VisibleAreaEvent event) {
        Rectangle oldRectangle = event.getOldRectangle();
        return oldRectangle == null || oldRectangle.y != event.getNewRectangle().y || oldRectangle.height != event.getNewRectangle().height || oldRectangle.width != event.getNewRectangle().width;
    }

    private final boolean isLineChanged() {
        int newVisualLine = this.editor.yToVisualLine(this.activeVisualArea.y);
        int newLineHeight = this.editor.getLineHeight();
        if (this.activeVisualLine != newVisualLine || this.activeLineHeight != newLineHeight) {
            this.activeVisualLine = newVisualLine;
            this.activeLineHeight = newLineHeight;
            return true;
        }
        return false;
    }

    private final boolean isYChanged(VisibleAreaEvent event) {
        return event.getOldRectangle().y != event.getNewRectangle().y;
    }

    private final boolean isSizeChanged(VisibleAreaEvent event) {
        return event.getOldRectangle().width != event.getNewRectangle().width || event.getOldRectangle().height != event.getNewRectangle().height;
    }

    private final boolean isPoint(Rectangle rectangle) {
        return rectangle.x == 0 && rectangle.y == 0 && rectangle.height == 0 && rectangle.width == 0;
    }
}

