/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.stickyLines.StickyLine;
import com.intellij.openapi.editor.impl.stickyLines.StickyLinesModel;
import com.intellij.openapi.editor.impl.stickyLines.VisualStickyLine;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0007J\u0006\u0010\u001b\u001a\u00020\u0015J,\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0002J\u001e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J$\u0010\u001f\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0002J,\u0010 \u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0002J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0002J \u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0018\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/VisualStickyLines;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "stickyModel", "Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesModel;", "scopeMinSize", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesModel;I)V", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesModel;)V", "logicalStickyLines", "", "Lcom/intellij/openapi/editor/impl/stickyLines/StickyLine;", "visualStickyLines", "Lcom/intellij/openapi/editor/impl/stickyLines/VisualStickyLine;", "visualWithYStickyLines", "totalHeight", "lineHeight", "lineLimit", "recalculate", "", "visibleArea", "Ljava/awt/Rectangle;", "lines", "", "height", "clear", "logicalLines", "visualLines", "collectLogical", "logicalToVisualLines", "setYLocation", "withYLocation", "toVisualLine", "logicalLine", "isPanelTooBig", "", "panelHeight", "editorHeight", "isScopeNotNarrow", "primaryVisual", "scopeVisual", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class VisualStickyLines {
    @NotNull
    private final Editor editor;
    @NotNull
    private final StickyLinesModel stickyModel;
    private final int scopeMinSize;
    @NotNull
    private final List<StickyLine> logicalStickyLines;
    @NotNull
    private final List<VisualStickyLine> visualStickyLines;
    @NotNull
    private final List<VisualStickyLine> visualWithYStickyLines;
    private int totalHeight;
    private int lineHeight;
    private int lineLimit;

    public VisualStickyLines(@NotNull Editor editor2, @NotNull StickyLinesModel stickyModel, int scopeMinSize) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)stickyModel, (String)"stickyModel");
        this.editor = editor2;
        this.stickyModel = stickyModel;
        this.scopeMinSize = scopeMinSize;
        if (!(this.scopeMinSize >= 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.logicalStickyLines = new ArrayList();
        this.visualStickyLines = new ArrayList();
        this.visualWithYStickyLines = new ArrayList();
    }

    public VisualStickyLines(@NotNull Editor editor2, @NotNull StickyLinesModel stickyModel) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)stickyModel, (String)"stickyModel");
        this(editor2, stickyModel, 5);
    }

    public final void recalculate(@NotNull Rectangle visibleArea) {
        Intrinsics.checkNotNullParameter((Object)visibleArea, (String)"visibleArea");
        this.clear();
        this.recalculate(visibleArea, this.logicalStickyLines, this.visualStickyLines);
    }

    @NotNull
    public final List<VisualStickyLine> lines(@NotNull Rectangle visibleArea) {
        Intrinsics.checkNotNullParameter((Object)visibleArea, (String)"visibleArea");
        this.visualWithYStickyLines.clear();
        this.totalHeight = this.setYLocation(visibleArea, this.visualStickyLines, this.visualWithYStickyLines);
        return this.visualWithYStickyLines;
    }

    public final int height() {
        return this.totalHeight;
    }

    public final void clear() {
        this.logicalStickyLines.clear();
        this.visualStickyLines.clear();
        this.visualWithYStickyLines.clear();
        this.totalHeight = 0;
    }

    private final void recalculate(Rectangle visibleArea, List<StickyLine> logicalLines, List<VisualStickyLine> visualLines) {
        this.lineLimit = this.editor.getSettings().getStickyLinesLimit();
        this.lineHeight = this.editor.getLineHeight();
        this.collectLogical(visibleArea, logicalLines);
        this.logicalToVisualLines(logicalLines, visualLines);
    }

    private final void collectLogical(Rectangle visibleArea, List<StickyLine> logicalStickyLines) {
        int maxStickyPanelHeight = this.lineHeight * this.lineLimit + 1;
        int yStart = visibleArea.y;
        int yEnd = yStart + maxStickyPanelHeight;
        int startLine = this.editor.xyToLogicalPosition((Point)new Point((int)0, (int)yStart)).line;
        int endLine = this.editor.xyToLogicalPosition((Point)new Point((int)0, (int)yEnd)).line;
        if (!DocumentUtil.isValidLine((int)endLine, (Document)this.editor.getDocument())) {
            if (!DocumentUtil.isValidLine((int)startLine, (Document)this.editor.getDocument())) {
                return;
            }
            endLine = Math.max(this.editor.getDocument().getLineCount() - 1, 0);
        }
        int startOffset = this.editor.getDocument().getLineStartOffset(startLine);
        int endOffset = this.editor.getDocument().getLineEndOffset(endLine);
        this.stickyModel.processStickyLines(startOffset, endOffset, (Processor<? super StickyLine>)((Processor)arg_0 -> VisualStickyLines.collectLogical$lambda$1(arg_0 -> VisualStickyLines.collectLogical$lambda$0(logicalStickyLines, arg_0), arg_0)));
    }

    private final void logicalToVisualLines(List<StickyLine> logicalLines, List<VisualStickyLine> visualLines) {
        if (logicalLines.isEmpty()) {
            return;
        }
        Set deduplicatedLines = new HashSet();
        for (StickyLine logicalLine : logicalLines) {
            int scopeVisual;
            int primaryVisual = this.toVisualLine(logicalLine.primaryLine());
            boolean isNotDuplicate = deduplicatedLines.add(primaryVisual);
            if (!isNotDuplicate || !this.isScopeNotNarrow(primaryVisual, scopeVisual = this.toVisualLine(logicalLine.scopeLine()))) continue;
            visualLines.add(new VisualStickyLine(logicalLine, primaryVisual, scopeVisual, 0, 8, null));
        }
        CollectionsKt.sort(visualLines);
    }

    private final int setYLocation(Rectangle visibleArea, List<VisualStickyLine> visualLines, List<VisualStickyLine> withYLocation) {
        if (visualLines.isEmpty()) {
            return 0;
        }
        int totalPanelHeight = 0;
        int editorY = visibleArea.y;
        int editorH = visibleArea.height;
        if (this.isPanelTooBig(this.lineHeight, totalPanelHeight, editorH)) {
            return 0;
        }
        for (VisualStickyLine line : visualLines) {
            boolean bl;
            int startY1 = this.editor.visualLineToY(line.primaryLine());
            int startY2 = startY1 + this.lineHeight;
            int endY1 = this.editor.visualLineToY(line.scopeLine());
            int endY2 = endY1 + this.lineHeight;
            int stickyY = editorY + totalPanelHeight + this.lineHeight;
            if (startY2 >= stickyY || stickyY > endY2) continue;
            int yOverlap = stickyY <= endY1 ? 0 : stickyY - endY1;
            boolean bl2 = bl = yOverlap >= 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "startY1: " + startY1 + ", startY2: " + startY2 + ", endY1: " + endY1 + ", endY2: " + endY2 + ", stickyY: " + stickyY;
                throw new AssertionError((Object)string);
            }
            line.setYLocation(totalPanelHeight - yOverlap);
            totalPanelHeight += this.lineHeight - yOverlap;
            if (this.lineHeight > yOverlap) {
                withYLocation.add(line);
            }
            if (yOverlap <= 0 && withYLocation.size() < this.lineLimit && !this.isPanelTooBig(this.lineHeight, totalPanelHeight, editorH)) continue;
            break;
        }
        return totalPanelHeight;
    }

    private final int toVisualLine(int logicalLine) {
        return this.editor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)logicalLine, (int)0)).line;
    }

    private final boolean isPanelTooBig(int lineHeight, int panelHeight, int editorHeight) {
        return panelHeight + 2 * lineHeight > editorHeight / 2;
    }

    private final boolean isScopeNotNarrow(int primaryVisual, int scopeVisual) {
        return scopeVisual - primaryVisual + 1 >= this.scopeMinSize;
    }

    private static final boolean collectLogical$lambda$0(List $logicalStickyLines, StickyLine stickyLine) {
        Intrinsics.checkNotNull((Object)stickyLine);
        $logicalStickyLines.add(stickyLine);
        return true;
    }

    private static final boolean collectLogical$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

