/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.InspectionsState;
import com.intellij.openapi.editor.markup.PassWrapper;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.util.ui.EmptyIcon;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB3\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0004\b\t\u0010\rJ\u000e\u00102\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0016J\u000e\u00103\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u001cJ\u0010\u00104\u001a\u00020\u00002\b\b\u0001\u00105\u001a\u00020\u0005J\u0014\u00106\u001a\u00020\u00002\f\u00105\u001a\b\u0012\u0004\u0012\u00020#0\"J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020-J\u0014\u00109\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\"J\u0006\u0010:\u001a\u00020\u001cJ\u000e\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u0000J\u0006\u0010=\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0006\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R \u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R \u0010(\u001a\b\u0012\u0004\u0012\u00020)0\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010%\"\u0004\b+\u0010'R\u001e\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020-@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/openapi/editor/markup/AnalyzerStatus;", "", "icon", "Ljavax/swing/Icon;", "title", "", "details", "controller", "Lcom/intellij/openapi/editor/markup/UIController;", "<init>", "(Ljavax/swing/Icon;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/editor/markup/UIController;)V", "controllerCreator", "Lkotlin/Function0;", "(Ljavax/swing/Icon;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getIcon", "()Ljavax/swing/Icon;", "getTitle", "()Ljava/lang/String;", "getDetails", "getController", "()Lcom/intellij/openapi/editor/markup/UIController;", "inspectionsState", "Lcom/intellij/openapi/editor/markup/InspectionsState;", "getInspectionsState", "()Lcom/intellij/openapi/editor/markup/InspectionsState;", "setInspectionsState", "(Lcom/intellij/openapi/editor/markup/InspectionsState;)V", "showNavigation", "", "getShowNavigation", "()Z", "setShowNavigation", "(Z)V", "expandedStatus", "", "Lcom/intellij/openapi/editor/markup/StatusItem;", "getExpandedStatus", "()Ljava/util/List;", "setExpandedStatus", "(Ljava/util/List;)V", "passes", "Lcom/intellij/openapi/editor/markup/PassWrapper;", "getPasses", "setPasses", "value", "Lcom/intellij/openapi/editor/markup/AnalyzingType;", "analyzingType", "getAnalyzingType", "()Lcom/intellij/openapi/editor/markup/AnalyzingType;", "textStatus", "withState", "withNavigation", "withTextStatus", "status", "withExpandedStatus", "withAnalyzingType", "type", "withPasses", "isTextStatus", "equalsTo", "other", "isEmpty", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class AnalyzerStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Icon icon;
    @NotNull
    private final String title;
    @NotNull
    private final String details;
    @NotNull
    private final UIController controller;
    @Nullable
    private InspectionsState inspectionsState;
    private boolean showNavigation;
    @NotNull
    private List<StatusItem> expandedStatus;
    @NotNull
    private List<PassWrapper> passes;
    @NotNull
    private AnalyzingType analyzingType;
    private boolean textStatus;
    @NotNull
    private static final AnalyzerStatus EMPTY;
    @ApiStatus.Internal
    @NotNull
    private static final UIController EmptyController;

    public AnalyzerStatus(@NotNull Icon icon2, @Nls @NotNull String title2, @Nls @NotNull String details, @NotNull UIController controller) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.icon = icon2;
        this.title = title2;
        this.details = details;
        this.controller = controller;
        this.expandedStatus = CollectionsKt.emptyList();
        this.passes = CollectionsKt.emptyList();
        this.analyzingType = AnalyzingType.COMPLETE;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    @Nls
    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @Nls
    @NotNull
    public final String getDetails() {
        return this.details;
    }

    @NotNull
    public final UIController getController() {
        return this.controller;
    }

    @Deprecated(message="use primary constructor")
    public AnalyzerStatus(@NotNull Icon icon2, @Nls @NotNull String title2, @Nls @NotNull String details, @NotNull Function0<? extends UIController> controllerCreator) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        Intrinsics.checkNotNullParameter(controllerCreator, (String)"controllerCreator");
        this(icon2, title2, details, (UIController)controllerCreator.invoke());
    }

    @Nullable
    public final InspectionsState getInspectionsState() {
        return this.inspectionsState;
    }

    public final void setInspectionsState(@Nullable InspectionsState inspectionsState) {
        this.inspectionsState = inspectionsState;
    }

    public final boolean getShowNavigation() {
        return this.showNavigation;
    }

    public final void setShowNavigation(boolean bl) {
        this.showNavigation = bl;
    }

    @NotNull
    public final List<StatusItem> getExpandedStatus() {
        return this.expandedStatus;
    }

    public final void setExpandedStatus(@NotNull List<StatusItem> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.expandedStatus = list2;
    }

    @NotNull
    public final List<PassWrapper> getPasses() {
        return this.passes;
    }

    public final void setPasses(@NotNull List<PassWrapper> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.passes = list2;
    }

    @NotNull
    public final AnalyzingType getAnalyzingType() {
        return this.analyzingType;
    }

    @NotNull
    public final AnalyzerStatus withState(@NotNull InspectionsState value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.inspectionsState = value;
        return this;
    }

    @NotNull
    public final AnalyzerStatus withNavigation(boolean value) {
        this.showNavigation = value;
        return this;
    }

    @NotNull
    public final AnalyzerStatus withTextStatus(@Nls @NotNull String status2) {
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        List<StatusItem> list2 = Collections.singletonList(new StatusItem(status2, null, null, null, 14, null));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"singletonList(...)");
        this.expandedStatus = list2;
        this.textStatus = true;
        return this;
    }

    @NotNull
    public final AnalyzerStatus withExpandedStatus(@NotNull List<StatusItem> status2) {
        Intrinsics.checkNotNullParameter(status2, (String)"status");
        this.expandedStatus = status2;
        return this;
    }

    @NotNull
    public final AnalyzerStatus withAnalyzingType(@NotNull AnalyzingType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.analyzingType = type;
        return this;
    }

    @NotNull
    public final AnalyzerStatus withPasses(@NotNull List<PassWrapper> passes) {
        Intrinsics.checkNotNullParameter(passes, (String)"passes");
        this.passes = passes;
        return this;
    }

    public final boolean isTextStatus() {
        return this.textStatus;
    }

    public final boolean equalsTo(@NotNull AnalyzerStatus other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.icon, (Object)other.icon) && Intrinsics.areEqual(this.expandedStatus, other.expandedStatus) && Intrinsics.areEqual((Object)this.title, (Object)other.title) && Intrinsics.areEqual((Object)this.details, (Object)other.details) && this.showNavigation == other.showNavigation && Intrinsics.areEqual(this.passes, other.passes);
    }

    public final boolean isEmpty() {
        return Intrinsics.areEqual((Object)this, (Object)EMPTY);
    }

    @NotNull
    public static final AnalyzerStatus getEMPTY() {
        return Companion.getEMPTY();
    }

    @NotNull
    public static final UIController getEmptyController() {
        return Companion.getEmptyController();
    }

    static {
        Icon icon2 = EmptyIcon.ICON_0;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ICON_0");
        UIController uIController = UIController.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)uIController, (String)"EMPTY");
        EMPTY = new AnalyzerStatus(icon2, "", "", uIController);
        UIController uIController2 = UIController.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)uIController2, (String)"EMPTY");
        EmptyController = uIController2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/editor/markup/AnalyzerStatus$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/openapi/editor/markup/AnalyzerStatus;", "getEMPTY$annotations", "getEMPTY", "()Lcom/intellij/openapi/editor/markup/AnalyzerStatus;", "EmptyController", "Lcom/intellij/openapi/editor/markup/UIController;", "getEmptyController$annotations", "getEmptyController", "()Lcom/intellij/openapi/editor/markup/UIController;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnalyzerStatus getEMPTY() {
            return EMPTY;
        }

        @JvmStatic
        public static /* synthetic */ void getEMPTY$annotations() {
        }

        @NotNull
        public final UIController getEmptyController() {
            return EmptyController;
        }

        @JvmStatic
        @Deprecated(message="use UIController.EMPTY")
        public static /* synthetic */ void getEmptyController$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

