/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

class TextComponentDocument
extends UserDataHolderBase
implements Document {
    private final JTextComponent myTextComponent;

    TextComponentDocument(JTextComponent textComponent) {
        this.myTextComponent = textComponent;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        String string;
        try {
            javax.swing.text.Document document2 = this.myTextComponent.getDocument();
            string = document2.getText(0, document2.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            TextComponentDocument.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText(@NotNull TextRange range) {
        String string;
        if (range == null) {
            TextComponentDocument.$$$reportNull$$$0(1);
        }
        try {
            javax.swing.text.Document document2 = this.myTextComponent.getDocument();
            string = document2.getText(range.getStartOffset(), range.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            TextComponentDocument.$$$reportNull$$$0(2);
        }
        return string;
    }

    public int getTextLength() {
        return this.myTextComponent.getDocument().getLength();
    }

    public int getLineCount() {
        return 1;
    }

    public int getLineNumber(int offset) {
        return 0;
    }

    public int getLineStartOffset(int line) {
        return 0;
    }

    public int getLineEndOffset(int line) {
        return this.getTextLength();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            TextComponentDocument.$$$reportNull$$$0(3);
        }
        try {
            this.myTextComponent.getDocument().insertString(offset, s.toString(), null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        try {
            this.myTextComponent.getDocument().remove(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            TextComponentDocument.$$$reportNull$$$0(4);
        }
        javax.swing.text.Document document2 = this.myTextComponent.getDocument();
        try {
            document2.remove(startOffset, endOffset - startOffset);
            document2.insertString(startOffset, s.toString(), null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isWritable() {
        return true;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            TextComponentDocument.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/textarea/TextComponentDocument";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableCharSequence";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/textarea/TextComponentDocument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

