/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserPanel;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.fileChooser.actions.FileNameInputValidator;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.IoErrorText;
import java.awt.Component;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewFolderAction
extends FileChooserAction
implements LightEditCompatible {
    NewFolderAction() {
    }

    public NewFolderAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
        super(text2, description, icon2);
    }

    @Override
    protected void update(@NotNull FileChooserPanel panel2, @NotNull AnActionEvent e) {
        if (panel2 == null) {
            NewFolderAction.$$$reportNull$$$0(0);
        }
        if (e == null) {
            NewFolderAction.$$$reportNull$$$0(1);
        }
        Path directory = panel2.currentDirectory();
        e.getPresentation().setEnabled(directory != null && !directory.getFileSystem().isReadOnly());
    }

    @Override
    protected void actionPerformed(@NotNull FileChooserPanel panel2, @NotNull AnActionEvent e) {
        String input;
        Path directory;
        if (panel2 == null) {
            NewFolderAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            NewFolderAction.$$$reportNull$$$0(3);
        }
        if ((directory = panel2.currentDirectory()) == null || directory.getFileSystem().isReadOnly()) {
            return;
        }
        String title2 = UIBundle.message((String)"file.chooser.new.dir.title", (Object[])new Object[0]);
        String prompt = UIBundle.message((String)"file.chooser.new.dir.prompt", (Object[])new Object[0]);
        String initial = "newDirectory";
        TextRange selection = new TextRange(0, initial.length());
        FileNameInputValidator validator2 = new FileNameInputValidator(directory.getFileSystem());
        while ((input = MessagesService.getInstance().showInputDialog(null, (Component)panel2.getComponent(), prompt, title2, null, initial, (InputValidator)validator2, selection, null)) != null) {
            String name2;
            initial = name2 = input.trim();
            selection = null;
            try {
                String progress = UIBundle.message((String)"file.chooser.creating.progress", (Object[])new Object[]{name2});
                panel2.reloadAfter(() -> (Path)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Path, IOException>(this, e.getProject(), panel2.getComponent(), progress, true){

                    protected Path compute(@NotNull ProgressIndicator indicator2) throws IOException {
                        if (indicator2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        indicator2.setIndeterminate(true);
                        Path newDirectory = directory.resolve(name2);
                        if (Files.exists(newDirectory, new LinkOption[0])) {
                            throw new FileAlreadyExistsException(newDirectory.toString());
                        }
                        NioFiles.createDirectories((Path)newDirectory);
                        return newDirectory;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileChooser/actions/NewFolderAction$1", "compute"));
                    }
                }));
                break;
            }
            catch (IOException | InvalidPathException ex) {
                Messages.showErrorDialog((Component)panel2.getComponent(), (String)IoErrorText.message((Throwable)ex), (String)CommonBundle.getErrorTitle());
            }
        }
    }

    @Override
    protected void update(@NotNull FileSystemTree fileSystemTree, @NotNull AnActionEvent e) {
        if (fileSystemTree == null) {
            NewFolderAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            NewFolderAction.$$$reportNull$$$0(5);
        }
        VirtualFile parent = fileSystemTree.getNewFileParent();
        e.getPresentation().setEnabled(parent != null && parent.isDirectory());
    }

    @Override
    protected void actionPerformed(@NotNull FileSystemTree fileSystemTree, @NotNull AnActionEvent e) {
        VirtualFile parent;
        if (fileSystemTree == null) {
            NewFolderAction.$$$reportNull$$$0(6);
        }
        if (e == null) {
            NewFolderAction.$$$reportNull$$$0(7);
        }
        if ((parent = fileSystemTree.getNewFileParent()) == null || !parent.isDirectory()) {
            return;
        }
        NewFolderValidator validator2 = new NewFolderValidator(parent);
        String newFolderName = Messages.showInputDialog((String)UIBundle.message((String)"create.new.folder.enter.new.folder.name.prompt.text", (Object[])new Object[0]), (String)UIBundle.message((String)"new.folder.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator2);
        if (newFolderName == null) {
            return;
        }
        Exception failReason = ((FileSystemTreeImpl)fileSystemTree).createNewFolder(parent, newFolderName);
        if (failReason != null) {
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.folder.could.not.create.folder.error.message", (Object[])new Object[]{newFolderName}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystemTree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileChooser/actions/NewFolderAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class NewFolderValidator
    implements InputValidatorEx {
        private final VirtualFile myDirectory;
        private @NlsContexts.DetailedDescription String myErrorText;

        NewFolderValidator(VirtualFile directory) {
            this.myDirectory = directory;
        }

        @Nullable
        public String getErrorText(String inputString) {
            return this.myErrorText;
        }

        public boolean checkInput(String inputString) {
            boolean firstToken = true;
            for (String token : StringUtil.tokenize((String)inputString, (String)"\\/")) {
                VirtualFile child;
                if (firstToken && (child = this.myDirectory.findChild(token)) != null) {
                    this.myErrorText = child.isDirectory() ? IdeBundle.message((String)"dialog.message.folder.with.name.already.exists", (Object[])new Object[]{token}) : IdeBundle.message((String)"dialog.message.file.with.name.already.exists", (Object[])new Object[]{token});
                    return false;
                }
                firstToken = false;
                if (token.equals(".") || token.equals("..")) {
                    this.myErrorText = IdeBundle.message((String)"directory.message.cant.create.folder", (Object[])new Object[]{token});
                    return false;
                }
                if (!FileTypeManager.getInstance().isFileIgnored(token)) continue;
                this.myErrorText = IdeBundle.message((String)"dialog.message.trying.to.create.folder.with.ignored.name", (Object[])new Object[0]);
                return true;
            }
            this.myErrorText = null;
            return !inputString.isEmpty();
        }
    }
}

