/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.UIBundle;
import com.intellij.util.UriUtil;
import com.intellij.util.system.OS;
import com.jetbrains.JBRFileDialog;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.KeyboardFocusManager;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0015J6\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u000b\u0010\u001e\u001a\u00070\u0007\u00a2\u0006\u0002\b\u001f\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/fileChooser/impl/FileChooserDialogHelper;", "Lcom/intellij/openapi/Disposable;", "descriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "<init>", "(Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;)V", "ZIP_FS_TYPE", "", "getZIP_FS_TYPE$annotations", "()V", "localFs", "Lkotlin/Lazy;", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "jarFs", "dispose", "", "setNativeDialogProperties", "setFileFilter", "fileDialog", "Lcom/jetbrains/JBRFileDialog;", "showNativeDialog", "Ljava/awt/FileDialog;", "selectedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "paths", "", "Ljava/nio/file/Path;", "parent", "Ljava/awt/Component;", "title", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "(Ljava/util/List;Ljava/awt/Component;Ljava/lang/String;)[Lcom/intellij/openapi/vfs/VirtualFile;", "toVirtualFile", "path", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFileChooserDialogHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileChooserDialogHelper.kt\ncom/intellij/openapi/fileChooser/impl/FileChooserDialogHelper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n37#2,2:152\n1#3:154\n*S KotlinDebug\n*F\n+ 1 FileChooserDialogHelper.kt\ncom/intellij/openapi/fileChooser/impl/FileChooserDialogHelper\n*L\n64#1:152,2\n*E\n"})
public final class FileChooserDialogHelper
implements Disposable {
    @NotNull
    private final FileChooserDescriptor descriptor;
    @NotNull
    private final String ZIP_FS_TYPE;
    @NotNull
    private final Lazy<VirtualFileSystem> localFs;
    @NotNull
    private final Lazy<VirtualFileSystem> jarFs;

    public FileChooserDialogHelper(@NotNull FileChooserDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.descriptor = descriptor2;
        this.ZIP_FS_TYPE = "zipfs";
        this.localFs = LazyKt.lazy(FileChooserDialogHelper::localFs$lambda$0);
        this.jarFs = LazyKt.lazy(FileChooserDialogHelper::jarFs$lambda$0);
        if (!FileTypeRegistry.isInstanceSupplierSet()) {
            CoreFileTypeRegistry registry = new CoreFileTypeRegistry();
            registry.registerFileType((FileType)ArchiveFileType.INSTANCE, "zip");
            registry.registerFileType((FileType)ArchiveFileType.INSTANCE, "jar");
            FileTypeRegistry.setInstanceSupplier(() -> FileChooserDialogHelper._init_$lambda$0(registry), (Disposable)this);
        }
    }

    private static /* synthetic */ void getZIP_FS_TYPE$annotations() {
    }

    public void dispose() {
    }

    public final void setNativeDialogProperties() {
        if (OS.CURRENT == OS.Windows) {
            System.setProperty("sun.awt.windows.useCommonItemDialog", "true");
        }
    }

    public final void setFileFilter(@NotNull JBRFileDialog fileDialog, @NotNull FileChooserDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)fileDialog, (String)"fileDialog");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        com.intellij.openapi.util.Pair extFilter = descriptor2.getExtensionFilter();
        if (extFilter != null) {
            Object object = extFilter.second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
            Collection $this$toTypedArray$iv = (Collection)object;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] fileTypes = thisCollection$iv.toArray(new String[0]);
            if (OS.CURRENT == OS.macOS) {
                int n = fileTypes.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    String string = fileTypes[i2];
                    Intrinsics.checkNotNull((Object)string);
                    int p = StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
                    if (p < 0) continue;
                    String string2 = fileTypes[i2];
                    Intrinsics.checkNotNull((Object)string2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2.substring(p + 1), (String)"substring(...)");
                }
            }
            fileDialog.setFileFilterExtensions((String)extFilter.first, fileTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void showNativeDialog(@NotNull FileDialog fileDialog) {
        Intrinsics.checkNotNullParameter((Object)fileDialog, (String)"fileDialog");
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            LaterInvocator.enterModal((Object)fileDialog);
        }
        Component previousFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        try {
            fileDialog.setVisible(true);
        }
        finally {
            if (app != null) {
                LaterInvocator.leaveModal((Object)fileDialog);
            }
            Component component2 = previousFocusOwner;
            if (component2 != null) {
                component2.requestFocus();
            }
            Disposer.dispose((Disposable)this);
        }
    }

    @NotNull
    public final VirtualFile[] selectedFiles(@NotNull List<? extends Path> paths, @Nullable Component parent, @NotNull String title2) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Component component2 = parent;
        ModalTaskOwner modalTaskOwner = component2 != null ? ModalTaskOwner.component((Component)component2) : ModalTaskOwner.guess();
        Intrinsics.checkNotNull((Object)modalTaskOwner);
        ModalTaskOwner owner = modalTaskOwner;
        String string = UIBundle.message((String)"file.chooser.vfs.progress", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        modalTaskOwner = (Pair)TasksKt.runWithModalProgressBlocking$default((ModalTaskOwner)owner, (String)string, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends List<VirtualFile>, ? extends List<String>>>, Object>(paths, this, null){
            int label;
            final /* synthetic */ List<Path> $paths;
            final /* synthetic */ FileChooserDialogHelper this$0;
            {
                this.$paths = $paths;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        List results = new ArrayList<E>();
                        List misses = new ArrayList<E>();
                        for (Path path : this.$paths) {
                            VirtualFile adjusted;
                            VirtualFile file2 = FileChooserDialogHelper.access$toVirtualFile(this.this$0, path);
                            VirtualFile virtualFile2 = adjusted = file2 != null && file2.isValid() ? FileChooserDialogHelper.access$getDescriptor$p(this.this$0).getFileToSelect(file2) : null;
                            if (adjusted != null) {
                                ((Collection)results).add(adjusted);
                                continue;
                            }
                            ((Collection)misses).add(path.toUri().toString());
                        }
                        return TuplesKt.to((Object)results, (Object)misses);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Pair<? extends List<VirtualFile>, ? extends List<String>>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)4, null);
        List results = (List)modalTaskOwner.component1();
        List misses = (List)modalTaskOwner.component2();
        if (!((Collection)misses).isEmpty()) {
            String urls = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)misses), FileChooserDialogHelper::selectedFiles$lambda$0), (CharSequence)"<br>", null, null, (int)0, null, null, (int)62, null);
            Object[] objectArray = new Object[]{urls};
            String string2 = UIBundle.message((String)"file.chooser.vfs.lookup", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String message = string2;
            Messages.showErrorDialog((Component)parent, (String)message, (String)title2);
            return new VirtualFile[0];
        }
        if (results.isEmpty()) {
            return new VirtualFile[0];
        }
        try {
            VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)results);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"toVirtualFileArray(...)");
            VirtualFile[] selectedFiles2 = virtualFileArray;
            this.descriptor.validateSelectedFiles(selectedFiles2);
            return selectedFiles2;
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)parent, (String)e.getMessage(), (String)title2);
            return new VirtualFile[0];
        }
    }

    private final VirtualFile toVirtualFile(Path path) {
        VirtualFile virtualFile2;
        if (Intrinsics.areEqual((Object)path.getFileSystem(), (Object)FileSystems.getDefault())) {
            virtualFile2 = ((VirtualFileSystem)this.localFs.getValue()).refreshAndFindFileByPath(((Object)path).toString());
        } else {
            VirtualFile virtualFile3;
            try {
                VirtualFile virtualFile4;
                FileStore store = path.getFileSystem().getFileStores().iterator().next();
                if (Intrinsics.areEqual((Object)store.type(), (Object)this.ZIP_FS_TYPE)) {
                    String string = UriUtil.trimTrailingSlashes((String)store.name());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimTrailingSlashes(...)");
                    String localPath = string;
                    virtualFile4 = ((VirtualFileSystem)this.jarFs.getValue()).refreshAndFindFileByPath(UriUtil.trimTrailingSlashes((String)localPath) + "!" + path);
                } else {
                    virtualFile4 = null;
                }
                virtualFile3 = virtualFile4;
            }
            catch (Exception e) {
                Logger.getInstance(FileChooserDialogHelper.class).warn((Throwable)e);
                virtualFile3 = null;
            }
            virtualFile2 = virtualFile3;
        }
        return virtualFile2;
    }

    private static final VirtualFileSystem localFs$lambda$0() {
        Application application;
        block3: {
            block2: {
                application = ApplicationManager.getApplication();
                if (application == null) break block2;
                Application it = application;
                boolean bl = false;
                VirtualFileSystem virtualFileSystem = StandardFileSystems.local();
                application = virtualFileSystem;
                if (virtualFileSystem != null) break block3;
            }
            application = (VirtualFileSystem)new CoreLocalFileSystem();
        }
        return application;
    }

    private static final VirtualFileSystem jarFs$lambda$0() {
        Application application;
        block3: {
            block2: {
                application = ApplicationManager.getApplication();
                if (application == null) break block2;
                Application it = application;
                boolean bl = false;
                VirtualFileSystem virtualFileSystem = StandardFileSystems.jar();
                application = virtualFileSystem;
                if (virtualFileSystem != null) break block3;
            }
            application = (VirtualFileSystem)new CoreJarFileSystem();
        }
        return application;
    }

    private static final FileTypeRegistry _init_$lambda$0(CoreFileTypeRegistry $registry) {
        return (FileTypeRegistry)$registry;
    }

    private static final String selectedFiles$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "&nbsp;&nbsp;&nbsp;" + it;
    }

    public static final /* synthetic */ VirtualFile access$toVirtualFile(FileChooserDialogHelper $this, Path path) {
        return $this.toVirtualFile(path);
    }

    public static final /* synthetic */ FileChooserDescriptor access$getDescriptor$p(FileChooserDialogHelper $this) {
        return $this.descriptor;
    }
}

