/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileNavigator;
import com.intellij.openapi.fileEditor.FileNavigatorImpl;
import com.intellij.openapi.fileEditor.FileNavigatorImplKt;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ProjectFileNavigatorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/fileEditor/FileNavigatorImpl;", "Lcom/intellij/openapi/fileEditor/FileNavigator;", "<init>", "()V", "ignoreContextEditor", "Ljava/lang/ThreadLocal;", "", "canNavigateToSource", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "navigate", "", "requestFocus", "navigateInEditorOrNativeApp", "navigateInEditor", "navigateInRequestedEditor", "navigateInRequestedEditorAsync", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;Lcom/intellij/openapi/actionSystem/DataContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "navigateIgnoringContextEditor", "navigatable", "Lcom/intellij/pom/Navigatable;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFileNavigatorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileNavigatorImpl.kt\ncom/intellij/openapi/fileEditor/FileNavigatorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,124:1\n1#2:125\n13#3:126\n13#3:127\n74#4,10:128\n*S KotlinDebug\n*F\n+ 1 FileNavigatorImpl.kt\ncom/intellij/openapi/fileEditor/FileNavigatorImpl\n*L\n69#1:126\n82#1:127\n86#1:128,10\n*E\n"})
public final class FileNavigatorImpl
implements FileNavigator {
    @NotNull
    private final ThreadLocal<Boolean> ignoreContextEditor = new ThreadLocal();

    public boolean canNavigateToSource(@NotNull OpenFileDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        VirtualFile virtualFile2 = descriptor2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        VirtualFile file2 = virtualFile2;
        if (file2.isValid()) {
            return FileEditorManager.getInstance((Project)descriptor2.getProject()).canOpenFile(file2) || file2.getFileType() instanceof INativeFileType;
        }
        return false;
    }

    public void navigate(@NotNull OpenFileDescriptor descriptor2, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!this.canNavigate(descriptor2)) {
            boolean bl = false;
            String string = "target not valid";
            throw new IllegalStateException(string.toString());
        }
        if (!descriptor2.getFile().isDirectory() && this.navigateInEditorOrNativeApp(descriptor2, requestFocus)) {
            return;
        }
        Project project2 = descriptor2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ProjectFileNavigatorImpl projectFileNavigatorImpl = ProjectFileNavigatorImpl.Companion.getInstance(project2);
        VirtualFile virtualFile2 = descriptor2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        projectFileNavigatorImpl.scheduleNavigateInProjectView(virtualFile2, requestFocus);
    }

    private final boolean navigateInEditorOrNativeApp(OpenFileDescriptor descriptor2, boolean requestFocus) {
        FileType type = FileTypeManager.getInstance().getKnownFileTypeOrAssociate(descriptor2.getFile(), descriptor2.getProject());
        if (type == null || !descriptor2.getFile().isValid()) {
            return false;
        }
        if (type instanceof INativeFileType) {
            return ((INativeFileType)type).openFileInAssociatedApplication(descriptor2.getProject(), descriptor2.getFile());
        }
        return this.navigateInEditor(descriptor2, requestFocus);
    }

    public boolean navigateInEditor(@NotNull OpenFileDescriptor descriptor2, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.navigateInRequestedEditor(descriptor2) || FileNavigatorImplKt.access$navigateInAnyFileEditor(descriptor2, requestFocus);
    }

    public final boolean navigateInRequestedEditor(@NotNull OpenFileDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (Intrinsics.areEqual((Object)this.ignoreContextEditor.get(), (Object)true)) {
            return false;
        }
        DataContext dataContext2 = DataManager.getInstance().getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext dataContext3 = dataContext2;
        Editor editor2 = (Editor)OpenFileDescriptor.NAVIGATE_IN_EDITOR.getData(dataContext3);
        if (editor2 == null) {
            return false;
        }
        Editor e = editor2;
        if (e.isDisposed()) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(FileNavigatorImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Disposed editor returned for NAVIGATE_IN_EDITOR from " + dataContext3);
            return false;
        }
        if (!Intrinsics.areEqual((Object)FileDocumentManager.getInstance().getFile(e.getDocument()), (Object)descriptor2.getFile())) {
            return false;
        }
        OpenFileDescriptor.navigateInEditor((OpenFileDescriptor)descriptor2, (Editor)e);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object navigateInRequestedEditorAsync(@NotNull OpenFileDescriptor descriptor, @NotNull DataContext dataContext, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof navigateInRequestedEditorAsync.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ FileNavigatorImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.navigateInRequestedEditorAsync(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = (Editor)OpenFileDescriptor.NAVIGATE_IN_EDITOR.getData(dataContext);
                if (v0 == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                e = v0;
                if (e.isDisposed()) {
                    $i$f$logger = false;
                    v1 = Logger.getInstance(FileNavigatorImpl.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                    v1.error("Disposed editor returned for NAVIGATE_IN_EDITOR from " + dataContext);
                    return Boxing.boxBoolean((boolean)false);
                }
                $i$f$serviceAsync = 0;
                v2 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getApplication(...)");
                $this$serviceAsync$iv$iv = (ComponentManager)v2;
                $i$f$serviceAsync = 0;
                $continuation.L$0 = descriptor;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)dataContext);
                $continuation.L$2 = e;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.I$1 = $i$f$serviceAsync;
                $continuation.label = 1;
                v3 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(FileDocumentManager.class, (Continuation)$continuation);
                if (v3 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl49
            }
            case 1: {
                $i$f$serviceAsync = $continuation.I$1;
                $i$f$serviceAsync = $continuation.I$0;
                $this$serviceAsync$iv$iv = (ComponentManager)$continuation.L$3;
                e = (Editor)$continuation.L$2;
                dataContext = (DataContext)$continuation.L$1;
                descriptor = (OpenFileDescriptor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl49:
                // 2 sources

                if (!Intrinsics.areEqual((Object)((FileDocumentManager)v3).getFile(e.getDocument()), (Object)descriptor.getFile())) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)descriptor);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)dataContext);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                $continuation.L$3 = null;
                $continuation.label = 2;
                v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(descriptor, e, null){
                    int label;
                    final /* synthetic */ OpenFileDescriptor $descriptor;
                    final /* synthetic */ Editor $e;
                    {
                        this.$descriptor = $descriptor;
                        this.$e = $e;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                OpenFileDescriptor.navigateInEditor((OpenFileDescriptor)this.$descriptor, (Editor)this.$e);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v4 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl66
            }
            case 2: {
                e = (Editor)$continuation.L$2;
                dataContext = (DataContext)$continuation.L$1;
                descriptor = (OpenFileDescriptor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl66:
                // 2 sources

                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    public final boolean navigateIgnoringContextEditor(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        if (!navigatable.canNavigate()) {
            return false;
        }
        this.ignoreContextEditor.set(true);
        try {
            navigatable.navigate(true);
        }
        finally {
            this.ignoreContextEditor.set(null);
        }
        return true;
    }
}

