/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.featureStatistics.fusCollectors.FileEditorCollector;
import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.ui.UISettings;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.CompositeTabIconHolderCreator;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorAutoClosingHandler;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorCompositeKt;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindow$special$;
import com.intellij.openapi.fileEditor.impl.EditorWindowKt;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.EditorsSplittersKt;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptionsHint;
import com.intellij.openapi.fileEditor.impl.MySplitPainter;
import com.intellij.openapi.fileEditor.impl.SplitterService;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ReadmeShownUsageCollector;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabInfoIconHolder;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010#\n\u0002\b\n\u0018\u0000 \u00c9\u00012\u00020\u0001:\u0006\u00c9\u0001\u00ca\u0001\u00cb\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'J\u0018\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020 2\b\u0010)\u001a\u0004\u0018\u00010*J\u000e\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u0013J\b\u00102\u001a\u00020$H\u0002J\u0010\u0010<\u001a\u0004\u0018\u00010;2\u0006\u0010>\u001a\u00020\u0013J\n\u0010?\u001a\u0004\u0018\u00010@H\u0007J\f\u0010E\u001a\b\u0012\u0004\u0012\u00020;0FJ\u0013\u0010L\u001a\b\u0012\u0004\u0012\u00020@0FH\u0001\u00a2\u0006\u0002\bRJ\u0019\u0010W\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020\u00000XH\u0000\u00a2\u0006\u0002\bZJ\u0018\u0010[\u001a\u00020$2\u0006\u0010\\\u001a\u00020;2\u0006\u0010]\u001a\u00020\u0013H\u0007J\u0016\u0010^\u001a\u00020$2\u0006\u0010_\u001a\u00020@2\u0006\u0010]\u001a\u00020\u0013J\u0016\u0010^\u001a\u00020$2\u0006\u0010\\\u001a\u00020;2\u0006\u0010]\u001a\u00020\u0013J\u0018\u0010`\u001a\u00020$2\u0006\u0010a\u001a\u0002052\u0006\u0010]\u001a\u00020\u0013H\u0007J-\u0010b\u001a\u00020$2\u0006\u0010\\\u001a\u00020;2\u0006\u0010_\u001a\u00020@2\u0006\u0010c\u001a\u00020\u00192\u0006\u0010d\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\beJ\u001d\u0010f\u001a\u00020$2\u0006\u0010\\\u001a\u00020;2\u0006\u0010g\u001a\u00020hH\u0000\u00a2\u0006\u0002\biJ\u0015\u0010j\u001a\u00020$2\u0006\u0010\\\u001a\u00020;H\u0001\u00a2\u0006\u0002\bkJ\u0015\u0010j\u001a\u00020$2\u0006\u0010g\u001a\u00020hH\u0001\u00a2\u0006\u0002\bkJ=\u0010l\u001a\u00020$2\u0006\u0010g\u001a\u00020h2\u0006\u0010,\u001a\u00020\u00132\u001c\u0010m\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0o\u0012\u0006\u0012\u0004\u0018\u00010\u00010nH\u0001\u00a2\u0006\u0004\bp\u0010qJ@\u0010r\u001a\u0004\u0018\u00010\u00002\u0006\u0010s\u001a\u00020 2\u0006\u0010t\u001a\u00020\u00132\b\u0010u\u001a\u0004\u0018\u00010@2\u0006\u0010v\u001a\u00020\u00132\b\b\u0002\u0010w\u001a\u00020\u00132\b\b\u0002\u0010x\u001a\u00020\u0013H\u0007JO\u0010r\u001a\u0004\u0018\u00010\u00002\u0006\u0010s\u001a\u00020 2\u0006\u0010t\u001a\u00020\u00132\b\u0010u\u001a\u0004\u0018\u00010@2\u0006\u0010v\u001a\u00020\u00132\b\b\u0002\u0010w\u001a\u00020\u00132\b\b\u0002\u0010x\u001a\u00020\u00132\b\u0010y\u001a\u0004\u0018\u00010zH\u0000\u00a2\u0006\u0002\b{J\u0010\u0010|\u001a\u00020$2\u0006\u0010}\u001a\u00020~H\u0002J\u0014\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020\u00000HH\u0007\u00a2\u0006\u0003\u0010\u0080\u0001J\u000f\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000BH\u0001J\u0015\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000FH\u0001\u00a2\u0006\u0003\b\u0083\u0001J\u000f\u0010,\u001a\u00020$2\u0007\u0010\u0084\u0001\u001a\u00020\u0013J\u0007\u0010\u0085\u0001\u001a\u00020$J\u001b\u0010\u0086\u0001\u001a\u00020$2\n\b\u0002\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0000\u00a2\u0006\u0003\b\u0089\u0001J\u0012\u0010\u008a\u0001\u001a\u00020$2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010@J\u000f\u0010\u008c\u0001\u001a\u00020$H\u0000\u00a2\u0006\u0003\b\u008d\u0001J\u000f\u0010\u008e\u0001\u001a\u00020\u0013H\u0000\u00a2\u0006\u0003\b\u008f\u0001J\u000f\u0010\u0090\u0001\u001a\u00020$H\u0001\u00a2\u0006\u0003\b\u0091\u0001J%\u0010\u0092\u0001\u001a\u00020$2\u0006\u0010_\u001a\u00020@2\t\b\u0002\u0010\u0093\u0001\u001a\u00020\u00132\t\b\u0002\u0010\u0094\u0001\u001a\u00020\u0013J\u001c\u0010\u0092\u0001\u001a\u00020$2\u0006\u0010_\u001a\u00020@2\t\b\u0002\u0010\u0093\u0001\u001a\u00020\u0013H\u0007J*\u0010\u0092\u0001\u001a\u00020$2\u0006\u0010_\u001a\u00020@2\u0006\u0010\\\u001a\u00020;2\t\b\u0002\u0010\u0093\u0001\u001a\u00020\u0013H\u0001\u00a2\u0006\u0003\b\u0095\u0001J,\u0010\u0096\u0001\u001a\u0004\u0018\u00010h2\u0007\u0010\u0097\u0001\u001a\u00020h2\u0007\u0010\u0098\u0001\u001a\u00020@2\u0007\u0010\u0099\u0001\u001a\u00020 H\u0000\u00a2\u0006\u0003\b\u009a\u0001J\u0019\u0010\u009b\u0001\u001a\u00020$2\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0000\u00a2\u0006\u0003\b\u009e\u0001J\u0007\u0010\u009f\u0001\u001a\u00020$J!\u0010\u00a0\u0001\u001a\u00020 2\u0007\u0010\u0098\u0001\u001a\u00020@2\u0007\u0010\u00a1\u0001\u001a\u00020 H\u0000\u00a2\u0006\u0003\b\u00a2\u0001J#\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u00012\u0007\u0010\u00a7\u0001\u001a\u00020\u0013H\u0000\u00a2\u0006\u0003\b\u00a8\u0001J\u0007\u0010\u00a9\u0001\u001a\u00020$J\u0012\u0010\u00aa\u0001\u001a\u00020$2\u0007\u0010\u00ab\u0001\u001a\u00020\u0013H\u0001J\u0007\u0010\u00ac\u0001\u001a\u00020$J\u0007\u0010\u00ad\u0001\u001a\u00020\u0013J\u0013\u0010\u00b0\u0001\u001a\u0004\u0018\u0001052\u0006\u0010_\u001a\u00020@H\u0007J\u0012\u0010\u00b1\u0001\u001a\u0004\u0018\u00010;2\u0007\u0010\u00b2\u0001\u001a\u00020@J\u001e\u0010\u00b3\u0001\u001a\u0010\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020h\u0018\u00010\u00172\u0007\u0010\u00b2\u0001\u001a\u00020@J\u0011\u0010\u00b4\u0001\u001a\u00020 2\u0006\u0010\\\u001a\u00020;H\u0002J\u0019\u0010\u00b5\u0001\u001a\u0004\u0018\u00010h2\u0006\u0010\\\u001a\u00020;H\u0000\u00a2\u0006\u0003\b\u00b6\u0001J\u0019\u0010\u00b7\u0001\u001a\u0004\u0018\u00010h2\u0006\u0010_\u001a\u00020@H\u0000\u00a2\u0006\u0003\b\u00b8\u0001J\u000f\u0010\u00b9\u0001\u001a\u00020\u00132\u0006\u0010_\u001a\u00020@J\u000f\u0010\u00ba\u0001\u001a\u00020\u00132\u0006\u0010_\u001a\u00020@J\u0018\u0010\u00bb\u0001\u001a\u00020$2\u0006\u0010_\u001a\u00020@2\u0007\u0010\u00bc\u0001\u001a\u00020\u0013J\u001a\u0010\u00bb\u0001\u001a\u00020$2\u0006\u0010\\\u001a\u00020;2\u0007\u0010\u00bc\u0001\u001a\u00020\u0013H\u0002J\u001b\u0010\u00bd\u0001\u001a\u00020$2\t\u0010\u00be\u0001\u001a\u0004\u0018\u00010@2\u0007\u0010\u0094\u0001\u001a\u00020\u0013J&\u0010\u00bf\u0001\u001a\u00020$2\t\u0010\u00be\u0001\u001a\u0004\u0018\u00010@2\u0007\u0010\u00c0\u0001\u001a\u00020\u00132\u0007\u0010\u0094\u0001\u001a\u00020\u0013H\u0002J\u0019\u0010\u00c1\u0001\u001a\t\u0012\u0004\u0012\u00020@0\u00c2\u00012\u0007\u0010\u00c0\u0001\u001a\u00020\u0013H\u0002J\u001c\u0010\u00c3\u0001\u001a\u00020\u00132\u0006\u0010_\u001a\u00020@2\t\u0010\u00be\u0001\u001a\u0004\u0018\u00010@H\u0002J\u0014\u0010\u00c4\u0001\u001a\u00020\u00132\t\u0010\u00be\u0001\u001a\u0004\u0018\u00010@H\u0002J\u001a\u0010\u00c5\u0001\u001a\u00020$2\u0006\u0010_\u001a\u00020@2\u0007\u0010\u0094\u0001\u001a\u00020\u0013H\u0002J\u001c\u0010\u00c6\u0001\u001a\u00020\u00132\u0006\u0010_\u001a\u00020@2\t\u0010\u00be\u0001\u001a\u0004\u0018\u00010@H\u0002J\u0011\u0010\u00c7\u0001\u001a\u00020\u00132\u0006\u0010_\u001a\u00020@H\u0002J\u000b\u0010\u00c8\u0001\u001a\u00020\u0018H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\u001c8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010-\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0014R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u00103\u001a\u00020\u00138AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0014R\u0019\u00104\u001a\u0004\u0018\u0001058G\u00a2\u0006\f\u0012\u0004\b6\u00107\u001a\u0004\b8\u00109R\u0013\u0010:\u001a\u0004\u0018\u00010;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0017\u0010A\u001a\b\u0012\u0004\u0012\u00020;0B8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u001d\u0010G\u001a\b\u0012\u0004\u0012\u0002050H8G\u00a2\u0006\f\u0012\u0004\bI\u00107\u001a\u0004\bJ\u0010KR \u0010L\u001a\b\u0012\u0004\u0012\u00020@0H8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bM\u00107\u001a\u0004\bN\u0010OR\u0017\u0010P\u001a\b\u0012\u0004\u0012\u00020@0B8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010DR\u0016\u0010S\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010;0TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010U\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010;0V8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u008b\u0001\u001a\u0004\u0018\u00010@8F\u00a2\u0006\b\u001a\u0006\b\u00ae\u0001\u0010\u00af\u0001\u00a8\u0006\u00cc\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "", "owner", "Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;Lkotlinx/coroutines/CoroutineScope;)V", "getOwner", "()Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;", "component", "Ljavax/swing/JComponent;", "getComponent$intellij_platform_ide_impl", "()Ljavax/swing/JComponent;", "tabbedPane", "Lcom/intellij/openapi/fileEditor/impl/EditorTabbedContainer;", "getTabbedPane", "()Lcom/intellij/openapi/fileEditor/impl/EditorTabbedContainer;", "isDisposed", "", "()Z", "removedTabs", "Lkotlin/collections/ArrayDeque;", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/fileEditor/impl/FileEditorOpenOptions;", "isShowing", "manager", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl;", "getManager", "()Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl;", "tabCount", "", "getTabCount", "()I", "setForegroundAt", "", "index", "color", "Ljava/awt/Color;", "setTextAttributes", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "setAsCurrentWindow", "requestFocus", "isEmptyVisible", "size", "Ljava/awt/Dimension;", "getSize", "()Ljava/awt/Dimension;", "checkConsistency", "isValid", "selectedEditor", "Lcom/intellij/openapi/fileEditor/impl/EditorWithProviderComposite;", "getSelectedEditor$annotations", "()V", "getSelectedEditor", "()Lcom/intellij/openapi/fileEditor/impl/EditorWithProviderComposite;", "selectedComposite", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "getSelectedComposite", "()Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "ignorePopup", "getContextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "allComposites", "", "getAllComposites", "()Ljava/util/List;", "composites", "Lkotlin/sequences/Sequence;", "editors", "", "getEditors$annotations", "getEditors", "()[Lcom/intellij/openapi/fileEditor/impl/EditorWithProviderComposite;", "files", "getFiles$annotations", "getFiles", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "fileList", "getFileList", "files$intellij_platform_ide_impl", "_currentCompositeFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "currentCompositeFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getAdjacentEditors", "", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow$RelativePosition;", "getAdjacentEditors$intellij_platform_ide_impl", "setSelectedEditor", "composite", "focusEditor", "setSelectedComposite", "file", "setEditor", "editor", "addComposite", "options", "isNewEditor", "addComposite$intellij_platform_ide_impl", "watchForTabActions", "tab", "Lcom/intellij/ui/tabs/TabInfo;", "watchForTabActions$intellij_platform_ide_impl", "setCurrentCompositeAndSelectTab", "setCurrentCompositeAndSelectTab$intellij_platform_ide_impl", "selectTabOnStartup", "windowAdded", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "selectTabOnStartup$intellij_platform_ide_impl", "(Lcom/intellij/ui/tabs/TabInfo;ZLkotlin/jvm/functions/Function1;)V", "split", "orientation", "forceSplit", "virtualFile", "focusNew", "fileIsSecondaryComponent", "forceFocus", "internalHint", "Lcom/intellij/openapi/fileEditor/impl/FileEditorOpenOptionsHint;", "split$intellij_platform_ide_impl", "normalizeProportionsIfNeed", "inputComponent", "Ljava/awt/Container;", "findSiblings", "()[Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "getSiblings", "siblings", "siblings$intellij_platform_ide_impl", "forced", "toFront", "updateTabsVisibility", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "updateTabsVisibility$intellij_platform_ide_impl", "closeAllExcept", "selectedFile", "dispose", "dispose$intellij_platform_ide_impl", "hasClosedTabs", "hasClosedTabs$intellij_platform_ide_impl", "restoreClosedTab", "restoreClosedTab$intellij_platform_ide_impl", "closeFile", "disposeIfNeeded", "transferFocus", "closeFile$intellij_platform_ide_impl", "getTabToSelect", "tabBeingClosed", "fileBeingClosed", "componentIndex", "getTabToSelect$intellij_platform_ide_impl", "logEmptyStateIfMainSplitter", "cause", "Lcom/intellij/featureStatistics/fusCollectors/FileEditorCollector$EmptyStateCause;", "logEmptyStateIfMainSplitter$intellij_platform_ide_impl", "removeFromSplitter", "computeIndexToSelect", "fileIndex", "computeIndexToSelect$intellij_platform_ide_impl", "showSplitChooser", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow$SplitChooser;", "project", "Lcom/intellij/openapi/project/Project;", "showInfoPanel", "showSplitChooser$intellij_platform_ide_impl", "changeOrientation", "unsplit", "setCurrent", "unsplitAll", "inSplitter", "getSelectedFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "findFileComposite", "getComposite", "inputFile", "findCompositeAndTab", "findComponentIndex", "findTabByComposite", "findTabByComposite$intellij_platform_ide_impl", "findTabByFile", "findTabByFile$intellij_platform_ide_impl", "isFileOpen", "isFilePinned", "setFilePinned", "pinned", "trimToSize", "fileToIgnore", "doTrimSize", "closeNonModifiedFilesFirst", "getTabClosingOrder", "", "shouldCloseSelected", "isAnyTabClosable", "defaultCloseFile", "fileCanBeClosed", "isClosingAllowed", "toString", "Companion", "RelativePosition", "SplitChooser", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEditorWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorWindow.kt\ncom/intellij/openapi/fileEditor/impl/EditorWindow\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FileEditorManagerImpl.kt\ncom/intellij/openapi/fileEditor/impl/FileEditorManagerImplKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1307:1\n479#2:1308\n226#2,9:1313\n37#3,2:1309\n37#3,2:1311\n37#3,2:1323\n1#4:1322\n2405#5,20:1325\n2405#5,20:1345\n296#6,2:1365\n363#6,7:1367\n296#6,2:1374\n296#6,2:1376\n1807#6,3:1378\n1786#6,3:1381\n*S KotlinDebug\n*F\n+ 1 EditorWindow.kt\ncom/intellij/openapi/fileEditor/impl/EditorWindow\n*L\n178#1:1308\n332#1:1313,9\n178#1:1309,2\n182#1:1311,2\n603#1:1323,2\n630#1:1325,20\n670#1:1345,20\n917#1:1365,2\n981#1:1367,7\n983#1:1374,2\n985#1:1376,2\n1126#1:1378,3\n1147#1:1381,3\n*E\n"})
public final class EditorWindow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorsSplitters owner;
    @JvmField
    @NotNull
    public final CoroutineScope coroutineScope;
    @NotNull
    private final EditorTabbedContainer tabbedPane;
    @NotNull
    private final ArrayDeque<Pair<String, FileEditorOpenOptions>> removedTabs;
    @NotNull
    private final MutableStateFlow<EditorComposite> _currentCompositeFlow;
    @JvmField
    @NotNull
    public final StateFlow<EditorComposite> currentCompositeFlow;
    @JvmField
    @NotNull
    public static final DataKey<EditorWindow> DATA_KEY = DataKey.Companion.create("editorWindow");
    @NotNull
    private static final Key<Integer> DRAG_START_INDEX_KEY;
    @NotNull
    private static final Key<Integer> DRAG_START_LOCATION_HASH_KEY;
    @JvmField
    @NotNull
    public static final Key<Boolean> DRAG_START_PINNED_KEY;

    public EditorWindow(@NotNull EditorsSplitters owner, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.owner = owner;
        this.coroutineScope = coroutineScope;
        this.tabbedPane = new EditorTabbedContainer(this, this.coroutineScope);
        this.removedTabs = new ArrayDeque();
        this._currentCompositeFlow = StateFlowKt.MutableStateFlow(null);
        this.currentCompositeFlow = FlowKt.asStateFlow(this._currentCompositeFlow);
        EditorWindow.updateTabsVisibility$intellij_platform_ide_impl$default(this, null, 1, null);
        this.tabbedPane.getTabs().addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (newSelection != null) {
                    Object object = newSelection.getObject();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFile");
                    VirtualFile newFile = (VirtualFile)object;
                    if (GeneralSettings.Companion.getInstance().isSyncOnFrameActivation()) {
                        VirtualFile[] virtualFileArray = new VirtualFile[]{newFile};
                        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])virtualFileArray);
                    }
                }
                TabInfo tabInfo = newSelection;
                _currentCompositeFlow.setValue((Object)(tabInfo != null ? EditorWindowKt.getComposite(tabInfo) : null));
            }
        });
    }

    @NotNull
    public final EditorsSplitters getOwner() {
        return this.owner;
    }

    @NotNull
    public final JComponent getComponent$intellij_platform_ide_impl() {
        return this.tabbedPane.getComponent();
    }

    @NotNull
    public final EditorTabbedContainer getTabbedPane() {
        return this.tabbedPane;
    }

    public final boolean isDisposed() {
        return !kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.coroutineScope);
    }

    public final boolean isShowing() {
        return this.getComponent$intellij_platform_ide_impl().isShowing();
    }

    @ApiStatus.Internal
    @NotNull
    public final FileEditorManagerImpl getManager() {
        return this.owner.getManager();
    }

    public final int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public final void setForegroundAt(int index, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.tabbedPane.getTabs().getTabAt(index).setDefaultForeground(color);
    }

    public final void setTextAttributes(int index, @Nullable TextAttributes attributes) {
        this.tabbedPane.getTabs().getTabAt(index).setDefaultAttributes(attributes);
    }

    public final void setAsCurrentWindow(boolean requestFocus) {
        this.owner.setCurrentWindow$intellij_platform_ide_impl(this, requestFocus);
    }

    public final boolean isEmptyVisible() {
        return this.tabbedPane.editorTabs.isEmptyVisible();
    }

    @NotNull
    public final Dimension getSize() {
        Dimension dimension = this.getComponent$intellij_platform_ide_impl().getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        return dimension;
    }

    private final void checkConsistency() {
        EditorWindowKt.access$getLOG$p().assertTrue(this.isValid(), (Object)"EditorWindow not in collection");
    }

    @JvmName(name="isValid")
    public final boolean isValid() {
        return this.owner.containsWindow$intellij_platform_ide_impl(this);
    }

    @Deprecated(message="Use selectedComposite", replaceWith=@ReplaceWith(expression="selectedComposite", imports={}), level=DeprecationLevel.ERROR)
    @Nullable
    public final EditorWithProviderComposite getSelectedEditor() {
        return (EditorWithProviderComposite)this.getSelectedComposite();
    }

    public static /* synthetic */ void getSelectedEditor$annotations() {
    }

    @Nullable
    public final EditorComposite getSelectedComposite() {
        return (EditorComposite)this.currentCompositeFlow.getValue();
    }

    @Nullable
    public final EditorComposite getSelectedComposite(boolean ignorePopup) {
        TabInfo tabInfo = ignorePopup ? this.tabbedPane.editorTabs.getSelectedInfo() : this.tabbedPane.editorTabs.getTargetInfo();
        return tabInfo != null ? EditorWindowKt.getComposite(tabInfo) : null;
    }

    @ApiStatus.Internal
    @Nullable
    public final VirtualFile getContextFile() {
        Object object = this.tabbedPane.getTabs().getTargetInfo();
        return object != null && (object = EditorWindowKt.getComposite((TabInfo)object)) != null ? ((EditorComposite)object).getFile() : null;
    }

    @NotNull
    public final List<EditorComposite> getAllComposites() {
        return SequencesKt.toList(this.composites());
    }

    @NotNull
    public final Sequence<EditorComposite> composites() {
        List list2 = this.tabbedPane.getTabs().getTabs();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTabs(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), EditorWindow::composites$lambda$0);
    }

    @Deprecated(message="{@link #getAllComposites()}", replaceWith=@ReplaceWith(expression="allComposites)", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public final EditorWithProviderComposite[] getEditors() {
        Sequence<EditorComposite> $this$filterIsInstance$iv = this.composites();
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)special$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)sequence);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new EditorWithProviderComposite[0]);
    }

    public static /* synthetic */ void getEditors$annotations() {
    }

    @NotNull
    public final VirtualFile[] getFiles() {
        Collection $this$toTypedArray$iv = SequencesKt.toList(this.files$intellij_platform_ide_impl());
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new VirtualFile[0]);
    }

    @Deprecated(message="Use [fileList]", replaceWith=@ReplaceWith(expression="fileList", imports={}), level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getFiles$annotations() {
    }

    @NotNull
    public final List<VirtualFile> getFileList() {
        return SequencesKt.toList(this.files$intellij_platform_ide_impl());
    }

    @RequiresEdt
    @NotNull
    public final Sequence<VirtualFile> files$intellij_platform_ide_impl() {
        return SequencesKt.map(this.composites(), EditorWindow::files$lambda$0);
    }

    @NotNull
    public final Map<RelativePosition, EditorWindow> getAdjacentEditors$intellij_platform_ide_impl() {
        this.checkConsistency();
        HashMap<RelativePosition, EditorWindow> adjacentEditors = new HashMap<RelativePosition, EditorWindow>(4);
        List<EditorWindow> windows = this.owner.getOrderedWindows$intellij_platform_ide_impl();
        windows.remove(this);
        HashMap<JComponent, EditorWindow> panelToWindow = new HashMap<JComponent, EditorWindow>();
        for (EditorWindow window : windows) {
            panelToWindow.put(window.getComponent$intellij_platform_ide_impl(), window);
        }
        RelativePoint relativePoint = ApplicationManager.getApplication().isUnitTestMode() ? new RelativePoint(new MouseEvent(new JLabel(), 0, 0L, 0, 0, 0, 0, false)) : new RelativePoint(this.getComponent$intellij_platform_ide_impl().getLocationOnScreen());
        Point point = relativePoint.getPoint((Component)this.owner);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        Point point2 = point;
        Function2 nearestComponent = (arg_0, arg_1) -> EditorWindow.getAdjacentEditors$lambda$0(this, arg_0, arg_1);
        int x = point2.x + this.getComponent$intellij_platform_ide_impl().getWidth() / 4;
        int searchStep = 2;
        EditorWindow.getAdjacentEditors$biConsumer(adjacentEditors, EditorWindow.getAdjacentEditors$findAdjacentEditor(this, panelToWindow, (Component)nearestComponent.invoke((Object)x, (Object)(point2.y - searchStep))), RelativePosition.UP);
        EditorWindow.getAdjacentEditors$biConsumer(adjacentEditors, EditorWindow.getAdjacentEditors$findAdjacentEditor(this, panelToWindow, (Component)nearestComponent.invoke((Object)x, (Object)(point2.y + this.getComponent$intellij_platform_ide_impl().getHeight() + searchStep))), RelativePosition.DOWN);
        EditorWindow.getAdjacentEditors$biConsumer(adjacentEditors, EditorWindow.getAdjacentEditors$findAdjacentEditor(this, panelToWindow, (Component)nearestComponent.invoke((Object)(point2.x - searchStep), (Object)point2.y)), RelativePosition.LEFT);
        EditorWindow.getAdjacentEditors$biConsumer(adjacentEditors, EditorWindow.getAdjacentEditors$findAdjacentEditor(this, panelToWindow, (Component)nearestComponent.invoke((Object)(point2.x + this.getComponent$intellij_platform_ide_impl().getWidth() + searchStep), (Object)point2.y)), RelativePosition.RIGHT);
        return adjacentEditors;
    }

    @Deprecated(message="{@link #setSelectedComposite(EditorComposite, boolean)}", replaceWith=@ReplaceWith(expression="setSelectedComposite(composite, focusEditor)", imports={}), level=DeprecationLevel.ERROR)
    public final void setSelectedEditor(@NotNull EditorComposite composite2, boolean focusEditor) {
        Intrinsics.checkNotNullParameter((Object)composite2, (String)"composite");
        this.setSelectedComposite(composite2, focusEditor);
    }

    public final void setSelectedComposite(@NotNull VirtualFile file2, boolean focusEditor) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        for (TabInfo tab : this.tabbedPane.getTabs().getTabs()) {
            Intrinsics.checkNotNull((Object)tab);
            if (!Intrinsics.areEqual((Object)EditorWindowKt.getComposite(tab).getFile(), (Object)file2)) continue;
            this.tabbedPane.getTabs().select(tab, focusEditor);
            break;
        }
    }

    public final void setSelectedComposite(@NotNull EditorComposite composite2, boolean focusEditor) {
        EditorComposite currentComposite;
        Intrinsics.checkNotNullParameter((Object)composite2, (String)"composite");
        for (TabInfo tab : this.tabbedPane.getTabs().getTabs()) {
            Intrinsics.checkNotNull((Object)tab);
            if (EditorWindowKt.getComposite(tab) != composite2) continue;
            this.tabbedPane.getTabs().select(tab, focusEditor);
            break;
        }
        if ((currentComposite = (EditorComposite)this.currentCompositeFlow.getValue()) != composite2) {
            EditorWindowKt.access$getLOG$p().error(currentComposite + " is not equal to " + composite2);
        }
    }

    @Deprecated(message="Use {@link #setComposite(EditorComposite, boolean)}", replaceWith=@ReplaceWith(expression="setComposite(editor, FileEditorOpenOptions().withRequestFocus(focusEditor))", imports={"com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions"}))
    @ApiStatus.ScheduledForRemoval
    public final void setEditor(@NotNull EditorWithProviderComposite editor2, boolean focusEditor) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.addComposite$intellij_platform_ide_impl(editor2, editor2.getFile(), new FileEditorOpenOptions(false, false, false, focusEditor, false, 0, false, null, false, false, false, null, 4087, null), this.findTabByComposite$intellij_platform_ide_impl(editor2) == null);
    }

    @RequiresEdt
    public final void addComposite$intellij_platform_ide_impl(@NotNull EditorComposite composite2, @NotNull VirtualFile file2, @NotNull FileEditorOpenOptions options2, boolean isNewEditor) {
        block16: {
            block18: {
                Boolean initialPinned;
                block17: {
                    Intrinsics.checkNotNullParameter((Object)composite2, (String)"composite");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
                    boolean isPreviewMode = (isNewEditor || composite2.isPreview()) && EditorWindowKt.access$shouldReservePreview(composite2.getFile(), options2, this.owner.getManager().getProject());
                    composite2.setPreview(isPreviewMode);
                    if (!isNewEditor) break block16;
                    this.owner.scheduleUpdateFileIcon$intellij_platform_ide_impl(file2);
                    int indexToInsert = options2.index;
                    if (indexToInsert == -1) {
                        if (isPreviewMode) {
                            Sequence<EditorComposite> $this$indexOfLast$iv = this.composites();
                            boolean $i$f$indexOfLast = false;
                            int lastIndex$iv = -1;
                            int index$iv = 0;
                            for (Object item$iv : $this$indexOfLast$iv) {
                                if (index$iv < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                EditorComposite it = (EditorComposite)item$iv;
                                boolean bl = false;
                                if (it.isPreview()) {
                                    lastIndex$iv = index$iv;
                                }
                                ++index$iv;
                            }
                            indexToInsert = lastIndex$iv;
                        }
                        if (indexToInsert == -1) {
                            indexToInsert = UISettings.Companion.getInstance().getOpenTabsAtTheEnd() ? this.tabbedPane.getTabCount() : this.tabbedPane.getSelectedIndex() + 1;
                        }
                    }
                    Icon icon2 = AllIcons.FileTypes.Text;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Text");
                    Icon template = icon2;
                    TabInfo tab = this.tabbedPane.insertTab$intellij_platform_ide_impl(file2, (Icon)EmptyIcon.create((int)template.getIconWidth(), (int)template.getIconHeight()), composite2.getComponent(), null, indexToInsert, composite2.getSelectedEditor(), composite2, (Function1<? super TabInfo, ? extends TabInfoIconHolder>)((Function1)arg_0 -> EditorWindow.addComposite$lambda$1(composite2, arg_0)));
                    this.watchForTabActions$intellij_platform_ide_impl(composite2, tab);
                    Integer dragStartIndex = null;
                    Integer hash = (Integer)file2.getUserData(DRAG_START_LOCATION_HASH_KEY);
                    if (hash != null && System.identityHashCode(this.tabbedPane.getTabs()) == hash) {
                        dragStartIndex = (Integer)file2.getUserData(DRAG_START_INDEX_KEY);
                    }
                    if (dragStartIndex == null) break block17;
                    int n = -1;
                    if (dragStartIndex == n) break block18;
                }
                if ((initialPinned = (Boolean)file2.getUserData(DRAG_START_PINNED_KEY)) != null) {
                    composite2.setPinned(initialPinned);
                } else if (composite2.isPinned()) {
                    composite2.setPinned(true);
                }
            }
            file2.putUserData(DRAG_START_LOCATION_HASH_KEY, null);
            file2.putUserData(DRAG_START_INDEX_KEY, null);
            file2.putUserData(DRAG_START_PINNED_KEY, null);
            this.trimToSize(file2, false);
        }
        this.owner.scheduleUpdateFileColor$intellij_platform_ide_impl(file2);
        if (options2.pin) {
            this.setFilePinned(composite2, true);
        }
        if (options2.selectAsCurrent) {
            this.setCurrentCompositeAndSelectTab$intellij_platform_ide_impl(composite2);
            this.owner.setCurrentWindow$intellij_platform_ide_impl(this);
            boolean isHeadless = ApplicationManager.getApplication().isHeadlessEnvironment();
            if (isHeadless) {
                this.owner.setCurrentWindow$intellij_platform_ide_impl(this);
            }
            CoroutineScope coroutineScope = composite2.coroutineScope;
            CoroutineContext coroutineContext = CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE).plus(ClientId.Companion.coroutineContext());
            ModalityState modalityState = ModalityState.any();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(isHeadless, this, options2, composite2, null){
                int label;
                final /* synthetic */ boolean $isHeadless;
                final /* synthetic */ EditorWindow this$0;
                final /* synthetic */ FileEditorOpenOptions $options;
                final /* synthetic */ EditorComposite $composite;
                {
                    this.$isHeadless = $isHeadless;
                    this.this$0 = $receiver;
                    this.$options = $options;
                    this.$composite = $composite;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (!this.$isHeadless) {
                                this.this$0.getOwner().setCurrentWindow$intellij_platform_ide_impl(this.this$0);
                            }
                            if (!this.$options.requestFocus) return Unit.INSTANCE;
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$composite, this.this$0, this.$options, null){
                                int label;
                                final /* synthetic */ EditorComposite $composite;
                                final /* synthetic */ EditorWindow this$0;
                                final /* synthetic */ FileEditorOpenOptions $options;
                                {
                                    this.$composite = $composite;
                                    this.this$0 = $receiver;
                                    this.$options = $options;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            v0 = this.$composite.waitForAvailable((Continuation<? super Unit>)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            this.label = 2;
                                            v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$composite, this.this$0, this.$options, null){
                                                int label;
                                                final /* synthetic */ EditorComposite $composite;
                                                final /* synthetic */ EditorWindow this$0;
                                                final /* synthetic */ FileEditorOpenOptions $options;
                                                {
                                                    this.$composite = $composite;
                                                    this.this$0 = $receiver;
                                                    this.$options = $options;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            EditorCompositeKt.focusEditorOnComposite$default(this.$composite, this.this$0.getOwner(), false, this.$options.forceFocus, 4, null);
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (v1 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl21
                                        }
                                        case 2: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl21:
                                            // 2 sources

                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        EditorWindow.updateTabsVisibility$intellij_platform_ide_impl$default(this, null, 1, null);
        this.owner.validate();
    }

    public final void watchForTabActions$intellij_platform_ide_impl(@NotNull EditorComposite composite2, @NotNull TabInfo tab) {
        Intrinsics.checkNotNullParameter((Object)composite2, (String)"composite");
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(composite2, tab, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ EditorComposite $composite;
            final /* synthetic */ TabInfo $tab;
            final /* synthetic */ EditorWindow this$0;
            {
                this.$composite = $composite;
                this.$tab = $tab;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScopeKt.attachAsChildTo((CoroutineScope)$this$launch, (CoroutineScope)this.$composite.coroutineScope);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.$composite.selectedEditorWithProvider), (Function2)((Function2)new Function2<FileEditorWithProvider, Continuation<? super Unit>, Object>(this.$tab, this.this$0, null){
                            Object L$1;
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ TabInfo $tab;
                            final /* synthetic */ EditorWindow this$0;
                            {
                                this.$tab = $tab;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                FileEditorWithProvider fileEditorWithProvider = (FileEditorWithProvider)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        FileEditor fileEditor = it;
                                        ActionGroup tabActions = fileEditor != null && (fileEditor = fileEditor.getFileEditor()) != null ? fileEditor.getTabActions() : null;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)tabActions);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$tab, tabActions, this.this$0, null){
                                            int label;
                                            final /* synthetic */ TabInfo $tab;
                                            final /* synthetic */ ActionGroup $tabActions;
                                            final /* synthetic */ EditorWindow this$0;
                                            {
                                                this.$tab = $tab;
                                                this.$tabActions = $tabActions;
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        if (!Intrinsics.areEqual((Object)this.$tab.getTabPaneActions(), (Object)this.$tabActions)) {
                                                            this.$tab.setTabPaneActions(this.$tabActions);
                                                            if (Intrinsics.areEqual((Object)this.$tab, (Object)this.this$0.getTabbedPane().editorTabs.getSelectedInfo())) {
                                                                this.this$0.getTabbedPane().editorTabs.updateEntryPointToolbar(this.$tabActions);
                                                            }
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ActionGroup tabActions = (ActionGroup)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(FileEditorWithProvider p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @RequiresEdt
    public final void setCurrentCompositeAndSelectTab$intellij_platform_ide_impl(@NotNull EditorComposite composite2) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)composite2, (String)"composite");
            List list2 = this.tabbedPane.getTabs().getTabs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTabs(...)");
            Iterable iterable = list2;
            for (Object t : iterable) {
                TabInfo it = (TabInfo)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)EditorWindowKt.getComposite(it), (Object)composite2)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        TabInfo tabInfo = v1;
        if (tabInfo != null) {
            TabInfo it = tabInfo;
            boolean bl = false;
            this.tabbedPane.editorTabs.select(it, false);
        }
        this._currentCompositeFlow.setValue((Object)composite2);
    }

    @RequiresEdt
    public final void setCurrentCompositeAndSelectTab$intellij_platform_ide_impl(@NotNull TabInfo tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        this.tabbedPane.editorTabs.select(tab, false);
        this._currentCompositeFlow.setValue((Object)EditorWindowKt.getComposite(tab));
    }

    @RequiresEdt
    public final void selectTabOnStartup$intellij_platform_ide_impl(@NotNull TabInfo tab, boolean requestFocus, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> windowAdded) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter(windowAdded, (String)"windowAdded");
        EditorComposite composite2 = EditorWindowKt.getComposite(tab);
        this.tabbedPane.editorTabs.selectTabSilently(tab);
        this._currentCompositeFlow.setValue((Object)composite2);
        this.owner.setCurrentWindow$intellij_platform_ide_impl(this);
        if (requestFocus) {
            BuildersKt.launch$default((CoroutineScope)composite2.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(windowAdded, composite2, this, null){
                Object L$0;
                int label;
                final /* synthetic */ Function1<Continuation<? super Unit>, Object> $windowAdded;
                final /* synthetic */ EditorComposite $composite;
                final /* synthetic */ EditorWindow this$0;
                {
                    this.$windowAdded = $windowAdded;
                    this.$composite = $composite;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = this.$windowAdded.invoke((Object)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.label = 2;
                            v1 = this.$composite.waitForAvailable((Continuation<? super Unit>)((Continuation)this));
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl21
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            var3_3 = PlatformUtils.isJetBrainsClient() != false ? ModalityState.nonModal() : ModalityState.any();
                            Intrinsics.checkNotNull((Object)var3_3);
                            modalityState = var3_3;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)modalityState);
                            this.label = 3;
                            v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE).plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.$composite, this.this$0, null){
                                int label;
                                final /* synthetic */ EditorComposite $composite;
                                final /* synthetic */ EditorWindow this$0;
                                {
                                    this.$composite = $composite;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            return Boxing.boxBoolean((boolean)EditorCompositeKt.focusEditorOnComposite$default(this.$composite, this.this$0.getOwner(), false, false, 8, null));
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v2 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl34
                        }
                        case 3: {
                            modalityState = (ModalityState)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl34:
                            // 2 sources

                            if (((Boolean)v2).booleanValue()) {
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)modalityState);
                                this.label = 4;
                                v3 = this.this$0.getOwner().updateFrameTitle$intellij_platform_ide_impl((Continuation<? super Unit>)((Continuation)this));
                                if (v3 == var4_2) {
                                    return var4_2;
                                }
                            }
                            ** GOTO lbl45
                        }
                        case 4: {
                            modalityState = (ModalityState)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl45:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @JvmOverloads
    @RequiresEdt
    @Nullable
    public final EditorWindow split(int orientation, boolean forceSplit, @Nullable VirtualFile virtualFile2, boolean focusNew, boolean fileIsSecondaryComponent, boolean forceFocus) {
        return this.split$intellij_platform_ide_impl(orientation, forceSplit, virtualFile2, focusNew, fileIsSecondaryComponent, forceFocus, null);
    }

    public static /* synthetic */ EditorWindow split$default(EditorWindow editorWindow, int n, boolean bl, VirtualFile virtualFile2, boolean bl2, boolean bl3, boolean bl4, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x20) != 0) {
            bl4 = false;
        }
        return editorWindow.split(n, bl, virtualFile2, bl2, bl3, bl4);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final EditorWindow split$intellij_platform_ide_impl(int orientation, boolean forceSplit, @Nullable VirtualFile virtualFile, boolean focusNew, boolean fileIsSecondaryComponent, boolean forceFocus, @Nullable FileEditorOpenOptionsHint internalHint) {
        this.checkConsistency();
        if (this.getTabCount() < 1) {
            return null;
        }
        if (!forceSplit && this.inSplitter()) {
            target = (EditorWindow)SequencesKt.first(this.siblings$intellij_platform_ide_impl());
            selectedComposite = this.getSelectedComposite();
            if (virtualFile != null && selectedComposite != null) {
                var12_14 = var11_12 = selectedComposite;
                var20_16 = virtualFile;
                var19_18 = target;
                var18_20 = this.owner.getManager();
                $i$a$-takeIf-EditorWindow$split$1 = false;
                var21_24 = Intrinsics.areEqual((Object)it.getFile(), (Object)virtualFile);
                v0 = var21_24 != false ? var11_12 : null;
                var18_20.openFileImpl(var19_18, var20_16, v0 != null ? v0.currentStateAsFileEntry() : null, new FileEditorOpenOptions(false, false, false, focusNew, false, 0, false, null, false, false, forceFocus, null, 1015, null));
            }
            return target;
        }
        if (this.getTabCount() == 0) {
            return null;
        }
        splitter = EditorsSplittersKt.createSplitter(orientation == 0, 0.5f, 0.1f, 0.9f);
        splitter.putClientProperty((Object)"EditorsSplitters", (Object)true);
        selectedComposite = this.getSelectedComposite();
        existingEditor = this.tabbedPane.getComponent();
        newWindow = new EditorWindow(this.owner, CoroutineScopeKt.childScope$default((CoroutineScope)this.owner.coroutineScope, (String)"EditorWindow", null, (boolean)false, (int)6, null));
        this.owner.addWindow$intellij_platform_ide_impl(newWindow);
        v1 = existingEditor.getParent();
        Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type javax.swing.JPanel");
        EditorWindowKt.access$swapComponents((JPanel)v1, (JComponent)splitter, existingEditor);
        if (fileIsSecondaryComponent) {
            splitter.setFirstComponent(existingEditor);
            splitter.setSecondComponent(newWindow.getComponent$intellij_platform_ide_impl());
        } else {
            splitter.setFirstComponent(newWindow.getComponent$intellij_platform_ide_impl());
            splitter.setSecondComponent(existingEditor);
        }
        v2 = InternalUICustomization.Companion.getInstance();
        if (v2 != null) {
            v2.installEditorBackground(newWindow.getComponent$intellij_platform_ide_impl());
        }
        this.normalizeProportionsIfNeed(existingEditor);
        v3 = virtualFile;
        if (v3 == null) {
            v4 = selectedComposite;
            Intrinsics.checkNotNull((Object)v4);
            v3 = v4.getFile();
        }
        nextFile = v3;
        v5 = this.owner.getManager();
        v6 = newWindow;
        v7 = nextFile;
        v8 = selectedComposite;
        if (v8 == null) ** GOTO lbl-1000
        var16_28 = var15_27 = v8;
        var20_17 = v7;
        var19_19 = v6;
        var18_21 = v5;
        $i$a$-takeIf-EditorWindow$split$composite$1 = false;
        var21_25 = Intrinsics.areEqual((Object)it.getFile(), (Object)nextFile);
        v5 = var18_21;
        v6 = var19_19;
        v7 = var20_17;
        v8 = var21_25 != false ? var15_27 : null;
        if (v8 != null) {
            v9 = v8.currentStateAsFileEntry();
        } else lbl-1000:
        // 2 sources

        {
            v9 = null;
        }
        v10 = this.getComposite(nextFile);
        var14_30 = v10 != null ? v10.isPinned() : false;
        v11 = v5.openFileInNewCompositeInEdt$intellij_platform_ide_impl(v6, v7, v9, new FileEditorOpenOptions(focusNew, false, false, focusNew, var14_30, 0, true, null, false, false, forceFocus, internalHint, 934, null));
        if (v11 == null) {
            return newWindow;
        }
        composite = v11;
        if (!focusNew) {
            EditorWindowKt.access$getLOG$p().assertTrue(Intrinsics.areEqual((Object)this.currentCompositeFlow.getValue(), (Object)selectedComposite));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, split$lambda$2(com.intellij.openapi.fileEditor.impl.EditorComposite ), ()V)((EditorComposite)selectedComposite));
            if (composite instanceof EditorComposite) {
                newWindow.setCurrentCompositeAndSelectTab$intellij_platform_ide_impl((EditorComposite)composite);
            }
        }
        this.getComponent$intellij_platform_ide_impl().revalidate();
        return newWindow;
    }

    public static /* synthetic */ EditorWindow split$intellij_platform_ide_impl$default(EditorWindow editorWindow, int n, boolean bl, VirtualFile virtualFile2, boolean bl2, boolean bl3, boolean bl4, FileEditorOpenOptionsHint fileEditorOpenOptionsHint, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x20) != 0) {
            bl4 = false;
        }
        return editorWindow.split$intellij_platform_ide_impl(n, bl, virtualFile2, bl2, bl3, bl4, fileEditorOpenOptionsHint);
    }

    private final void normalizeProportionsIfNeed(Container inputComponent) {
        Boolean bl;
        Container component2 = inputComponent;
        if (!AdvancedSettings.Companion.getBoolean("editor.normalize.splits")) {
            return;
        }
        if (component2 instanceof Splitter) {
            bl = ((Splitter)component2).isVertical();
        } else {
            Component[] componentArray = component2.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            if (ArraysKt.firstOrNull((Object[])componentArray) instanceof Splitter) {
                Component[] componentArray2 = component2.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray2, (String)"getComponents(...)");
                Object object = ArraysKt.first((Object[])componentArray2);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.Splitter");
                bl = ((Splitter)object).isVertical();
            } else {
                bl = null;
            }
        }
        Boolean isVertical = bl;
        LinkedHashMap<Container, Boolean> hierarchyStack = new LinkedHashMap<Container, Boolean>();
        while (component2 != this.getManager().getComponent()) {
            Container parent = component2.getParent();
            if (parent instanceof Splitter) {
                if (isVertical == null) {
                    isVertical = ((Splitter)parent).isVertical();
                } else if (!Intrinsics.areEqual((Object)isVertical, (Object)((Splitter)parent).isVertical())) break;
                hierarchyStack.put(parent, ((Splitter)parent).getFirstComponent() == component2);
            }
            if (parent == null) break;
        }
        int i2 = 0;
        for (Map.Entry entry : ((Map)hierarchyStack).entrySet()) {
            Splitter key = (Splitter)entry.getKey();
            boolean value = (Boolean)entry.getValue();
            key.setProportion(value ? 1.0f - 1.0f / (float)(2 + i2) : 1.0f / (float)(2 + i2));
            ++i2;
        }
    }

    @Deprecated(message="Use getSiblings()", replaceWith=@ReplaceWith(expression="getSiblings()", imports={}))
    @NotNull
    public final EditorWindow[] findSiblings() {
        Collection $this$toTypedArray$iv = SequencesKt.toList(this.siblings$intellij_platform_ide_impl());
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new EditorWindow[0]);
    }

    @JvmName(name="getSiblings")
    @NotNull
    public final List<EditorWindow> getSiblings() {
        return SequencesKt.toList(this.siblings$intellij_platform_ide_impl());
    }

    @RequiresEdt
    @NotNull
    public final Sequence<EditorWindow> siblings$intellij_platform_ide_impl() {
        this.checkConsistency();
        Container container = this.getComponent$intellij_platform_ide_impl().getParent();
        Splitter splitter2 = container instanceof Splitter ? (Splitter)container : null;
        if (splitter2 == null) {
            return SequencesKt.emptySequence();
        }
        Splitter splitter3 = splitter2;
        return SequencesKt.filter(this.owner.windows(), arg_0 -> EditorWindow.siblings$lambda$0(this, splitter3, arg_0));
    }

    public final void requestFocus(boolean forced) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.tabbedPane.editorTabs.getComponent(), forced);
    }

    public final void toFront() {
        UIUtil.toFront((Window)ComponentUtil.getWindow((Component)this.tabbedPane.getComponent()));
    }

    public final void updateTabsVisibility$intellij_platform_ide_impl(@NotNull UISettings uiSettings) {
        Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
        this.tabbedPane.editorTabs.setHideTabs(this.owner.isFloating() && this.getTabCount() == 1 && this.owner.isSingletonEditorInWindow$intellij_platform_ide_impl() || uiSettings.getEditorTabPlacement() == 0 || uiSettings.getPresentationMode() && !Registry.Companion.is("ide.editor.tabs.visible.in.presentation.mode"));
    }

    public static /* synthetic */ void updateTabsVisibility$intellij_platform_ide_impl$default(EditorWindow editorWindow, UISettings uISettings, int n, Object object) {
        if ((n & 1) != 0) {
            uISettings = UISettings.Companion.getInstance();
        }
        editorWindow.updateTabsVisibility$intellij_platform_ide_impl(uISettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeAllExcept(@Nullable VirtualFile selectedFile) {
        block7: {
            block8: {
                EditorsSplitters splitters$iv = this.owner;
                boolean $i$f$runBulkTabChange = false;
                if (!EDT.isCurrentThreadEdt()) break block8;
                EditorsSplitters splitters$iv$iv = splitters$iv;
                boolean $i$f$runBulkTabChangeInEdt = false;
                int n = splitters$iv$iv.insideChange;
                splitters$iv$iv.insideChange = n + 1;
                try {
                    boolean bl = false;
                    for (VirtualFile file2 : SequencesKt.toList(this.files$intellij_platform_ide_impl())) {
                        if (Intrinsics.areEqual((Object)file2, (Object)selectedFile) || this.isFilePinned(file2)) continue;
                        EditorWindow.closeFile$default(this, file2, false, 2, null);
                    }
                    Unit unit = Unit.INSTANCE;
                    int n2 = splitters$iv$iv.insideChange;
                    splitters$iv$iv.insideChange = n2 + -1;
                    if (splitters$iv$iv.isInsideChange$intellij_platform_ide_impl()) break block7;
                }
                catch (Throwable throwable) {
                    int n3 = splitters$iv$iv.insideChange;
                    splitters$iv$iv.insideChange = n3 + -1;
                    if (!splitters$iv$iv.isInsideChange$intellij_platform_ide_impl()) {
                        splitters$iv$iv.validate();
                        for (EditorWindow window$iv$iv : splitters$iv$iv.windows()) {
                            window$iv$iv.getTabbedPane().editorTabs.revalidateAndRepaint();
                        }
                    }
                    throw throwable;
                }
                splitters$iv$iv.validate();
                for (EditorWindow window$iv$iv : splitters$iv$iv.windows()) {
                    window$iv$iv.getTabbedPane().editorTabs.revalidateAndRepaint();
                }
                break block7;
            }
            boolean bl = false;
            for (VirtualFile file3 : SequencesKt.toList(this.files$intellij_platform_ide_impl())) {
                if (Intrinsics.areEqual((Object)file3, (Object)selectedFile) || this.isFilePinned(file3)) continue;
                EditorWindow.closeFile$default(this, file3, false, 2, null);
            }
        }
    }

    public final void dispose$intellij_platform_ide_impl() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.owner.removeWindow$intellij_platform_ide_impl(this);
    }

    public final boolean hasClosedTabs$intellij_platform_ide_impl() {
        return !this.removedTabs.isEmpty();
    }

    @RequiresEdt
    public final void restoreClosedTab$intellij_platform_ide_impl() {
        Pair pair = (Pair)this.removedTabs.removeLastOrNull();
        if (pair == null) {
            return;
        }
        Pair info = pair;
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl((String)info.getFirst());
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        this.getManager().openFileImpl(this, file2, null, FileEditorOpenOptions.copy$default((FileEditorOpenOptions)info.getSecond(), true, false, false, true, false, 0, false, null, false, false, false, null, 3830, null));
    }

    public final void closeFile(@NotNull VirtualFile file2, boolean disposeIfNeeded, boolean transferFocus) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.closeFile(file2, disposeIfNeeded);
    }

    public static /* synthetic */ void closeFile$default(EditorWindow editorWindow, VirtualFile virtualFile2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        editorWindow.closeFile(virtualFile2, bl, bl2);
    }

    @JvmOverloads
    public final void closeFile(@NotNull VirtualFile file2, boolean disposeIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        EditorComposite editorComposite = this.getComposite(file2);
        if (editorComposite == null) {
            return;
        }
        EditorComposite composite2 = editorComposite;
        this.closeFile$intellij_platform_ide_impl(file2, composite2, disposeIfNeeded);
    }

    public static /* synthetic */ void closeFile$default(EditorWindow editorWindow, VirtualFile virtualFile2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        editorWindow.closeFile(virtualFile2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresEdt
    public final void closeFile$intellij_platform_ide_impl(@NotNull VirtualFile file2, @NotNull EditorComposite composite2, boolean disposeIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)composite2, (String)"composite");
        EditorsSplitters splitters$iv = this.owner;
        boolean $i$f$runBulkTabChange = false;
        if (EDT.isCurrentThreadEdt()) {
            EditorsSplitters splitters$iv$iv = splitters$iv;
            boolean $i$f$runBulkTabChangeInEdt = false;
            int n = splitters$iv$iv.insideChange;
            splitters$iv$iv.insideChange = n + 1;
            try {
                boolean bl = false;
                FileEditorManagerImpl fileEditorManager = this.getManager();
                try {
                    WriteIntentReadAction.run(() -> EditorWindow.closeFile$lambda$0$0(fileEditorManager, file2));
                    int componentIndex = this.findComponentIndex(composite2);
                    JBEditorTabs editorTabs = this.tabbedPane.editorTabs;
                    if (componentIndex >= 0) {
                        boolean bl2 = composite2.isPinned();
                        this.removedTabs.addLast((Object)TuplesKt.to((Object)file2.getUrl(), (Object)new FileEditorOpenOptions(false, false, false, false, bl2, componentIndex, false, null, false, false, false, null, 4047, null)));
                        if (this.removedTabs.size() >= Companion.getTabLimit()) {
                            this.removedTabs.removeFirst();
                        }
                        TabInfo info = editorTabs.getTabAt(componentIndex);
                        if (this.isDisposed() || !this.getManager().getProject().isOpen()) {
                            editorTabs.removeTabWithoutChangingSelection(info);
                        } else {
                            TabInfo toSelect = this.getTabToSelect$intellij_platform_ide_impl(info, file2, componentIndex);
                            JBTabsImpl.removeTab$default((JBTabsImpl)((JBTabsImpl)editorTabs), (TabInfo)info, (TabInfo)toSelect, (boolean)false, (int)4, null);
                        }
                        fileEditorManager.disposeComposite$intellij_platform_ide_impl(composite2);
                    }
                    if (disposeIfNeeded && this.getTabCount() == 0) {
                        this.removeFromSplitter();
                        this.logEmptyStateIfMainSplitter$intellij_platform_ide_impl(FileEditorCollector.EmptyStateCause.ALL_TABS_CLOSED);
                    } else {
                        this.getComponent$intellij_platform_ide_impl().revalidate();
                    }
                    if (editorTabs.getSelectedInfo() == null) {
                        this._currentCompositeFlow.setValue(null);
                    }
                }
                finally {
                    Instant openedTs = (Instant)file2.getUserData(ReadmeShownUsageCollector.INSTANCE.getREADME_OPENED_ON_START_TS$intellij_platform_ide_impl());
                    if (openedTs != null) {
                        file2.putUserData(ReadmeShownUsageCollector.INSTANCE.getREADME_OPENED_ON_START_TS$intellij_platform_ide_impl(), null);
                        long wasOpenedMillis = Instant.now().toEpochMilli() - openedTs.toEpochMilli();
                        ReadmeShownUsageCollector.INSTANCE.logReadmeClosedIn$intellij_platform_ide_impl(wasOpenedMillis);
                    }
                    fileEditorManager.removeSelectionRecord$intellij_platform_ide_impl(file2, this);
                    Project project2 = fileEditorManager.getProject();
                    if (!project2.isDisposed()) {
                        MessageBus messageBus = project2.getMessageBus();
                        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
                        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
                        ((FileEditorManagerListener)messageBus.syncPublisher(topic)).fileClosed((FileEditorManager)fileEditorManager, file2);
                    }
                    this.owner.afterFileClosed$intellij_platform_ide_impl(file2);
                }
                Unit unit = Unit.INSTANCE;
                int n2 = splitters$iv$iv.insideChange;
                splitters$iv$iv.insideChange = n2 + -1;
                if (splitters$iv$iv.isInsideChange$intellij_platform_ide_impl()) return;
            }
            catch (Throwable throwable) {
                int n3 = splitters$iv$iv.insideChange;
                splitters$iv$iv.insideChange = n3 + -1;
                if (splitters$iv$iv.isInsideChange$intellij_platform_ide_impl()) throw throwable;
                splitters$iv$iv.validate();
                for (EditorWindow window$iv$iv : splitters$iv$iv.windows()) {
                    window$iv$iv.getTabbedPane().editorTabs.revalidateAndRepaint();
                }
                throw throwable;
            }
            splitters$iv$iv.validate();
            for (EditorWindow window$iv$iv : splitters$iv$iv.windows()) {
                window$iv$iv.getTabbedPane().editorTabs.revalidateAndRepaint();
            }
            return;
        }
        boolean bl = false;
        FileEditorManagerImpl fileEditorManager = this.getManager();
        try {
            WriteIntentReadAction.run(() -> EditorWindow.closeFile$lambda$0$0(fileEditorManager, file2));
            int componentIndex = this.findComponentIndex(composite2);
            JBEditorTabs editorTabs = this.tabbedPane.editorTabs;
            if (componentIndex >= 0) {
                boolean project3 = composite2.isPinned();
                this.removedTabs.addLast((Object)TuplesKt.to((Object)file2.getUrl(), (Object)new FileEditorOpenOptions(false, false, false, false, project3, componentIndex, false, null, false, false, false, null, 4047, null)));
                if (this.removedTabs.size() >= Companion.getTabLimit()) {
                    this.removedTabs.removeFirst();
                }
                TabInfo info = editorTabs.getTabAt(componentIndex);
                if (this.isDisposed() || !this.getManager().getProject().isOpen()) {
                    editorTabs.removeTabWithoutChangingSelection(info);
                } else {
                    TabInfo toSelect = this.getTabToSelect$intellij_platform_ide_impl(info, file2, componentIndex);
                    JBTabsImpl.removeTab$default((JBTabsImpl)((JBTabsImpl)editorTabs), (TabInfo)info, (TabInfo)toSelect, (boolean)false, (int)4, null);
                }
                fileEditorManager.disposeComposite$intellij_platform_ide_impl(composite2);
            }
            if (disposeIfNeeded && this.getTabCount() == 0) {
                this.removeFromSplitter();
                this.logEmptyStateIfMainSplitter$intellij_platform_ide_impl(FileEditorCollector.EmptyStateCause.ALL_TABS_CLOSED);
            } else {
                this.getComponent$intellij_platform_ide_impl().revalidate();
            }
            if (editorTabs.getSelectedInfo() != null) return;
            this._currentCompositeFlow.setValue(null);
            return;
        }
        finally {
            Instant openedTs = (Instant)file2.getUserData(ReadmeShownUsageCollector.INSTANCE.getREADME_OPENED_ON_START_TS$intellij_platform_ide_impl());
            if (openedTs != null) {
                file2.putUserData(ReadmeShownUsageCollector.INSTANCE.getREADME_OPENED_ON_START_TS$intellij_platform_ide_impl(), null);
                long wasOpenedMillis = Instant.now().toEpochMilli() - openedTs.toEpochMilli();
                ReadmeShownUsageCollector.INSTANCE.logReadmeClosedIn$intellij_platform_ide_impl(wasOpenedMillis);
            }
            fileEditorManager.removeSelectionRecord$intellij_platform_ide_impl(file2, this);
            Project project4 = fileEditorManager.getProject();
            if (!project4.isDisposed()) {
                MessageBus messageBus = project4.getMessageBus();
                Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
                ((FileEditorManagerListener)messageBus.syncPublisher(topic)).fileClosed((FileEditorManager)fileEditorManager, file2);
            }
            this.owner.afterFileClosed$intellij_platform_ide_impl(file2);
        }
    }

    public static /* synthetic */ void closeFile$intellij_platform_ide_impl$default(EditorWindow editorWindow, VirtualFile virtualFile2, EditorComposite editorComposite, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        editorWindow.closeFile$intellij_platform_ide_impl(virtualFile2, editorComposite, bl);
    }

    @Nullable
    public final TabInfo getTabToSelect$intellij_platform_ide_impl(@NotNull TabInfo tabBeingClosed, @NotNull VirtualFile fileBeingClosed, int componentIndex) {
        Intrinsics.checkNotNullParameter((Object)tabBeingClosed, (String)"tabBeingClosed");
        Intrinsics.checkNotNullParameter((Object)fileBeingClosed, (String)"fileBeingClosed");
        TabInfo previousSelection = tabBeingClosed.getPreviousSelection();
        if (previousSelection != null && this.tabbedPane.editorTabs.getVisibleInfos().contains(previousSelection)) {
            return previousSelection;
        }
        int indexToSelect = this.computeIndexToSelect$intellij_platform_ide_impl(fileBeingClosed, componentIndex);
        JBEditorTabs editorTabs = this.tabbedPane.editorTabs;
        return indexToSelect >= 0 && indexToSelect < editorTabs.getTabCount() ? editorTabs.getTabAt(indexToSelect) : null;
    }

    public final void logEmptyStateIfMainSplitter$intellij_platform_ide_impl(@NotNull FileEditorCollector.EmptyStateCause cause) {
        Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
        if (!(this.getTabCount() == 0)) {
            boolean bl = false;
            String string = "Tab count expected to be zero";
            throw new IllegalArgumentException(string.toString());
        }
        if (EditorEmptyTextPainter.isEnabled() && this.getComponent$intellij_platform_ide_impl().getParent() == this.getManager().getMainSplitters()) {
            FileEditorCollector.INSTANCE.logEditorEmptyState(this.getManager().getProject(), cause);
        }
    }

    public final void removeFromSplitter() {
        if (!this.inSplitter()) {
            return;
        }
        EditorWindow it = this.owner.getCurrentWindow();
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)it, (Object)this) || it == null;
        if (bl2) {
            this.owner.setCurrentWindow$intellij_platform_ide_impl((EditorWindow)SequencesKt.firstOrNull(this.siblings$intellij_platform_ide_impl()), true);
        }
        Container container = this.getComponent$intellij_platform_ide_impl().getParent();
        Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.Splitter");
        Splitter splitter2 = (Splitter)container;
        JComponent otherComponent = splitter2.getOtherComponent((Component)this.getComponent$intellij_platform_ide_impl());
        Container parent = splitter2.getParent();
        if (parent instanceof Splitter) {
            if (((Splitter)parent).getFirstComponent() == splitter2) {
                ((Splitter)parent).setFirstComponent(otherComponent);
            } else {
                ((Splitter)parent).setSecondComponent(otherComponent);
            }
            EditorWindow editorWindow = this.owner.getCurrentWindow();
            Intrinsics.checkNotNull((Object)editorWindow);
            this.normalizeProportionsIfNeed(editorWindow.getComponent$intellij_platform_ide_impl());
        } else if (parent instanceof EditorsSplitters) {
            Component currentFocusComponent = IdeFocusManager.getGlobalInstance().getFocusedDescendantFor((Component)parent);
            ((EditorsSplitters)parent).removeAll();
            ((EditorsSplitters)parent).add((Component)otherComponent, "Center");
            ((EditorsSplitters)parent).revalidate();
            Component component2 = currentFocusComponent;
            if (component2 != null) {
                component2.requestFocusInWindow();
            }
        } else {
            EditorWindowKt.access$getLOG$p().error("Unknown container: " + parent);
        }
        this.dispose$intellij_platform_ide_impl();
    }

    public final int computeIndexToSelect$intellij_platform_ide_impl(@NotNull VirtualFile fileBeingClosed, int fileIndex) {
        Intrinsics.checkNotNullParameter((Object)fileBeingClosed, (String)"fileBeingClosed");
        int currentlySelectedIndex = this.tabbedPane.getSelectedIndex();
        if (currentlySelectedIndex != fileIndex) {
            return currentlySelectedIndex;
        }
        UISettings uiSettings = UISettings.Companion.getInstance();
        if (uiSettings.getState().getActiveMruEditorOnClose()) {
            List<VirtualFile> histFiles = EditorHistoryManager.Companion.getInstance(this.getManager().getProject()).getFileList();
            int n = ((Collection)histFiles).size() + -1;
            if (0 <= n) {
                do {
                    int histFileIndex;
                    int index;
                    VirtualFile histFile;
                    if (Intrinsics.areEqual((Object)(histFile = histFiles.get(index = n--)), (Object)fileBeingClosed)) continue;
                    EditorComposite editorComposite = this.getComposite(histFile);
                    if (editorComposite == null || (histFileIndex = this.findComponentIndex(editorComposite)) < 0) continue;
                    return histFileIndex;
                } while (0 <= n);
            }
        } else if (uiSettings.getActiveRightEditorOnClose() && fileIndex + 1 < this.tabbedPane.getTabCount()) {
            return fileIndex + 1;
        }
        return fileIndex > 0 ? fileIndex - 1 : -1;
    }

    @NotNull
    public final SplitChooser showSplitChooser$intellij_platform_ide_impl(@NotNull Project project2, boolean showInfoPanel) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Disposable disposable = Disposer.newDisposable((String)"GlassPaneListeners");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        MySplitPainter painter = new MySplitPainter(project2, showInfoPanel, this.tabbedPane, this.owner);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            IdeGlassPaneUtil.find((Component)this.getComponent$intellij_platform_ide_impl()).addPainter((Component)this.getComponent$intellij_platform_ide_impl(), (Painter)painter, disposable2);
        }
        ComponentAdapter updatePainterSizeOnTabbedPaneResizeListener2 = new ComponentAdapter(painter){
            final /* synthetic */ MySplitPainter $painter;
            {
                this.$painter = $painter;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$painter.updateRectangleAndRepaint();
            }
        };
        this.getComponent$intellij_platform_ide_impl().addComponentListener(updatePainterSizeOnTabbedPaneResizeListener2);
        TabInfo tabInfo = this.tabbedPane.getTabs().getSelectedInfo();
        Intrinsics.checkNotNull((Object)tabInfo);
        Component component2 = tabInfo.getComponent().getComponent(0);
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent componentToFocus = (JComponent)component2;
        componentToFocus.repaint();
        componentToFocus.setFocusable(true);
        componentToFocus.grabFocus();
        componentToFocus.setFocusTraversalKeysEnabled(false);
        FocusAdapter focusAdapter2 = new FocusAdapter(this, updatePainterSizeOnTabbedPaneResizeListener2, componentToFocus, project2){
            final /* synthetic */ EditorWindow this$0;
            final /* synthetic */ showSplitChooser.updatePainterSizeOnTabbedPaneResizeListener.1 $updatePainterSizeOnTabbedPaneResizeListener;
            final /* synthetic */ JComponent $componentToFocus;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$updatePainterSizeOnTabbedPaneResizeListener = $updatePainterSizeOnTabbedPaneResizeListener;
                this.$componentToFocus = $componentToFocus;
                this.$project = $project;
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getComponent$intellij_platform_ide_impl().removeComponentListener(this.$updatePainterSizeOnTabbedPaneResizeListener);
                this.$componentToFocus.removeFocusListener(this);
                SplitterService splitterService = SplitterService.Companion.getInstance(this.$project);
                if (Intrinsics.areEqual((Object)splitterService.getActiveWindow(), (Object)this.this$0)) {
                    splitterService.stopSplitChooser(true);
                }
            }
        };
        componentToFocus.addFocusListener(focusAdapter2);
        return new SplitChooser(painter, this, updatePainterSizeOnTabbedPaneResizeListener2, componentToFocus, focusAdapter2, disposable2){
            final /* synthetic */ MySplitPainter $painter;
            final /* synthetic */ EditorWindow this$0;
            final /* synthetic */ showSplitChooser.updatePainterSizeOnTabbedPaneResizeListener.1 $updatePainterSizeOnTabbedPaneResizeListener;
            final /* synthetic */ JComponent $componentToFocus;
            final /* synthetic */ showSplitChooser.focusAdapter.1 $focusAdapter;
            final /* synthetic */ Disposable $disposable;
            {
                this.$painter = $painter;
                this.this$0 = $receiver;
                this.$updatePainterSizeOnTabbedPaneResizeListener = $updatePainterSizeOnTabbedPaneResizeListener;
                this.$componentToFocus = $componentToFocus;
                this.$focusAdapter = $focusAdapter;
                this.$disposable = $disposable;
            }

            public RelativePosition getPosition() {
                return this.$painter.getPosition();
            }

            public void positionChanged(RelativePosition position2) {
                Intrinsics.checkNotNullParameter((Object)((Object)position2), (String)"position");
                this.$painter.positionChanged(position2);
            }

            public void dispose() {
                this.this$0.getComponent$intellij_platform_ide_impl().removeComponentListener(this.$updatePainterSizeOnTabbedPaneResizeListener);
                this.$painter.setRectangle(null);
                this.$componentToFocus.removeFocusListener(this.$focusAdapter);
                this.$componentToFocus.setFocusable(false);
                this.$componentToFocus.repaint();
                Disposer.dispose((Disposable)this.$disposable);
            }
        };
    }

    public final void changeOrientation() {
        this.checkConsistency();
        Container parent = this.getComponent$intellij_platform_ide_impl().getParent();
        if (parent instanceof Splitter) {
            ((Splitter)parent).setOrientation(!((Splitter)parent).getOrientation());
        }
    }

    @JvmName(name="unsplit")
    public final void unsplit(boolean setCurrent) {
        Object object;
        List siblingWindows;
        Splitter splitter2;
        block10: {
            this.checkConsistency();
            Container container = this.getComponent$intellij_platform_ide_impl().getParent();
            Splitter splitter3 = container instanceof Splitter ? (Splitter)container : null;
            if (splitter3 == null) {
                return;
            }
            splitter2 = splitter3;
            siblingWindows = SequencesKt.toList((Sequence)SequencesKt.filter(this.owner.windows(), arg_0 -> EditorWindow.unsplit$lambda$0(this, splitter2, arg_0)));
            object = this.getSelectedComposite();
            if (object == null) {
                for (Object eachSibling : (Iterable)siblingWindows) {
                    boolean bl = false;
                    if ((eachSibling = ((EditorWindow)eachSibling).getSelectedComposite()) == null) continue;
                    object = eachSibling;
                    break block10;
                }
                object = null;
            }
        }
        EditorComposite compositeToSelect = object;
        FileEditorOpenOptions openOptions = new FileEditorOpenOptions(false, false, false, false, false, 0, false, null, false, false, false, null, 4086, null);
        int editorTabLimit = UISettings.Companion.getInstance().getState().getEditorTabLimit();
        for (EditorWindow siblingWindow : siblingWindows) {
            for (EditorComposite siblingComposite : SequencesKt.toList(siblingWindow.composites())) {
                Object v3;
                block11: {
                    if (compositeToSelect == null) {
                        compositeToSelect = siblingComposite;
                    }
                    List list2 = this.tabbedPane.getTabs().getTabs();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTabs(...)");
                    Iterable $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        TabInfo it = (TabInfo)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!Intrinsics.areEqual((Object)EditorWindowKt.getComposite(it).getFile(), (Object)siblingComposite.getFile())) continue;
                        v3 = element$iv;
                        break block11;
                    }
                    v3 = null;
                }
                if (v3 == null && this.getTabCount() < editorTabLimit) {
                    this.addComposite$intellij_platform_ide_impl(siblingComposite, siblingComposite.getFile(), openOptions, true);
                    continue;
                }
                this.getManager().disposeComposite$intellij_platform_ide_impl(siblingComposite);
            }
            siblingWindow.dispose$intellij_platform_ide_impl();
        }
        Container container = splitter2.getParent();
        Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type javax.swing.JPanel");
        JPanel parent = (JPanel)container;
        EditorWindowKt.access$swapComponents(parent, this.tabbedPane.getComponent(), (JComponent)splitter2);
        parent.revalidate();
        if (compositeToSelect != null) {
            this.setSelectedComposite(compositeToSelect, true);
        }
        if (setCurrent) {
            this.owner.setCurrentWindow$intellij_platform_ide_impl(this, false);
        }
        this.normalizeProportionsIfNeed(this.getComponent$intellij_platform_ide_impl());
    }

    public final void unsplitAll() {
        this.checkConsistency();
        while (this.inSplitter()) {
            this.unsplit(true);
        }
    }

    public final boolean inSplitter() {
        this.checkConsistency();
        return this.getComponent$intellij_platform_ide_impl().getParent() instanceof Splitter;
    }

    @Nullable
    public final VirtualFile getSelectedFile() {
        this.checkConsistency();
        EditorComposite editorComposite = this.getSelectedComposite();
        return editorComposite != null ? editorComposite.getFile() : null;
    }

    @Deprecated(message="Use {@link #getComposite(VirtualFile)}", replaceWith=@ReplaceWith(expression="getComposite(file)", imports={}))
    @Nullable
    public final EditorWithProviderComposite findFileComposite(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return (EditorWithProviderComposite)this.getComposite(file2);
    }

    @Nullable
    public final EditorComposite getComposite(@NotNull VirtualFile inputFile) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        TabInfo tabInfo = this.findTabByFile$intellij_platform_ide_impl(inputFile);
        return tabInfo != null ? EditorWindowKt.getComposite(tabInfo) : null;
    }

    @Nullable
    public final Pair<EditorComposite, TabInfo> findCompositeAndTab(@NotNull VirtualFile inputFile) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        BackedVirtualFile backedVirtualFile = inputFile instanceof BackedVirtualFile ? (BackedVirtualFile)inputFile : null;
        if (backedVirtualFile == null || (backedVirtualFile = backedVirtualFile.getOriginFile()) == null) {
            backedVirtualFile = inputFile;
        }
        BackedVirtualFile file2 = backedVirtualFile;
        for (TabInfo tab : this.tabbedPane.getTabs().getTabs()) {
            Intrinsics.checkNotNull((Object)tab);
            EditorComposite composite2 = EditorWindowKt.getComposite(tab);
            if (!Intrinsics.areEqual((Object)composite2.getFile(), (Object)file2)) continue;
            return TuplesKt.to((Object)composite2, (Object)tab);
        }
        return null;
    }

    private final int findComponentIndex(EditorComposite composite2) {
        int n;
        block2: {
            List list2 = this.tabbedPane.getTabs().getTabs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTabs(...)");
            List $this$indexOfFirst$iv = list2;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                TabInfo it = (TabInfo)item$iv;
                boolean bl = false;
                if (it.getComponent() == composite2.getComponent()) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    @Nullable
    public final TabInfo findTabByComposite$intellij_platform_ide_impl(@NotNull EditorComposite composite2) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)composite2, (String)"composite");
            List list2 = this.tabbedPane.getTabs().getTabs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTabs(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TabInfo it = (TabInfo)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(EditorWindowKt.getComposite(it) == composite2)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final TabInfo findTabByFile$intellij_platform_ide_impl(@NotNull VirtualFile file2) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            List list2 = this.tabbedPane.getTabs().getTabs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTabs(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TabInfo it = (TabInfo)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)EditorWindowKt.getComposite(it).getFile(), (Object)file2)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    public final boolean isFileOpen(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getComposite(file2) != null;
    }

    public final boolean isFilePinned(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        EditorComposite editorComposite = this.getComposite(file2);
        if (editorComposite == null) {
            boolean bl = false;
            String string = "file is not open: " + file2;
            throw new IllegalArgumentException(string.toString());
        }
        return editorComposite.isPinned();
    }

    public final void setFilePinned(@NotNull VirtualFile file2, boolean pinned) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        EditorWindow editorWindow = this;
        EditorComposite editorComposite = this.getComposite(file2);
        if (editorComposite == null) {
            EditorWindow editorWindow2 = editorWindow;
            boolean bl = false;
            EditorWindow editorWindow3 = editorWindow2;
            String string = "file is not open: " + file2;
            throw new IllegalArgumentException(string.toString());
        }
        editorWindow.setFilePinned(editorComposite, pinned);
    }

    private final void setFilePinned(EditorComposite composite2, boolean pinned) {
        block2: {
            boolean wasPinned = composite2.isPinned();
            composite2.setPinned(pinned);
            if (pinned && composite2.isPreview()) {
                composite2.setPreview(false);
                this.owner.scheduleUpdateFileColor$intellij_platform_ide_impl(composite2.getFile());
            }
            if (wasPinned == pinned || !EDT.isCurrentThreadEdt()) break block2;
            JBTabs jBTabs = this.tabbedPane.getTabs();
            JBTabsImpl jBTabsImpl = jBTabs instanceof JBTabsImpl ? (JBTabsImpl)jBTabs : null;
            if (jBTabsImpl != null) {
                jBTabsImpl.doLayout();
            }
        }
    }

    public final void trimToSize(@Nullable VirtualFile fileToIgnore, boolean transferFocus) {
        if (!this.isDisposed()) {
            this.doTrimSize(fileToIgnore, UISettings.Companion.getInstance().getState().getCloseNonModifiedFilesFirst(), transferFocus);
        }
    }

    private final void doTrimSize(VirtualFile fileToIgnore, boolean closeNonModifiedFilesFirst, boolean transferFocus) {
        VirtualFile virtualFile2;
        VirtualFile selectedFile = this.getSelectedFile();
        if (selectedFile != null && this.shouldCloseSelected(selectedFile, fileToIgnore)) {
            this.defaultCloseFile(selectedFile, transferFocus);
            virtualFile2 = selectedFile;
        } else {
            virtualFile2 = null;
        }
        VirtualFile alreadyClosedFile = virtualFile2;
        for (VirtualFile file2 : SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(this.composites(), EditorWindow::doTrimSize$lambda$0), EditorWindow::doTrimSize$lambda$1), arg_0 -> EditorWindow.doTrimSize$lambda$2(fileToIgnore, arg_0))))) {
            this.defaultCloseFile(file2, transferFocus);
        }
        int limit = Companion.getTabLimit();
        if (EditorWindow.doTrimSize$isUnderLimit(this, limit, fileToIgnore)) {
            return;
        }
        Set<VirtualFile> closingOrder = this.getTabClosingOrder(closeNonModifiedFilesFirst);
        for (VirtualFile file3 : closingOrder) {
            if (EditorWindow.doTrimSize$isUnderLimit(this, limit, fileToIgnore)) {
                return;
            }
            if (Intrinsics.areEqual((Object)file3, (Object)alreadyClosedFile) || !this.fileCanBeClosed(file3, fileToIgnore)) continue;
            this.defaultCloseFile(file3, transferFocus);
        }
    }

    private final Set<VirtualFile> getTabClosingOrder(boolean closeNonModifiedFilesFirst) {
        List allFiles = SequencesKt.toList(this.files$intellij_platform_ide_impl());
        List<VirtualFile> histFiles = EditorHistoryManager.Companion.getInstance(this.getManager().getProject()).getFileList();
        LinkedHashSet<VirtualFile> closingOrder = new LinkedHashSet<VirtualFile>();
        for (VirtualFile file2 : allFiles) {
            if (histFiles.contains(file2)) continue;
            closingOrder.add(file2);
        }
        if (closeNonModifiedFilesFirst) {
            for (VirtualFile file2 : histFiles) {
                EditorComposite composite2 = this.getComposite(file2);
                if (composite2 == null || this.owner.getManager().isChanged(composite2)) continue;
                closingOrder.add(file2);
            }
            for (EditorComposite composite3 : this.composites()) {
                if (this.owner.getManager().isChanged(composite3)) continue;
                closingOrder.add(composite3.getFile());
            }
        }
        closingOrder.addAll((Collection)histFiles);
        for (EditorComposite composite3 : this.composites()) {
            closingOrder.add(composite3.getFile());
        }
        VirtualFile selectedFile = this.getSelectedFile();
        if (selectedFile != null) {
            closingOrder.remove(selectedFile);
            closingOrder.add(selectedFile);
        }
        return closingOrder;
    }

    private final boolean shouldCloseSelected(VirtualFile file2, VirtualFile fileToIgnore) {
        if (!UISettings.Companion.getInstance().getReuseNotModifiedTabs() || !this.owner.getManager().getProject().isInitialized()) {
            return false;
        }
        EditorComposite editorComposite = this.getComposite(file2);
        if (editorComposite == null) {
            return false;
        }
        EditorComposite composite2 = editorComposite;
        if (composite2.isPinned() || Intrinsics.areEqual((Object)file2, (Object)fileToIgnore)) {
            return false;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JComponent component2;
            Component owner = IdeFocusManager.getInstance((Project)this.owner.getManager().getProject()).getFocusOwner();
            if (owner == null) {
                return false;
            }
            FileEditor fileEditor = composite2.getSelectedEditor();
            JComponent jComponent = component2 = fileEditor != null ? fileEditor.getComponent() : null;
            if (component2 == null || !SwingUtilities.isDescendingFrom(owner, component2)) {
                return false;
            }
        }
        return !this.owner.getManager().isChanged(composite2);
    }

    private final boolean isAnyTabClosable(VirtualFile fileToIgnore) {
        boolean bl;
        block3: {
            List list2 = this.tabbedPane.getTabs().getTabs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTabs(...)");
            Iterable $this$any$iv = CollectionsKt.asReversedMutable((List)list2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TabInfo it = (TabInfo)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.fileCanBeClosed(EditorWindowKt.getComposite(it).getFile(), fileToIgnore)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void defaultCloseFile(VirtualFile file2, boolean transferFocus) {
        this.closeFile(file2, true, transferFocus);
    }

    private final boolean fileCanBeClosed(VirtualFile file2, VirtualFile fileToIgnore) {
        if (file2 instanceof BackedVirtualFile && Intrinsics.areEqual((Object)((BackedVirtualFile)file2).getOriginFile(), (Object)fileToIgnore)) {
            return false;
        }
        return this.isFileOpen(file2) && !Intrinsics.areEqual((Object)file2, (Object)fileToIgnore) && !this.isFilePinned(file2) && this.isClosingAllowed(file2);
    }

    private final boolean isClosingAllowed(VirtualFile file2) {
        boolean bl;
        block5: {
            List extensions = EditorAutoClosingHandler.Companion.getEP_NAME().getExtensionList();
            if (extensions.isEmpty()) {
                return true;
            }
            EditorComposite editorComposite = this.getComposite(file2);
            if (editorComposite == null) {
                return true;
            }
            EditorComposite composite2 = editorComposite;
            Iterable $this$all$iv = extensions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    EditorAutoClosingHandler it = (EditorAutoClosingHandler)element$iv;
                    boolean bl2 = false;
                    if (it.isClosingAllowed(composite2)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        if (EDT.isCurrentThreadEdt()) {
            return "EditorWindow(files=" + SequencesKt.joinToString$default(this.composites(), null, null, null, (int)0, null, EditorWindow::toString$lambda$0, (int)31, null) + ")";
        }
        return super.toString();
    }

    @JvmOverloads
    @RequiresEdt
    @Nullable
    public final EditorWindow split(int orientation, boolean forceSplit, @Nullable VirtualFile virtualFile2, boolean focusNew, boolean fileIsSecondaryComponent) {
        return EditorWindow.split$default(this, orientation, forceSplit, virtualFile2, focusNew, fileIsSecondaryComponent, false, 32, null);
    }

    @JvmOverloads
    @RequiresEdt
    @Nullable
    public final EditorWindow split(int orientation, boolean forceSplit, @Nullable VirtualFile virtualFile2, boolean focusNew) {
        return EditorWindow.split$default(this, orientation, forceSplit, virtualFile2, focusNew, false, false, 48, null);
    }

    @JvmOverloads
    public final void closeFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        EditorWindow.closeFile$default(this, file2, false, 2, null);
    }

    private static final EditorComposite composites$lambda$0(TabInfo it) {
        Intrinsics.checkNotNull((Object)it);
        return EditorWindowKt.getComposite(it);
    }

    private static final VirtualFile files$lambda$0(EditorComposite it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile();
    }

    private static final Component getAdjacentEditors$lambda$0(EditorWindow this$0, int x, int y) {
        return SwingUtilities.getDeepestComponentAt(this$0.owner, x, y);
    }

    private static final EditorWindow getAdjacentEditors$findAdjacentEditor(EditorWindow this$0, HashMap<JComponent, EditorWindow> panelToWindow, Component startComponent) {
        Component component2 = startComponent;
        while (component2 != this$0.owner && component2 != null) {
            EditorWindow editorWindow = (EditorWindow)((Map)panelToWindow).get(component2);
            if (editorWindow != null) {
                EditorWindow it = editorWindow;
                boolean bl = false;
                return it;
            }
            Container container = component2.getParent();
            if (container == null) {
                break;
            }
            component2 = container;
        }
        return null;
    }

    private static final void getAdjacentEditors$biConsumer(HashMap<RelativePosition, EditorWindow> adjacentEditors, EditorWindow window, RelativePosition position2) {
        if (window != null) {
            adjacentEditors.put(position2, window);
        }
    }

    private static final TabInfoIconHolder addComposite$lambda$1(EditorComposite $composite, TabInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CompositeTabIconHolderCreator.Companion.getInstance().createTabIconHolder($composite, it);
    }

    private static final void split$lambda$2(EditorComposite $selectedComposite) {
        block0: {
            Object object = $selectedComposite;
            if (object == null || (object = ((EditorComposite)object).getPreferredFocusedComponent()) == null) break block0;
            Object it = object;
            boolean bl = false;
            IdeFocusManager.getGlobalInstance().requestFocus((Component)it, true);
        }
    }

    private static final boolean siblings$lambda$0(EditorWindow this$0, Splitter $splitter, EditorWindow it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)this$0) && SwingUtilities.isDescendingFrom(it.getComponent$intellij_platform_ide_impl(), (Component)$splitter);
    }

    private static final void closeFile$lambda$0$0(FileEditorManagerImpl $fileEditorManager, VirtualFile $file) {
        MessageBus messageBus = $fileEditorManager.getProject().getMessageBus();
        Topic topic = FileEditorManagerListener.Before.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        ((FileEditorManagerListener.Before)messageBus.syncPublisher(topic)).beforeFileClosed((FileEditorManager)$fileEditorManager, $file);
    }

    private static final boolean unsplit$lambda$0(EditorWindow this$0, Splitter $splitter, EditorWindow it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)this$0) && SwingUtilities.isDescendingFrom(it.getComponent$intellij_platform_ide_impl(), (Component)$splitter);
    }

    private static final boolean doTrimSize$lambda$0(EditorComposite it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isPreview();
    }

    private static final VirtualFile doTrimSize$lambda$1(EditorComposite it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile();
    }

    private static final boolean doTrimSize$lambda$2(VirtualFile $fileToIgnore, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$fileToIgnore);
    }

    private static final boolean doTrimSize$isUnderLimit(EditorWindow this$0, int limit, VirtualFile $fileToIgnore) {
        return this$0.tabbedPane.getTabCount() <= limit || this$0.tabbedPane.getTabCount() == 0 || !this$0.isAnyTabClosable($fileToIgnore);
    }

    private static final CharSequence toString$lambda$0(EditorComposite it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    public static final int getTabLimit() {
        return Companion.getTabLimit();
    }

    static {
        KeyWithDefaultValue keyWithDefaultValue = KeyWithDefaultValue.create((String)"drag start editor index", (Object)-1);
        Intrinsics.checkNotNullExpressionValue((Object)keyWithDefaultValue, (String)"create(...)");
        DRAG_START_INDEX_KEY = (Key)keyWithDefaultValue;
        KeyWithDefaultValue keyWithDefaultValue2 = KeyWithDefaultValue.create((String)"drag start editor location hash", (Object)0);
        Intrinsics.checkNotNullExpressionValue((Object)keyWithDefaultValue2, (String)"create(...)");
        DRAG_START_LOCATION_HASH_KEY = (Key)keyWithDefaultValue2;
        Key key = Key.create((String)"drag start editor pinned state");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DRAG_START_PINNED_KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorWindow$Companion;", "", "<init>", "()V", "DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "DRAG_START_INDEX_KEY", "Lcom/intellij/openapi/util/Key;", "", "getDRAG_START_INDEX_KEY$intellij_platform_ide_impl", "()Lcom/intellij/openapi/util/Key;", "DRAG_START_LOCATION_HASH_KEY", "getDRAG_START_LOCATION_HASH_KEY$intellij_platform_ide_impl", "DRAG_START_PINNED_KEY", "", "tabLimit", "getTabLimit$annotations", "getTabLimit", "()I", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Integer> getDRAG_START_INDEX_KEY$intellij_platform_ide_impl() {
            return DRAG_START_INDEX_KEY;
        }

        @NotNull
        public final Key<Integer> getDRAG_START_LOCATION_HASH_KEY$intellij_platform_ide_impl() {
            return DRAG_START_LOCATION_HASH_KEY;
        }

        public final int getTabLimit() {
            if (DistractionFreeModeController.isDistractionFreeModeEnabled() && DistractionFreeModeController.getStandardTabPlacement() == 0) {
                return 1;
            }
            return UISettings.Companion.getInstance().getEditorTabLimit();
        }

        @JvmStatic
        public static /* synthetic */ void getTabLimit$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorWindow$RelativePosition;", "", "swingConstant", "", "<init>", "(Ljava/lang/String;II)V", "CENTER", "UP", "LEFT", "DOWN", "RIGHT", "intellij.platform.ide.impl"})
    public static final class RelativePosition
    extends Enum<RelativePosition> {
        @JvmField
        public final int swingConstant;
        public static final /* enum */ RelativePosition CENTER = new RelativePosition(0);
        public static final /* enum */ RelativePosition UP = new RelativePosition(1);
        public static final /* enum */ RelativePosition LEFT = new RelativePosition(2);
        public static final /* enum */ RelativePosition DOWN = new RelativePosition(3);
        public static final /* enum */ RelativePosition RIGHT = new RelativePosition(4);
        private static final /* synthetic */ RelativePosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RelativePosition(int swingConstant) {
            this.swingConstant = swingConstant;
        }

        public static RelativePosition[] values() {
            return (RelativePosition[])$VALUES.clone();
        }

        public static RelativePosition valueOf(String value) {
            return Enum.valueOf(RelativePosition.class, value);
        }

        @NotNull
        public static EnumEntries<RelativePosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = relativePositionArray = new RelativePosition[]{RelativePosition.CENTER, RelativePosition.UP, RelativePosition.LEFT, RelativePosition.DOWN, RelativePosition.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\b\u001a\u00020\u0007H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorWindow$SplitChooser;", "", "position", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow$RelativePosition;", "getPosition", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow$RelativePosition;", "positionChanged", "", "dispose", "intellij.platform.ide.impl"})
    public static interface SplitChooser {
        @NotNull
        public RelativePosition getPosition();

        public void positionChanged(@NotNull RelativePosition var1);

        public void dispose();
    }
}

