/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.project.Project;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FocusBasedCurrentEditorProvider
implements CurrentEditorProvider {
    private static final Logger LOG = Logger.getInstance(FocusBasedCurrentEditorProvider.class);

    @Override
    @Nullable
    public FileEditor getCurrentEditor(@Nullable Project project2) {
        return FocusBasedCurrentEditorProvider.getCurrentEditorEx();
    }

    @ApiStatus.Internal
    @Nullable
    public static FileEditor getCurrentEditorEx() {
        try {
            return FocusBasedCurrentEditorProvider.getCurrentEditorEx0();
        }
        catch (Throwable ex) {
            LOG.error("Failed to retrieve focused editor", ex);
            return null;
        }
    }

    @Nullable
    private static FileEditor getCurrentEditorEx0() {
        DataManager dataManager = DataManager.getInstanceIfCreated();
        if (dataManager != null) {
            return FocusBasedCurrentEditorProvider.getFocusedEditor(dataManager.getDataContext());
        }
        return null;
    }

    @Nullable
    private static FileEditor getFocusedEditor(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            FocusBasedCurrentEditorProvider.$$$reportNull$$$0(0);
        }
        return (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(dataContext2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/fileEditor/impl/FocusBasedCurrentEditorProvider", "getFocusedEditor"));
    }

    @ApiStatus.Internal
    @TestOnly
    public static final class TestProvider
    implements CurrentEditorProvider {
        private final @NotNull Supplier<? extends @Nullable Editor> focusedEditor;

        public TestProvider(@NotNull Supplier<? extends @Nullable Editor> focusedEditor) {
            if (focusedEditor == null) {
                TestProvider.$$$reportNull$$$0(0);
            }
            this.focusedEditor = focusedEditor;
        }

        @Override
        @Nullable
        public FileEditor getCurrentEditor(@Nullable Project project2) {
            Editor editor2 = this.focusedEditor.get();
            if (editor2 != null) {
                DataContext dataContext2 = Utils.createAsyncDataContext(editor2.getContentComponent());
                return FocusBasedCurrentEditorProvider.getFocusedEditor(dataContext2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusedEditor", "com/intellij/openapi/fileEditor/impl/FocusBasedCurrentEditorProvider$TestProvider", "<init>"));
        }
    }
}

