/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.fileEditor.FileEntry;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/fileEditor/impl/MoveEditorToOppositeTabGroupAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "closeSource", "", "<init>", "(Z)V", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "e", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isEnabled", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "intellij.platform.ide.impl"})
public class MoveEditorToOppositeTabGroupAction
extends AnAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    private final boolean closeSource;

    public MoveEditorToOppositeTabGroupAction(boolean closeSource) {
        this.closeSource = closeSource;
    }

    public MoveEditorToOppositeTabGroupAction() {
        this(true);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext2 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext dataContext3 = dataContext2;
        VirtualFile virtualFile2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext3);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile vFile = virtualFile2;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext3);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        EditorWindow editorWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext3);
        if (editorWindow == null) {
            return;
        }
        EditorWindow window = editorWindow;
        List<EditorWindow> siblings = window.getSiblings();
        if (siblings.size() != 1) {
            return;
        }
        EditorComposite editorComposite = window.getSelectedComposite();
        FileEntry entry = editorComposite != null ? editorComposite.currentStateAsFileEntry() : null;
        vFile.putUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN, (Object)true);
        if (this.closeSource) {
            window.closeFile(vFile, true, false);
        }
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.Companion.getInstanceEx(project3);
        Intrinsics.checkNotNull((Object)((Object)fileEditorManagerEx), (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        ((FileEditorManagerImpl)fileEditorManagerEx).openFileImpl(siblings.get(0), vFile, entry, new FileEditorOpenOptions(false, false, false, true, false, 0, false, null, false, false, false, null, 4087, null));
        vFile.putUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation presentation3 = presentation2;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext dataContext3 = dataContext2;
        VirtualFile virtualFile2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext3);
        if (virtualFile2 == null) {
            return;
        }
        EditorWindow editorWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext3);
        if (editorWindow == null) {
            return;
        }
        boolean enabled2 = this.isEnabled(virtualFile2, editorWindow);
        presentation3.setEnabled(enabled2);
        if (e.isFromContextMenu()) {
            presentation3.setVisible(enabled2);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final boolean isEnabled(VirtualFile vFile, EditorWindow window) {
        if (!this.closeSource && FileEditorManagerImpl.Companion.forbidSplitFor(vFile)) {
            return false;
        }
        return window.getSiblings().size() == 1;
    }
}

