/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.options.ex.HierarchicalConfigurable;
import com.intellij.openapi.options.ex.Weighted;
import com.intellij.openapi.options.newEditor.ConfigurableMarkerProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ConfigurableWrapper
implements SearchableConfigurable,
Weighted,
HierarchicalConfigurable,
ConfigurableMarkerProvider {
    static final Logger LOG = Logger.getInstance(ConfigurableWrapper.class);
    private final ConfigurableEP<?> myEp;
    int myWeight;
    @Nullable
    private UnnamedConfigurable myConfigurable;
    @Nls
    @Nullable
    private String markerText;

    @Nullable
    public static <T extends UnnamedConfigurable> T wrapConfigurable(@NotNull ConfigurableEP<T> ep) {
        if (ep == null) {
            ConfigurableWrapper.$$$reportNull$$$0(0);
        }
        return ConfigurableWrapper.wrapConfigurable(ep, false);
    }

    @Nullable
    public static <T extends UnnamedConfigurable> T wrapConfigurable(@NotNull ConfigurableEP<T> ep, boolean settings) {
        if (ep == null) {
            ConfigurableWrapper.$$$reportNull$$$0(1);
        }
        if (!ep.canCreateConfigurable()) {
            return null;
        }
        if (settings || ep.displayName != null || ep.key != null || ep.parentId != null || ep.groupId != null) {
            return (T)(!ep.dynamic && ep.children == null && ep.childrenEPName == null ? new ConfigurableWrapper(ep) : new CompositeWrapper(ep, new Configurable[0]));
        }
        return ConfigurableWrapper.createConfigurable(ep, LOG.isDebugEnabled());
    }

    @Nullable
    private static <T extends UnnamedConfigurable> T createConfigurable(@NotNull ConfigurableEP<T> ep, boolean log) {
        if (ep == null) {
            ConfigurableWrapper.$$$reportNull$$$0(2);
        }
        try {
            long time = System.currentTimeMillis();
            UnnamedConfigurable configurable = ep.createConfigurable();
            if (configurable instanceof Configurable) {
                ConfigurableCardPanel.warn((Configurable)configurable, "init", time);
                if (log) {
                    LOG.debug("cannot create configurable wrapper for " + String.valueOf(configurable.getClass()));
                }
            }
            return (T)configurable;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    public static <T extends UnnamedConfigurable> @Unmodifiable List<T> createConfigurables(@NotNull ExtensionPointName<? extends ConfigurableEP<T>> name2) {
        List collection;
        if (name2 == null) {
            ConfigurableWrapper.$$$reportNull$$$0(3);
        }
        if ((collection = name2.getExtensionList()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result2 = new ArrayList(collection.size());
        for (ConfigurableEP item : collection) {
            T o = ConfigurableWrapper.wrapConfigurable(item, false);
            if (o == null) continue;
            result2.add(o);
        }
        return result2.isEmpty() ? Collections.emptyList() : result2;
    }

    public static boolean hasOwnContent(UnnamedConfigurable configurable) {
        SearchableConfigurable.Parent parent = ConfigurableWrapper.cast(SearchableConfigurable.Parent.class, configurable);
        return parent != null && parent.hasOwnContent();
    }

    public static boolean isNonDefaultProject(Configurable configurable) {
        return configurable instanceof NonDefaultProjectConfigurable || configurable instanceof ConfigurableWrapper && ((ConfigurableWrapper)configurable).myEp.nonDefaultProject;
    }

    public void focusOn(@Nls @NotNull String label2) {
        Configurable unwrapped;
        if (label2 == null) {
            ConfigurableWrapper.$$$reportNull$$$0(4);
        }
        if ((unwrapped = ConfigurableWrapper.cast(Configurable.class, (UnnamedConfigurable)this)) != null && unwrapped != this) {
            unwrapped.focusOn(label2);
        }
    }

    @ApiStatus.Internal
    public static <T> boolean tryToCast(@NotNull Class<T> type, @Nullable UnnamedConfigurable configurable) {
        if (type == null) {
            ConfigurableWrapper.$$$reportNull$$$0(5);
        }
        if (ConfigurableWrapper.cast(type, configurable) != null) {
            return true;
        }
        if (configurable instanceof Configurable.ClassCastChecker) {
            Configurable.ClassCastChecker checker = (Configurable.ClassCastChecker)configurable;
            return checker.tryToCast(type);
        }
        return false;
    }

    @Nullable
    public static <T> T cast(@NotNull Class<T> type, @Nullable UnnamedConfigurable configurable) {
        if (type == null) {
            ConfigurableWrapper.$$$reportNull$$$0(6);
        }
        if (configurable instanceof ConfigurableWrapper) {
            Class configurableType;
            ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable;
            if (wrapper2.myConfigurable == null && (configurableType = wrapper2.getExtensionPoint().getConfigurableType()) != null && !type.isAssignableFrom(configurableType)) {
                return null;
            }
            configurable = wrapper2.getConfigurable();
        }
        return type.isInstance(configurable) ? (T)type.cast(configurable) : null;
    }

    private ConfigurableWrapper(@NotNull ConfigurableEP<?> ep) {
        if (ep == null) {
            ConfigurableWrapper.$$$reportNull$$$0(7);
        }
        this.markerText = null;
        this.myEp = ep;
        this.myWeight = ep.groupWeight;
    }

    @Nullable
    public UnnamedConfigurable getRawConfigurable() {
        return this.myConfigurable;
    }

    public UnnamedConfigurable getConfigurable() {
        if (this.myConfigurable == null) {
            this.myConfigurable = ConfigurableWrapper.createConfigurable(this.myEp, false);
            if (this.myConfigurable == null) {
                String message = "Can't instantiate configurable for " + String.valueOf(this.myEp);
                PluginDescriptor pluginDescriptor = this.myEp.getPluginDescriptor();
                if (pluginDescriptor != null) {
                    LOG.error((Throwable)new PluginException(message, pluginDescriptor.getPluginId()));
                } else {
                    LOG.error(message);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("created configurable for " + String.valueOf(this.myConfigurable.getClass()));
            }
        }
        return this.myConfigurable;
    }

    @Override
    public int getWeight() {
        return this.myWeight;
    }

    @Nullable
    public String getDisplayNameFast() {
        return this.myEp.displayName == null && this.myEp.key == null ? null : this.myEp.getDisplayName();
    }

    @Nls
    public String getDisplayName() {
        if (this.myEp.displayName == null && this.myEp.key == null) {
            boolean loaded = this.myConfigurable != null;
            Configurable configurable = ConfigurableWrapper.cast(Configurable.class, (UnnamedConfigurable)this);
            if (configurable != null) {
                String name2 = configurable.getDisplayName();
                if (!loaded) {
                    String message = "No display name specified in plugin descriptor XML file for configurable " + configurable.getClass().getName() + ";\nspecify it using 'displayName' or 'key' attribute to avoid necessity to load the configurable class when Settings dialog is opened";
                    PluginDescriptor pluginDescriptor = this.myEp.getPluginDescriptor();
                    PluginId pluginId = pluginDescriptor != null ? pluginDescriptor.getPluginId() : null;
                    LOG.error((Throwable)new PluginException(message, pluginId));
                }
                return name2;
            }
        }
        return this.myEp.getDisplayName();
    }

    public String getProviderClass() {
        return this.myEp.providerClass;
    }

    @Nullable
    public Project getProject() {
        return this.myEp.getProject();
    }

    @Nullable
    public String getHelpTopic() {
        UnnamedConfigurable configurable = this.getConfigurable();
        return configurable instanceof Configurable ? ((Configurable)configurable).getHelpTopic() : null;
    }

    @Nullable
    public JComponent createComponent() {
        UnnamedConfigurable configurable = this.getConfigurable();
        return configurable == null ? null : configurable.createComponent();
    }

    public boolean isModified() {
        return this.getConfigurable().isModified();
    }

    public void apply() throws ConfigurationException {
        this.getConfigurable().apply();
    }

    public void reset() {
        this.getConfigurable().reset();
    }

    public void disposeUIResources() {
        UnnamedConfigurable configurable = this.myConfigurable;
        if (configurable != null) {
            configurable.disposeUIResources();
            this.myConfigurable = null;
        }
    }

    public void cancel() {
        UnnamedConfigurable configurable = this.myConfigurable;
        if (configurable != null) {
            configurable.cancel();
        }
    }

    @NotNull
    public String getId() {
        if (this.myEp.id != null) {
            String string = this.myEp.id;
            if (string == null) {
                ConfigurableWrapper.$$$reportNull$$$0(8);
            }
            return string;
        }
        boolean loaded = this.myConfigurable != null;
        SearchableConfigurable configurable = ConfigurableWrapper.cast(SearchableConfigurable.class, (UnnamedConfigurable)this);
        if (configurable != null) {
            String id2 = configurable.getId();
            if (!loaded) {
                LOG.debug("XML does not provide id for " + String.valueOf(configurable.getClass()));
            }
            String string = id2;
            if (string == null) {
                ConfigurableWrapper.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.myEp.providerClass != null ? this.myEp.providerClass : (this.myEp.instanceClass != null ? this.myEp.instanceClass : this.myEp.implementationClass);
        if (string == null) {
            ConfigurableWrapper.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public ConfigurableEP<?> getExtensionPoint() {
        ConfigurableEP<?> configurableEP = this.myEp;
        if (configurableEP == null) {
            ConfigurableWrapper.$$$reportNull$$$0(11);
        }
        return configurableEP;
    }

    @Override
    public String getParentId() {
        return this.myEp.parentId;
    }

    @Override
    public ConfigurableWrapper addChild(Configurable configurable) {
        return new CompositeWrapper(this.myEp, configurable);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        UnnamedConfigurable configurable = this.getConfigurable();
        return configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).enableSearch(option2) : null;
    }

    @NotNull
    public Class<?> getOriginalClass() {
        UnnamedConfigurable configurable = this.getConfigurable();
        Class<Object> clazz = configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).getOriginalClass() : (configurable != null ? configurable.getClass() : this.getClass());
        if (clazz == null) {
            ConfigurableWrapper.$$$reportNull$$$0(12);
        }
        return clazz;
    }

    @Override
    @Nls
    @Nullable
    public String getMarkerText() {
        return this.markerText;
    }

    @Override
    public void setMarkerText(@Nls @Nullable String text2) {
        this.markerText = text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableWrapper";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurables";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "focusOn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryToCast";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cast";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class CompositeWrapper
    extends ConfigurableWrapper
    implements Configurable.Composite {
        private Configurable[] myKids;
        private Comparator<Configurable> myComparator;
        private Predicate<? super Configurable> myFilter;
        private boolean isInitialized;

        private CompositeWrapper(@NotNull ConfigurableEP ep, Configurable ... kids) {
            if (ep == null) {
                CompositeWrapper.$$$reportNull$$$0(0);
            }
            super(ep);
            this.myComparator = COMPARATOR;
            this.myKids = kids;
        }

        @NotNull
        public @NotNull Configurable @NotNull [] getConfigurables() {
            Object composite2;
            if (this.isInitialized) {
                if (this.myKids == null) {
                    CompositeWrapper.$$$reportNull$$$0(1);
                }
                return this.myKids;
            }
            long time = System.currentTimeMillis();
            ArrayList<@NotNull Object> list2 = new ArrayList<Object>();
            if (this.myEp.dynamic && (composite2 = CompositeWrapper.cast(Configurable.Composite.class, (UnnamedConfigurable)this)) != null) {
                Collections.addAll(list2, composite2.getConfigurables());
            }
            if (this.myEp.children != null) {
                for (ConfigurableEP configurableEP : this.myEp.getChildren()) {
                    if (!configurableEP.isAvailable()) continue;
                    ContainerUtil.addIfNotNull(list2, (Object)((Configurable)CompositeWrapper.wrapConfigurable(configurableEP)));
                }
            }
            if (this.myEp.childrenEPName != null) {
                List extensions;
                Project project2 = this.myEp.getProject();
                ExtensionsArea extensionsArea = project2 == null ? ApplicationManager.getApplication().getExtensionArea() : project2.getExtensionArea();
                ExtensionPoint point = extensionsArea.getExtensionPointIfRegistered(this.myEp.childrenEPName);
                if (point == null) {
                    LOG.warn("Cannot find extension point " + this.myEp.childrenEPName + " in " + String.valueOf(extensionsArea));
                    extensions = Collections.emptyList();
                } else {
                    extensions = point.getExtensionList();
                }
                if (!extensions.isEmpty()) {
                    Configurable.Composite composite3;
                    if (extensions.get(0) instanceof ConfigurableEP) {
                        for (Object object : extensions) {
                            ContainerUtil.addIfNotNull(list2, (Object)((Configurable)CompositeWrapper.wrapConfigurable((ConfigurableEP)object)));
                        }
                    } else if (!this.myEp.dynamic && (composite3 = CompositeWrapper.cast(Configurable.Composite.class, (UnnamedConfigurable)this)) != null) {
                        Collections.addAll(list2, composite3.getConfigurables());
                    }
                }
            }
            Collections.addAll(list2, this.myKids);
            if (!(this.getRawConfigurable() instanceof Configurable.WithEpDependencies)) {
                list2.sort(COMPARATOR);
            }
            for (Configurable configurable : list2) {
                if (!(configurable instanceof Weighted) || ((Weighted)configurable).getWeight() == 0) continue;
                this.myComparator = COMPARATOR;
                list2.sort(this.myComparator);
                break;
            }
            if (this.myFilter != null) {
                list2.removeIf(Predicate.not(this.myFilter));
            }
            this.myKids = list2.toArray(new Configurable[0]);
            this.isInitialized = true;
            ConfigurableCardPanel.warn((Configurable)this, "children", time);
            if (this.myKids == null) {
                CompositeWrapper.$$$reportNull$$$0(2);
            }
            return this.myKids;
        }

        @Override
        public ConfigurableWrapper addChild(Configurable configurable) {
            if (this.myComparator != null) {
                int index = Arrays.binarySearch(this.myKids, configurable, this.myComparator);
                LOG.assertTrue(index < 0, (Object)"similar configurable is already exist");
                this.myKids = (Configurable[])ArrayUtil.insert((Object[])this.myKids, (int)(-1 - index), (Object)configurable);
            } else {
                this.myKids = (Configurable[])ArrayUtil.append((Object[])this.myKids, (Object)configurable);
            }
            return this;
        }

        public void setFilter(Predicate<? super Configurable> filter2) {
            this.myFilter = filter2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ep";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableWrapper$CompositeWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableWrapper$CompositeWrapper";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

