/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.newEditor.SimpleBanner;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

final class ConfigurableEditorBanner
extends SimpleBanner {
    private final JLabel myProjectIcon = new JLabel();
    public final JComponent myHeaderText;

    ConfigurableEditorBanner(Action action2, JComponent jLabel) {
        this.myHeaderText = jLabel;
        this.myProjectIcon.setMinimumSize(new Dimension(0, 0));
        this.myProjectIcon.setBorder((Border)JBUI.Borders.empty((int)8, (int)4, (int)8, (int)8));
        this.myProjectIcon.setIcon(AllIcons.General.ProjectConfigurable);
        this.myProjectIcon.setForeground(UIUtil.getContextHelpForeground());
        this.showProject(false);
        this.myLeftPanel.removeAll();
        this.myLeftPanel.add(this.myHeaderText);
        this.myLeftPanel.add(this.myProjectIcon);
        this.myLeftPanel.add((Component)new ActionLink(action2));
        this.myLeftPanel.add(this.myProgress);
    }

    void setProjectText(@Nullable @Nls String projectText) {
        boolean visible = projectText != null;
        this.showProject(visible);
        if (visible) {
            this.myProjectIcon.setToolTipText(projectText);
        }
    }

    void showProject(boolean hasProject) {
        this.myProjectIcon.setVisible(hasProject);
    }

    @Override
    void setLeftComponent(Component component2) {
        super.setLeftComponent(component2);
        this.myHeaderText.setVisible(component2 == null);
    }

    @Override
    Component getBaselineTemplate() {
        return this.myHeaderText;
    }
}

