/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.newEditor.CopySettingsPathAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a-\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u00042\u000e\b\u0004\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0082\b\u001a$\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u00a8\u0006\u0013"}, d2={"copy", "", "names", "", "", "getTextLabel", "component", "", "createSwingAction", "Ljavax/swing/Action;", "id", "name", "performer", "Lkotlin/Function0;", "", "copyLink", "supplier", "Ljava/util/function/Supplier;", "isHttp", "intellij.platform.ide.impl"})
public final class CopySettingsPathActionKt {
    private static final boolean copy(Collection<String> names) {
        Transferable transferable = CopySettingsPathAction.Companion.createTransferable(names);
        if (transferable == null) {
            return false;
        }
        CopyPasteManager.getInstance().setContents(transferable);
        return true;
    }

    private static final String getTextLabel(Object component2) {
        String text2;
        CharSequence charSequence;
        if (component2 instanceof JToggleButton && !((charSequence = (CharSequence)(text2 = ((JToggleButton)component2).getText())) == null || charSequence.length() == 0)) {
            return text2;
        }
        if (component2 instanceof JLabel) {
            text2 = ((JLabel)component2).getText();
            charSequence = text2;
            if (!(charSequence == null || charSequence.length() == 0)) {
                return text2;
            }
        } else if (component2 instanceof JComponent) {
            return CopySettingsPathActionKt.getTextLabel(((JComponent)component2).getClientProperty("labeledBy"));
        }
        return null;
    }

    private static final Action createSwingAction(String id2, @NlsActions.ActionText String name2, Function0<Unit> performer) {
        AbstractAction action2;
        block1: {
            boolean $i$f$createSwingAction = false;
            action2 = new AbstractAction(name2, performer){
                final /* synthetic */ Function0<Unit> $performer;
                {
                    this.$performer = $performer;
                    super($name);
                }

                public void actionPerformed(ActionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.$performer.invoke();
                }
            };
            if (id2 == null) break block1;
            KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut(id2);
            if (keyboardShortcut != null) {
                KeyboardShortcut it = keyboardShortcut;
                boolean bl = false;
                action2.putValue("AcceleratorKey", it.getFirstKeyStroke());
            }
        }
        return action2;
    }

    private static final void copyLink(Supplier<Collection<String>> supplier, boolean isHttp) {
        StringBuilder builder = new StringBuilder();
        StringBuilder stringBuilder = isHttp ? builder.append("http://localhost:").append(BuiltInServerManager.Companion.getInstance().getPort()).append("/api") : builder.append("jetbrains://").append(PlatformUtils.getPlatformPrefix());
        builder.append("/settings?name=");
        Collection<String> collection = supplier.get();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"get(...)");
        Iterable iterable = collection;
        Appendable appendable = builder;
        CharSequence charSequence = "--";
        Escaper escaper = UrlEscapers.urlFormParameterEscaper();
        Intrinsics.checkNotNullExpressionValue((Object)escaper, (String)"urlFormParameterEscaper(...)");
        CollectionsKt.joinTo$default((Iterable)iterable, (Appendable)appendable, (CharSequence)charSequence, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((Object)escaper){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Escaper)this.receiver).escape(p0);
            }
        }), (int)60, null);
        CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(builder));
    }

    public static final /* synthetic */ boolean access$copy(Collection names) {
        return CopySettingsPathActionKt.copy(names);
    }

    public static final /* synthetic */ void access$copyLink(Supplier supplier, boolean isHttp) {
        CopySettingsPathActionKt.copyLink(supplier, isHttp);
    }

    public static final /* synthetic */ String access$getTextLabel(Object component2) {
        return CopySettingsPathActionKt.getTextLabel(component2);
    }
}

