/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.ex;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.messages.ChooseDialog;
import com.intellij.util.ArrayUtilRt;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessagesEx
extends Messages {
    public static MessageInfo fileIsReadOnly(Project project2, String filePath) {
        return MessagesEx.error(project2, UIBundle.message((String)"file.is.read.only.message.text", (Object[])new Object[]{filePath}));
    }

    public static MessageInfo filesAreReadOnly(Project project2, String[] files2) {
        if (files2.length == 1) {
            return MessagesEx.fileIsReadOnly(project2, files2[0]);
        }
        return MessagesEx.error(project2, UIBundle.message((String)"files.are.read.only.message.text", (Object[])new Object[]{String.join((CharSequence)",\n", files2)}));
    }

    public static MessageInfo fileIsReadOnly(Project project2, VirtualFile file2) {
        return MessagesEx.fileIsReadOnly(project2, file2.getPresentableUrl());
    }

    public static MessageInfo error(Project project2, @NlsContexts.DialogMessage String message) {
        return MessagesEx.error(project2, message, UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]));
    }

    @NotNull
    public static MessageInfo error(Project project2, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title2) {
        return new MessageInfo(project2, message, title2);
    }

    public static void showErrorDialog(@Nullable Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title2) {
        if (title2 == null) {
            MessagesEx.$$$reportNull$$$0(0);
        }
        if (parent != null) {
            Messages.showErrorDialog((Component)parent, (String)message, (String)title2);
        } else {
            MessagesEx.showErrorDialog((String)message, (String)title2);
        }
    }

    public static void showWarningDialog(@Nullable Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title2) {
        if (title2 == null) {
            MessagesEx.$$$reportNull$$$0(1);
        }
        if (parent != null) {
            Messages.showWarningDialog((Component)parent, (String)message, (String)title2);
        } else {
            MessagesEx.showWarningDialog((String)message, (String)title2);
        }
    }

    public static void showInfoMessage(@Nullable Component parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle @NotNull String title2) {
        if (title2 == null) {
            MessagesEx.$$$reportNull$$$0(2);
        }
        if (parent != null) {
            Messages.showInfoMessage((Component)parent, (String)message, (String)title2);
        } else {
            MessagesEx.showInfoMessage((String)message, (String)title2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "title";
        objectArray2[1] = "com/intellij/openapi/ui/ex/MessagesEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showWarningDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showInfoMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class MessageInfo
    extends BaseDialogInfo<MessageInfo> {
        public MessageInfo(Project project2, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title2) {
            super(project2, message, title2, Messages.getErrorIcon());
        }

        public int showNow() {
            return Messages.showDialog((Project)this.getProject(), (String)this.getMessage(), (String)this.getTitle(), (String[])this.getOptions(), (int)this.getDefaultOption(), (Icon)this.getIcon());
        }

        public void showLater() {
            ApplicationManager.getApplication().invokeLater(() -> this.showNow(), ApplicationManager.getApplication().getDisposed());
        }

        @Messages.YesNoResult
        public int askYesNo() {
            this.setIcon(Messages.getQuestionIcon());
            return Messages.showYesNoDialog((Project)this.getProject(), (String)this.getMessage(), (String)this.getTitle(), (Icon)this.getIcon());
        }

        public int ask(String[] options2, int defaultOptionIndex) {
            this.setOptions(options2, defaultOptionIndex);
            return this.showNow();
        }

        @Override
        @NotNull
        protected MessageInfo getThis() {
            MessageInfo messageInfo = this;
            if (messageInfo == null) {
                MessageInfo.$$$reportNull$$$0(0);
            }
            return messageInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ex/MessagesEx$MessageInfo", "getThis"));
        }
    }

    public static abstract class BaseInputInfo<ThisClass extends BaseInputInfo>
    extends BaseDialogInfo<ThisClass> {
        public BaseInputInfo(Project project2) {
            super(project2);
        }

        public String forceUserInput() {
            this.setOptions(new String[]{CommonBundle.getOkButtonText()}, 0);
            return this.askUser().getInput();
        }

        public abstract UserInput askUser();
    }

    public static final class InputInfo
    extends BaseInputInfo<InputInfo> {
        private String myDefaultValue;

        public InputInfo(Project project2) {
            super(project2);
            this.setOptions(new String[]{CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText()}, 0);
        }

        @Override
        public UserInput askUser() {
            Messages.InputDialog dialog2 = new Messages.InputDialog(this.getProject(), this.getMessage(), this.getTitle(), this.getIcon(), this.myDefaultValue, null, this.getOptions(), this.getDefaultOption());
            dialog2.show();
            return new UserInput(dialog2.getTextField().getText(), dialog2.getExitCode());
        }

        @Override
        @NotNull
        public InputInfo getThis() {
            InputInfo inputInfo = this;
            if (inputInfo == null) {
                InputInfo.$$$reportNull$$$0(0);
            }
            return inputInfo;
        }

        public void setDefaultValue(String defaultValue) {
            this.myDefaultValue = defaultValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ex/MessagesEx$InputInfo", "getThis"));
        }
    }

    public static final class UserInput {
        private final int mySelectedOption;
        private final String myInput;

        public UserInput(String choice, int option2) {
            this.mySelectedOption = option2;
            this.myInput = choice;
        }

        public String getInput() {
            return this.myInput;
        }

        public int getSelectedOption() {
            return this.mySelectedOption;
        }
    }

    public static final class ChoiceInfo
    extends BaseInputInfo<ChoiceInfo> {
        private String[] myChoises = ArrayUtilRt.EMPTY_STRING_ARRAY;
        @NlsSafe
        private String myDefaultChoice = null;

        public ChoiceInfo(Project project2) {
            super(project2);
            this.setIcon(Messages.getQuestionIcon());
            this.setOptions(new String[]{CommonBundle.getOkButtonText()}, 0);
        }

        @Override
        @NotNull
        public ChoiceInfo getThis() {
            ChoiceInfo choiceInfo = this;
            if (choiceInfo == null) {
                ChoiceInfo.$$$reportNull$$$0(0);
            }
            return choiceInfo;
        }

        public ChoiceInfo setChoices(String[] choices, String defaultChoice) {
            this.myChoises = choices;
            this.myDefaultChoice = defaultChoice;
            return this.getThis();
        }

        @Override
        public UserInput askUser() {
            ChooseDialog dialog2 = new ChooseDialog(this.getProject(), this.getMessage(), this.getTitle(), this.getIcon(), this.myChoises, this.myDefaultChoice, this.getOptions(), this.getDefaultOption());
            dialog2.setValidator(null);
            JComboBox comboBox = dialog2.getComboBox();
            comboBox.setEditable(false);
            comboBox.setSelectedItem(this.myDefaultChoice);
            dialog2.show();
            Object selectedItem = comboBox.getSelectedItem();
            return new UserInput(selectedItem != null ? selectedItem.toString() : null, dialog2.getExitCode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ex/MessagesEx$ChoiceInfo", "getThis"));
        }
    }

    public static abstract class BaseDialogInfo<ThisClass extends BaseDialogInfo> {
        private final Project myProject;
        private @NlsContexts.DialogMessage String myMessage;
        @NlsContexts.DialogTitle
        private String myTitle;
        private Icon myIcon;
        private String[] myOptions;
        private int myDefaultOption;

        protected BaseDialogInfo(Project project2) {
            this.myOptions = new String[]{CommonBundle.getOkButtonText()};
            this.myDefaultOption = 0;
            this.myProject = project2;
        }

        public BaseDialogInfo(Project project2, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle String title2, Icon icon2) {
            if (message == null) {
                BaseDialogInfo.$$$reportNull$$$0(0);
            }
            this(project2);
            this.myMessage = message;
            this.myTitle = title2;
            this.myIcon = icon2;
        }

        @NotNull
        public ThisClass setTitle(@NlsContexts.DialogTitle String title2) {
            this.myTitle = title2;
            ThisClass ThisClass = this.getThis();
            if (ThisClass == null) {
                BaseDialogInfo.$$$reportNull$$$0(1);
            }
            return ThisClass;
        }

        @NlsContexts.DialogMessage
        public String getMessage() {
            return this.myMessage;
        }

        @NotNull
        public ThisClass appendMessage(@NlsContexts.DialogMessage @NotNull String message) {
            if (message == null) {
                BaseDialogInfo.$$$reportNull$$$0(2);
            }
            this.myMessage = this.myMessage + message;
            ThisClass ThisClass = this.getThis();
            if (ThisClass == null) {
                BaseDialogInfo.$$$reportNull$$$0(3);
            }
            return ThisClass;
        }

        public void setOptions(String[] options2, int defaultOption) {
            this.myOptions = options2;
            this.myDefaultOption = defaultOption;
        }

        @NotNull
        protected abstract ThisClass getThis();

        @NotNull
        public ThisClass setIcon(Icon icon2) {
            this.myIcon = icon2;
            ThisClass ThisClass = this.getThis();
            if (ThisClass == null) {
                BaseDialogInfo.$$$reportNull$$$0(4);
            }
            return ThisClass;
        }

        public void setMessage(@NlsContexts.DialogMessage @NotNull String message) {
            if (message == null) {
                BaseDialogInfo.$$$reportNull$$$0(5);
            }
            this.myMessage = message;
        }

        public Project getProject() {
            return this.myProject;
        }

        @NlsContexts.DialogTitle
        public String getTitle() {
            return this.myTitle;
        }

        public String[] getOptions() {
            return this.myOptions;
        }

        public int getDefaultOption() {
            return this.myDefaultOption;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/ex/MessagesEx$BaseDialogInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/ex/MessagesEx$BaseDialogInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTitle";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendMessage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "appendMessage";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setMessage";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

