/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.IntegrityCheckCapableFileSystem;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.openapi.vfs.impl.jar.TimedZipHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.Function;
import com.intellij.util.Suppressions;
import com.intellij.util.ThrowableRunnable;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JarFileSystemImpl
extends JarFileSystem
implements IntegrityCheckCapableFileSystem {
    @NotNull
    public String getProtocol() {
        return "jar";
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(0);
        }
        String string = super.extractPresentableUrl(StringUtil.trimEnd((String)path, (String)"!/"));
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        int separatorIndex;
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(2);
        }
        return (separatorIndex = path.indexOf("!/")) > 0 ? FileUtil.normalize((String)path.substring(0, separatorIndex)) + path.substring(separatorIndex) : null;
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        int separatorIndex;
        if (normalizedPath == null) {
            JarFileSystemImpl.$$$reportNull$$$0(3);
        }
        return (separatorIndex = normalizedPath.indexOf("!/")) > 0 ? normalizedPath.substring(0, separatorIndex + "!/".length()) : "";
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            JarFileSystemImpl.$$$reportNull$$$0(4);
        }
        String string = StringUtil.trimEnd((String)rootPath, (String)"!/");
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            JarFileSystemImpl.$$$reportNull$$$0(6);
        }
        String string = localPath + "!/";
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected ZipHandlerBase getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            JarFileSystemImpl.$$$reportNull$$$0(8);
        }
        ZipHandlerBase zipHandlerBase = (ZipHandlerBase)VfsImplUtil.getHandler((ArchiveFileSystem)this, (VirtualFile)entryFile, (Function)(SystemInfo.isWindows ? TimedZipHandler::new : ZipHandler::new));
        if (zipHandlerBase == null) {
            JarFileSystemImpl.$$$reportNull$$$0(9);
        }
        return zipHandlerBase;
    }

    @TestOnly
    public void markDirtyAndRefreshVirtualFileDeepInsideJarForTest(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JarFileSystemImpl.$$$reportNull$$$0(10);
        }
        this.getHandler(file2).clearCaches();
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file2});
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(11);
        }
        return JarFileSystemImpl.isValid(path) ? JarFileSystemImpl.findFileByPath((NewVirtualFileSystem)this, (String)path) : null;
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(12);
        }
        return JarFileSystemImpl.isValid(path) ? JarFileSystemImpl.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path) : null;
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(13);
        }
        return JarFileSystemImpl.isValid(path) ? VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path) : null;
    }

    private static boolean isValid(String path) {
        return path.contains("!/");
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    @TestOnly
    @ApiStatus.Internal
    public static void cleanupForNextTest() {
        Suppressions.runSuppressing((ThrowableRunnable[])new ThrowableRunnable[]{() -> TimedZipHandler.closeOpenZipReferences(), () -> ZipHandler.clearFileAccessorCache()});
    }

    @NotNull
    public Map<String, Long> getArchiveCrcHashes(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            JarFileSystemImpl.$$$reportNull$$$0(14);
        }
        Map map2 = this.getHandler(file2).getArchiveCrcHashes();
        if (map2 == null) {
            JarFileSystemImpl.$$$reportNull$$$0(15);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7, 9, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "composeRootPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchiveCrcHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "composeRootPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "markDirtyAndRefreshVirtualFileDeepInsideJarForTest";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getArchiveCrcHashes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 7, 9, 15 -> new IllegalStateException(string);
        };
    }
}

