/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.impl.local.WatchRootsUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class CanonicalPathMap {
    private static final Executor ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CanonicalPathMap", (Executor)ProcessIOExecutorService.INSTANCE, (int)Runtime.getRuntime().availableProcessors());
    private final NavigableSet<String> myOptimizedRecursiveWatchRoots;
    private final NavigableSet<String> myOptimizedFlatWatchRoots;
    private Collection<Pair<String, String>> myInitialPathMappings;
    private final MultiMap<String, String> myPathMappings;

    static CanonicalPathMap empty() {
        return new CanonicalPathMap(Collections.emptyNavigableSet(), Collections.emptyNavigableSet(), Collections.emptyNavigableSet());
    }

    public CanonicalPathMap(@NotNull NavigableSet<String> optimizedRecursiveWatchRoots, @NotNull NavigableSet<String> optimizedFlatWatchRoots, @NotNull Collection<Pair<String, String>> initialPathMappings) {
        if (optimizedRecursiveWatchRoots == null) {
            CanonicalPathMap.$$$reportNull$$$0(0);
        }
        if (optimizedFlatWatchRoots == null) {
            CanonicalPathMap.$$$reportNull$$$0(1);
        }
        if (initialPathMappings == null) {
            CanonicalPathMap.$$$reportNull$$$0(2);
        }
        this.myOptimizedRecursiveWatchRoots = optimizedRecursiveWatchRoots;
        this.myOptimizedFlatWatchRoots = optimizedFlatWatchRoots;
        this.myInitialPathMappings = initialPathMappings;
        this.myPathMappings = MultiMap.createConcurrentSet();
    }

    @VisibleForTesting
    @NotNull
    public Pair<List<String>, List<String>> getCanonicalWatchRoots() {
        this.initializeMappings();
        ConcurrentHashMap canonicalPathMappings = new ConcurrentHashMap();
        CompletableFuture[] futures = (CompletableFuture[])Stream.concat(this.myOptimizedRecursiveWatchRoots.stream(), this.myOptimizedFlatWatchRoots.stream()).map(root -> CompletableFuture.runAsync(() -> {
            String canonicalRoot = FileSystemUtil.resolveSymLink((String)root);
            if (canonicalRoot != null && OSAgnosticPathUtil.COMPARATOR.compare(canonicalRoot, root) != 0) {
                canonicalPathMappings.put(root, canonicalRoot);
            }
        }, ourExecutor)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
        NavigableSet<String> canonicalRecursiveRoots = WatchRootsUtil.createFileNavigableSet();
        for (String root2 : this.myOptimizedRecursiveWatchRoots) {
            String canonical = (String)canonicalPathMappings.get(root2);
            if (canonical != null) {
                this.myPathMappings.putValue((Object)canonical, (Object)root2);
            } else {
                canonical = root2;
            }
            WatchRootsUtil.insertRecursivePath(canonicalRecursiveRoots, canonical);
        }
        HashSet<String> canonicalFlatRoots = new HashSet<String>();
        for (String root3 : this.myOptimizedFlatWatchRoots) {
            String canonical = (String)canonicalPathMappings.get(root3);
            if (canonical != null) {
                this.myPathMappings.putValue((Object)canonical, (Object)root3);
            } else {
                canonical = root3;
            }
            if (WatchRootsUtil.isCoveredRecursively(canonicalRecursiveRoots, canonical)) continue;
            canonicalFlatRoots.add(canonical);
        }
        return new Pair(new ArrayList<String>(canonicalRecursiveRoots), new ArrayList(canonicalFlatRoots));
    }

    private void initializeMappings() {
        String lastMapping = "";
        Collection lastCollection = null;
        for (Pair<String, String> mapping : this.myInitialPathMappings) {
            String currentMapping = (String)mapping.first;
            if (!currentMapping.equals(lastMapping) || lastCollection == null) {
                lastMapping = (String)mapping.first;
                lastCollection = this.myPathMappings.getModifiable((Object)lastMapping);
            }
            lastCollection.add((String)mapping.second);
        }
        this.myInitialPathMappings = null;
    }

    @VisibleForTesting
    public void addMapping(@NotNull Collection<? extends Pair<String, String>> mapping) {
        if (mapping == null) {
            CanonicalPathMap.$$$reportNull$$$0(3);
        }
        for (Pair<String, String> pair : mapping) {
            String from = (String)pair.first;
            String to = (String)pair.second;
            Collection<String> preRemapPathToWatchedPaths = this.applyMapping(to);
            for (String realWatchedPath : preRemapPathToWatchedPaths) {
                this.myPathMappings.putValue((Object)from, (Object)realWatchedPath);
            }
            this.myPathMappings.putValue((Object)from, (Object)to);
        }
    }

    boolean belongsToWatchRoots(@NotNull String reportedPath, boolean isFile) {
        if (reportedPath == null) {
            CanonicalPathMap.$$$reportNull$$$0(4);
        }
        return WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, reportedPath) || this.myOptimizedFlatWatchRoots.contains(reportedPath) || isFile && this.myOptimizedFlatWatchRoots.contains(PathUtil.getParentPath((String)reportedPath));
    }

    @VisibleForTesting
    @NotNull
    public Collection<String> mapToOriginalWatchRoots(@NotNull String reportedPath, boolean isExact) {
        if (reportedPath == null) {
            CanonicalPathMap.$$$reportNull$$$0(5);
        }
        if (this.myOptimizedFlatWatchRoots.isEmpty() && this.myOptimizedRecursiveWatchRoots.isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                CanonicalPathMap.$$$reportNull$$$0(6);
            }
            return list2;
        }
        Collection<String> affectedPaths = this.applyMapping(reportedPath);
        HashSet<String> changedPaths = new HashSet<String>();
        for (String affectedPath : affectedPaths) {
            if (WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, affectedPath) || this.myOptimizedFlatWatchRoots.contains(affectedPath) || isExact && this.myOptimizedFlatWatchRoots.contains(PathUtil.getParentPath((String)affectedPath))) {
                changedPaths.add(affectedPath);
                continue;
            }
            if (isExact) continue;
            CanonicalPathMap.addPrefixedPaths(this.myOptimizedRecursiveWatchRoots, affectedPath, changedPaths);
            CanonicalPathMap.addPrefixedPaths(this.myOptimizedFlatWatchRoots, affectedPath, changedPaths);
        }
        HashSet<String> hashSet = changedPaths;
        if (hashSet == null) {
            CanonicalPathMap.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private Collection<String> applyMapping(String reportedPath) {
        if (this.myPathMappings.isEmpty()) {
            return List.of(reportedPath);
        }
        SmartList results = new SmartList((Object)reportedPath);
        WatchRootsUtil.forEachPathSegment(reportedPath, File.separatorChar, path -> {
            this.myPathMappings.get(path).forEach(mapped -> results.add((Object)(mapped + reportedPath.substring(path.length()))));
            return true;
        });
        return results;
    }

    private static void addPrefixedPaths(NavigableSet<String> paths, String prefix, Collection<? super String> result2) {
        String possibleRoot = paths.ceiling(prefix);
        if (possibleRoot != null && FileUtil.startsWith((String)possibleRoot, (String)prefix)) {
            for (String root : paths.tailSet(prefix, false)) {
                if (FileUtil.startsWith((String)root, (String)prefix)) {
                    result2.add(root);
                    continue;
                }
                return;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizedRecursiveWatchRoots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizedFlatWatchRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialPathMappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportedPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/CanonicalPathMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/CanonicalPathMap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToOriginalWatchRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "belongsToWatchRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mapToOriginalWatchRoots";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

